local timers = require("level.timer")
local parent, thisObj, concussionParams, objectPosition
local triggerDelay = 2
function OnScriptLoaded(level, obj)
  thisObj = obj
  parent = obj:GetEffectObjectCreator()
  objectPosition = obj:GetWorldPosition()
end
function OnStart(level, obj)
  _G.StartLevelTimer(triggerDelay - 0.45, function()
    EmitLightning(level, obj)
  end)
  _G.StartLevelTimer(triggerDelay, function()
    ExplodeMine(level, obj)
  end)
end
function OnUpdate(level, obj)
  game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_GroundBombs")
end
function ExplodeMine()
  local mineLocation = thisObj:GetWorldPosition()
  if parent ~= nil then
    concussionParams = {
      Tweak = "CNC_EARTHDRAGON_ELECTRIC_EXPLODE",
      WorldLocation = mineLocation,
      GameObject = parent,
      EnemyId = parent:GetID()
    }
    game.Combat.PlayConcussion(concussionParams)
  end
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 2,
    TweenIn = {Time = 0}
  })
  game.Blender.Trigger({
    Name = "FFB_SMALL_RANGED_NEAR",
    TweenIn = {Time = 0}
  })
  CleanUp()
end
function EmitLightning(level, obj)
  local arrowData = {}
  arrowData.Tweak = "ARR_EARTHDRAGON_MORTAR_LIGHTNING_STRIKE_LUA"
  arrowData.Level = level
  arrowData.EmitLocation = objectPosition + obj:GetWorldUp() * 45
  arrowData.TargetLocation = objectPosition
  game.Combat.EmitArrow(arrowData)
end
function CleanUp()
  thisObj:Destroy()
end
