local statemachine = require("ai.statemachine")
local tablex = require("core.tablex")
local picklelib = require("core.pickle")
local DL = require("design.DesignerLibrary")
Brain_Core = require("behavior.corebrain")
constants = {}
global = {}
function detectAggroStateFromSpawnMove(ai)
  local spawnContext = ai:GetContext()
  if DL.CheckCreatureContext(spawnContext, "INCOMBAT") then
    global.aggroState = "INCOMBAT"
  elseif DL.CheckCreatureContext(spawnContext, "UNAWARE") then
    global.aggroState = "UNAWARE"
  elseif DL.CheckCreatureContext(spawnContext, "NONHOSTILE") then
    global.aggroState = "NONHOSTILE"
  elseif DL.CheckCreatureContext(spawnContext, "PASSIVE") then
    global.aggroState = "PASSIVE"
  end
end
function LuaHook_WarpToPlayer(ai, data)
  local player = game.Player.FindPlayer()
  local playerPosition = player:GetWorldPosition()
  local playerForward = player:GetWorldForward()
  ai:Warp(playerPosition, playerForward)
  SnareTrapActivate(ai)
end
function SnareTrapActivate(ai)
  ai:TriggerMoveEvent("LE_CSVineSnareWhiff")
end
function LuaHook_MotionWarpRotation(ai)
  local player = game.Player.FindPlayer()
  local playerForward = player:GetWorldForward()
  local rotationDriver = ai:GetAnimDriver("SnareEnterRot")
  rotationDriver.ValueVec = playerForward
end
function OnAIPostSpawn(ai)
  detectAggroStateFromSpawnMove(ai)
  if ai:HasMarker("DoNotEvaluate") == false then
    ai:AddMarker("DoNotEvaluate")
  end
  if ai:HasMarker("nooffscreen") == false then
    ai:AddMarker("nooffscreen")
  end
  if not ai:PickupIsAcquired("FreyaVines_Attributes") then
    ai:PickupAcquire("FreyaVines_Attributes")
  end
end
function OnAIUpdate(ai)
end
function _G.OnAICreateLuaState(ai)
  _G.OnAICreateLuaState = nil
end
picklelib.Install()
function Pickle(GO)
  return {
    global = global
  }
end
function Unpickle(GO, t)
  global = t.global
end
