local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
selfDestructWarningTimer = nil
selfDestructTimer = nil
local heroPuppeteer
player = nil
myGO = nil
owner = nil
throwableActive = false
preDetonationFX = nil
local playerThrewGrenade = false
grenadeOwnerOnImpact = nil
gameObjectHitOnImpact = nil
selfDestructCooldown = 6.5
selfDestructWarningCooldown = 2.5
local frontInteractZone
function OnScriptLoaded(level, go)
  myGO = go
  player = game.Player:FindPlayer()
  throwableActive = true
  owner = go:GetParentGameObjectForSpawnedGameObject()
  print(owner)
  print(owner:GetID())
  selfDestructWarningTimer = StartLevelTimer(selfDestructWarningCooldown, SelfDestructWarning)
  selfDestructWarningTimer:Restart()
  frontInteractZone = game.InteractZone.New(go, "handle1")
  frontInteractZone:SetHintXZRange(3)
  frontInteractZone:SetYRange(3)
  frontInteractZone:SetXZRange(3)
  frontInteractZone:SetAngle(360)
  frontInteractZone:SetOnScreenPercent(0.25)
end
function OnUpdate(level, go)
  if throwableActive and preDetonationFX ~= nil and preDetonationFX.Spawned then
    preDetonationFX:SetWorldPosition(go:GetWorldPosition())
  end
end
function OnUseWorld(level, obj)
  if throwableActive and frontInteractZone:PlayerCanInteract() then
    if heroPuppeteer == nil then
      heroPuppeteer = game.Puppeteer.NewForce(obj, "Golem Grenade Pickup", player)
    end
    heroPuppeteer:StartMove("MOV_Throwable_Combat_Pickup")
    local throwableTemplate = {
      name = "Light",
      attachName = "ATT_Throwable",
      standardName = "Throwable",
      range = 15,
      maxThrowRange = 30,
      reticleOffset = 0.3,
      bounciness = 0.1,
      rotationSpeed = 0.1
    }
    player:SetThrowable(myGO, throwableTemplate, "reticle")
    heroPuppeteer:OnComplete(EndPickupThrowable)
  end
end
function EndPickupThrowable()
  if heroPuppeteer ~= nil then
    heroPuppeteer:Clear()
    heroPuppeteer:DetachPuppet()
    heroPuppeteer = nil
  end
end
function SelfDestructWarning()
  if myGO ~= nil then
    preDetonationFX = game.FX.Spawn("Golem_HeatGrenadePreDetonate_FX")
  else
    print("myGO is nil")
  end
end
function OnHitGameObject(level, obj, weaponOwnerCreature, hitGameObject)
  print("I am owned by...", weaponOwnerCreature:GetName())
  print("I hit a..", hitGameObject:GetName())
  grenadeOwnerOnImpact = weaponOwnerCreature
  if weaponOwnerCreature:GetName() == "golem00" and hitGameObject:GetName() ~= "vis" or weaponOwnerCreature == player then
    ImpactDetonation()
  elseif weaponOwnerCreature == player then
    gameObjectHitOnImpact = hitGameObject
    ImpactDetonation()
  end
end
function SelfDestruct()
  throwableActive = false
  selfDestructTimer = nil
  if preDetonationFX ~= nil and preDetonationFX.Spawned then
    preDetonationFX:Destroy()
    preDetonationFX = nil
  end
  if myGO ~= nil then
    local concussionParams = {
      Tweak = "CNC_GOLEM_GRENADE_PAYLOAD",
      WorldLocation = myGO:GetWorldPosition(),
      Creature = owner,
      EnemyId = owner:GetID()
    }
    game.Combat.PlayConcussion(concussionParams)
  end
  DestroyThrowable()
end
function ImpactDetonation()
  throwableActive = false
  if selfDestructWarningTimer ~= nil then
    selfDestructWarningTimer:Stop()
    selfDestructWarningTimer = nil
  end
  if selfDestructTimer ~= nil then
    selfDestructTimer:Stop()
    selfDestructTimer = nil
  end
  if preDetonationFX ~= nil and preDetonationFX.Spawned then
    preDetonationFX:Destroy()
    preDetonationFX = nil
  end
  if myGO ~= nil then
    local concussionParams = {
      Tweak = "CNC_GOLEM_GRENADE_PAYLOAD",
      WorldLocation = myGO:GetWorldPosition(),
      GameObject = myGO,
      EnemyId = owner:GetID()
    }
    game.Combat.PlayConcussion(concussionParams)
  end
  DestroyThrowable()
end
function DestroyThrowable()
  if myGO ~= nil then
    print("destroy grenade")
    if grenadeOwnerOnImpact == player then
      print("drop players throwable")
      player:DropThrowable("Throwable")
    end
    myGO:Hide()
  end
end
