local timer = require("creature.timer")
local LD = require("design.LevelDesignLibrary")
function ResetCineMixStates()
  print("ResetCineMixStates")
  game.Audio.SetWwiseState("Scene_000_Forest_OpeningIdle", "out")
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "out")
  game.Audio.SetWwiseState("Scene_013_Forest_LogBoatEnter", "out")
  game.Audio.SetWwiseState("Scene_015_Forest_LogBoatExit", "out")
  game.Audio.SetWwiseState("Scene_020_Forest_MothersKnife", "out")
  game.Audio.SetWwiseState("Scene_025_Forest_DeerSurprise", "out")
  game.Audio.SetWwiseState("Scene_030_Forest_DeerMiss", "out")
  game.Audio.SetWwiseState("Scene_040_Forest_DeerSpotA", "out")
  game.Audio.SetWwiseState("Scene_050_Forest_DeerSpotB", "out")
  game.Audio.SetWwiseState("Scene_060_Forest_DeerHitEnter", "out")
  game.Audio.SetWwiseState("Scene_065_Forest_TrollSurprise", "out")
  game.Audio.SetWwiseState("Scene_072_Forest_TrollAftermath", "out")
  game.Audio.SetWwiseState("Scene_078_Forest_AshesGathered", "out")
  game.Audio.SetWwiseState("Scene_080_Forest_BaldurIntro", "out")
  game.Audio.SetWwiseState("Scene_100_Forest_TimeToGo", "out")
  game.Audio.SetWwiseState("Scene_110_Forest_RunicStave", "out")
  game.Audio.SetWwiseState("Scene_115_Riverpass_BridgeFall", "out")
  game.Audio.SetWwiseState("Scene_118_Riverpass_BanditCamp", "out")
  game.Audio.SetWwiseState("Scene_120_Riverpass_FirstHumanKillA", "out")
  game.Audio.SetWwiseState("Scene_120_Riverpass_FirstHumanKillB", "out")
  game.Audio.SetWwiseState("Scene_130_Riverpass_BrokIntro", "out")
  game.Audio.SetWwiseState("Scene_135_Riverpass_CanyonOverlook", "out")
  game.Audio.SetWwiseState("Scene_136_Riverpass_NewTracks", "out")
  game.Audio.SetWwiseState("Scene_137_Riverpass_BoarIntro", "out")
  game.Audio.SetWwiseState("Scene_140_Riverpass_BoarShoot", "out")
  game.Audio.SetWwiseState("Scene_150_Riverpass_WitchIntro", "out")
  game.Audio.SetWwiseState("Scene_160_Riverpass_WitchHouseA", "out")
  game.Audio.SetWwiseState("Scene_163_Riverpass_KnifeReturn", "out")
  game.Audio.SetWwiseState("Scene_165_Riverpass_WitchHouseB", "out")
  game.Audio.SetWwiseState("Scene_180_Caldera_WorldSnakeIntro", "out")
  game.Audio.SetWwiseState("Scene_181_Caldera_WorldSnakeIntroOutro", "out")
  game.Audio.SetWwiseState("Scene_182_Caldera_CalShopIntro", "out")
  game.Audio.SetWwiseState("Scene_183_Caldera_FastTravelAquired", "out")
  game.Audio.SetWwiseState("Scene_185_Foothills_SindriIntro", "out")
  game.Audio.SetWwiseState("Scene_187_Foothills_OgreIntro", "out")
  game.Audio.SetWwiseState("Scene_190_Foothills_BlackBreath", "out")
  game.Audio.SetWwiseState("Scene_200_Alfhiem_Bifrost_Intro", "out")
  game.Audio.SetWwiseState("Scene_210_Alfheim_AlfheimArrival", "out")
  game.Audio.SetWwiseState("Scene_215_Alfheim_AreYouSerious", "out")
  game.Audio.SetWwiseState("Scene_220_Alfheim_AlfSonOverwhelmed", "out")
  game.Audio.SetWwiseState("Scene_230_Alfheim_SonGapCarryEnter", "out")
  game.Audio.SetWwiseState("Scene_235_Alfhiem_HiveClimbKill", "out")
  game.Audio.SetWwiseState("Scene_236_Alfheim_CrashThroughFloor", "out")
  game.Audio.SetWwiseState("Scene_237_Alfheim_TendrilCut02", "out")
  game.Audio.SetWwiseState("Scene_240_Alfhiem_EnterTheLight", "out")
  game.Audio.SetWwiseState("Scene_242_Alfhiem_OutOfTheLight", "out")
  game.Audio.SetWwiseState("Scene_243_Alfhiem_BifrostArrows", "out")
  game.Audio.SetWwiseState("Scene_245_Alfhiem_LightOnesReturn", "out")
  game.Audio.SetWwiseState("Scene_250_Alfhiem_Momfrontation", "out")
  game.Audio.SetWwiseState("Scene_263_Caldera_BrokShop", "out")
  game.Audio.SetWwiseState("Scene_267_PeaksPass_RopeStuckA", "out")
  game.Audio.SetWwiseState("Scene_270_PeaksPass_SkyLantern", "out")
  game.Audio.SetWwiseState("Scene_280_PeaksPass_DragonFight", "out")
  game.Audio.SetWwiseState("Scene_290_PeaksPass_SindriDragon", "out")
  game.Audio.SetWwiseState("Scene_295_PeaksPass_DragonChopEnter", "out")
  game.Audio.SetWwiseState("Scene_300_PeaksPass_ArrowFix", "out")
  game.Audio.SetWwiseState("Scene_310_Jotunheim_ReleaseAshes", "out")
  game.Audio.SetWwiseState("Scene_310_PeaksPass_MimirIntro", "out")
  game.Audio.SetWwiseState("Scene_320_Caldera_BrokCares", "out")
  game.Audio.SetWwiseState("Scene_330_Riverpass_HeadEnchant", "out")
  game.Audio.SetWwiseState("Scene_340_Caldera_SerpentTranslate", "out")
  game.Audio.SetWwiseState("Scene_350_StoneMason_SindriStoneMason", "out")
  game.Audio.SetWwiseState("Scene_355_StoneMason_HammerFall", "out")
  game.Audio.SetWwiseState("Scene_358_StoneMason_AttackOftheBros", "out")
  game.Audio.SetWwiseState("Scene_360_StoneMason_ChiselSick", "out")
  game.Audio.SetWwiseState("Scene_365_StoneMason_Modi2Enter", "out")
  game.Audio.SetWwiseState("Scene_368_Caldera_SonBoatEnter", "out")
  game.Audio.SetWwiseState("Scene_369_Riverpass_SonBoatExit", "out")
  game.Audio.SetWwiseState("Scene_370_Riverpass_FreyaTendsSon", "out")
  game.Audio.SetWwiseState("Scene_375_Riverpass_AthenaBoat", "out")
  game.Audio.SetWwiseState("Scene_380_Forest_RetrieveBlades", "out")
  game.Audio.SetWwiseState("Scene_383_Caldera_BrokSavesCat", "out")
  game.Audio.SetWwiseState("Scene_387_Helheim_RetrieveHearCineBlades", "out")
  game.Audio.SetWwiseState("Scene_388_Helheim_HelDrainAcquire", "out")
  game.Audio.SetWwiseState("Scene_390_Riverpass_SonHealed", "out")
  game.Audio.SetWwiseState("Scene_400_Riverpass_DemigodReveal", "out")
  game.Audio.SetWwiseState("Scene_425_RuneVault_WineAquire", "out")
  game.Audio.SetWwiseState("Scene_430_RuneVault_FathersKnife", "out")
  game.Audio.SetWwiseState("Scene_440_TempleFlip_DemigodToast", "out")
  game.Audio.SetWwiseState("Scene_450_Foothills_SindriGetsServed", "out")
  game.Audio.SetWwiseState("Scene_460_PeaksPass_ModiReturns", "out")
  game.Audio.SetWwiseState("Scene_470_PeaksPass_BaldurReturns", "out")
  game.Audio.SetWwiseState("Scene_490_Caldera_HengeDisruption", "out")
  game.Audio.SetWwiseState("Scene_492_HelehimReturn_OutOfControl", "out")
  game.Audio.SetWwiseState("Scene_494_HelheimReturn_PastHauntsBaldur", "out")
  game.Audio.SetWwiseState("Scene_498_HelheimReturn_FlyingBoatJump", "out")
  game.Audio.SetWwiseState("Scene_499_RuneVault_TyrTriptych", "out")
  game.Audio.SetWwiseState("Scene_500_Caldera_AlmostHome", "out")
  game.Audio.SetWwiseState("Scene_510_Caldera_HuldraReunion", "out")
  game.Audio.SetWwiseState("Scene_520_Caldera_SnakesStatue", "out")
  game.Audio.SetWwiseState("Scene_540_StoneMason_FinalFightIntro", "out")
  game.Audio.SetWwiseState("Scene_550_StoneMason_ShieldsDown", "out")
  game.Audio.SetWwiseState("Scene_570_StoneMason_BaldurDeath", "out")
  game.Audio.SetWwiseState("Scene_580_Caldera_SayingGoodbye", "out")
  game.Audio.SetWwiseState("Scene_590_Jotunheim_SonBond", "out")
  game.Audio.SetWwiseState("Scene_600_Jotunheim_MothersSecretReveal", "out")
  game.Audio.SetWwiseState("Scene_620_Forest_EpilogueTeaster", "out")
  game.Audio.SetWwiseState("Scene_900_XPL_BrokQuest1", "out")
  game.Audio.SetWwiseState("Scene_910_XPL_SindriQuest1", "out")
  game.Audio.SetWwiseState("Scene_920_XPL_BrokQuest2", "out")
  game.Audio.SetWwiseState("Scene_930_XPL_SindriQuest2", "out")
  game.Audio.SetWwiseState("Scene_940_XPL_HailToTheKing", "out")
  game.Audio.SetWwiseState("Credits", "out")
  game.Audio.PlaySound("SND_ALF_InsideTheLight_STATE_OFF")
  game.Audio.SetBusLevelRTPCValue("MX_Intensity_Meter", game.Audio.GetMusicIntensity() + game.Encounters.GetEnemiesInCombatCount())
end
function LuaHook_DeathEnter()
  if game.FindLevel("Peak550_DragonArena") then
    game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_fail")
  else
    game.Audio.StartMusic("SND_MX_Player_Dead")
  end
end
function LuaHook_OpeningIntIdle()
  game.Audio.SetWwiseState("Scene_000_Forest_OpeningIdle", "in")
end
function LuaHook_OpeningIntIdleEND()
  game.Audio.SetWwiseState("Scene_000_Forest_OpeningIdle", "out")
end
function LuaHook_OpeningCineEnter()
  game.Audio.StartMusic("SND_MX_PRO_tree_opening")
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "in")
end
function LuaHook_OpeningCineEnterEND()
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "out")
end
function LuaHook_OpeningIntAxeHit01()
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "in")
  game.Audio.StartMusic("SND_MX_PRO_tree_chop")
end
function LuaHook_OpeningIntAxeHit01END()
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "out")
end
function LuaHook_OpeningCineExit()
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "in")
  game.Audio.StartMusic("SND_MX_PRO_tree_fall")
end
function LuaHook_OpeningCineExitEND()
  game.Audio.SetWwiseState("Scene_010_Forest_OpeningCine", "out")
end
function LuaHook_LogBoatEnter()
  game.Audio.StartMusic("SND_MX_PRO_boat_enter")
  game.Audio.SetWwiseState("Scene_013_Forest_LogBoatEnter", "in")
end
function LuaHook_LogBoatEnterEND()
  game.Audio.SetWwiseState("Scene_013_Forest_LogBoatEnter", "out")
end
function LuaHook_LogBoatExit()
  game.Audio.StartMusic("SND_MX_PRO_boat_exit")
  game.Audio.SetWwiseState("Scene_015_Forest_LogBoatExit", "in")
end
function LuaHook_LogBoatExitEND()
  game.Audio.SetWwiseState("Scene_015_Forest_LogBoatExit", "out")
end
function LuaHook_MothersKnife()
  game.Audio.StartMusic("SND_MX_PRO_mothers_knife")
  game.Audio.SetWwiseState("Scene_020_Forest_MothersKnife", "in")
end
function LuaHook_MothersKnifeEND()
  game.Audio.SetWwiseState("Scene_020_Forest_MothersKnife", "out")
end
function LuaHook_AshesGathered()
  game.Audio.StartMusic("SND_MX_PRO_ashes_gathered")
  game.Audio.SetWwiseState("Scene_078_Forest_AshesGathered", "in")
end
function LuaHook_AshesGatheredEND()
  game.Audio.SetWwiseState("Scene_078_Forest_AshesGathered", "out")
end
function LuaHook_POIDeerSpot2_30()
  game.Audio.StartMusic("SND_MX_PRO_deer_spot_2")
end
function LuaHook_DeerSpotBCine()
  game.Audio.StartMusic("SND_MX_PRO_deer_spot_2")
  game.Audio.SetWwiseState("Scene_050_Forest_DeerSpotB", "in")
end
function LuaHook_DeerSpotBCineEND()
  game.Audio.SetWwiseState("Scene_050_Forest_DeerSpotB", "out")
end
function LuaHook_DeerInteractHitEnter()
  game.Audio.StartMusic("SND_MX_PRO_deer_hit_lesson")
end
function LuaHook_DeerInteractHitExit()
  game.Audio.StartMusic("SND_MX_PRO_deer_hit_shot")
end
function LuaHook_TrollSurprise()
  game.Audio.StartMusic("SND_MX_PRO_troll_surprise")
  timer.StartCreatureTimer(95, trollSurpriseDelay)
  game.Audio.SetWwiseState("Scene_065_Forest_TrollSurprise", "in")
end
function trollSurpriseDelay()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_troll_fight_in")
end
function LuaHook_TrollSurpriseEND()
  game.Audio.SetWwiseState("Scene_065_Forest_TrollSurprise", "out")
end
function LuaHook_TrollAfterMathBDummy()
  game.Audio.StartMusic("SND_MX_PRO_troll_aftermath")
  game.Audio.SetWwiseState("Scene_072_Forest_TrollAftermath", "in")
end
function LuaHook_TrollAfterMathBDummyEND()
  game.Audio.SetWwiseState("Scene_072_Forest_TrollAftermath", "out")
end
function LuaHook_TrollAfterMathB()
  game.Audio.SetWwiseState("Scene_072_Forest_TrollAftermath", "in")
end
function LuaHook_TrollAfterMathBEND()
  game.Audio.SetWwiseState("Scene_072_Forest_TrollAftermath", "out")
end
function LuaHook_BaldurIntro()
  game.Audio.PlaySound("SND_GLB_Interior")
  game.Audio.StartMusic("SND_MX_PRO_baldur_intro")
  game.Audio.SetWwiseState("Scene_080_Forest_BaldurIntro", "in")
end
function LuaHook_BaldurIntro50()
  game.Audio.PlaySound("SND_GLB_Exterior")
end
function LuaHook_BaldurIntro95()
  game.Audio.StartMusic("SND_MX_PRO_baldur1_arena1_prelap")
end
function LuaHook_BaldurIntroEND()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_arena1_in")
  game.Audio.SetWwiseState("Scene_080_Forest_BaldurIntro", "out")
end
function LuaHook_BaldurWound0()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  if soundEmitter:IsPlaying("SND_vo_lvl_pro_s456_010_kra") then
    LD.StopSound(soundEmitter, "SND_vo_glb_cbt_exrt_dmg_breath_LP")
  else
    LD.PlaySound(soundEmitter, "SND_vo_glb_cbt_exrt_dmg_breath_LP")
  end
end
function LuaHook_BaldurWound1()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  if soundEmitter:IsPlaying("SND_vo_lvl_pro_s456_020_kra") then
    LD.StopSound(soundEmitter, "SND_vo_glb_cbt_exrt_dmg_breath_LP")
  else
    LD.PlaySound(soundEmitter, "SND_vo_glb_cbt_exrt_dmg_breath_LP")
  end
end
function LuaHook_BaldurWound2()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  if soundEmitter:IsPlaying("SND_vo_lvl_pro_s456_030_kra") then
    LD.StopSound(soundEmitter, "SND_vo_glb_cbt_exrt_nav_breath_exhausted_LP")
  else
    LD.PlaySound(soundEmitter, "SND_vo_glb_cbt_exrt_nav_breath_exhausted_LP")
  end
end
function LuaHook_Phase1_RoofSlamUppercut03()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_roof_slam")
end
function LuaHook_Phase1_RoofBeatdownEnter()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_grapple1_out")
end
function LuaHook_Phase1_RoofBeatdownExit()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_grapple2_out")
end
function LuaHook_Phase1_PlowThroughEnter()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_charge")
end
function LuaHook_Phase1_BaldurBuried()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.PlaySound(soundEmitter, "SND_AMB_Emit_Rock_Debris_Crevice_For200_LP")
end
function LuaHook_Phase1_RageActivate()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_rage")
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.StopSound(soundEmitter, "SND_AMB_Emit_Rock_Debris_Crevice_For200_LP")
end
function LuaHook_Phase1_RageActivateEND()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_arena2_in")
end
function LuaHook_Phase2_BaldurBuriedStagger()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_surprise")
end
function LuaHook_HereToThereEnter2()
  game.Audio.StartMusic("SND_MX_PRO_baldur1_smash")
end
function LuaHook_Phase2_BaldurBirdseyeLaunch()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_grapple3_out")
end
function LuaHook_HereToThereEnter3()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_choke_in")
end
function LuaHook_Phase3_BaldurKillExit()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_choke_out")
end
function LuaHook_Phase3_BaldurKillExitEND()
  game.Audio.StartMusic("SND_MX_PRO_struggle_walk_in")
end
function LuaHook_BaldurWound_StartAxeDrag()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.PlaySound(soundEmitter, "SND_WPN_Axe_Foley_Drag_Snow_LP")
end
function LuaHook_BaldurWound_StopAxeDrag()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.StopSound(soundEmitter, "SND_WPN_Axe_Foley_Drag_Snow_LP")
end
function LuaHook_BaldurWound_1_Transition()
  game.Audio.StartMusic("SND_MX_PRO_struggle_walk_out")
end
function LuaHook_Phase2_Staredown()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_staredown")
end
function LuaHook_Phase2_StaredownEND()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_baldur1_arena3_in")
end
function LuaHook_RetrieveBladesAudio()
  game.Audio.StartMusic("SND_MX_PRO_retireve_blades")
  game.Audio.SetWwiseState("Scene_380_Forest_RetrieveBlades", "in")
end
function LuaHook_RetrieveBladesEND()
  game.Audio.SetWwiseState("Scene_380_Forest_RetrieveBlades", "out")
end
function LuaHook_TimeToGo()
  game.Audio.PlaySound("SND_GLB_Interior")
  game.Audio.StartMusic("SND_MX_PRO_time_to_go")
  game.Audio.SetWwiseState("Scene_100_Forest_TimeToGo", "in")
end
function LuaHook_TimeToGoEND()
  game.Audio.StartMusic("SND_MX_PRO_go_to_chasm")
  game.Audio.SetWwiseState("Scene_100_Forest_TimeToGo", "out")
end
function LuaHook_RunicStave()
  game.Audio.StartMusic("SND_MX_PRO_runic_stave")
  game.Audio.SetWwiseState("Scene_110_Forest_RunicStave", "in")
end
function LuaHook_RunicStaveEND()
  game.Audio.StartMusic("SND_MX_PRO_runic_stave")
  game.Audio.SetWwiseState("Scene_110_Forest_RunicStave", "out")
end
function LuaHook_EpilogueCine()
  game.Audio.StartMusic("SND_MX_PRO_epilogue_teaser")
  game.Audio.SetWwiseState("Scene_620_Forest_EpilogueTeaster", "in")
end
function LuaHook_EpilogueCineEND()
  game.Audio.SetWwiseState("Scene_620_Forest_EpilogueTeaster", "out")
end
function LuaHook_BridgeFallEnter()
  game.Audio.SetWwiseState("Scene_115_Riverpass_BridgeFall", "out")
end
function LuaHook_BridgeFall()
  game.Audio.StartMusic("SND_MX_RIV_bridge_collapse")
end
function LuaHook_BridgeFallEND()
  game.Audio.SetWwiseState("Scene_115_Riverpass_BridgeFall", "out")
end
function LuaHook_BFnotdead()
  game.Audio.StartCheckpointedMusic("SND_MX_Riv_fight_3_in")
end
function LuaHook_BanditCamp()
  game.Audio.StartMusic("SND_MX_RIV_bandit_camp_intro")
  game.Audio.SetWwiseState("Scene_118_Riverpass_BanditCamp", "in")
end
function LuaHook_BanditCampEND()
  game.Audio.SetWwiseState("Scene_118_Riverpass_BanditCamp", "out")
end
function LuaHook_PlaySoundBanditGate()
  local level = game.FindLevel("Riv250_DangersSide")
  level:CallScript("LH_PlaySoundBanditGate")
end
function LuaHook_FirstHumanKillA()
  game.Audio.StartMusic("SND_MX_RIV_first_kill_pt1")
  game.Audio.SetWwiseState("Scene_120_Riverpass_FirstHumanKillA", "in")
end
function LuaHook_FirstHumanKillAEND()
  game.Audio.SetWwiseState("Scene_120_Riverpass_FirstHumanKillA", "out")
end
function LuaHook_FirstHumanKillB()
  game.Audio.StartMusic("SND_MX_RIV_first_kill_pt2")
  game.Audio.SetWwiseState("Scene_120_Riverpass_FirstHumanKillB", "in")
end
function LuaHook_FirstHumanKillBEND()
  game.Audio.SetWwiseState("Scene_120_Riverpass_FirstHumanKillB", "out")
end
function LuaHook_SonBoostSad4MeterCrawlStandSad()
  game.Audio.StartMusic("SND_MX_RIV_mopey_son")
end
function LuaHook_NewTracks()
  game.Audio.SetWwiseState("Scene_136_Riverpass_NewTracks", "in")
end
function LuaHook_NewTracksEND()
  game.Audio.SetWwiseState("Scene_136_Riverpass_NewTracks", "out")
end
function LuaHook_BrokIntro()
  game.Audio.SetWwiseState("Scene_130_Riverpass_BrokIntro", "in")
end
function LuaHook_BrokIntroEND()
  game.Audio.SetWwiseState("Scene_130_Riverpass_BrokIntro", "out")
end
function LuaHook_BoarIntro()
  game.Audio.StartMusic("SND_MX_RIV_boar_intro")
  game.Audio.SetWwiseState("Scene_137_Riverpass_BoarIntro", "in")
end
function LuaHook_BoarIntroExitEND()
  game.Audio.SetWwiseState("Scene_137_Riverpass_BoarIntro", "out")
end
function LuaHook_BoarShoot()
  game.Audio.SetWwiseState("Scene_140_Riverpass_BoarShoot", "in")
end
function LuaHook_BoarShootEND()
  game.Audio.SetWwiseState("Scene_140_Riverpass_BoarShoot", "out")
end
function LuaHook_CanyonOverLook()
  game.Audio.StartMusic("SND_MX_RIV_canyon_overlook")
  game.Audio.SetWwiseState("Scene_135_Riverpass_CanyonOverlook", "in")
end
function LuaHook_CanyonOverLookEND()
  game.Audio.SetWwiseState("Scene_135_Riverpass_CanyonOverlook", "out")
end
function LuaHook_WitchIntroCineEnter()
  game.Audio.StartMusic("SND_MX_RIV_forest_chase_2_out")
  game.Audio.StartMusic("SND_MX_RIV_witch_intro")
  game.Audio.SetWwiseState("Scene_150_Riverpass_WitchIntro", "in")
end
function LuaHook_WitchIntroMiniGame_Exit()
  game.Audio.StartMusic("SND_MX_RIV_witch_intro_pt2")
end
function LuaHook_WitchIntroMiniGame_ExitEND()
  game.Audio.SetWwiseState("Scene_150_Riverpass_WitchIntro", "out")
end
function LuaHook_WitchHouseACine()
  game.Audio.StartMusic("SND_MX_RIV_WitchHouseA")
  game.Audio.SetWwiseState("Scene_160_Riverpass_WitchHouseA", "in")
end
function LuaHook_WitchHouseACineEND()
  game.Audio.SetWwiseState("Scene_160_Riverpass_WitchHouseA", "out")
end
function LuaHook_WitchHouseBCine()
  game.Audio.StartMusic("SND_MX_RIV_WitchHouseB")
  game.Audio.SetWwiseState("Scene_165_Riverpass_WitchHouseB", "in")
end
function LuaHook_WitchHouseBCineEND()
  game.Audio.SetWwiseState("Scene_165_Riverpass_WitchHouseB", "out")
end
function LuaHook_KnifeReturnCine()
  game.Audio.SetWwiseState("Scene_163_Riverpass_KnifeReturn", "in")
end
function LuaHook_KnifeReturnCineEND()
  game.Audio.SetWwiseState("Scene_163_Riverpass_KnifeReturn", "out")
end
function LuaHook_HeadEnchant()
  game.Audio.StartMusic("SND_MX_RIV_head_enchant")
  game.Audio.SetWwiseState("Scene_330_Riverpass_HeadEnchant", "in")
end
function LuaHook_HeadEnchantEND()
  game.Audio.SetWwiseState("Scene_330_Riverpass_HeadEnchant", "out")
  if not game.FindLevel("Riv925_FreyaCave") ~= nil then
    game.FindLevel("Riv925_FreyaCave"):CallScript("Emitters925CaveOn")
  end
end
function LuaHook_FreyaTendsSon()
  game.Audio.StartMusic("SND_MX_RIV_freya_tends_son")
  game.Audio.SetWwiseState("Scene_370_Riverpass_FreyaTendsSon", "in")
end
function LuaHook_FreyaTendsSonEND()
  game.Audio.SetWwiseState("Scene_370_Riverpass_FreyaTendsSon", "out")
end
function LuaHook_AthenaBoat()
  game.Audio.SetWwiseState("Scene_375_Riverpass_AthenaBoat", "in")
  game.Audio.StartMusic("SND_MX_RIV_athena_boat")
  timer.StartCreatureTimer(120, boat2Music)
end
function boat2Music()
  game.Audio.StartMusic("SND_MX_PRO_athena_boat_part2")
end
function LuaHook_AthenaBoatEND()
  game.Audio.SetWwiseState("Scene_375_Riverpass_AthenaBoat", "out")
end
function LuaHook_SonHealed()
  game.Audio.StartMusic("SND_MX_RIV_son_healed")
  game.Audio.SetWwiseState("Scene_390_Riverpass_SonHealed", "in")
end
function LuaHook_SonHealedEND()
  game.Audio.SetWwiseState("Scene_390_Riverpass_SonHealed", "out")
end
function LuaHook_DemigodReveal()
  game.Audio.StartMusic("SND_MX_RIV_demigod_reveal")
  game.Audio.SetWwiseState("Scene_400_Riverpass_DemigodReveal", "in")
end
function LuaHook_DemigodRevealEND()
  game.Audio.SetWwiseState("Scene_400_Riverpass_DemigodReveal", "out")
  game.Audio.StartMusic("SND_MX_CAL_boat_explore1")
end
function LuaHook_WineAcquire()
  game.Audio.SetWwiseState("Scene_425_RuneVault_WineAquire", "in")
end
function LuaHook_WineAcquireEND()
  game.Audio.SetWwiseState("Scene_425_RuneVault_WineAquire", "out")
end
function LuaHook_FathersKnife()
  game.Audio.StartMusic("SND_MX_CAL_fathers_knife")
  timer.StartCreatureTimer(120, delayFathersKnife)
  game.Audio.SetWwiseState("Scene_430_RuneVault_FathersKnife", "in")
end
function delayFathersKnife()
  game.Audio.StartCheckpointedMusic("SND_MX_CAL_vault_stone_troll_in")
end
function LuaHook_FathersKnifeEND()
  game.Audio.SetWwiseState("Scene_430_RuneVault_FathersKnife", "out")
end
function LuaHook_WorldSnakeIntro()
  game.Audio.StartMusic("SND_MX_CAL_world_serpent_intro")
  game.Audio.SetWwiseState("Scene_180_Caldera_WorldSnakeIntro", "in")
end
function LuaHook_WorldSnakeIntroEND()
  game.Audio.SetWwiseState("Scene_180_Caldera_WorldSnakeIntro", "out")
end
function LuaHook_WorldSnakeOutro()
  game.Audio.SetWwiseState("Scene_181_Caldera_WorldSnakeIntroOutro", "in")
end
function LuaHook_WorldSnakeOutroEND()
  game.Audio.SetWwiseState("Scene_181_Caldera_WorldSnakeIntroOutro", "out")
end
function LuaHook_CalShopIntro()
  game.Audio.SetWwiseState("Scene_182_Caldera_CalShopIntro", "in")
end
function LuaHook_CalShopIntroEND()
  game.Audio.SetWwiseState("Scene_182_Caldera_CalShopIntro", "out")
end
function LuaHook_SerpentTranslate()
  game.Audio.StartMusic("SND_MX_CAL_serpent_translate")
  game.Audio.SetWwiseState("Scene_340_Caldera_SerpentTranslate", "in")
end
function LuaHook_SerpentTranslateEND()
  game.Audio.SetWwiseState("Scene_340_Caldera_SerpentTranslate", "out")
end
function LuaHook_BaldurDragonTailTransition()
  game.Audio.StartMusic("SND_MX_PEAK_baldur2_grapple2_trans")
end
function LuaHook_BaldurDragonBackTransition()
  game.Audio.StartMusic("SND_MX_PEAK_baldur2_grapple3_trans")
end
local baldurDragonKill = false
function LuaHook_BaldurDragonKill()
  if baldurDragonKill == false then
    timer.StartCreatureTimer(1.97, LuaHook_BaldurDragonKillDelay)
    baldurDragonKill = true
  end
end
function LuaHook_BaldurDragonKillDelay()
  game.Audio.StartMusic("SND_MX_PEAK_baldur2_fall_outro")
end
function LuaHook_BaldurDragonExit()
  game.Audio.StartMusic("SND_MX_CAL_henge_disruption_prelap")
end
function LuaHook_BaldurDragonExit_Sprint()
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.PlaySound(soundEmitter, "SND_vo_glb_cbt_exrt_nav_breath_sprint_LP")
end
function LuaHook_CalShopIntro()
  game.Audio.StartMusic("SND_MX_CAL_caldera_shop_intro")
end
function LuaHook_RealmTravelIntroCine()
  game.Audio.StartMusic("SND_MX_CAL_realm_travel_intro")
end
local bridgepushInMusic = false
function LuaHook_Cal100BridgePush_ForwardStart01()
  if bridgepushInMusic == false then
    game.Audio.StartMusic("SND_MX_CAL_bridge_push_in")
    bridgepushInMusic = true
  end
end
local bridgepushOutMusic = false
function LuaHook_Cal100BridgePush_Exit01()
  if bridgepushOutMusic == false then
    game.Audio.StartMusic("SND_MX_CAL_bridge_push_out")
    bridgepushOutMusic = true
  end
end
function LuaHook_FastTravelIntro()
  game.Audio.SetWwiseState("Scene_183_Caldera_FastTravelAquired", "in")
end
function LuaHook_FastTravelIntroEND()
  game.Audio.SetWwiseState("Scene_183_Caldera_FastTravelAquired", "out")
end
function LuaHook_DemigodToast()
  game.Audio.StartMusic("SND_MX_CAL_demigod_toast")
  game.Audio.SetWwiseState("Scene_440_TempleFlip_DemigodToast", "in")
end
function LuaHook_DemigodToastEND()
  game.Audio.SetWwiseState("Scene_440_TempleFlip_DemigodToast", "out")
end
function LuaHook_TyrTriptych()
  game.Audio.StartMusic("SND_MX_CAL_tyr_triptych")
  game.Audio.SetWwiseState("Scene_499_RuneVault_TyrTriptych", "in")
end
function LuaHook_TyrTriptychEND()
  game.Audio.SetWwiseState("Scene_499_RuneVault_TyrTriptych", "out")
end
function LuaHook_AlmostHome()
  game.Audio.StartMusic("SND_MX_CAL_almost_home")
  game.Audio.SetWwiseState("Scene_500_Caldera_AlmostHome", "in")
end
function LuaHook_AlmostHomeEND()
  game.Audio.SetWwiseState("Scene_500_Caldera_AlmostHome", "out")
end
function LuaHook_HuldraReunion()
  game.Audio.StartMusic("SND_MX_CAL_huldra_reunion")
  game.Audio.SetWwiseState("Scene_510_Caldera_HuldraReunion", "in")
end
function LuaHook_HuldraReunionEND()
  game.Audio.SetWwiseState("Scene_510_Caldera_HuldraReunion", "out")
end
function LuaHook_SonBoatEnter()
  game.Audio.SetWwiseState("Scene_368_Caldera_SonBoatEnter", "in")
end
function LuaHook_SonBoatEnterEND()
  game.Audio.SetWwiseState("Scene_368_Caldera_SonBoatEnter", "out")
end
function LuaHook_SonBoatExit()
  game.Audio.StartCheckpointedMusic("SND_MX_SonSick_travel_to_freya_2")
  game.Audio.SetWwiseState("Scene_369_Riverpass_SonBoatExit", "in")
end
function LuaHook_SonBoatExitEND()
  game.Audio.SetWwiseState("Scene_369_Riverpass_SonBoatExit", "out")
end
function LuaHook_BrokCares()
  game.Audio.SetWwiseState("Scene_320_Caldera_BrokCares", "in")
end
function LuaHook_BrokCaresEND()
  game.Audio.SetWwiseState("Scene_320_Caldera_BrokCares", "out")
end
function LuaHook_BrokSavesCat()
  game.Audio.SetWwiseState("Scene_383_Caldera_BrokSavesCat", "in")
end
function LuaHook_BrokSavesCatEND()
  game.Audio.SetWwiseState("Scene_383_Caldera_BrokSavesCat", "out")
end
function LuaHook_TalismanAcquire()
  game.Audio.SetWwiseState("Scene_515_TalismanAcquired", "in")
end
function LuaHook_TalismanAcquireEND()
  game.Audio.SetWwiseState("Scene_515_TalismanAcquired", "out")
end
function LuaHook_RealmTravelRestored()
  game.Audio.SetWwiseState("Scene_518_RealmTravelRestored", "in")
end
function LuaHook_RealmTravelRestoredEND()
  game.Audio.SetWwiseState("Scene_518_RealmTravelRestored", "out")
end
function LuaHook_SnakeStatue()
  game.Audio.SetWwiseState("Scene_520_Caldera_SnakesStatue", "in")
end
function LuaHook_SnakeStatueEND()
  game.Audio.SetWwiseState("Scene_520_Caldera_SnakesStatue", "out")
end
function LuaHook_PutDownGenercLongEnter()
  game.Audio.StartMusic("SND_MX_CAL270_skele_button")
end
function LuaHook_SnakeBellyExit_Back()
  game.Audio.StartMusic("SND_MX_CAL_snake_belly_exit")
end
function LuaHook_SayingGoodbye()
  game.Audio.StartMusic("SND_MX_CAL_saying_goodbye")
  game.Audio.SetWwiseState("Scene_580_Caldera_SayingGoodbye", "in")
end
function LuaHook_SayingGoodbyeEND()
  game.Audio.SetWwiseState("Scene_580_Caldera_SayingGoodbye", "out")
end
function LuaHook_MimirsEye()
  game.Audio.StartMusic("SND_MX_CAL_snake_belly_mimir_eye")
end
function LuaHook_Trapped_Enter()
end
function LuaHook_POI_CalTempleFlip010()
  game.Audio.StartMusic("SND_MX_CAL_temple_flip_ring_down")
end
function LuaHook_TNF_TempleFlip_Win2Success()
  game.Audio.StartMusic("SND_MX_CAL_temple_flip_complete")
end
function LuaHook_TNF_TempleFlip_Struggle1_OneShot1()
  local level = game.FindLevel("Cal140_TempleExt")
  level:CallScript("LuaHook_PlaySound_StruggleOneShot", 1)
end
function LuaHook_TNF_TempleFlip_Struggle1_OneShot2()
  local level = game.FindLevel("Cal140_TempleExt")
  level:CallScript("LuaHook_PlaySound_StruggleOneShot", 2)
end
function LuaHook_TNF_TempleFlip_Struggle2_OneShot1()
  local level = game.FindLevel("Cal140_TempleExt")
  level:CallScript("LuaHook_PlaySound_StruggleOneShot", 3)
end
function LuaHook_RealmFallSuccess()
  game.Audio.StartMusic("SND_MX_CAL_realm_between_realms_jump")
end
function LuaHook_RealmFallSuccessEND()
  game.Audio.StartMusic("SND_MX_CAL_between_realms_tower_reveal")
end
function LuaHook_SindriIntro()
  game.Audio.StartMusic("SND_MX_FOOT_meet_sindri")
  game.Audio.SetWwiseState("Scene_185_Foothills_SindriIntro", "in")
end
function LuaHook_SindriIntroEND()
  game.Audio.SetWwiseState("Scene_185_Foothills_SindriIntro", "out")
end
function LuaHook_SindriGetsServed()
  game.Audio.SetWwiseState("Scene_450_Foothills_SindriGetsServed", "in")
end
function LuaHook_SindriGetsServedEND()
  game.Audio.SetWwiseState("Scene_450_Foothills_SindriGetsServed", "out")
end
function LuaHook_JotunnEncounter()
  game.Audio.StartMusic("SND_MX_FOOT_ogre_intro")
  timer.StartCreatureTimer(50, jotunnEncounterDelay)
  game.Audio.SetWwiseState("Scene_187_Foothills_OgreIntro", "in")
end
function jotunnEncounterDelay()
  game.Audio.StartCheckpointedMusic("SND_MX_FOOT_ogre_battle_in")
end
function LuaHook_JotunnEncounterEND()
  game.Audio.SetWwiseState("Scene_187_Foothills_OgreIntro", "out")
end
function LuaHook_BlackBreath()
  game.Audio.SetWwiseState("Scene_190_Foothills_BlackBreath", "in")
  game.Audio.StartMusic("SND_MX_FOOT_black_breath_intro")
end
function LuaHook_BlackBreathEND()
  game.Audio.SetWwiseState("Scene_190_Foothills_BlackBreath", "out")
end
function LuaHook_DoorSpreadFreyaOpen()
  game.Audio.StartMusic("SND_MX_FOOT_gondola_return_out")
end
function LuaHook_AlfheimHengeFull()
  game.Audio.StartMusic("SND_MX_ALF_alfheim_arrival")
  game.Audio.SetWwiseState("Scene_210_Alfheim_AlfheimArrival", "in")
end
function LuaHook_AlfheimHengeFullEND()
  game.Audio.SetWwiseState("Scene_210_Alfheim_AlfheimArrival", "out")
end
function LuaHook_AreYouSerious()
  game.Audio.StartMusic("SND_MX_ALF_drag_boat_to_water")
  game.Audio.SetWwiseState("Scene_215_Alfheim_AreYouSerious", "in")
end
function LuaHook_AreYouSeriousEND()
  game.Audio.SetWwiseState("Scene_215_Alfheim_AreYouSerious", "out")
end
function LuaHook_SonOverwhelmed()
  game.Audio.StartMusic("SND_MX_ALF_son_overwhelmed")
  game.Audio.SetWwiseState("Scene_220_Alfheim_AlfSonOverwhelmed", "in")
end
function LuaHook_SonOverwhelmedEND()
  game.Audio.SetWwiseState("Scene_220_Alfheim_AlfSonOverwhelmed", "out")
end
function LuaHook_SonGapCarryMusic()
  game.Audio.StartMusic("SND_MX_ALF_trench_kidnap_in")
end
function LuaHook_SonGapCarry()
  game.Audio.SetWwiseState("Scene_230_Alfheim_SonGapCarryEnter", "in")
end
function LuaHook_SonGapCarryEND()
  game.Audio.SetWwiseState("Scene_230_Alfheim_SonGapCarryEnter", "out")
end
function LuaHook_SonGapCarryRageFail()
  game.Audio.StartMusic("SND_MX_ALF_trench_kidnap_fail")
end
function LuaHook_AlfSonGapCarryRageScene()
  game.Audio.StartMusic("SND_MX_ALF_trench_kidnap_out")
end
function LuaHook_AlfSonGapCarryEnterPillar()
  game.Audio.StartMusic("SND_MX_ALF_trench_push_pillar_in")
end
function LuaHook_AlfSonGapCarryPillarScene()
  game.Audio.StartMusic("SND_MX_ALF_trench_push_pillar_out")
end
function LuaHook_AlfSonGapCarryPillarSceneEnd()
  LD.StartCombatMusic("SND_MX_ALF_trench_pillar_fight_in", "SND_MX_ALF_trench_pillar_fight_out")
end
function LuaHook_AlfHiveClimbKill()
  game.Audio.StartMusic("SND_MX_ALF_dark_one_attack_1")
  game.Audio.SetWwiseState("Scene_235_Alfhiem_HiveClimbKill", "in")
end
function LuaHook_AlfHiveClimbKillEND()
  game.Audio.SetWwiseState("Scene_235_Alfhiem_HiveClimbKill", "out")
end
function LuaHook_AlfCrashThroughFloor()
  game.Audio.StartMusic("SND_MX_ALF_dark_one_attack_2")
  game.Audio.SetWwiseState("Scene_236_Alfheim_CrashThroughFloor", "in")
end
function LuaHook_AlfCrashThroughFloorEND()
  game.Audio.SetWwiseState("Scene_236_Alfheim_CrashThroughFloor", "out")
end
function LuaHook_AlfTendrilCut02()
  game.Audio.StartMusic("SND_MX_ALF_hive_tendril_cut_02")
  game.Audio.SetWwiseState("Scene_237_Alfheim_TendrilCut02", "in")
end
function LuaHook_AlfTendrilCut02END()
  game.Audio.SetWwiseState("Scene_237_Alfheim_TendrilCut02", "out")
end
function LuaHook_AlfHeimLight()
  game.Audio.StartMusic("SND_MX_ALF_hive_combat_out")
  game.Audio.SetWwiseState("Scene_240_Alfhiem_EnterTheLight", "in")
end
function LuaHook_AlfHeimLight60()
  game.Audio.StartMusic("SND_MX_ALF_enter_light_1")
end
function LuaHook_AlfHeimLightStruggleStart01()
  game.Audio.StartMusic("SND_MX_ALF_enter_light_2")
end
function LuaHook_AlfHeimLightWin()
  game.Audio.StartMusic("SND_MX_ALF_enter_light_3")
end
function LuaHook_AlfHeimLightWinEND()
  game.Audio.StartCheckpointedMusic("SND_MX_ALF_follow_light_1")
  game.Audio.SetWwiseState("Scene_240_Alfhiem_EnterTheLight", "out")
end
function LuaHook_AlfBifrostIntro020CineScene()
  game.Audio.SetWwiseState("Scene_200_Alfhiem_Bifrost_Intro", "in")
end
function LuaHook_AlfBifrostIntro020CineSceneEND()
  game.Audio.SetWwiseState("Scene_200_Alfhiem_Bifrost_Intro", "out")
end
function LuaHook_scnAlfheimLight110CineExit()
  game.Audio.StartMusic("SND_MX_ALF_out_of_the_light")
  game.Audio.SetWwiseState("Scene_242_Alfhiem_OutOfTheLight", "in")
  if game.FindLevel("Alf050_Sound") then
    game.FindLevel("Alf050_Sound"):CallScript("PlayLightLoop")
  end
end
function LuaHook_scnAlfheimLight110CineExitEND()
  game.Audio.SetWwiseState("Scene_242_Alfhiem_OutOfTheLight", "out")
  game.Audio.SetBusLevelRTPCValue("MX_Intensity_Meter", game.Audio.GetMusicIntensity() + game.Encounters.GetEnemiesInCombatCount())
end
function LuaHook_AlfBifrostArrowTutorial()
  game.Audio.StartCheckpointedMusic("SND_MX_ALF_temple_interior_puzzle_in")
  game.Audio.SetWwiseState("Scene_243_Alfhiem_BifrostArrows", "in")
end
function LuaHook_AlfBifrostArrowTutorialEND()
  game.Audio.SetWwiseState("Scene_243_Alfhiem_BifrostArrows", "out")
end
function LuaHook_LightOnesReturn()
  game.Audio.StartMusic("SND_MX_ALF_light_ones_return")
  game.Audio.SetWwiseState("Scene_245_Alfhiem_LightOnesReturn", "in")
end
function LuaHook_LightOnesReturnEND()
  game.Audio.SetWwiseState("Scene_245_Alfhiem_LightOnesReturn", "out")
end
function LuaHook_CSDarkOneEliteHang_Enter()
  game.Audio.StartMusic("SND_MX_ALF_dark_elf_grab_in")
end
function LuaHook_CSDarkOneEliteHang_Win()
  game.Audio.StartMusic("SND_MX_ALF_dark_elf_grab_out")
end
function LuaHook_CSDarkOneKingKill()
  game.Audio.StartMusic("SND_MX_ALF_dark_elf_leader_out")
end
function LuaHook_narAlf00BoatMomTalk10Cine()
  game.Audio.StartMusic("SND_MX_ALF_momfrontation")
  game.Audio.SetWwiseState("Scene_250_Alfhiem_Momfrontation", "in")
end
function LuaHook_narAlf00BoatMomTalk10CineEND()
  game.Audio.SetWwiseState("Scene_250_Alfhiem_Momfrontation", "out")
end
function LuaHook_BrokShop()
  game.Audio.SetWwiseState("Scene_263_Caldera_BrokShop", "in")
end
function LuaHook_BrokShopEND()
  game.Audio.SetWwiseState("Scene_263_Caldera_BrokShop", "out")
end
function LuaHook_SindriStoneMason()
  game.Audio.StartMusic("SND_MX_STN_sindri_stone_mason")
  game.Audio.SetWwiseState("Scene_350_StoneMason_SindriStoneMason", "in")
end
function LuaHook_SindriStoneMasonEND()
  game.Audio.SetWwiseState("Scene_350_StoneMason_SindriStoneMason", "out")
end
function LuaHook_Crack_Climb_Jump_Enter()
  local stoneMasonElevatorLevel = game.FindLevel("Stn430_HammerClimb")
  if stoneMasonElevatorLevel ~= nil then
    stoneMasonElevatorLevel:CallScript("ElevatorMusicOff")
  end
end
function LuaHook_TNF_HammerStrap_Enter()
  game.Audio.StartMusic("SND_MX_STN_hammer_buckle_push")
end
function LuaHook_TNF_HammerStrap_Win()
  game.Audio.StartMusic("SND_MX_STN_hammer_buckle_release")
end
function LuaHook_HammerFallPush()
  game.Audio.StartMusic("SND_MX_STN_hammer_head_push")
end
function LuaHook_HammerFallCine()
  game.Audio.StartMusic("SND_MX_STN_hammer_fall")
  game.Audio.SetWwiseState("Scene_355_StoneMason_HammerFall", "in")
end
function LuaHook_HammerFallCineEND()
  game.Audio.StartMusic("SND_MX_STN_hammer_crawl")
  game.Audio.SetWwiseState("Scene_355_StoneMason_HammerFall", "out")
end
function LuaHook_AttackOfTheBros()
  game.Audio.StartMusic("SND_MX_STN_attack_of_the_bros")
  game.Audio.SetWwiseState("Scene_358_StoneMason_AttackOftheBros", "in")
end
function LuaHook_AttackOfTheBrosEND()
  game.Audio.SetWwiseState("Scene_358_StoneMason_AttackOftheBros", "out")
end
function LuaHook_MagniKillEnter()
  game.Audio.StartMusic("SND_MX_STN_magni_struggle")
end
function LuaHook_MagniKillWin()
  game.Audio.StartMusic("SND_MX_STN_magni_kill")
end
function LuaHook_ChiselSick()
  game.Audio.StartMusic("SND_MX_STN_chisel_sick")
  game.Audio.SetWwiseState("Scene_360_StoneMason_ChiselSick", "in")
end
function LuaHook_ChiselSickEND()
  game.Audio.SetWwiseState("Scene_360_StoneMason_ChiselSick", "out")
end
function LuaHook_Modi2()
  game.Audio.StartMusic("SND_MX_CAL_modi2_intro")
  game.Audio.SetWwiseState("Scene_365_StoneMason_Modi2Enter", "in")
end
function LuaHook_Modi2END()
  game.Audio.SetWwiseState("Scene_365_StoneMason_Modi2Enter", "out")
end
function LuaHook_Modi2Fail()
  game.Audio.StartMusic("SND_MX_CAL_modi2_fail")
end
function LuaHook_FinalFightIntro()
  game.Audio.StartMusic("SND_MX_STN_final_fight_intro")
  timer.StartCreatureTimer(236.67, finalFightMusisDelay)
  game.Audio.SetWwiseState("Scene_540_StoneMason_FinalFightIntro", "in")
end
function finalFightMusisDelay()
  local stoneMasonFinalFightIntroLevel = game.FindLevel("Stn910_BossEntrance")
  if stoneMasonFinalFightIntroLevel ~= nil then
    stoneMasonFinalFightIntroLevel:CallScript("FinalFightMusicDelay")
  end
end
function LuaHook_FinalFightIntroEND()
  game.Audio.SetWwiseState("Scene_540_StoneMason_FinalFightIntro", "out")
end
function LuaHook_csBaldurSlamUpperCutEnter()
  game.Audio.StartMusic("SND_MX_STN_baldur3_fight1_out")
end
function LuaHook_ShieldsDown()
  game.Audio.StartMusic("SND_MX_STN_shields_down")
  game.Audio.SetWwiseState("Scene_550_StoneMason_ShieldsDown", "in")
end
function LuaHook_ShieldsDownEND()
  game.Audio.StartMusic("SND_MX_STN_baldur3_mason_carry")
  game.Audio.SetWwiseState("Scene_550_StoneMason_ShieldsDown", "out")
end
function LuaHook_StoneMason_Phase1_ArenaDrop()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_fight2_in")
end
function LuaHook_FirstElementalTransition()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_fight2b_trans")
end
function LuaHook_CSBaldurSlingShotEnter()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_hand_drop")
end
function LuaHook_phase1_csHandLiftStruggleWin()
  game.Audio.StartMusic("SND_MX_STN_baldur3_hand_out")
end
function LuaHook_csStoneMasonHandLift_SonShootWinEND()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_fight3_in")
end
function LuaHook_csStoneMasonSonHandLift_SonShootFail()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_hand_fail")
  timer.StartCreatureTimer(3, LuaHook_DeathEnter)
end
function LuaHook_csBaldurTomahawkEnter()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_chisel_drop")
end
function LuaHook_ChiselMMA_Defense_TransToHangMMA()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_grapple2_trans")
end
function LuaHook_csChiselSlam_Lift()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_chisel_jump")
end
function LuaHook_ChiselMMA_Hang_TransToChokeMMA()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_flying_arrows")
end
function LuaHook_ChokeMMA_SonDanger_RageBurst()
  game.Audio.StartMusic("SND_MX_STN_baldur3_rage_trans")
end
function LuaHook_ChokeMMA_SonDanger_RageBurstEND()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_final_arena_in")
end
function LuaHook_csBaldurUpperCutToBeatDown_Enter()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_final_arena_out")
end
function LuaHook_CSBaldurBeatDown_Win03()
  game.Audio.StartCheckpointedMusic("SND_MX_STN_baldur3_beatdown")
end
function LuaHook_csStoneMasonKill()
  game.Audio.StartMusic("SND_MX_STN_baldur3_mason_kill")
end
function LuaHook_BaldurDeath()
  game.Audio.StartMusic("SND_MX_STN_baldur_death")
  game.Audio.SetWwiseState("Scene_570_StoneMason_BaldurDeath", "in")
end
function LuaHook_BaldurDeathEND()
  game.Audio.SetWwiseState("Scene_570_StoneMason_BaldurDeath", "out")
end
function LuaHook_ArenaIntroduction()
  game.Audio.StartMusic("SND_MX_HEL_main_bridge_vista")
end
function LuaHook_HelGuardianTrollIntro()
  game.Audio.StartMusic("SND_MX_HEL_guardian_fight_intro")
end
function LuaHook_StopMarkerScanLoop()
  if game.FindLevel("Hel600_GuardianArena") then
    game.FindLevel("Hel600_GuardianArena"):CallScript("StopMarkerScanLoop")
  end
end
function LuaHook_HelGuardianAlertedEND()
  game.Audio.StartCheckpointedMusic("SND_MX_HEL_guardian_fight_p1_in")
end
function LuaHook_RetrieveHeartCineBlades()
  game.Audio.StartMusic("SND_MX_HEL_heart_slice1")
end
function LuaHook_RetrieveHeartCineInsertBlades()
  game.Audio.StartMusic("SND_MX_HEL_heart_slice2")
end
function LuaHook_RetrieveHeartCineScene()
  game.Audio.StartMusic("SND_MX_HEL_retrieve_heart")
  game.Audio.SetWwiseState("Scene_387_Helheim_RetrieveHearCineBlades", "in")
end
function LuaHook_RetrieveHeartCineSceneEND()
  game.Audio.SetWwiseState("Scene_387_Helheim_RetrieveHearCineBlades", "out")
end
function LuaHook_TNF_UpperDeckPush_Win()
  local soundLevel = game.FindLevel("HelR050_Sound")
  if soundLevel ~= nil then
    soundLevel:CallScript("StopDockExploreMusic")
  end
end
function LuaHook_TNF_ShipHarpMoment03_Front_Enter()
  game.Audio.StartMusic("SND_MX_HEL_ship_push_in")
end
function LuaHook_TNF_ShipHarpMoment03_Front_Fail()
  game.Audio.StartMusic("SND_MX_HEL_ship_push_fail")
end
function LuaHook_FlyingBoatJump()
  game.Audio.StartMusic("SND_MX_HEL_flying_boat_jump")
  game.Audio.SetWwiseState("Scene_498_HelheimReturn_FlyingBoatJump", "in")
end
function LuaHook_FlyingBoatJumpEND()
  game.Audio.SetWwiseState("Scene_498_HelheimReturn_FlyingBoatJump", "out")
  local helR300 = game.FindLevel("HelR300_HelShip")
  if helR300 ~= nil then
    local shipScript = helR300:FindSingleGameObject("HelheimShipScript")
    if shipScript ~= nil then
      shipScript:CallScript("StopAllBoatLoops")
    end
  end
end
function LuaHook_HengeDisruptionMixer()
  game.Audio.SetWwiseState("Scene_490_Caldera_HengeDisruption", "in")
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.StopSound(soundEmitter, "SND_vo_glb_cbt_exrt_nav_breath_sprint_LP")
end
function LuaHook_HengeDisruptionEND()
  game.Audio.SetWwiseState("Scene_490_Caldera_HengeDisruption", "out")
  local player = game.Player.FindPlayer()
  local soundEmitter = player:FindSingleSoundEmitterByName("SNDMouth")
  LD.StopSound(soundEmitter, "SND_vo_glb_cbt_exrt_nav_breath_sprint_LP")
end
function LuaHook_OutOfControl()
  game.Audio.SetWwiseState("Scene_492_HelehimReturn_OutOfControl", "in")
end
function LuaHook_OutOfControlEND()
  game.Audio.SetWwiseState("Scene_492_HelehimReturn_OutOfControl", "out")
end
function LuaHook_DrainAcquire()
  game.Audio.SetWwiseState("Scene_388_Helheim_HelDrainAcquire", "in")
end
function LuaHook_DrainAcquireEND()
  game.Audio.SetWwiseState("Scene_388_Helheim_HelDrainAcquire", "out")
end
function LuaHook_FirstSawClaw()
  game.Audio.StartMusic("SND_MX_PEAK_enter_lower_chimney")
end
function LuaHook_RopeStuckA()
  game.Audio.StartMusic("SND_MX_PEAK_rope_stuck_a")
  game.Audio.SetWwiseState("Scene_267_PeaksPass_RopeStuckA", "in")
end
function LuaHook_RopeStuckAEND()
  game.Audio.SetWwiseState("Scene_267_PeaksPass_RopeStuckA", "out")
end
function LuaHook_SkyLantern()
  game.Audio.StartMusic("SND_MX_PEAK_sky_lantern")
  game.Audio.SetWwiseState("Scene_270_PeaksPass_SkyLantern", "in")
end
function LuaHook_SkyLanternEND()
  game.Audio.SetWwiseState("Scene_270_PeaksPass_SkyLantern", "out")
end
function LuaHook_FreeStuckElevator()
  local level = game.FindLevel("Peak380_BigElevator")
  if level ~= nil then
    level:CallScript("LuaHook_FreeStuckElevator")
  end
end
function LuaHook_DragonBreathEnterB()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_dragon_boss_elevator_in")
  print("beam burst 49%")
end
function LuaHook_SG1_CSSmashDragonFace()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_elevator_out")
end
function LuaHook_DragonFightCine()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_sindri")
  game.Audio.SetWwiseState("Scene_280_PeaksPass_DragonFight", "in")
end
function LuaHook_DragonFightCineEND()
  game.Audio.SetWwiseState("Scene_280_PeaksPass_DragonFight", "out")
end
function LuaHook_STG2_CSDragonBackAttack()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_mount")
end
function LuaHook_STG3_CSDragonSpitKratosToSTG3()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_dragon_boss_arena")
end
function LuaHook_STG3_Pos02HitBombFace_Trans()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_dragon_boss_crane")
end
function LuaHook_STG3_CSDragonFinisherStart()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_claw")
end
function LuaHook_STG3_CSDragonFinisherExit()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_complete")
end
function LuaHook_SindriDragonCine()
  game.Audio.StartMusic("SND_MX_PEAK_meet_sindri")
  game.Audio.SetWwiseState("Scene_290_PeaksPass_SindriDragon", "in")
end
function LuaHook_SindriDragonCineEND()
  game.Audio.SetWwiseState("Scene_290_PeaksPass_SindriDragon", "out")
end
function LuaHook_DragonChopEnter()
  game.Audio.SetWwiseState("Scene_295_PeaksPass_DragonChopEnter", "in")
end
function LuaHook_DragonChopEnterEND()
  game.Audio.SetWwiseState("Scene_295_PeaksPass_DragonChopEnter", "out")
end
function LuaHook_VibrateArrows()
  game.Audio.StartMusic("SND_MX_PEAK_vibrate_arrows")
end
function LuaHook_ArrowFix()
  game.Audio.StartMusic("SND_MX_PEAK_arrow_fix")
  game.Audio.SetWwiseState("Scene_300_PeaksPass_ArrowFix", "in")
end
function LuaHook_ArrowFixEND()
  game.Audio.SetWwiseState("Scene_300_PeaksPass_ArrowFix", "out")
end
function LuaHook_MimirIntro()
  game.Audio.StartMusic("SND_MX_PEAK_mimir_intro")
  game.Audio.SetWwiseState("Scene_310_PeaksPass_MimirIntro", "in")
end
function LuaHook_MimirIntroEND()
  game.Audio.SetWwiseState("Scene_310_PeaksPass_MimirIntro", "out")
end
function LuaHook_ModiReturnsCine()
  game.Audio.StartMusic("SND_MX_PEAK_modi_return")
  game.Audio.SetWwiseState("Scene_460_PeaksPass_ModiReturns", "in")
end
function LuaHook_ModiReturnsCineEND()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK2_explore1_in")
  game.Audio.SetWwiseState("Scene_460_PeaksPass_ModiReturns", "out")
end
function LuaHook_BaldurReturns()
  game.Audio.StartMusic("SND_MX_PEAK_baldur_returns")
  game.Audio.SetWwiseState("Scene_470_PeaksPass_BaldurReturns", "in")
end
function LuaHook_BaldurReturnsEND()
  game.Audio.SetWwiseState("Scene_470_PeaksPass_BaldurReturns", "out")
end
function LuaHook_BaldurDragonEnter()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_baldur2_leap_intro")
end
function LuaHook_BaldurDragonEnterEND()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_baldur2_grapple1_trans")
end
function LuaHook_SonBond()
  game.Audio.StartMusic("SND_MX_JOT_son_bond")
  game.Audio.SetWwiseState("Scene_590_Jotunheim_SonBond", "in")
end
function LuaHook_SonBondEND()
  game.Audio.SetWwiseState("Scene_590_Jotunheim_SonBond", "out")
end
function LuaHook_MothersSecretReveal()
  game.Audio.StartMusic("SND_MX_JOT_mothers_secret_reveal")
  game.Audio.SetWwiseState("Scene_600_Jotunheim_MothersSecretReveal", "in")
end
function LuaHook_MothersSecretRevealEND()
  game.Audio.SetWwiseState("Scene_600_Jotunheim_MothersSecretReveal", "out")
end
function LuaHook_ReleaseAshes()
  game.Audio.StartMusic("SND_MX_JOT_release_ashes")
  game.Audio.SetWwiseState("Scene_310_Jotunheim_ReleaseAshes", "in")
end
function LuaHook_ReleaseAshesEND()
  game.Audio.SetWwiseState("Scene_310_Jotunheim_ReleaseAshes", "out")
end
function LuaHook_MimirPickup()
  game.Audio.StartMusic("SND_MX_JOT_credits_01_out")
end
function LuaHook_HailToTheKing()
  game.Audio.StartMusic("SND_MX_XPL100_find_king")
  game.Audio.SetWwiseState("Scene_940_XPL_HailToTheKing", "in")
end
function LuaHook_HailToTheKingEND()
  game.Audio.SetWwiseState("Scene_940_XPL_HailToTheKing", "out")
end
function LuaHook_SindriQuest2()
  game.Audio.StartMusic("SND_MX_XPL300_find_dead_reaver")
  game.Audio.SetWwiseState("Scene_930_XPL_SindriQuest2", "in")
end
function LuaHook_SindriQuest2END()
  game.Audio.SetWwiseState("Scene_930_XPL_SindriQuest2", "out")
end
function LuaHook_BrokQuest1()
  game.Audio.StartMusic("SND_MX_XPL400_spot_soul_eater")
  game.Audio.SetWwiseState("Scene_900_XPL_BrokQuest1", "in")
end
function LuaHook_BrokQuest1END()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL400_explore1_in")
  game.Audio.SetWwiseState("Scene_900_XPL_BrokQuest1", "out")
end
function LuaHook_SindriQuest1()
  game.Audio.SetWwiseState("Scene_910_XPL_SindriQuest1", "in")
end
function LuaHook_SindriQuest1END()
  game.Audio.SetWwiseState("Scene_910_XPL_SindriQuest1", "out")
end
function LuaHook_BrokQuest2()
  game.Audio.SetWwiseState("Scene_920_XPL_BrokQuest2", "in")
end
function LuaHook_BrokQuest2END()
  game.Audio.SetWwiseState("Scene_920_XPL_BrokQuest2", "out")
end
function LuaHook_CSWingRipDeath()
  if game.FindLevel("Alf355_ChiselDungeon") then
    game.Audio.StartMusic("SND_MX_ALF_valkyrie_fight_out")
  elseif game.FindLevel("Foot250_ChiselArena") then
    game.Audio.StartMusic("SND_MX_FOOT_valkyrie_fight_out")
  elseif game.FindLevel("Hel350_ChiselArena") then
    game.Audio.StartMusic("SND_MX_HEL_valkyrie_fight_out")
  elseif game.FindLevel("Msp100_Base") then
    game.Audio.StartMusic("SND_MX_MSP_valkyrie_fight_out")
  elseif game.FindLevel("Nid310_NWRoom") then
    game.Audio.StartMusic("SND_MX_NIF_valkyrie_fight_out")
  elseif game.FindLevel("Peak205_ChiselArena") then
    game.Audio.StartMusic("SND_MX_PEAK_valkyrie_fight_out")
  elseif game.FindLevel("Riv975_ChiselArena") then
    game.Audio.StartMusic("SND_MX_RIV_valkyrie_fight_out")
  elseif game.FindLevel("Stn110_ChiselArena") then
    game.Audio.StartMusic("SND_MX_STN_valkyrie_fight_out")
  elseif game.FindLevel("Xpl600_MasonTrail") then
    game.Audio.StartMusic("SND_MX_XPL600_valkyrie_fight_out")
  end
end
function LuaHook_ValkyieHelmetExit()
  if game.FindLevel("Xpl600_MasonTrail") then
    game.Audio.StartMusic("SND_MX_XPL600_valkyrie_complete")
  end
end
function LuaHook_HelDrain_Timer_Start()
  timer.StartCreatureTimer(1, HelDrain_Timer_SFX_Start)
end
function HelDrain_Timer_SFX_Start()
  local player = game.Player.FindPlayer()
  if player:PickupIsActive("DrainEnergy") then
    LD.PlaySound(player:FindSingleSoundEmitterByName("SNDKratos"), "SND_MAG_Blades_HelDrain_Timer")
  end
end
