local mpicon = require("ui.mpicon")
local DL = require("design.DesignerLibrary")
local uiCalls = require("ui.uicalls")
local lookAtConsts = require("game.lookAtConsts")
lookAtConsts.RegisterDuringUIStartup()
local timer = require("creature.timer")
local LD = require("design.LevelDesignLibrary")
local TUT = require("game.GlobalTutorials")
local color = require("core.color")
engine.SetIncrementalGCTime(250)
local traverselink = require("creature.traverselink")
traverselink.InstallHooks()
local locomotion = require("creature.locomotion")
locomotion.Install()
local perks = require("hero.perks")
perks.InstallHooks()
local components = require("design.components")
local scriptComponents = {
  components.Debuff_HeroFrostComponent.New(),
  components.Debuff_HeroFreezeComponent.New(),
  components.Debuff_HeroBurnComponent.New(),
  components.Debuff_HeroPoisonComponent.New(),
  components.Debuff_HeroBlindComponent.New(),
  components.Debuff_HeroCursedComponent.New(),
  components.Debuff_HeroDazeComponent.New(),
  components.RageModeComponent.New()
}
local lValue, rValue, lRelValue, rRelValue
local weaponsLoaded = false
local wasFrosty = false
local sprintingLastFrame = false
local sprintTimer = 0
local blockTimer = 0
local inSynchMovePrevFrame, inSynchCurrentFrame, currentCarry, currentBase, riftEncounterStarted
local isVince = false
local initializedLookAtValues = false
local sonbb
local boatNavIdleTimer = timer.StartCreatureTimer(1.4)
boatNavIdleTimer:Stop()
local walkTimer = timer.StartCreatureTimer(0.8)
walkTimer:Stop()
_G.thisLookAtEntry = nil
_G.lookAtPriorityOverrides = {}
local playerVelocity, giveLootChance
local giveLootType = "commonLoot"
local conRumbleMedium = {EffectName = "FFB_MEDIUM", Duration = 3}
local conRumbleLight = {EffectName = "FFB_MEDIUM", Duration = 1}
local ffbRumbleThrowHeavy = {
  EffectName = "FFB_THROW_HEAVY",
  Duration = 1.5
}
local ffbRumbleThrow = {
  EffectName = "FFB_LIGHT_ATTACK_03",
  Duration = 1.5
}
local ffbRumbleExplode = {
  EffectName = "FFB_HEAVY_RUMBLE_LOOP_SHORT",
  Duration = 1.5
}
local shiftDelayTimer = timer.StartCreatureTimer(0.1)
shiftDelayTimer:Stop()
local hipDelayTimer = timer.StartCreatureTimer(0.5)
hipDelayTimer:Stop()
local buttonDelayTimer = timer.StartCreatureTimer(0.1)
buttonDelayTimer:Stop()
local playerCreature = game.Player.FindPlayer()
local son = game.AI.FindSon()
local mimirEyeVisible = false
local setupPouchOnStart = false
local bifrostObj, bifrostBottomMesh
local tier1RecipesGiven = false
local unlockAll = false
local unlockAllFastTravel = false
local discoverAllMap = false
local shockArrowUnlocked = false
local lightArrowUnlocked = false
local resourcesGiven = false
local unlockAllMetersAndCiphers = false
local inRageMode = false
local lastUpdateCombatState = false
local warpLoc, warpRot
local VFS = {}
VFS.AxeFrostDebug = engine.VFSBool.New("Axe Frost Debug")
VFS.PositionDistanceDebug = engine.VFSBool.New("Position Distance Debug -- Press Triangle")
VFS.UnlockAllTrinkets = engine.VFSBool.New("Unlock All Talismans")
VFS.UnlockAllWeaponComponents = engine.VFSBool.New("Unlock All Weapon Components")
VFS.UnlockEverything = engine.VFSBool.New("Unlock All")
VFS.UnlockAllFastTravel = engine.VFSBool.New("Unlock All Fast Travel")
VFS.DiscoverAllMap = engine.VFSBool.New("Discover All Map")
VFS.GiveResources = engine.VFSBool.New("Give Crafting Resources")
VFS.UnlockBowReinforcement = engine.VFSBool.New("Unlock Bow Reinforcement")
VFS.UnlockShockArrow = engine.VFSBool.New("Unlock Shock Arrow")
VFS.UnlockLightArrow = engine.VFSBool.New("Unlock Light Arrow")
VFS.UnlockAllMetersAndCiphers = engine.VFSBool.New("Unlock All Meter Upgrades and Ciphers")
VFS.UnlockAllSpecials = engine.VFSBool.New("Unlock All Weapon Specials")
VFS.EnableMomentumSystem = engine.VFSBool.New("Enable Momentum System")
VFS.EnableMomentumSystem.value = false
VFS.SetMomentumAmount = engine.VFSFloat.New("Set Momentum Meter Amount", -1, 100, 0.5)
VFS.SetMomentumAmount.value = -1
VFS.InfiniteRage = engine.VFSBool.New("Infinite Rage and Momentum")
VFS.InfiniteRage.value = false
VFS.EnableEasyStun = engine.VFSBool.New("Enable Easy Stun")
VFS.EnableEasyStun.value = false
VFS.EnableEasyStunCurrentState = false
VFS.DisableStun = engine.VFSBool.New("Disable Stun Reactions")
VFS.DisableStun.value = false
VFS.DisableStunCurrentState = false
VFS.UnlockTier01 = engine.VFSInt.New("Tier 01: 1 = Tank - 2 = Damage - 3 Speed", 0, 3)
VFS.UnlockTier02 = engine.VFSInt.New("Tier 02: 1 = Tank - 2 = Damage - 3 Speed", 0, 3)
VFS.UnlockTier03 = engine.VFSInt.New("Tier 03: 1 = Tank - 2 = Damage - 3 Speed", 0, 3)
VFS.UnlockTier04 = engine.VFSInt.New("Tier 04: 1 = Tank - 2 = Damage - 3 Speed", 0, 3)
VFS.UnlockTier05 = engine.VFSInt.New("Tier 05: 1 = Tank - 2 = Damage - 3 Speed", 0, 3)
VFS.UnlockTier06 = engine.VFSInt.New("Tier 06: 1 = Tank - 2 = Damage - 3 Speed", 0, 3)
VFS.AddArmorRunes = engine.VFSInt.New("Add Armor Runes by Tier", 0, 6)
VFS.Unlock_AddArmorRunes = 0
VFS.AddUniqueRunes = engine.VFSInt.New("Add UniqueRunes", 0, 17)
VFS.Unlock_AddUniqueRunes = 0
VFS.RuneDebugStat = engine.VFSInt.New("RUNE DEBUG: Select Stat 1 = Strength - 2 = Runic ...", 1, 6)
VFS.RuneDebugStat.value = 1
VFS.RuneDebugPerk = engine.VFSInt.New("RUNE DEBUG: Select Perk", 1, 18)
VFS.RuneDebugPerk.value = 1
VFS.RuneDebugTier = engine.VFSInt.New("RUNE DEBUG: Select Tier", 2, 6)
VFS.RuneDebugTier.value = 2
VFS.RuneDebugCreate = engine.VFSInt.New("RUNE DEBUG: Create Rune (move to 6 then back to 0)", 0, 6)
VFS.Unlock_RuneDebugCreate = 0
VFS.UnlockArmor_DefenseTierPrevFrame = 0
VFS.UnlockArmor_PureDamageTierPrevFrame = 0
VFS.UnlockArmor_FocusTierPrevFrame = 0
VFS.UnlockArmor_ToughnessTierPrevFrame = 1
VFS.UnlockArmor_HybridDamageTierPrevFrame = 1
VFS.UnlockArmor_RunicTierPrevFrame = 1
VFS.UnlockArmor_MusSpecialPrevFrame = 0
VFS.UnlockArmor_NifSpecialPrevFrame = 0
VFS.UnlockArmor_ValkSpecialPrevFrame = 0
VFS.UnlockArmor_DefenseTier = engine.VFSInt.New("UNLOCK ARMOR: Defense Armor Set, Tiers 1 - 6", 0, 6)
VFS.UnlockArmor_PureDamageTier = engine.VFSInt.New("UNLOCK ARMOR: Pure Damage Armor Set, Tiers 1 - 6", 0, 6)
VFS.UnlockArmor_FocusTier = engine.VFSInt.New("UNLOCK ARMOR: Focus Armor Set, Tiers 1 - 6", 0, 6)
VFS.UnlockArmor_ToughnessTier = engine.VFSInt.New("UNLOCK ARMOR: Toughness Armor Set, Tiers 2 - 6", 0, 6)
VFS.UnlockArmor_HybridDamageTier = engine.VFSInt.New("UNLOCK ARMOR: Hybrid Damage Armor Set, Tiers 2 - 6", 0, 6)
VFS.UnlockArmor_RunicTier = engine.VFSInt.New("UNLOCK ARMOR: Runic Armor Set, Tiers 2 - 6", 0, 6)
VFS.UnlockArmor_MusSpecial = engine.VFSInt.New("UNLOCK ARMOR: Muspelheim (Tier04 - Tier07)", 0, 3)
VFS.UnlockArmor_NifSpecial = engine.VFSInt.New("UNLOCK ARMOR: Nifleheim (Tier060 - Tier08)", 0, 3)
VFS.UnlockArmor_ValkSpecial = engine.VFSInt.New("UNLOCK ARMOR: Valkyrie (Tier06 - Tier08)", 0, 3)
VFS.UpgradeArmorPrevFrame = false
VFS.UpgradeArmor = engine.VFSBool.New("Auto Upgrade Armor to max stage")
VFS.UnlockTier01_PrevFrame = 0
VFS.UnlockTier02_PrevFrame = 0
VFS.UnlockTier03_PrevFrame = 0
VFS.UnlockTier04_PrevFrame = 0
VFS.UnlockTier05_PrevFrame = 0
VFS.UnlockTier06_PrevFrame = 0
VFS.GiveResources.value = false
VFS.UnlockBowReinforcement.value = false
VFS.UnlockShockArrow.value = false
VFS.UnlockLightArrow.value = false
VFS.UnlockEverything.value = false
VFS.UnlockAllSpecials.value = false
VFS.UnlockAllTrinkets.value = false
VFS.UnlockAllWeaponComponents.value = false
VFS.UnlockAllMetersAndCiphers.value = false
VFS.HideSpeedControlInfo = engine.VFSBool.New("Hide Speed Control Info")
local WeaponComponentsUnlocked = false
local TrinketsUnlocked = false
local SpecialsUnlocked = false
local axeIsAcquired = false
local UnlockPlaytestVar = false
local ForceCheckMapState = false
local tetherArrow_lastKnownPosition
local tetherArrowExists = false
local AxeFrostState = "Off"
local AxeFrostResetTimer = 0
local AxeFrostResetTimeValue = 5
local playerHealthCurrent = 100
local playerHealthMaxPrevFrame = 100
local playerHealthMax = 100
local playerHealthPercent = 100
local healthPrevFrame = 100
local playerHealthLowThreshold = 20
local playerHealthCriticalThreshold = 10
local healthDifference = 0
local showLowHealthWarningTimer = 0
local showLowHealthWarningTimerMax = 10
local shieldSoundEmitter = playerCreature:FindSingleSoundEmitterByName("SNDRightHand")
local chainSoundEmitterR, chainSoundEmitterL
local lowHealthSFXCall = false
function LuaHook_CheckTraverseLink(crt, data)
  if crt:GetTraverseLink() == nil then
    return data:FindOutcomeBranchesEntry("BranchNav")
  end
end
function LuaHook_PyreFire()
  local level = game.FindLevel("For200_House")
  level:CallScript("LuaHook_PyreFire_For200")
end
local encounterMusic = {}
encounterMusic.combatMusicStart = nil
encounterMusic.combatMusicEnd = nil
encounterMusic.activeEnemies = 0
encounterMusic.lastEnemyCount = 0
function CombatEncounterStarted(ai, startMusic, endMusic)
  EvaluateCombatMusicStart(ai, startMusic, endMusic)
end
function EvaluateCombatMusicStart(ai, startMusic, endMusic)
  if startMusic and endMusic and encounterMusic.combatMusicStart == nil and encounterMusic.combatMusicEnd == nil then
    encounterMusic.combatMusicStart = startMusic
    encounterMusic.combatMusicEnd = endMusic
    game.Audio.StartMusic(encounterMusic.combatMusicStart)
  end
end
function CombatEncounterEnded(ai, endMusicOverride)
  if bboard:GetNumber("ActiveCombatEncounters") <= 0 and encounterMusic.combatMusicStart ~= nil then
    EvaluateCombatMusicEnd(ai, endMusicOverride)
  end
end
function EvaluateCombatMusicEnd(ai, endMusicOverride)
  if encounterMusic.combatMusicEnd ~= nil or endMusicOverride ~= nil then
    local endMusic = endMusicOverride or encounterMusic.combatMusicEnd
    game.Audio.StartMusic(endMusic)
    encounterMusic.combatMusicStart = nil
    encounterMusic.combatMusicEnd = nil
  end
end
function LuaHook_AxeLightTurn180()
  print(tostring(LD.GetEntityVariable("MusicIntensity") + encounterMusic.activeEnemies) .. " music meter")
end
local boatExitCheckpointEnabled = true
function DisableNextDockingCheckpoint()
  boatExitCheckpointEnabled = false
end
function LuaHook_CheckpointOnExit()
  local maxDistance = 30
  local nearestDock
  local nearbyDocks = game.World.FindGameObjectsByMarker("BoatDock", playerCreature:GetWorldPosition(), maxDistance)
  for _, dock in pairs(nearbyDocks) do
    if maxDistance > game.AIUtil.Distance(playerCreature, dock) then
      maxDistance = game.AIUtil.Distance(playerCreature, dock)
      nearestDock = dock
    end
  end
  nearestDock:CallScript("UpdateBoatLocationAndStoreCheckpoint", boatExitCheckpointEnabled)
  boatExitCheckpointEnabled = true
end
local debugPosStart, debugPosEnd, debugPosDistanceXZ, debugPosDistanceY
local debugPosSwitch = true
local debugPosResult
local UI = game.UI
VFS.ShowWorldOffscreenIndicator = engine.VFSBool.New("World Offscreen Indicator")
VFS.ShowWorldOffscreenIndicator.value = false
stats = {
  Strength = 10,
  Endurance = 10,
  Power = 15,
  Focus = 6,
  Luck = 7,
  Recovery = 25
}
armor = {
  ItemName = "null",
  ItemStats = stats,
  Level = 0
}
local fseVignetteTakeDmg = {
  EffectName = "FSE_ColorCorrection_TakeDamage",
  Duration = 0.2,
  TweenInTime = 0.1,
  TweenInEaseIn = 0.1,
  TweenOutEaseOut = 0.5,
  TweenOutTime = 0.45
}
local fseVignetteTakeDmgCritical = {
  EffectName = "FSE_ColorCorrection_TakeDamageCritical",
  Duration = 0.25,
  TweenInTime = 0.5,
  TweenInEaseIn = 0.4,
  TweenOutEaseOut = 0.65,
  TweenOutTime = 0.5
}
local fseVignetteTakeDmgCriticalDelayed = {
  EffectName = "FSE_ColorCorrection_TakeDamageCritical_Delayed",
  Duration = 0.75,
  TweenInTime = 0.5,
  TweenInEaseIn = 0.4,
  TweenOutEaseOut = 0.65,
  TweenOutTime = 0.5
}
local fseVignetteMoveArmor = {
  EffectName = "FSE_ColorCorrection_MoveArmor",
  Duration = 0.65,
  TweenInTime = 0.1,
  TweenInEaseIn = 0.1,
  TweenOutEaseOut = 0.5,
  TweenOutTime = 0.45
}
local padColorReset = false
local reviveDisabled = false
function _G.OnGOCreateLuaState(go)
  go:SetBlackboardSize(16)
  bboard = go:GetPrivateBlackboard()
  go:SetInfluenceConeAngle(95)
  go:SetInfluenceConeLength(4)
  go:SetInfluenceConeIntensity(0.1)
  go:SetInfluenceConeDecay(game.Creature.InfluenceConeDecay.kLinearDecay)
  go:SetInfluenceConeIsEnabled(true)
  go:SetInfluenceCircleRadius(3.25)
  go:SetInfluenceCircleIntensity(0.02)
  go:SetInfluenceCircleDecay(game.Creature.InfluenceConeDecay.kLinearDecay)
  go:SetInfluenceCircleIsEnabled(true)
  reviveDisabled = false
  mpicon.level.Create(go, "KRATOS_HEALTH_BAR", "zerojoint")
  if go.SetOverrideStatusEffectIconParent ~= nil then
    go:SetOverrideStatusEffectIconParent("KRATOS_HEALTH_BAR")
  end
end
global = {}
global.inventory = {}
global.sprintAccessibilityTimeHeld = 0
rageLevel = 0
gVFSInfiniteMeter = engine.VFSBool.New("Ironsight Son Commands")
translationDriver = nil
rotationDriver = nil
bboard = nil
local statusEffectIconsOn = {}
statusEffectIconsOn.BURN = false
statusEffectIconsOn.FROST = false
statusEffectIconsOn.POISON = false
statusEffectIconsOn.WEAKEN = false
statusEffectIconsOn.BLIND = false
statusEffectIconsOn.DAZE = false
statusEffectIconsOn.CURSED = false
wasAimCapable = false
wasAiming = false
wasAttacking = false
wasBlocking = false
wasBlockFull = false
wasAxeFrostPowerUp = false
reticleTargetCreatureChangeTimer = 0
reticleTargetCreatureTimeThreshold = 1
reticleTargetCreatureTimeThresholdFast = 0.25
reticleTargetCreaturePrevious = nil
global.DebugLoadout = {}
global.DebugLoadout.initialized = false
global.DebugLoadout.pickups = {"Bifrost", "Blades"}
local DebugGiveHeroLoadout = function(C)
  if game.Resources.SetDebugAddMode then
    game.Resources.SetDebugAddMode(true)
  end
  if global.DebugLoadout.initialized == false then
    local levelName = C.GroundLevel
    if levelName then
      global.DebugLoadout.initialized = true
      levelName = string.upper(levelName.Name)
      if string.find(levelName, "WAD_TB") == 1 then
        for _, pickups in ipairs(global.DebugLoadout.pickups) do
          game.Wallets.AddResource("HERO", "Blades", 1, "NO_TELEMETRY")
          if C:PickupIsAcquired(pickups) == false then
            C:PickupAcquire(pickups)
          end
        end
      end
    end
  end
  if game.Resources.SetDebugAddMode then
    game.Resources.SetDebugAddMode(false)
  end
end
local IsValidRuneID = function(runeID)
  return runeID ~= nil and runeID ~= 1
end
local HasFlag = function(runeID, flag)
  local hasFlag = false
  if IsValidRuneID(runeID) then
    hasFlag = game.Wallets.RuneHasFlag("HERO", runeID, {flag})
  end
  return hasFlag
end
function LuaHook_ActivateTalisman_EmpoweringRift(C)
  local runesInPickup = game.Wallets.FindPickupRunes("HERO", "KratosArmorTrinket_EmpoweringRift")
  if runesInPickup[1] ~= nil then
    local runeID = runesInPickup[1]
    if game.Wallets.RuneHasFlag("HERO", runeID, {"Tier02"}) then
      playerCreature:PickupAcquire("Buff_SuperArmor")
    end
  end
  if runesInPickup[2] ~= nil then
    local runeID02 = runesInPickup[2]
    if game.Wallets.RuneHasFlag("HERO", runeID02, {"Tier02"}) then
      playerCreature:PickupAcquire("Buff_HealthBurst")
    end
  end
  if runesInPickup[3] ~= nil then
    local runeID03 = runesInPickup[3]
    if game.Wallets.RuneHasFlag("HERO", runeID03, {"Tier02"}) then
      playerCreature:PickupAcquire("Buff_CooldownBurst")
    end
  end
end
function LuaHook_CombatEvent_CooldownActivated(C, pickupName)
  local pickupNameString = tostring(pickupName)
  local specialLight = playerCreature.PickupGetPickupNameInSlot(playerCreature, "WeaponSpecial_Light")
  local specialHeavy = playerCreature.PickupGetPickupNameInSlot(playerCreature, "WeaponSpecial_Heavy")
  local specialBladesLight = playerCreature.PickupGetPickupNameInSlot(playerCreature, "WeaponSpecial_Blades_Light")
  local specialBladesHeavy = playerCreature.PickupGetPickupNameInSlot(playerCreature, "WeaponSpecial_Blades_Heavy")
  if pickupNameString == specialBladesHeavy and playerCreature:PickupIsAcquired(pickupNameString) then
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff")
    end
  end
  if pickupNameString == specialBladesLight and playerCreature:PickupIsAcquired(pickupNameString) then
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff")
    end
  end
  if pickupNameString == specialLight and playerCreature:PickupIsAcquired(pickupNameString) then
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff")
    end
  end
  if pickupNameString == specialHeavy and playerCreature:PickupIsAcquired(pickupNameString) then
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnActivation_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_HealthBurst") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst")
    end
    if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnRefresh_RunicBuff") then
      playerCreature:CallScript("LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff")
    end
  end
end
local Unlock_Trinkets = function(C, tier)
  if 1 <= tier then
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_LowHealth_Offense", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_LowHealth_Shield", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_HealthBurst", 1, "NO_TELEMETRY")
  end
  if 2 <= tier then
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_RageMode", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_RageGrab", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Talisman_WeaponSpecials_Runic", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_Parry", 1, "NO_TELEMETRY")
  end
  if 3 <= tier then
    game.Wallets.AddResource("HERO", "Perk_Defense_OnBlock_ActiveAbsorb", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Utility_JustEvade_Slowdown", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Utility_Focus_Mode", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_EmpoweringRift", 1, "NO_TELEMETRY")
  end
  if 4 <= tier and 1 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_FrostActivation") then
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_FrostActivation", 1, "NO_TELEMETRY")
  end
  if 5 <= tier then
    if 1 > game.Wallets.GetResourceValue("HERO", "Perk_Talisman_Muspelheim") then
      game.Wallets.AddResource("HERO", "Perk_Talisman_Muspelheim", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "Perk_Talisman_Niflheim") then
      game.Wallets.AddResource("HERO", "Perk_Talisman_Niflheim", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_EmpoweringRift") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_EmpoweringRift", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_FrostActivation") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_FrostActivation", 1, "NO_TELEMETRY")
    end
  end
  if 6 <= tier then
    if 1 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_CurseActivation") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_CurseActivation", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_Gauntlet") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_Gauntlet", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_EmpoweringRift") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_EmpoweringRift", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "Perk_Talisman_Muspelheim") then
      game.Wallets.AddResource("HERO", "Perk_Talisman_Muspelheim", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "Perk_Talisman_Niflheim") then
      game.Wallets.AddResource("HERO", "Perk_Talisman_Niflheim", 1, "NO_TELEMETRY")
    end
    if 3 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_FrostActivation") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_FrostActivation", 1, "NO_TELEMETRY")
    end
  end
  if 7 <= tier then
    if 1 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_Valkyrie") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_Valkyrie", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_CurseActivation") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_CurseActivation", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_Gauntlet") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_Gauntlet", 1, "NO_TELEMETRY")
    end
    if 3 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_EmpoweringRift") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_EmpoweringRift", 1, "NO_TELEMETRY")
    end
    if 3 > game.Wallets.GetResourceValue("HERO", "Perk_Talisman_Muspelheim") then
      game.Wallets.AddResource("HERO", "Perk_Talisman_Muspelheim", 1, "NO_TELEMETRY")
    end
    if 3 > game.Wallets.GetResourceValue("HERO", "Perk_Talisman_Niflheim") then
      game.Wallets.AddResource("HERO", "Perk_Talisman_Niflheim", 1, "NO_TELEMETRY")
    end
  end
  if 8 <= tier then
    if 3 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_CurseActivation") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_CurseActivation", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_Valkyrie") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_Valkyrie", 1, "NO_TELEMETRY")
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_Valkyrie", 1, "NO_TELEMETRY")
    end
    if 3 > game.Wallets.GetResourceValue("HERO", "KratosArmorTrinket_Gauntlet") then
      game.Wallets.AddResource("HERO", "KratosArmorTrinket_Gauntlet", 1, "NO_TELEMETRY")
    end
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_RageMode_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_RageMode_Shop_Tier02_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "Perk_Talisman_WeaponSpecials_Runic_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_WeaponSpecials_Runic_Shop_Tier02_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_HealthBurst_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_HealthBurst_Tier02_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_Parry_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_Parry_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "Perk_Utility_JustEvade_Slowdown_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Utility_JustEvade_Slowdown_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "Perk_Defense_OnBlock_ActiveAbsorb_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Defense_OnBlock_ActiveAbsorb_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "Perk_Utility_Focus_Mode_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Utility_Focus_Mode_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "Perk_Talisman_Muspelheim_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_Muspelheim_Tier05_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "Perk_Talisman_Niflheim_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_Niflheim_Tier05_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_EmpoweringRift_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_EmpoweringRift_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_Gauntlet_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_Gauntlet_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_Valkyrie_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_Valkyrie_Tier05_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_CurseActivation_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_CurseActivation_Tier03_Reinforce_1_NGP")
    game.Wallets.AddResource("HERO", "KratosArmorTrinket_FrostActivation_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_FrostActivation_Tier03_Reinforce_1_NGP")
  end
end
local Unlock_AllTrinkets = function(C)
  Unlock_Trinkets(C, 8)
end
local Unlock_AllBaseTrinkets = function()
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_LowHealth_Offense", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_LowHealth_Offense_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_LowHealth_Shield", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_LowHealth_Shield_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_RageMode", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_RageMode_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_RageGrab", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_RageGrab_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Talisman_WeaponSpecials_Runic", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_WeaponSpecials_Runic_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_HealthBurst", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_HealthBurst_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_Parry", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_Parry_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Utility_JustEvade_Slowdown", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Utility_JustEvade_Slowdown_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Defense_OnBlock_ActiveAbsorb", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Defense_OnBlock_ActiveAbsorb_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Utility_Focus_Mode", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Utility_Focus_Mode_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Talisman_Muspelheim", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_Muspelheim_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Talisman_Niflheim", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Talisman_Niflheim_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_EmpoweringRift", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_EmpoweringRift_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_Gauntlet", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_Gauntlet_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_Valkyrie", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_Valkyrie_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_CurseActivation", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_CurseActivation_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "KratosArmorTrinket_FrostActivation", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_KratosArmorTrinket_FrostActivation_Tier03_Reinforce_1")
end
local Unlock_WeaponComponents = function(C, tier)
  if 1 <= tier then
    game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_HealthDrain", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_Cooldown", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_Rage", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_HealthBurst", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_Cooldown", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_ProcFrost", 1, "NO_TELEMETRY")
  end
  if 2 <= tier then
    game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_HealthDrain", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_Shield", 1, "NO_TELEMETRY")
    if 1 > game.Wallets.GetResourceValue("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning") then
      game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning", 1, "NO_TELEMETRY")
    end
    game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_OffenseBuff", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_Runic", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Flat_OnKill_HealthDrain", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Flat_OnKill_Rage", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_RunicBuff", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_OffenseBuff", 1, "NO_TELEMETRY")
  end
  if 3 <= tier then
    game.Wallets.AddResource("HERO", "Perk_Offense_OnLaunch_Shield", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Perk_Offense_OnLaunch_OffenseBuff", 1, "NO_TELEMETRY")
  end
  if 4 <= tier then
    game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Finisher", 1, "NO_TELEMETRY")
    if 2 > game.Wallets.GetResourceValue("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning") then
      game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning", 1, "NO_TELEMETRY")
    end
  end
  if 5 <= tier then
    if 1 > game.Wallets.GetResourceValue("HERO", "Perk_Weapon_Muspelheim") then
      game.Wallets.AddResource("HERO", "Perk_Weapon_Muspelheim", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_NifleheimSpecial02") then
      game.Wallets.AddResource("HERO", "WeaponComponent_NifleheimSpecial02", 1, "NO_TELEMETRY")
    end
    C:PickupAcquire("Perk_Weapon_Muspelheim")
  end
  if 6 <= tier then
    if 1 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_Valkyrie01") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie01", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "Perk_Weapon_Niflheim") then
      game.Wallets.AddResource("HERO", "Perk_Weapon_Niflheim", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_NifleheimSpecial01") then
      game.Wallets.AddResource("HERO", "WeaponComponent_NifleheimSpecial01", 1, "NO_TELEMETRY")
    end
    if game.Wallets.GetResourceValue("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning") < 3 then
      game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning", 1, "NO_TELEMETRY")
    end
    C:PickupAcquire("Perk_Offense_OnMeleeDamage_ProcLightning")
  end
  if 7 <= tier then
    if 2 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_Valkyrie01") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie01", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_Valkyrie02") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie02", 1, "NO_TELEMETRY")
    end
    if 1 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_QueenValkyrie01") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_QueenValkyrie01", 1, "NO_TELEMETRY")
    end
    C:PickupAcquire("WeaponComponent_Axe_Valkyrie02")
  end
  if 8 <= tier then
    if 3 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_Valkyrie01") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie01", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_Valkyrie02") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie02", 1, "NO_TELEMETRY")
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie02", 1, "NO_TELEMETRY")
    end
    if 2 > game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_QueenValkyrie01") then
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_QueenValkyrie01", 1, "NO_TELEMETRY")
      game.Wallets.AddResource("HERO", "WeaponComponent_Axe_QueenValkyrie01", 2, "NO_TELEMETRY")
    end
    C:PickupAcquire("WeaponComponent_Axe_QueenValkyrie01")
  end
end
local Unlock_AllWeaponComponents = function(C)
  Unlock_WeaponComponents(C, 8)
end
local Unlock_AllBaseWeaponComponents = function()
  game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_HealthDrain", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_OnMeleeDamage_HealthDrain_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_NifleheimSpecial02", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_NifleheimSpecial02_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_Shield", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_OnMeleeDamage_Shield_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Axe_AllStats", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Axe_AllStats_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Weapon_Muspelheim", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Weapon_Muspelheim_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Weapon_Niflheim", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Weapon_Niflheim_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Finisher", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Axe_Finisher_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_ProcLightning", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_OnMeleeDamage_ProcLightning_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_NifleheimSpecial01", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_NifleheimSpecial01_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_OnMeleeDamage_ProcFrost", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_OnMeleeDamage_ProcFrost_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie01", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Axe_Valkyrie01_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Valkyrie02", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Axe_Valkyrie02_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Axe_QueenValkyrie01", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Axe_QueenValkyrie01_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_Muspelheim01", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_Muspelheim01_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_Valkyrie01", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_Valkyrie01_Tier05_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_Nidavellir01", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_Nidavellir01_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnKill_HealthBurst", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnKill_HealthBurst_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnLaunch_Shield", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnLaunch_Shield_Tier04_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnKill_DefenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnKill_DefenseBuff_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnKill_RunicBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnKill_RunicBuff_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnKill_CooldownBurst", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnKill_CooldownBurst_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnHeadshot_OffenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnHeadshot_OffenseBuff_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnHeadshot_DefenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnHeadshot_DefenseBuff_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnHeadshot_CooldownBurst", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnHeadshot_CooldownBurst_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnDamage_ProcFire", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnDamage_ProcFire_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnDamage_ProcBomb", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnDamage_ProcBomb_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnLaunch_OffenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnLaunch_OffenseBuff_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnKill_OffenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnKill_OffenseBuff_Reinforce_1")
  game.Wallets.AddResource("HERO", "WeaponComponent_Blades_OnKill_RageBurst", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_OnKill_RageBurst_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_HealthDrain", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Throw_OnHeadshot_HealthDrain_Shop_Tier01_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_Cooldown", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Throw_OnHeadshot_Cooldown_Shop_Tier01_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_Rage", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Throw_OnHeadshot_Rage_Shop_Tier01_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_HealthBurst", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_AxeHeavyHold_HealthBurst_Shop_Tier01_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_Cooldown", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_AxeHeavyHold_Cooldown_Shop_Tier01_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_OffenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Throw_OnHeadshot_OffenseBuff_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Throw_OnHeadshot_Runic", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Throw_OnHeadshot_Runic_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Flat_OnKill_HealthDrain", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Flat_OnKill_HealthDrain_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Flat_OnKill_Rage", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Flat_OnKill_Rage_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_RunicBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_AxeHeavyHold_RunicBuff_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_AxeHeavyHold_OffenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_AxeHeavyHold_OffenseBuff_Shop_Tier02_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_OnLaunch_Shield", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_OnLaunch_Shield_Shop_Tier03_Reinforce_1")
  game.Wallets.AddResource("HERO", "Perk_Offense_OnLaunch_OffenseBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddRecipe("HERO", "Recipe_Perk_Offense_OnLaunch_OffenseBuff_Shop_Tier03_Reinforce_1")
end
local AddArmorRunes = function(C, Tier)
  if Tier == 1 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Common_Tier01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Common_Tier01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Common_Tier01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Common_Tier01")
  end
  if Tier == 2 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier02_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier02_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier02_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier02_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier02_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier02_Common_One_Stat")
  end
  if Tier == 3 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier03_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier03_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier03_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier03_Rare_One_Stat_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier03_Rare_One_Stat_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier03_Rare_One_Stat_Take_Damage")
  end
  if Tier == 4 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Common_One_Stat")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Rare_One_Stat_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Rare_One_Stat_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Rare_One_Stat_Take_Damage")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier04_Rare_One_Stat_Low_Health")
  end
  if Tier == 5 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Legendary_Two_Stats_Strength_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Legendary_Two_Stats_Strength_Take_Damage")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Legendary_Two_Stats_Strength_Low_Health")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Rare_Two_Stats_Defense")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Rare_Two_Stats_Runic")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Rare_Two_Stats_Strength")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Rare_Two_Stats_Focus")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Rare_Two_Stats_Resistance")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier05_Rare_Two_Stats_Luck")
  end
  if Tier == 6 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Runic_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Runic_Take_Damage")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Runic_Low_Health")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Defense_Defensive")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Strength_Low_Health")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Strength_Take_Damage")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Strength_All_Perks")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Runic_All_Perks")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Focus_All_Perks")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Resistance_All_Perks")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Defense_All_Perks")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier06_Epic_Two_Stats_Focus_All_Perks")
  end
end
local AddDebugRunes = function(C, stat, perk, tier)
  local GiveResource_Safe = function(resource)
    if game.Wallets.GetResourceValue("HERO", resource) <= 0 then
      game.Wallets.AddResource("HERO", resource, 1)
    end
  end
  GiveResource_Safe("KratosArmorChest_NifTankSet_Tier06")
  GiveResource_Safe("KratosArmorChest_NifTankSet_Tier06_Reinforce1")
  GiveResource_Safe("KratosArmorChest_NifTankSet_Tier06_Reinforce2")
  GiveResource_Safe("KratosArmorWrist_NifTankSet_Tier06")
  GiveResource_Safe("KratosArmorWrist_NifTankSet_Tier06_Reinforce1")
  GiveResource_Safe("KratosArmorWrist_NifTankSet_Tier06_Reinforce2")
  GiveResource_Safe("KratosArmorLegs_NifTankSet_Tier06")
  GiveResource_Safe("KratosArmorLegs_NifTankSet_Tier06_Reinforce1")
  GiveResource_Safe("KratosArmorLegs_NifTankSet_Tier06_Reinforce2")
  GiveResource_Safe("KratosArmorTrinket_Gauntlet")
  GiveResource_Safe("KratosArmorTrinket_Gauntlet_Reinforce1")
  GiveResource_Safe("KratosArmorTrinket_Gauntlet_Reinforce2")
  local StatTable = {
    "Strength",
    "Runic",
    "Defense",
    "Resistance",
    "Focus",
    "Luck"
  }
  local PerkTable = {
    game.Pickup.GetId("Perk_Defense_OnBlock_Cooldown"),
    game.Pickup.GetId("Perk_Defense_OnParry_RunicBuff"),
    game.Pickup.GetId("Perk_Defense_OnParry_HealthBurst"),
    game.Pickup.GetId("Perk_Defense_OnParry_Shield"),
    game.Pickup.GetId("Perk_Damage_AxeHeavyHold_HealthBurst"),
    game.Pickup.GetId("Perk_Damage_AxeHeavyHold_CooldownBurst"),
    game.Pickup.GetId("Perk_Damage_AxeHeavyHold_RageBurst"),
    game.Pickup.GetId("Perk_Kill_Any_HealthDrain"),
    game.Pickup.GetId("Perk_Kill_Any_OffenseBuff"),
    game.Pickup.GetId("Perk_Kill_Any_RunicBuff"),
    game.Pickup.GetId("Perk_Kill_Any_DefenseBuff"),
    game.Pickup.GetId("Perk_Kill_Any_Cooldown"),
    game.Pickup.GetId("Perk_Defense_OnTakeDamage_Cooldown"),
    game.Pickup.GetId("Perk_Defense_OnTakeDamage_Rage"),
    game.Pickup.GetId("Perk_Defense_OnTakeDamage_DefenseBuff"),
    game.Pickup.GetId("Perk_Defense_OnLowHealth_OffenseBuff"),
    game.Pickup.GetId("Perk_Defense_OnLowHealth_DefenseBuff"),
    game.Pickup.GetId("Perk_Defense_OnLowHealth_RunicBuff")
  }
  local runeName = string.format("DEBUG_RuneCreator_Tier0%d_%s_%d", tier, StatTable[stat], PerkTable[perk])
  game.Wallets.GenerateRune("HERO", runeName)
end
function UpgradeArmor(C)
  local chestArmor = C:PickupGetPickupNameInSlot("ArmorChest")
  local wristArmor = C:PickupGetPickupNameInSlot("ArmorWrist")
  local legsArmor = C:PickupGetPickupNameInSlot("ArmorLegs")
  local talisman = C:PickupGetPickupNameInSlot("ArmorTrinket")
  if chestArmor ~= "" and C:PickupGetStage(chestArmor) ~= C:PickupCountStages(chestArmor) then
    C:PickupSetStage(chestArmor, C:PickupCountStages(chestArmor))
  end
  if wristArmor ~= "" and C:PickupGetStage(wristArmor) ~= C:PickupCountStages(wristArmor) then
    C:PickupSetStage(wristArmor, C:PickupCountStages(wristArmor))
  end
  if legsArmor ~= "" and C:PickupGetStage(legsArmor) ~= C:PickupCountStages(legsArmor) then
    C:PickupSetStage(legsArmor, C:PickupCountStages(legsArmor))
  end
  if talisman ~= "" and C:PickupGetStage(talisman) ~= C:PickupCountStages(talisman) then
    C:PickupSetStage(talisman, C:PickupCountStages(talisman))
  end
end
function LuaHook_HideArmor()
  local equippedChest = playerCreature:PickupGetPickupNameInSlot("ArmorChest")
  local equippedWrist = playerCreature:PickupGetPickupNameInSlot("ArmorWrist")
  if equippedChest ~= "" then
    playerCreature:PickupDeactivate(equippedChest)
  end
  if equippedWrist ~= "" then
    playerCreature:PickupDeactivate(equippedWrist)
  end
  playerCreature:HideJoint(playerCreature:GetJointIndex("Jomeleeweapon1"))
end
local retrieveBlades_Wrist
function PopUICreatureWristArmor()
  local uiKratos = game.UI.FindCreatureByGOName("goHeroA00")
  if uiKratos then
    local wristArmor = uiKratos:PickupGetPickupNameInSlot("ArmorWrist")
    if wristArmor ~= "" then
      uiKratos:PickupRelinquishBySlot("ArmorWrist")
    end
  end
end
function LuaHook_RetrieveBlades_Start()
  PopUICreatureWristArmor()
  local equippedWrist = playerCreature:PickupGetPickupNameInSlot("ArmorWrist")
  if equippedWrist ~= "" then
    retrieveBlades_Wrist = equippedWrist
    playerCreature:PickupRelinquish(equippedWrist)
  end
  LD.AddRecipe_Safe("HERO", "Recipe_ReinforceBlades_Tier02")
  LD.AddRecipe_Safe("HERO", "Blades_Tier01_Melee_Node01_SubNode03")
  LD.AddRecipe_Safe("HERO", "Blades_Tier01_Melee_Node01_SubNode02")
  game.Wallets.AddResource("HERO", "Blades_Toss_Light_Unlock", 1, "NO_TELEMETRY")
  LD.AddRecipe_Safe("HERO", "Blades_Toss_Light_Unlock")
  LD.AddRecipe_Safe("HERO", "Blades_Momentum_01")
  LD.AddRecipe_Safe("HERO", "Blades_Tier01_Bare_Node01")
end
function LuaHook_RetrieveBlades()
  PopUICreatureWristArmor()
  if retrieveBlades_Wrist ~= nil then
    playerCreature:PickupAcquire(retrieveBlades_Wrist)
  end
end
function LuaHook_ShowArmor()
  local equippedChest = playerCreature:PickupGetPickupNameInSlot("ArmorChest")
  local equippedWrist = playerCreature:PickupGetPickupNameInSlot("ArmorWrist")
  if equippedChest ~= "" then
    playerCreature:PickupActivate(equippedChest)
  end
  if equippedWrist ~= "" then
    playerCreature:PickupActivate(equippedWrist)
  end
  playerCreature:ShowJoint(playerCreature:GetJointIndex("Jomeleeweapon1"))
end
local AddUniqueRunes = function(C, UniqueRune)
  if UniqueRune == 1 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie04")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Dragon01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Dragon02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Dragon03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Corruption")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FireResist_Focus")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FireResist_Defense")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_RageGain01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_RageDuration01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostMastery01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostMastery02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BurnMastery01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BurnMastery02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier07_Epic_Random")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier07_Epic_Random")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Midgard")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Luck")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Jotunnheim")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Musp")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Nidv")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Alfheim")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Alfheim_02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Alfheim_03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_QuestBrok")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Asgard")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Soul")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Hellheim")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Svartalfheim")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Vanaheim")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie02")
  end
  if UniqueRune == 2 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_AxeToss01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_AxeToss02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_AxeToss03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Momentum01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Momentum02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial04")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial05")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial04")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial05")
  end
  if UniqueRune == 3 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Nidv")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FireResist_Defense")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FireResist_Focus")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FireResist_Strength")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostResist_Focus")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostResist_Runic")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostResist_Defense")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Tier07_Epic_Random")
  end
  if UniqueRune == 4 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Midgard")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostMastery01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_FrostMastery02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BurnMastery01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BurnMastery02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_RageDuration01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_RageGain01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_StunDamage")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_ValkyrieKiller")
  end
  if UniqueRune == 5 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Alfheim")
  end
  if UniqueRune == 6 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_QuestBrok")
  end
  if UniqueRune == 7 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Asgard")
  end
  if UniqueRune == 8 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Hellheim")
  end
  if UniqueRune == 9 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Svartalfheim")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Soul")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_QuestBrok")
  end
  if UniqueRune == 10 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Vanaheim")
  end
  if UniqueRune == 11 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie01")
  end
  if UniqueRune == 12 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Valkyrie04")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Jotunnheim")
  end
  if UniqueRune == 13 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial04")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial05")
  end
  if UniqueRune == 14 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Corruption")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial01")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial03")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial04")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial05")
  end
  if UniqueRune == 15 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Dragon01")
  end
  if UniqueRune == 16 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Dragon02")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Dragon03")
  end
  if UniqueRune == 17 then
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial01_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial02_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial03_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial04_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_WeaponSpecial05_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial01_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial02_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial03_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial04_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_BladeWeaponSpecial05_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Elemental_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Traveler_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Tyr_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Kvasir_NGP")
    game.Wallets.GenerateRune("HERO", "RuneCreator_Unique_Protection_NGP")
  end
end
local AddSpecials_Tier01 = function(C)
  game.Wallets.AddResource("HERO", "FrostSpecialAxeSpin", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeLeap", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeSweep", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeQuickClear", 1, "NO_TELEMETRY")
end
local AddSpecials_Tier02 = function(C)
  game.Wallets.AddResource("HERO", "FrostSpecialAxeSwipeCharge", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeUpwardSlice", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeDashCombo", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeFlurryChop", 1, "NO_TELEMETRY")
end
local AddSpecials_Tier03 = function(C)
  game.Wallets.AddResource("HERO", "FrostSpecialAxeRake", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeWeaponBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeTossGrind", 1, "NO_TELEMETRY")
end
local AddSpecials_Tier04 = function(C)
  game.Wallets.AddResource("HERO", "FrostSpecialAxeTossThrowdown", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeTossRail", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeTossGlaive", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialSpin", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialHopSlam", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialFireClap", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialCross", 1, "NO_TELEMETRY")
end
local AddSpecials_Tier05 = function(C)
  game.Wallets.AddResource("HERO", "FrostSpecialAxeGandalfSlam", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeBeam", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialTripleSlam", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialTwirlBarrage", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialFlurrySpin", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialFlurryStab", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialFireWave", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialShotgun", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialShieldRush", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialMine", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialWeaponBuff", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialGrapple", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BladeSpecialMeteorSlam", 1, "NO_TELEMETRY")
end
local AddSonSpecials = function(C)
  game.Wallets.AddResource("HERO", "SummonFenrir", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SummonBird", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SummonDeer", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SummonRatatoskr", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SummonBoar", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SummonSouls", 1, "NO_TELEMETRY")
end
local Unlock_AllSpecials = function(C)
  AddSpecials_Tier01()
  AddSpecials_Tier02()
  AddSpecials_Tier03()
  AddSpecials_Tier04()
  AddSpecials_Tier05()
  AddSonSpecials()
end
local AddSonUpgrades_Tier01 = function()
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  game.Wallets.AddResource("HERO", "SonPerk_CloseCombat", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_LockDownTarget", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_FollowUp", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_ArrowDamage_Tier01", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorSpeed01", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorOffense01", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorDefense01", 1, "NO_TELEMETRY")
end
local AddSonUpgrades_Tier02 = function()
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  AddSonUpgrades_Tier01()
  game.Wallets.AddResource("HERO", "SonPerk_LightArrow_ExplosionRadius", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_Deftness_Tier01", 1, "NO_TELEMETRY")
end
local AddSonUpgrades_Tier03 = function()
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  AddSonUpgrades_Tier02()
  game.Wallets.AddResource("HERO", "SonPerk_LightArrow_WeakenDefense", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_LightArrow_Potency_Tier01", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "TEMP_Soul_of_the_Wolf", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_RunicDamage_Tier02", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_ArrowDamage_Tier02", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorSpeed02", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorOffense02", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorDefense02", 1, "NO_TELEMETRY")
end
local AddSonUpgrades_Tier04 = function()
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  AddSonUpgrades_Tier03()
  game.Wallets.AddResource("HERO", "SonPerk_LightArrow_Potency_Tier02", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_ShockArrow_Potency_Tier01", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_ShockArrow_Potency_Tier02", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_ShockArrow_SparkRate", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_ShockArrow_DetonationConduit", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_Deftness_Tier02", 1, "NO_TELEMETRY")
end
local AddSonUpgrades_Tier05 = function()
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  AddSonUpgrades_Tier04()
  game.Wallets.AddResource("HERO", "SonPerk_LightArrow_Potency_Tier03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_ShockArrow_Potency_Tier03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonPerk_ShockArrow_OnHitSpark", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_Deftness_Tier03", 1, "NO_TELEMETRY")
end
local AddSonUpgrades_Tier06 = function()
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  AddSonUpgrades_Tier05()
  game.Wallets.AddResource("HERO", "SonPerk_LightArrow_ExplosionSpread", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_ArrowDamage_Tier03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Bow_Skill_RunicDamage_Tier03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorSpeed03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorOffense03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "SonArmorDefense03", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementQuiver_Tier02", 1, "NO_TELEMETRY")
end
local Unlock_AllSon = function(C)
  AddSonUpgrades_Tier06()
end
local UnlockLoadout_DefenseArmor = function(C, tier)
  if tier == 1 then
    AddSonUpgrades_Tier01()
    Unlock_WeaponComponents(C, 1)
    Unlock_Trinkets(C, 1)
    AddSpecials_Tier01()
    local armorTier = 1
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 2 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 2)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier02", 1, "NO_TELEMETRY")
    local armorTier = 1
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 3 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 3)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier03", 1, "NO_TELEMETRY")
    local armorTier = 3
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 4 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 4)
    AddSpecials_Tier03()
    AddArmorRunes(C, 4)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    local armorTier = 3
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 5 then
    AddSonUpgrades_Tier03()
    Unlock_Trinkets(C, 5)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 5)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier05", 1, "NO_TELEMETRY")
    local armorTier = 5
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 6 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 6)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    Unlock_Trinkets(C, 6)
    local armorTier = 6
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
end
local UnlockLoadout_PureDamageArmor = function(C, tier)
  if tier == 1 then
    AddSonUpgrades_Tier01()
    Unlock_WeaponComponents(C, 1)
    Unlock_Trinkets(C, 1)
    AddSpecials_Tier01()
    local armorTier = 1
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 2 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 2)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier02", 1, "NO_TELEMETRY")
    local armorTier = 1
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 3 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier03", 1, "NO_TELEMETRY")
    AddArmorRunes(C, 3)
    local armorTier = 3
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 4 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 4)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    local armorTier = 3
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 5 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 5)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier05", 1, "NO_TELEMETRY")
    local armorTier = 5
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 6 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 6)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local armorTier = 5
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
end
local UnlockLoadout_FocusArmor = function(C, tier)
  if tier == 1 then
    AddSonUpgrades_Tier01()
    Unlock_WeaponComponents(C, 1)
    Unlock_Trinkets(C, 1)
    AddSpecials_Tier01()
    local armorTier = 1
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 2 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 2)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier02", 1, "NO_TELEMETRY")
    local armorTier = 1
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 3 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 3)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier03", 1, "NO_TELEMETRY")
    local armorTier = 3
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 4 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 4)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    local armorTier = 3
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 5 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 5)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier05", 1, "NO_TELEMETRY")
    local armorTier = 5
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 6 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 6)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local armorTier = 5
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
end
local UnlockLoadout_ToughnessArmor = function(C, tier)
  if tier == 2 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 2)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier02", 1, "NO_TELEMETRY")
    local armorTier = 2
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 3 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 3)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier03", 1, "NO_TELEMETRY")
    local armorTier = 2
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 4 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 4)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    local armorTier = 4
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 5 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 5)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier05", 1, "NO_TELEMETRY")
    local armorTier = 4
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 6 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 6)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local armorTier = 6
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_TankSet_Tier0" .. armorTier,
      "KratosArmorWrist_TankSet_Tier0" .. armorTier,
      "KratosArmorLegs_TankSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
end
local UnlockLoadout_HybridDamageArmor = function(C, tier)
  if tier == 2 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier02", 1, "NO_TELEMETRY")
    AddArmorRunes(C, 2)
    local armorTier = 2
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 3 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 3)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier03", 1, "NO_TELEMETRY")
    local armorTier = 2
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 4 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    AddArmorRunes(C, 4)
    local armorTier = 4
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 5 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 5)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier05", 1, "NO_TELEMETRY")
    local armorTier = 4
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 6 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 6)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local armorTier = 6
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_DamageSet_Tier0" .. armorTier,
      "KratosArmorWrist_DamageSet_Tier0" .. armorTier,
      "KratosArmorLegs_DamageSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
end
local UnlockLoadout_RunicArmor = function(C, tier)
  if tier == 2 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 2)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier02", 1, "NO_TELEMETRY")
    local armorTier = 2
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 3 then
    AddSonUpgrades_Tier02()
    Unlock_WeaponComponents(C, 2)
    Unlock_Trinkets(C, 2)
    AddSpecials_Tier02()
    AddArmorRunes(C, 3)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier03", 1, "NO_TELEMETRY")
    local armorTier = 2
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 4 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 4)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    local armorTier = 4
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
  if tier == 5 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 5)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier05", 1, "NO_TELEMETRY")
    local armorTier = 4
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    local ReinforcementResources = {}
    ReinforcementResources.reinforcements = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
      local reinforcementLevel = "_Reinforce1"
      game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
    end
  end
  if tier == 6 then
    AddSonUpgrades_Tier03()
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddArmorRunes(C, 6)
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local armorTier = 6
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier0" .. armorTier,
      "KratosArmorWrist_SpeedSet_Tier0" .. armorTier,
      "KratosArmorLegs_SpeedSet_Tier0" .. armorTier
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
  end
end
local UnlockLoadout_SpecialArmor = function(C, tier, armor)
  if armor == "Val" then
    AddSpecials_Tier03()
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_ValkyrieSet_Tier06",
      "KratosArmorLegs_ValkyrieSet_Tier06",
      "KratosArmorWrist_ValkyrieSet_Tier06"
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    if tier == 1 then
      Unlock_Trinkets(C, 6)
      Unlock_WeaponComponents(C, 6)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      AddUniqueRunes(C, 5)
    end
    if tier == 2 then
      Unlock_Trinkets(C, 7)
      Unlock_WeaponComponents(C, 7)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      AddUniqueRunes(C, 5)
      AddUniqueRunes(C, 6)
      AddUniqueRunes(C, 7)
      local ReinforcementResources = {}
      ReinforcementResources.reinforcements = {
        "KratosArmorChest_ValkyrieSet_Tier06",
        "KratosArmorWrist_ValkyrieSet_Tier06",
        "KratosArmorLegs_ValkyrieSet_Tier06"
      }
      for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
        local reinforcementLevel = "_Reinforce1"
        game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
      end
    end
    if tier == 3 then
      Unlock_Trinkets(C, 8)
      Unlock_WeaponComponents(C, 8)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      AddUniqueRunes(C, 5)
      AddUniqueRunes(C, 6)
      AddUniqueRunes(C, 7)
      AddUniqueRunes(C, 8)
      local ReinforcementResources = {}
      ReinforcementResources.reinforcements = {
        "KratosArmorChest_ValkyrieSet_Tier06",
        "KratosArmorWrist_ValkyrieSet_Tier06",
        "KratosArmorWrist_ValkyrieSet_Tier06"
      }
      for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
        local reinforcementLevel = "_Reinforce2"
        game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
      end
    end
  end
  if armor == "Nif" then
    game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_NifTankSet_Tier06",
      "KratosArmorLegs_NifTankSet_Tier06",
      "KratosArmorWrist_NifTankSet_Tier06"
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    if tier == 1 then
      Unlock_Trinkets(C, 6)
      Unlock_WeaponComponents(C, 6)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      AddUniqueRunes(C, 5)
    end
    if tier == 2 then
      Unlock_Trinkets(C, 6)
      Unlock_WeaponComponents(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      AddUniqueRunes(C, 5)
      local ReinforcementResources = {}
      ReinforcementResources.reinforcements = {
        "KratosArmorChest_NifTankSet_Tier06",
        "KratosArmorLegs_NifTankSet_Tier06",
        "KratosArmorWrist_NifTankSet_Tier06"
      }
      for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
        local reinforcementLevel = "_Reinforce1"
        game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
      end
    end
    if tier == 3 then
      Unlock_Trinkets(C, 7)
      Unlock_WeaponComponents(C, 7)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      AddUniqueRunes(C, 5)
      local ReinforcementResources = {}
      ReinforcementResources.reinforcements = {
        "KratosArmorChest_NifTankSet_Tier06",
        "KratosArmorLegs_NifTankSet_Tier06",
        "KratosArmorWrist_NifTankSet_Tier06"
      }
      for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
        local reinforcementLevel = "_Reinforce2"
        game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
      end
    end
  end
  if armor == "Mus" then
    Unlock_WeaponComponents(C, 3)
    Unlock_Trinkets(C, 3)
    AddSpecials_Tier03()
    AddSonUpgrades_Tier03()
    if tier == 1 then
      Unlock_Trinkets(C, 4)
      Unlock_WeaponComponents(C, 4)
      AddArmorRunes(C, 4)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier04", 1, "NO_TELEMETRY")
    end
    local ArmorPickups = {}
    ArmorPickups.pickups = {
      "KratosArmorChest_MspTankSet_Tier06",
      "KratosArmorLegs_MspTankSet_Tier06",
      "KratosArmorWrist_MspTankSet_Tier06"
    }
    for _, pickups in ipairs(ArmorPickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
    end
    if tier == 2 then
      Unlock_Trinkets(C, 6)
      Unlock_WeaponComponents(C, 6)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
      local ReinforcementResources = {}
      ReinforcementResources.reinforcements = {
        "KratosArmorChest_MspTankSet_Tier06",
        "KratosArmorLegs_MspTankSet_Tier06",
        "KratosArmorWrist_MspTankSet_Tier06"
      }
      for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
        local reinforcementLevel = "_Reinforce1"
        game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
      end
    end
    if tier == 3 then
      Unlock_Trinkets(C, 7)
      Unlock_WeaponComponents(C, 7)
      AddArmorRunes(C, 6)
      AddUniqueRunes(C, 1)
      AddUniqueRunes(C, 2)
      AddUniqueRunes(C, 3)
      AddUniqueRunes(C, 4)
      game.Wallets.AddResource("HERO", "ReinforcementAxe_Tier06", 1, "NO_TELEMETRY")
      local ReinforcementResources = {}
      ReinforcementResources.reinforcements = {
        "KratosArmorChest_MspTankSet_Tier06",
        "KratosArmorLegs_MspTankSet_Tier06",
        "KratosArmorWrist_MspTankSet_Tier06"
      }
      for _, reinforcements in ipairs(ReinforcementResources.reinforcements) do
        local reinforcementLevel = "_Reinforce2"
        game.Wallets.AddResource("HERO", reinforcements .. reinforcementLevel, 1, "NO_TELEMETRY")
      end
    end
  end
end
local UnlockLoadout_Tier01 = function(C, loadoutType)
  Unlock_WeaponComponents(C, 1)
  Unlock_Trinkets(C, 1)
  AddSpecials_Tier01()
  AddSonUpgrades_Tier01()
  C:PickupSetStage("Axe", 0)
  if loadoutType == 1 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier01Pickups = {}
    Tier01Pickups.pickups = {
      "KratosArmorChest_TankSet_Tier01",
      "KratosArmorWrist_TankSet_Tier01",
      "KratosArmorLegs_TankSet_Tier01",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier01Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 2 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier01Pickups = {}
    Tier01Pickups.pickups = {
      "KratosArmorChest_DamageSet_Tier01",
      "KratosArmorWrist_DamageSet_Tier01",
      "KratosArmorLegs_DamageSet_Tier01",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier01Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 3 or loadoutType == -1 then
    local Tier01Pickups = {}
    Tier01Pickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier01",
      "KratosArmorWrist_SpeedSet_Tier01",
      "KratosArmorLegs_SpeedSet_Tier01",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier01Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
end
local UnlockLoadout_Tier02 = function(C, loadoutType)
  Unlock_WeaponComponents(C, 1)
  Unlock_Trinkets(C, 1)
  AddSpecials_Tier01()
  Unlock_WeaponComponents(C, 2)
  Unlock_Trinkets(C, 2)
  AddSpecials_Tier02()
  AddSonUpgrades_Tier02()
  AddArmorRunes(C, 2)
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  LD.AddRecipe_Safe("HERO", "Recipe_ReinforceAxe_Tier03")
  C:PickupSetStage("Axe", 1)
  if loadoutType == 1 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier02Pickups = {}
    Tier02Pickups.pickups = {
      "KratosArmorChest_TankSet_Tier02",
      "KratosArmorWrist_TankSet_Tier02",
      "KratosArmorLegs_TankSet_Tier02",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier02Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 2 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier02Pickups = {}
    Tier02Pickups.pickups = {
      "KratosArmorChest_DamageSet_Tier02",
      "KratosArmorWrist_DamageSet_Tier02",
      "KratosArmorLegs_DamageSet_Tier02",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier02Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 3 or loadoutType == -1 then
    local Tier02Pickups = {}
    Tier02Pickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier02",
      "KratosArmorWrist_SpeedSet_Tier02",
      "KratosArmorLegs_SpeedSet_Tier02",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier02Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
end
local Unlock_PeaksPassLoadout = function()
  playerCreature:PickupSetStage("Axe", 2)
  local Tier03Pickups = {}
  Tier03Pickups.pickups = {
    "KratosArmorChest_DamageSet_Tier03",
    "KratosArmorWrist_DamageSet_Tier03",
    "KratosArmorLegs_DamageSet_Tier03",
    "KratosArmorTrinket_HealthBurst"
  }
  for _, pickups in ipairs(Tier03Pickups.pickups) do
    if game.Wallets.HasResource("HERO", pickups) == false then
      game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
    end
    if playerCreature:PickupIsAcquired(pickups) == true then
      playerCreature:PickupActivate(pickups)
    end
    if playerCreature:PickupIsAcquired(pickups) == false then
      playerCreature:PickupAcquire(pickups)
    end
  end
  game.Wallets.AddResource("HERO", "FrostSpecialAxeQuickClear", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "FrostSpecialAxeFlurryChop", 1, "NO_TELEMETRY")
  if playerCreature:PickupIsAcquired("FrostSpecialAxeFlurryChop") == false then
    playerCreature:PickupAcquire("FrostSpecialAxeFlurryChop")
  end
  if playerCreature:PickupIsAcquired("FrostSpecialAxeQuickClear") == false then
    playerCreature:PickupAcquire("FrostSpecialAxeQuickClear")
  end
end
local UnlockLoadout_Tier03 = function(C, loadoutType)
  Unlock_WeaponComponents(C, 1)
  Unlock_Trinkets(C, 1)
  AddSpecials_Tier01()
  Unlock_WeaponComponents(C, 2)
  Unlock_Trinkets(C, 2)
  AddSpecials_Tier02()
  Unlock_WeaponComponents(C, 3)
  Unlock_Trinkets(C, 3)
  AddSpecials_Tier03()
  AddSonUpgrades_Tier03()
  AddArmorRunes(C, 3)
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  LD.AddRecipe_Safe("HERO", "Recipe_ReinforceAxe_Tier04")
  C:PickupSetStage("Axe", 2)
  if loadoutType == 1 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier03Pickups = {}
    Tier03Pickups.pickups = {
      "KratosArmorChest_TankSet_Tier03",
      "KratosArmorWrist_TankSet_Tier03",
      "KratosArmorLegs_TankSet_Tier03",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier03Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 2 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier03Pickups = {}
    Tier03Pickups.pickups = {
      "KratosArmorChest_DamageSet_Tier03",
      "KratosArmorWrist_DamageSet_Tier03",
      "KratosArmorLegs_DamageSet_Tier03",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier03Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 3 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier03Pickups = {}
    Tier03Pickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier03",
      "KratosArmorWrist_SpeedSet_Tier03",
      "KratosArmorLegs_SpeedSet_Tier03",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier03Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
end
local UnlockLoadout_Tier04 = function(C, loadoutType)
  C:PickupSetStage("Axe", 3)
  Unlock_WeaponComponents(C, 4)
  Unlock_AllTrinkets()
  AddSpecials_Tier01()
  AddSpecials_Tier02()
  AddSpecials_Tier03()
  AddSpecials_Tier04()
  AddSonUpgrades_Tier04()
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  AddArmorRunes(C, 4)
  if game.Wallets.HasResource("HERO", "Blades") == false then
    game.Wallets.AddResource("HERO", "Blades", 1, "NO_TELEMETRY")
  end
  if loadoutType == 1 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier04Pickups = {}
    Tier04Pickups.pickups = {
      "KratosArmorChest_TankSet_Tier04",
      "KratosArmorWrist_TankSet_Tier04",
      "KratosArmorLegs_TankSet_Tier04",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier04Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 2 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier04Pickups = {}
    Tier04Pickups.pickups = {
      "KratosArmorChest_DamageSet_Tier04",
      "KratosArmorWrist_DamageSet_Tier04",
      "KratosArmorLegs_DamageSet_Tier04",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier04Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 3 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier04Pickups = {}
    Tier04Pickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier04",
      "KratosArmorWrist_SpeedSet_Tier04",
      "KratosArmorLegs_SpeedSet_Tier04",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier04Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
end
local UnlockLoadout_Tier05 = function(C, loadoutType)
  C:PickupSetStage("Axe", 4)
  Unlock_WeaponComponents(C, 4)
  Unlock_AllTrinkets()
  AddSpecials_Tier01()
  AddSpecials_Tier02()
  AddSpecials_Tier03()
  AddSpecials_Tier04()
  AddSpecials_Tier05()
  AddSonUpgrades_Tier05()
  AddArmorRunes(C, 5)
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  LD.AddRecipe_Safe("HERO", "Recipe_ReinforceAxe_Tier06")
  if game.Wallets.HasResource("HERO", "Blades") == false then
    game.Wallets.AddResource("HERO", "Blades", 1, "NO_TELEMETRY")
  end
  if loadoutType == 1 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier05Pickups = {}
    Tier05Pickups.pickups = {
      "KratosArmorChest_TankSet_Tier05",
      "KratosArmorWrist_TankSet_Tier05",
      "KratosArmorLegs_TankSet_Tier05",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier05Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 2 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier05Pickups = {}
    Tier05Pickups.pickups = {
      "KratosArmorChest_DamageSet_Tier05",
      "KratosArmorWrist_DamageSet_Tier05",
      "KratosArmorLegs_DamageSet_Tier05",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier05Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 3 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier05Pickups = {}
    Tier05Pickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier05",
      "KratosArmorWrist_SpeedSet_Tier05",
      "KratosArmorLegs_SpeedSet_Tier05",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier05Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
end
local UnlockLoadout_Tier06 = function(C, loadoutType)
  C:PickupSetStage("Axe", 5)
  Unlock_WeaponComponents(C, 4)
  Unlock_AllTrinkets()
  Unlock_AllSpecials()
  AddArmorRunes(C, 6)
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "AxeReinforcement", 1, "NO_TELEMETRY")
  AddSonUpgrades_Tier06()
  if game.Wallets.HasResource("HERO", "Blades") == false then
    game.Wallets.AddResource("HERO", "Blades", 1, "NO_TELEMETRY")
  end
  if loadoutType == 1 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier06Pickups = {}
    Tier06Pickups.pickups = {
      "KratosArmorChest_TankSet_Tier06",
      "KratosArmorWrist_TankSet_Tier06",
      "KratosArmorLegs_TankSet_Tier06",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier06Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 2 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier06Pickups = {}
    Tier06Pickups.pickups = {
      "KratosArmorChest_DamageSet_Tier06",
      "KratosArmorWrist_DamageSet_Tier06",
      "KratosArmorLegs_DamageSet_Tier06",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier06Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
  if loadoutType == 3 or loadoutType == -1 then
    print("if this is spamming, then there's a problem!")
    local Tier06Pickups = {}
    Tier06Pickups.pickups = {
      "KratosArmorChest_SpeedSet_Tier06",
      "KratosArmorWrist_SpeedSet_Tier06",
      "KratosArmorLegs_SpeedSet_Tier06",
      "KratosArmorTrinket_HealthBurst"
    }
    for _, pickups in ipairs(Tier06Pickups.pickups) do
      if game.Wallets.HasResource("HERO", pickups) == false then
        game.Wallets.AddResource("HERO", pickups, 1, "NO_TELEMETRY")
        local recipename = "Recipe_" .. pickups .. "_Reinforce1"
        LD.AddRecipe_Safe("HERO", recipename)
      end
      if C:PickupIsAcquired(pickups) == true then
        C:PickupActivate(pickups)
      end
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
  end
end
local ForceCheckMap = function()
  LD.CheckMapDiscoveryState()
end
local AddRecipe_NoNotification = function(walletName, recipeName)
  if not game.Wallets.HasRecipe(walletName, recipeName) then
    game.Wallets.AddRecipe(walletName, recipeName)
    game.UI.ClearNotification("Recipe", recipeName)
  end
end
local RemoveRecipe_Safe = function(walletName, recipeName)
  if game.Wallets.HasRecipe(walletName, recipeName) then
    game.UI.ClearNotification("Recipe", recipeName)
    game.Wallets.RemoveRecipe(walletName, recipeName)
  end
end
local AddResourceAndRecipe_NoNotifications = function(resourceAndRecipeName)
  if game.Wallets.GetResourceValue("HERO", resourceAndRecipeName) < 0 then
    game.Wallets.AddResource("HERO", resourceAndRecipeName, 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", resourceAndRecipeName)
  end
  AddRecipe_NoNotification("HERO", resourceAndRecipeName)
end
local FixupRecipesByTier = function(recipesByTierTable)
  for resourceTierLock, recipes in pairs(recipesByTierTable) do
    if game.Wallets.HasResource("HERO", resourceTierLock) then
      for _, recipe in pairs(recipes) do
        AddRecipe_NoNotification("HERO", recipe)
      end
    else
      for _, recipe in pairs(recipes) do
        RemoveRecipe_Safe("HERO", recipe)
      end
    end
  end
end
local RemoveRecipesByTier = function(recipesByTierTable)
  for _, recipes in pairs(recipesByTierTable) do
    for _, recipe in pairs(recipes) do
      RemoveRecipe_Safe("HERO", recipe)
    end
  end
end
local FixupSkillTreeRecipesAtLoad = function()
  AddResourceAndRecipe_NoNotifications("Axe_RageMode_Upgrade_R1_Base")
  AddResourceAndRecipe_NoNotifications("Axe_RageMode_Upgrade_L1_Base")
  AddRecipe_NoNotification("HERO", "Axe_RageMode_Upgrade_R1Hold")
  AddRecipe_NoNotification("HERO", "Axe_RageMode_Upgrade_R2")
  AddRecipe_NoNotification("HERO", "Blades_RageMode_Upgrade_R1Mash")
  AddRecipe_NoNotification("HERO", "Axe_RageMode_Upgrade_R2Hold")
  AddRecipe_NoNotification("HERO", "Blades_RageMode_Upgrade_L1")
  AddRecipe_NoNotification("HERO", "Blades_RageMode_Upgrade_L2")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_BlockBreak")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Bare_Node01")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_BareEvadeAttack_Light")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_ParryAttack_Light")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Bare_Node01_SubNode01")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Bare_Node01_SubNode02")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_ParryAttack_Heavy")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_BareHeavyHold_Upgrade")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Bare_Node01_SubNode03")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_ParryProjectile")
  AddRecipe_NoNotification("HERO", "Axe_Tier02_Bare_Node01")
  AddRecipe_NoNotification("HERO", "Axe_Tier02_Bare_Node01_SubNode01")
  AddRecipe_NoNotification("HERO", "Recipe_ReinforceAxe_Tier02")
  AddResourceAndRecipe_NoNotifications("Axe_Tier01_Throw_Node01_SubNode02")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Melee_Node01_SubNode01")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Melee_Node01_SubNode02")
  AddRecipe_NoNotification("HERO", "Axe_Tier01_Melee_Node01")
  local axeUpgradeRecipes = {
    ReinforcementAxe_Tier02 = {
      "Axe_Tier01_Throw_Node01",
      "Axe_Tier01_Throw_Node01_SubNode03",
      "Axe_Tier01_Melee_Node01_SubNode03",
      "Axe_Tier01_Momentum_Unlock_01",
      "Axe_Tier01_AxeEvadeAttack_Light"
    },
    ReinforcementAxe_Tier03 = {
      "Axe_Tier01_Throw_Node01_SubNode01",
      "Axe_Tier01_Throw_CriticalThrowUpgrade",
      "Axe_Tier01_Melee_Node01_SubNode04",
      "Axe_Tier01_Momentum_Unlock_02",
      "Axe_Tier01_AxeEvadeAttack_Light_Back"
    },
    ReinforcementAxe_Tier04 = {
      "Axe_Tier01_Throw_PaintTargetUpgrade",
      "Axe_Tier01_Throw_Node01_SubNode04",
      "Axe_Tier02_AxeDelayComboUpgrade",
      "Axe_Tier02_Melee_Node01",
      "Axe_Tier02_Melee_Node01_SubNode01"
    },
    ReinforcementAxe_Tier05 = {
      "Axe_Tier01_Throw_PaintTargetUpgrade_02",
      "Axe_Tier01_Throw_Node01_SubNode05",
      "Axe_Tier02_AxeDelayComboUpgrade_02",
      "Axe_Tier02_AxeDelayComboUpgrade_Heavy"
    }
  }
  FixupRecipesByTier(axeUpgradeRecipes)
  if game.Wallets.HasResource("HERO", "Blades") then
    AddRecipe_NoNotification("HERO", "Recipe_ReinforceBlades_Tier02")
    AddResourceAndRecipe_NoNotifications("Blades_Toss_Light_Unlock")
    AddRecipe_NoNotification("HERO", "Blades_Tier01_Melee_Node01_SubNode03")
    AddRecipe_NoNotification("HERO", "Blades_Tier01_Melee_Node01_SubNode02")
    AddRecipe_NoNotification("HERO", "Blades_Momentum_01")
    AddRecipe_NoNotification("HERO", "Blades_Tier01_Bare_Node01")
    local bladesUpgradeRecipes = {
      ReinforcementBlades_Tier02 = {
        "Blades_Tier01_Melee_Node01",
        "Blades_Tier01_Melee_Node01_SubNode01",
        "Blades_Momentum_02"
      },
      ReinforcementBlades_Tier03 = {
        "Blades_Tier01_Melee_Evade_Forward",
        "Blades_Tier01_Melee_Node01_SubNode04",
        "Blades_Tier01_Melee_Evade_Back",
        "Blades_Tier01_Toss_Light_Upgrade",
        "Blades_TossSurge_Lvl02",
        "Blades_Tier01_Bare_Node01_SubNode01"
      },
      ReinforcementBlades_Tier04 = {
        "Blades_Tier02_Melee_Node01",
        "Blades_Blade_Toss_Upgrade",
        "Blades_ElementalPrecision_Level03"
      },
      ReinforcementBlades_Tier05 = {
        "Blades_Tier02_Melee_Delay_Light_Upgrade_01",
        "Blades_Tier02_Melee_Node01_SubNode01",
        "Blades_Tier02_Melee_Delay_HeavyBomb",
        "Blades_StatUpgrade_Strength",
        "Blades_StatUpgrade_Luck",
        "Blades_StatUpgrade_Runic"
      }
    }
    FixupRecipesByTier(bladesUpgradeRecipes)
  end
  AddRecipe_NoNotification("HERO", "Recipe_SonPerk_FollowUp")
  AddRecipe_NoNotification("HERO", "Recipe_SonPerk_LockDownTarget")
  AddRecipe_NoNotification("HERO", "Recipe_SonPerk_CloseCombat")
  local bowCombatUpgradeRecipes = {
    ReinforcementBow_Tier02 = {
      "Recipe_Bow_Skill_ArrowDamage_Tier01",
      "Recipe_Bow_Skill_Deftness_Tier01"
    },
    ReinforcementBow_Tier03 = {
      "Recipe_SonPerk_ShockArrow_DetonationConduit",
      "Recipe_Bow_Skill_ArrowDamage_Tier02",
      "Recipe_Bow_Skill_Deftness_Tier02"
    },
    ReinforcementBow_Tier04 = {
      "Recipe_Bow_Skill_ArrowDamage_Tier03",
      "Recipe_Bow_Skill_Deftness_Tier03"
    }
  }
  FixupRecipesByTier(bowCombatUpgradeRecipes)
  local lightArrowUpgradeRecipes = {
    ReinforcementBow_Tier02 = {
      "Recipe_SonPerk_LightArrow_Potency_Tier01"
    },
    ReinforcementBow_Tier03 = {
      "Recipe_SonPerk_LightArrow_Potency_Tier02",
      "Recipe_SonPerk_LightArrow_ExplosionRadius"
    },
    ReinforcementBow_Tier04 = {
      "Recipe_SonPerk_LightArrow_Potency_Tier03"
    },
    ReinforcementBow_Tier05 = {
      "Recipe_SonPerk_LightArrow_ExplosionSpread"
    }
  }
  if game.Wallets.HasResource("HERO", "ArrowUnlock_Light") then
    AddRecipe_NoNotification("HERO", "Recipe_SonPerk_LightArrow_WeakenDefense")
    FixupRecipesByTier(lightArrowUpgradeRecipes)
  else
    RemoveRecipe_Safe("HERO", "Recipe_SonPerk_LightArrow_WeakenDefense")
    RemoveRecipesByTier(lightArrowUpgradeRecipes)
  end
  local shockArrowUpgradeRecipes = {
    ReinforcementBow_Tier02 = {
      "Recipe_SonPerk_ShockArrow_Potency_Tier01"
    },
    ReinforcementBow_Tier03 = {
      "Recipe_SonPerk_ShockArrow_Potency_Tier02",
      "Recipe_SonPerk_ShockArrow_DetonationConduit"
    },
    ReinforcementBow_Tier04 = {
      "Recipe_SonPerk_ShockArrow_Potency_Tier03"
    },
    ReinforcementBow_Tier05 = {
      "Recipe_SonPerk_ShockArrow_OnHitSpark"
    }
  }
  if game.Wallets.HasResource("HERO", "ArrowUnlock_Shock") then
    AddRecipe_NoNotification("HERO", "Recipe_SonPerk_ShockArrow_SparkRate")
    FixupRecipesByTier(shockArrowUpgradeRecipes)
  else
    RemoveRecipe_Safe("HERO", "Recipe_SonPerk_ShockArrow_SparkRate")
    RemoveRecipesByTier(shockArrowUpgradeRecipes)
  end
end
local UnlockPlaytest = function(C)
  if game.GetNewGamePlus() then
    local ngpCrashRune = game.Wallets.GetRunesWithFlags("SINDRI00", {
      "RuneCreator_Unique_NGP_CrashOldVersions"
    })
    if not ngpCrashRune or #ngpCrashRune < 1 then
      game.Wallets.GenerateRune("SINDRI00", "RuneCreator_Unique_NGP_CrashOldVersions")
    end
  end
  if game.Wallets.GetResourceValue("HERO", "ChiselUnlock") > 0 and game.Level.GetVariable("CompletedCineNumber") == 358 then
    game.Level.SetVariable("CompletedCineNumber", 360)
  end
  LD.SyncResurrectionStones(true)
  if 0 >= game.Wallets.GetResourceValue("HERO", "WeaponComponent_Axe_Default") then
    game.Wallets.AddResource("HERO", "WeaponComponent_Axe_Default", 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", "WeaponComponent_Axe_Default")
  end
  if 0 >= game.Wallets.GetResourceValue("HERO", "KratosShield_01") then
    game.Wallets.AddResource("HERO", "KratosShield_01", 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", "KratosShield_01")
  end
  if 0 >= game.Wallets.GetResourceValue("HERO", "KratosArmorChest_Starter_Tier00") then
    game.Wallets.AddResource("HERO", "KratosArmorChest_Starter_Tier00", 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", "KratosArmorChest_Starter_Tier00")
  end
  if 0 >= game.Wallets.GetResourceValue("HERO", "KratosArmorLegs_Starter_Tier00") then
    game.Wallets.AddResource("HERO", "KratosArmorLegs_Starter_Tier00", 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", "KratosArmorLegs_Starter_Tier00")
  end
  if 0 >= game.Wallets.GetResourceValue("HERO", "SonBow") then
    game.Wallets.AddResource("HERO", "SonBow", 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", "SonBow")
  end
  local player = game.Player.FindPlayer()
  if player:PickupIsAcquired("SonKratosBow") == true and game.Level.GetVariable("CompletedCineNumber") < 30 then
    player:PickupRelinquish("SonKratosBow")
  end
  FixupSkillTreeRecipesAtLoad()
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeSpin_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeSpin_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeQuickClear_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeQuickClear_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeSweep_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeSweep_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeUpwardSlice_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeUpwardSlice_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeSwipeCharge_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeSwipeCharge_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossGrind_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossGrind_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossRail_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossRail_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeBeam_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeBeam_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeDashCombo_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeDashCombo_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeLeap_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeLeap_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossThrowdown_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossThrowdown_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeFlurryChop_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeFlurryChop_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeGandalfSlam_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeGandalfSlam_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeWeaponBuff_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeWeaponBuff_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeRake_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeRake_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossGlaive_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_FrostSpecialAxeTossGlaive_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialSpin_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialSpin_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFireClap_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFireClap_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialTwirlBarrage_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialTwirlBarrage_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFlurryStab_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFlurryStab_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFlurrySpin_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFlurrySpin_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialCross_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialCross_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialShotgun_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialShotgun_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialShieldRush_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialShieldRush_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialTripleSlam_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialTripleSlam_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFireWave_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialFireWave_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialMine_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialMine_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialHopSlam_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialHopSlam_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialHopSlam_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialHopSlam_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialMeteorSlam_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialMeteorSlam_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialGrapple_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialGrapple_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialWeaponBuff_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_BladeSpecialWeaponBuff_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonFenrir_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonFenrir_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonBird_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonBird_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonDeer_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonDeer_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonRatatoskr_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonRatatoskr_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonBoar_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonBoar_Lvl03")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonSouls_Lvl02")
  AddRecipe_NoNotification("HERO", "WeaponSpecial_SummonSouls_Lvl03")
end
local RemoveResourceIfInWallet = function(resourceType)
  if game.Wallets.GetResourceValue("HERO", resourceType) >= 1 then
    game.Wallets.RemoveResource("HERO", resourceType, game.Wallets.GetResourceValue("HERO", resourceType))
  end
end
local RemoveAllResourcesInWallet = function()
  RemoveResourceIfInWallet("EconomyXP")
  RemoveResourceIfInWallet("Hacksilver")
  RemoveResourceIfInWallet("ReinforcementCommon")
  RemoveResourceIfInWallet("ReinforcementUncommon")
  RemoveResourceIfInWallet("ReinforcementRare")
  RemoveResourceIfInWallet("BoatLoot")
  RemoveResourceIfInWallet("TravelerLoot")
  RemoveResourceIfInWallet("EnhancedTravelerLoot")
  RemoveResourceIfInWallet("GolemLoot")
  RemoveResourceIfInWallet("EnhancedGolemLoot")
end
local AddBank_Tier01 = function(C)
  RemoveAllResourcesInWallet()
  game.Wallets.AddResource("HERO", "EconomyXP", 2700, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Hacksilver", 940, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementCommon", 12, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxHealthUpgrade", 1, "NO_TELEMETRY")
end
local AddBank_Tier02 = function(C)
  RemoveAllResourcesInWallet()
  game.Wallets.AddResource("HERO", "EconomyXP", 8100, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Hacksilver", 525, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BoatLoot", 5, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "TravelerLoot", 5, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "GolemLoot", 3, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementCommon", 13, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxHealthUpgrade", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxRageUpgrade", 1, "NO_TELEMETRY")
end
local AddBank_Tier03 = function(C)
  RemoveAllResourcesInWallet()
  game.Wallets.AddResource("HERO", "EconomyXP", 15300, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Hacksilver", 4715, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BoatLoot", 5, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "TravelerLoot", 5, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "GolemLoot", 3, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "EnhancedTravelerLoot", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "EnhancedGolemLoot", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementCommon", 13, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementUncommon", 15, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxHealthUpgrade", 2, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxRageUpgrade", 1, "NO_TELEMETRY")
end
local AddBank_Tier04 = function(C)
  RemoveAllResourcesInWallet()
  game.Wallets.AddResource("HERO", "EconomyXP", 26400, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Hacksilver", 10415, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BoatLoot", 10, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "TravelerLoot", 10, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "GolemLoot", 8, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "EnhancedTravelerLoot", 5, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "EnhancedGolemLoot", 2, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementCommon", 13, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementUncommon", 30, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxHealthUpgrade", 2, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxRageUpgrade", 2, "NO_TELEMETRY")
end
local AddBank_Tier05 = function(C)
  RemoveAllResourcesInWallet()
  game.Wallets.AddResource("HERO", "EconomyXP", 33600, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "Hacksilver", 19650, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BoatLoot", 20, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "TravelerLoot", 30, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "GolemLoot", 20, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "EnhancedTravelerLoot", 10, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "EnhancedGolemLoot", 9, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementCommon", 10, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementUncommon", 15, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "ReinforcementRare", 9, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxHealthUpgrade", 3, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxRageUpgrade", 2, "NO_TELEMETRY")
end
local AddBank_XP = function(C)
  game.Wallets.AddResource("HERO", "EconomyXP", 500, "NO_TELEMETRY")
end
local AddBank_Hacksilver = function(C)
  game.Wallets.AddResource("HERO", "Hacksilver", 500, "NO_TELEMETRY")
end
local DiscoverAllMap = function()
  if not discoverAllMap then
    LD.SetRealmDiscovered("Alfheim")
    LD.SetRealmDiscovered("Helheim")
    LD.SetRealmDiscovered("Muspelheim")
    LD.SetRealmDiscovered("Jotunheim")
    LD.SetRealmDiscovered("Niflheim")
    game.Level.SetVariable("_GBL_WaterDrop01Triggered", true)
    game.Level.SetVariable("_GBL_WaterDrop02Triggered", true)
    LD.SetRegionDiscovered("NiflheimMain")
    LD.SetRegionDiscovered("Alfheim")
    LD.SetRegionDiscovered("MuspelheimArena")
    LD.SetRegionDiscovered("Helheim")
    LD.SetRegionDiscovered("HelheimReturn")
    local regionInfoTable = game.Map.GetRegionsInfoTable("Midgard")
    for _, regionInfo in ipairs(regionInfoTable) do
      local regionID = regionInfo.Id
      game.Map.ChangeRegionState(regionID, tweaks.eTokenState.kDiscovered)
    end
    discoverAllMap = true
  end
end
local UnlockAllFastTravel = function()
  if not unlockAllFastTravel then
    if game.Map.GetMarkersInfoTableInRealmWithFlags ~= nil then
      local markerInfoTable = game.Map.GetMarkersInfoTableInRealmWithFlags("Midgard", {"FastTravel"})
      for _, markerInfo in ipairs(markerInfoTable) do
        game.Map.ChangeMarkerState(markerInfo.Id, tweaks.eTokenState.kDiscovered)
      end
    else
      local regionInfoTable = game.Map.GetRegionsInfoTable("Midgard")
      for _, regionInfo in ipairs(regionInfoTable) do
        local regionID = regionInfo.Id
        local regionMarkerInfoTable = game.Map.GetMarkersInfoTable(regionID)
        for _, markerInfo in ipairs(regionMarkerInfoTable) do
          local markerID = markerInfo.Id
          local isFT = game.Map.MarkerHasFlag(markerID, {"FastTravel"})
          if isFT then
            game.Map.ChangeMarkerState(markerID, tweaks.eTokenState.kDiscovered)
          end
        end
      end
    end
    unlockAllFastTravel = true
  end
end
local GiveShockArrow = function()
  if not shockArrowUnlocked then
    LD.GiveShockArrow()
    shockArrowUnlocked = true
  end
end
local GiveLightArrow = function()
  if not lightArrowUnlocked then
    LD.GiveLightArrow()
    lightArrowUnlocked = true
  end
end
local GiveResources = function(C)
  local resourceAmount = 20000
  if not resourcesGiven then
    game.Wallets.AddResource("HERO", "Hacksilver", resourceAmount, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "TravelerLoot", resourceAmount, "NO_TELEMETRY")
    resourcesGiven = true
  end
end
local UnlockAllCheck = function(C)
  game.Wallets.AddResource("HERO", "Blades", 1, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "BifrostUnlock", 1, "NO_TELEMETRY")
  if not unlockAll then
    print("if this is spamming, then there's a problem!")
    global.DebugUnlock = {}
    global.DebugUnlock.pickups = {"Blades", "MimirHead"}
    for _, pickups in ipairs(global.DebugUnlock.pickups) do
      if C:PickupIsAcquired(pickups) == false then
        C:PickupAcquire(pickups)
      end
    end
    if son ~= nil then
      LD.GiveShockArrow()
      LD.GiveLightArrow()
    end
    game.Wallets.AddResource("HERO", "FastTravelUnlock01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "ChiselUnlock", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorOffense01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorDefense01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorSpeed01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorOffense02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorDefense02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorSpeed02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorOffense03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorDefense03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorSpeed03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorBonus01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorBonus02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorBonus03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "SonArmorBonus04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_Starter_Tier00", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TankSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TankSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TankSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_SpeedSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_SpeedSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_SpeedSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_DamageSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_DamageSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_DamageSet_Tier01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TankSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TankSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TankSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_SpeedSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_SpeedSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_SpeedSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_DamageSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_DamageSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_DamageSet_Tier02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TankSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TankSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TankSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_SpeedSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_SpeedSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_SpeedSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_DamageSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_DamageSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_DamageSet_Tier03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TankSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TankSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TankSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_SpeedSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_SpeedSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_SpeedSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_DamageSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_DamageSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_DamageSet_Tier04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TankSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TankSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TankSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_SpeedSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_SpeedSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_SpeedSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_DamageSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_DamageSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_DamageSet_Tier05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_SpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_SpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_SpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_DamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_DamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_DamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TyrSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TyrSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TyrSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TyrSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TyrSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TyrSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_ElementalSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_ElementalSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_ElementalSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_ElementalSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_ElementalSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_ElementalSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TravelerSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TravelerSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TravelerSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_TravelerSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_TravelerSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_TravelerSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_HuldraBrokSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_HuldraBrokSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_HuldraBrokSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_HuldraBrokSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_HuldraBrokSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_HuldraBrokSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_HuldraSindriSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_HuldraSindriSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_HuldraSindriSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_HuldraSindriSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_HuldraSindriSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_HuldraSindriSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_ValkyrieSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_ValkyrieSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_ValkyrieSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_ValkyrieSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_ValkyrieSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_ValkyrieSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_MspTankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_MspTankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_MspTankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_MspTankSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_MspTankSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_MspTankSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_MspSpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_MspSpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_MspSpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_MspSpeedSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_MspSpeedSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_MspSpeedSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_MspDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_MspDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_MspDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_MspDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_MspDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_MspDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifTankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifTankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifTankSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifTankSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifTankSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifTankSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifSpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifSpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifSpeedSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifSpeedSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifSpeedSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifSpeedSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifDamageSet_Tier06", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_NifDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_NifDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_NifDamageSet_Tier06_NGP", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_Bonus01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_Bonus01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_Bonus01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_Bonus02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_Bonus02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_Bonus02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorChest_Bonus03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorWrist_Bonus03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "KratosArmorLegs_Bonus03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Node01_SubNode02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Node01_SubNode03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Node01_SubNode04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier02_Melee_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier02_Melee_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier02_Melee_Delay_HeavyBomb", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Bare_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Bare_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Evade_Forward", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Melee_Evade_Back", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier02_Melee_Delay_Light_Upgrade_01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Tier01_Toss_Light_Upgrade", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Melee_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Melee_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Melee_Node01_SubNode02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Melee_Node01_SubNode03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Melee_Node01_SubNode04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Bare_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Bare_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Bare_Node01_SubNode02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Bare_Node01_SubNode03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Momentum_Unlock_01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Momentum_Unlock_02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Momentum_01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Blades_Momentum_02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_Node01_SubNode02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_Node01_SubNode03", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_Melee_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_Melee_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_Bare_Node01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_Bare_Node01_SubNode01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_Node01_SubNode04", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_Node01_SubNode05", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_BlockBreak", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_AxeEvadeAttack_Light", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_AxeEvadeAttack_Light_Back", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_BareHeavyHold_Upgrade", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_BareEvadeAttack_Light", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_PaintTargetUpgrade", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_PaintTargetUpgrade_02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Throw_CriticalThrowUpgrade", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_ParryAttack_Light", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_ParryAttack_Heavy", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_ParryProjectile", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_AxeDelayComboUpgrade", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_AxeDelayComboUpgrade_02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier02_AxeDelayComboUpgrade_Heavy", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_R1_Base", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_L1_Base", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Momentum_Unlock_01", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_Tier01_Momentum_Unlock_02", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_R1Hold", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_R2Hold", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_L1", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_L2", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_R1Mash", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "Axe_RageMode_Upgrade_R2", 1, "NO_TELEMETRY")
    game.Wallets.AddResource("HERO", "WeaponComponent_Blades_Default", 1, "NO_TELEMETRY")
    game.InitEntitlementsResources()
    Unlock_AllTrinkets()
    Unlock_AllSpecials()
    Unlock_AllSon()
    Unlock_AllBaseWeaponComponents()
    unlockAll = true
  end
end
function UnlockAllMetersAndCiphers()
  game.Wallets.AddResource("HERO", "MaxHealthUpgrade", 8, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MaxRageUpgrade", 4, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "MuspelheimCipherPiece", 4, "NO_TELEMETRY")
  game.Wallets.AddResource("HERO", "NiflheimCipherPiece", 4, "NO_TELEMETRY")
end
function LuaHook_MomentumAxePurchased()
  LD.AddRecipe_Safe("HERO", "Axe_Tier01_Momentum_Unlock_01")
  LD.AddRecipe_Safe("HERO", "Axe_Tier01_Momentum_Unlock_02")
end
local GiveTier1Recipes = function()
  if not tier1RecipesGiven then
    AddRecipe_NoNotification("HERO", "SonLightArrow_Acquire")
    AddRecipe_NoNotification("HERO", "SonLightArrow_Consume")
    AddRecipe_NoNotification("HERO", "SonShockArrow_Consume")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneVolundr_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneNiflheim_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneForestDungeon_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneHuldra2_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneHuldra3_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneVikingFuneral_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "EntryStoneHTTK_Unlock")
    AddRecipe_NoNotification("HERO_SAVEONLY", "TyrAmuletUnlock_Unlock")
    tier1RecipesGiven = true
    print("SPAM CHECK MAKE SURE ITS OFF")
  end
end
local DirToEnvProbe, PosToEnvProbe
function GrabEnvProbes(C)
  if DirToEnvProbe == nil then
    DirToEnvProbe = C:GetAnimDriver("DirToEnvProbe")
  end
  if PosToEnvProbe == nil then
    PosToEnvProbe = C:GetAnimDriver("PosToEnvProbe")
  end
end
local HipSelectionValue
function GrabHipSelection(C)
  if HipSelectionValue == nil then
    HipSelectionValue = C:GetAnimDriver("HipSelectionDriver")
  end
end
function LuaHook_DisableRevive(ai, toggleValue)
  reviveDisabled = toggleValue
end
function IsDeathAllowed(C)
  if reviveDisabled then
    return true
  end
  if C:PickupIsAcquired("HeroSnowBlind") then
    return true
  end
  local son = game.AI.FindSon()
  if son == nil then
    return true
  end
  local sonBB = son:GetBlackboard()
  local sonEnraged = false
  if sonBB:Exists("Enraged") then
    sonEnraged = sonBB:GetBoolean("Enraged")
  end
  local canRevive = son ~= nil and (son.OwnedPOI == nil or son.OwnedPOI ~= nil and son.OwnedPOI:FindLuaTableAttribute("AllowRevive") ~= nil and son.OwnedPOI:FindLuaTableAttribute("AllowRevive") == true) and son:IsAvailableInLevel() and son:HasMarker("Son_KnockedDown") == false and sonEnraged == false and not DL.CheckCreatureContext(son:GetContext(), "INCAPACITATED") and C:IsPlayingMove("MOV_DeathSave") == false and C:IsPlayingMove("MOV_DeathSaveEnter") == false
  local hasRune = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneA") > 0 or 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneB") or 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneC")
  if canRevive and hasRune then
    if 0 < game.Wallets.GetResourceValue("HERO", "ResurrectionRuneStoneA") then
      LD.AddRecipe_Safe("HERO", "ResurrectionRuneStoneA_Consume")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "ResurrectionRuneStoneB") then
      LD.AddRecipe_Safe("HERO", "ResurrectionRuneStoneB_Consume")
    end
    if 0 < game.Wallets.GetResourceValue("HERO", "ResurrectionRuneStoneC") then
      LD.AddRecipe_Safe("HERO", "ResurrectionRuneStoneC_Consume")
    end
    son:TriggerMoveEvent("kLE_ExitGrabToRevive")
    return false
  else
    return true
  end
end
function DeathDisallowedByLua(C)
  local player = game.Player.FindPlayer()
  player:PickupAcquire("ResurrectionRuneStoneType")
  if game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneC") > 0 then
    player:PickupSetStage("ResurrectionRuneStoneType", 2)
  elseif 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneB") then
    player:PickupSetStage("ResurrectionRuneStoneType", 1)
  elseif 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneA") then
    player:PickupSetStage("ResurrectionRuneStoneType", 0)
  end
  player:TriggerMoveEvent("Resurrect")
  print("Trying to resurrect.")
end
function LuaHook_RemoveResurrectionStones(C)
  local amount = 0
  if 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneC") then
    amount = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneC")
    game.Wallets.RemoveResource("HERO_SAVEONLY", "ResurrectionRuneStoneC", amount)
    game.Wallets.Craft("HERO", "ResurrectionRuneStoneC_Consume")
  end
  if 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneB") then
    amount = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneB")
    game.Wallets.RemoveResource("HERO_SAVEONLY", "ResurrectionRuneStoneB", amount)
    game.Wallets.Craft("HERO", "ResurrectionRuneStoneB_Consume")
  end
  if 0 < game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneA") then
    amount = game.Wallets.GetResourceValue("HERO_SAVEONLY", "ResurrectionRuneStoneA")
    game.Wallets.RemoveResource("HERO_SAVEONLY", "ResurrectionRuneStoneA", amount)
    game.Wallets.Craft("HERO", "ResurrectionRuneStoneA_Consume")
  end
end
local breathEffect
local fakePad = {}
local tempDebuffBurnTimer = 0
local heroIsFrozen = false
local debugFastLeakTable
function DoMemoryDebugHelpers()
  if game.GetLeakMemory() then
    if debugFastLeakTable == nil then
      debugFastLeakTable = {}
    end
    local rate = game.GetLeakMemoryRate()
    for _ = 1, rate do
      debugFastLeakTable[#debugFastLeakTable + 1] = #debugFastLeakTable
    end
  end
  if game.GetCreateGarbage() then
    local rate = game.GetCreateGarbageRate()
    for _ = 1, rate do
      local garbageTable = {}
    end
  end
end
function EnableColdIdle(C)
  C:SetMood("MOOD_DEEP_SNOW")
end
function DisableColdIdle(C)
  C:ClearMood("MOOD_DEEP_SNOW")
end
function EnablePanicIdle(C)
  C:SetMood("MOOD_FRENZYRUN")
end
function DisablePanicIdle(C)
  C:ClearMood("MOOD_FRENZYRUN")
end
function OnCreatureUpdate(C)
  inSynchCurrentFrame = C:IsDoingSyncMove()
  if inSynchMovePrevFrame ~= nil and inSynchMovePrevFrame == true and inSynchCurrentFrame == false then
    C:PickupAcquire("PostCSMoveInvulnerability")
  end
  inSynchMovePrevFrame = inSynchCurrentFrame
  local pad = playerCreature.Pad or fakePad
  if game.CHECK_FEATURE and game.CHECK_FEATURE("MEMORY_DEBUG") then
    DoMemoryDebugHelpers()
  end
  if engine.SetInCombat then
    engine.SetInCombat(game.Combat.GetCombatStatus())
  end
  if game.Combat.GetCombatStatus then
    if not game.Combat.GetCombatStatus() then
      game.Interact.EnableTags("NotInCombat")
      if lastUpdateCombatState == true then
        local xpCount = game.Wallets.GetResourceValue("XP_HOLD", "EconomyXP")
        if 0 < xpCount then
          game.Wallets.RemoveResource("XP_HOLD", "EconomyXP", xpCount)
          game.Wallets.AddResource("HERO", "EconomyXP", xpCount)
        end
      end
    else
      game.Interact.DisableTags("NotInCombat")
    end
    lastUpdateCombatState = game.Combat.GetCombatStatus()
  end
  if 0 < game.Wallets.GetResourceValue("HERO", "HealthRuneDropCooldown") then
    game.Wallets.RemoveResource("HERO", "HealthRuneDropCooldown", game.Wallets.GetResourceValue("HERO", "HealthRuneDropCooldown"))
    C:PickupAcquire("HealthRuneDropCooldown")
  end
  if game.GetNewGamePlus() and 0 >= game.Wallets.GetResourceValue("HERO", "NGPFlag2") then
    game.Wallets.NGP_GrantAllRecipesWithFlags("HERO", {
      "Sell",
      "NGPGrantImmediate",
      "NGPNeverReplace"
    })
    game.Wallets.AddResource("HERO", "NGPFlag2", 1)
  end
  local isPlayerSprinting = playerCreature:HasMarker("Sprinting")
  if isPlayerSprinting == true and sprintingLastFrame == true then
    sprintTimer = sprintTimer + playerCreature:GetUnitTime()
  end
  if isPlayerSprinting == true and sprintingLastFrame == false then
    sprintingLastFrame = true
    sprintTimer = 0
  end
  if isPlayerSprinting == false and sprintingLastFrame == true then
    sprintingLastFrame = false
    sprintTimer = 0
  end
  if 3 < sprintTimer and playerCreature:PickupIsAcquired("Perk_Sprint_SuperArmor") then
    playerCreature:PickupAcquire("Buff_SuperArmor")
  end
  if not initializedLookAtValues then
    if C.AddLookAtPriorityOverride then
      _G.thisLookAtEntry = game.AddGlobalLookAtTarget(C, engine.Vector.New(0, 1.5, 0), lookAtConsts.TargetType.Hero)
      _G.lookAtPriorityOverrides.kid = C:AddLookAtPriorityOverride(lookAtConsts.TargetType.Kid, lookAtConsts.Priority.Ignore)
    end
    _G.lookAtPriorityOverrides.InterestingObject = C:AddLookAtPriorityOverride(lookAtConsts.TargetType.InterestingObject, lookAtConsts.Priority.Ignore)
    _G.lookAtPriorityOverrides.FriendlyAI = C:AddLookAtPriorityOverride(lookAtConsts.TargetType.FriendlyAI, lookAtConsts.Priority.High)
    initializedLookAtValues = true
  end
  encounterMusic.activeEnemies = game.Encounters.GetEnemiesInCombatCount()
  if encounterMusic.activeEnemies ~= encounterMusic.lastEnemyCount and game.CHECK_FEATURE("MUSIC_INTENSITY") then
    game.Audio.SetBusLevelRTPCValue("MX_Intensity_Meter", game.Audio.GetMusicIntensity() + encounterMusic.activeEnemies)
    print(tostring(game.Audio.GetMusicIntensity() + encounterMusic.activeEnemies) .. " music meter")
  end
  encounterMusic.lastEnemyCount = encounterMusic.activeEnemies
  if C.SetOverrideStatusEffectIconParent == nil then
    for statusEffect, value in pairs(statusEffectIconsOn) do
      if 0 < C:MeterGetValue(tostring(statusEffect)) and value == false then
        mpicon.level.Create(C, tostring(statusEffect) .. "_DEBUFF")
        mpicon.level.Parent(C, tostring(statusEffect) .. "_DEBUFF", "KRATOS_HEALTH_BAR")
        statusEffectIconsOn[tostring(statusEffect)] = true
      elseif 0 >= C:MeterGetValue(tostring(statusEffect)) and value == true then
        mpicon.level.Off(C, tostring(statusEffect) .. "_DEBUFF")
        statusEffectIconsOn[tostring(statusEffect)] = false
      end
    end
  end
  if heroIsFrozen then
    local hasFrozenPickup = C:PickupIsAcquired("Debuff_Hero_Freeze")
    if not (not (0 >= C.HitPoints) and hasFrozenPickup) or hasFrozenPickup and C:PickupGetStage("Debuff_Hero_Freeze") ~= 4 then
      mpicon.Off("FROZEN_MASH_BUTTON")
      heroIsFrozen = false
    end
  end
  if C:PickupIsAcquired("Debuff_Hero_Burn") then
    if tempDebuffBurnTimer <= 0 then
      TUT.FireDebuffRoll_Tutorial()
      tempDebuffBurnTimer = 8
    end
    if 0 < tempDebuffBurnTimer then
      tempDebuffBurnTimer = tempDebuffBurnTimer - C:GetUnitTime()
    end
  end
  if VFS.EnableEasyStun.value == true and VFS.EnableEasyStunCurrentState == false then
    if C:PickupIsAcquired("Buff_EasyStun") == false then
      C:PickupAcquire("Buff_EasyStun")
    end
    VFS.EnableEasyStunCurrentState = true
  elseif VFS.EnableEasyStun.value == false and VFS.EnableEasyStunCurrentState == true then
    if C:PickupIsAcquired("Buff_EasyStun") == true then
      C:PickupRelinquish("Buff_EasyStun")
    end
    VFS.EnableEasyStunCurrentState = false
  end
  if VFS.DisableStun.value == true and VFS.DisableStunCurrentState == false then
    game.Level.SetVariable("DEBUG_CBT_Disable_Stun", true)
    VFS.DisableStunCurrentState = true
  elseif VFS.DisableStun.value == false and VFS.DisableStunCurrentState == true then
    game.Level.SetVariable("DEBUG_CBT_Disable_Stun", false)
    VFS.DisableStunCurrentState = false
  end
  if VFS.InfiniteRage.value == true then
    C:MeterSetValue("Blood", 100)
    if C:PickupIsAcquired("MomentumMeter") then
      C:MeterSetValue("Momentum", 100)
    else
      C:PickupAcquire("MomentumMeter")
    end
    if C:PickupIsAcquired("MomentumBladesMeter") then
      C:MeterSetValue("MomentumBlades", 100)
    else
      C:PickupAcquire("MomentumBladesMeter")
    end
  end
  if C:PickupIsAcquired("ForceRageModeDisabled") then
    C:MeterSetValue("Blood", 0)
  end
  if VFS.EnableMomentumSystem.value == true and C:PickupIsAcquired("MomentumMeter") == false then
    game.Wallets.AddResource("HERO", "Axe_Tier01_Momentum_Unlock_01", 1, "NO_TELEMETRY")
  end
  if 0 <= VFS.SetMomentumAmount.value then
    C:MeterSetValue("Momentum", VFS.SetMomentumAmount.value)
  end
  locomotion.CreateDrivers(C)
  perks.OnUpdate(C)
  if playerCreature == nil then
    playerCreature = game.Player.FindPlayer()
  end
  if breathEffect == nil then
    local player = game.Player.FindPlayer()
    breathEffect = game.FX.Spawn("FX_kratos_Breath", nil, {
      Joint = "JOJaw1",
      GameObject = player,
      DeleteWithCreature = true
    })
    breathEffect:SetAnimFloatChannelDriver(player, "sliderfloatchannels._breathfxintensity")
    print("Breath playing")
  end
  local isCurrentlyFrosty = playerCreature:HasMarker("Aiming")
  if wasFrosty == false and isCurrentlyFrosty == true then
    for weaponInfo in playerCreature:IterateActiveWeapons() do
      local axeObj = weaponInfo.Weapon
      local axeObjSound
      if axeObj ~= nil and axeObj:GetName() == "axe00" then
        wasFrosty = true
      end
    end
  end
  if wasFrosty == true and isCurrentlyFrosty == false then
    for weaponInfo in playerCreature:IterateActiveWeapons() do
      local axeObj = weaponInfo.Weapon
      local axeObjSound
      if axeObj ~= nil and axeObj:GetName() == "axe00" then
        wasFrosty = false
      end
    end
  end
  if game.GetAutoSprint() then
    SprintAccessibilityCheck(C)
  end
  if game.Resources.SetDebugAddMode then
    game.Resources.SetDebugAddMode(true)
  end
  if game.build.GOLD_VERSION ~= 1 then
    if VFS.UnlockEverything.value == true then
      UnlockAllCheck(C)
    end
    if VFS.GiveResources.value == true then
      GiveResources(C)
    end
    if VFS.UnlockBowReinforcement.value == true then
      local son = game.AI.FindSon()
      if 0 >= son:PickupGetStage("SonBow") then
        game.Wallets.AddRecipe("HERO", "Recipe_ReinforceBow_Tier02")
      end
    end
    if VFS.UnlockShockArrow.value == true then
      GiveShockArrow(C)
    end
    if VFS.UnlockLightArrow.value == true then
      GiveLightArrow(C)
    end
    if isVince == true then
      Unlock_AllSon()
      isVince = false
    end
    if VFS.UnlockTier01.value ~= VFS.UnlockTier01_PrevFrame then
      UnlockLoadout_Tier01(C, VFS.UnlockTier01.value)
      VFS.UnlockTier01_PrevFrame = VFS.UnlockTier01.value
    end
    if VFS.UnlockTier02.value ~= VFS.UnlockTier02_PrevFrame then
      UnlockLoadout_Tier02(C, VFS.UnlockTier02.value)
      VFS.UnlockTier02_PrevFrame = VFS.UnlockTier02.value
    end
    if VFS.UnlockTier03.value ~= VFS.UnlockTier03_PrevFrame then
      UnlockLoadout_Tier03(C, VFS.UnlockTier03.value)
      VFS.UnlockTier03_PrevFrame = VFS.UnlockTier03.value
    end
    if VFS.UnlockTier04.value ~= VFS.UnlockTier04_PrevFrame then
      UnlockLoadout_Tier04(C, VFS.UnlockTier04.value)
      VFS.UnlockTier04_PrevFrame = VFS.UnlockTier04.value
    end
    if VFS.UnlockTier05.value ~= VFS.UnlockTier05_PrevFrame then
      UnlockLoadout_Tier05(C, VFS.UnlockTier05.value)
      VFS.UnlockTier05_PrevFrame = VFS.UnlockTier05.value
    end
    if VFS.UnlockTier06.value ~= VFS.UnlockTier06_PrevFrame then
      UnlockLoadout_Tier06(C, VFS.UnlockTier06.value)
      VFS.UnlockTier06_PrevFrame = VFS.UnlockTier06.value
    end
    if VFS.UnlockArmor_DefenseTier.value ~= VFS.UnlockArmor_DefenseTierPrevFrame then
      UnlockLoadout_DefenseArmor(C, VFS.UnlockArmor_DefenseTier.value)
      VFS.UnlockArmor_DefenseTierPrevFrame = VFS.UnlockArmor_DefenseTier.value
    end
    if VFS.UnlockArmor_PureDamageTier.value ~= VFS.UnlockArmor_PureDamageTierPrevFrame then
      UnlockLoadout_PureDamageArmor(C, VFS.UnlockArmor_PureDamageTier.value)
      VFS.UnlockArmor_PureDamageTierPrevFrame = VFS.UnlockArmor_PureDamageTier.value
    end
    if VFS.UnlockArmor_FocusTier.value ~= VFS.UnlockArmor_FocusTierPrevFrame then
      UnlockLoadout_FocusArmor(C, VFS.UnlockArmor_FocusTier.value)
      VFS.UnlockArmor_FocusTierPrevFrame = VFS.UnlockArmor_FocusTier.value
    end
    if VFS.UnlockArmor_ToughnessTier.value ~= VFS.UnlockArmor_ToughnessTierPrevFrame then
      UnlockLoadout_ToughnessArmor(C, VFS.UnlockArmor_ToughnessTier.value)
      VFS.UnlockArmor_ToughnessTierPrevFrame = VFS.UnlockArmor_ToughnessTier.value
    end
    if VFS.UnlockArmor_HybridDamageTier.value ~= VFS.UnlockArmor_HybridDamageTierPrevFrame then
      UnlockLoadout_HybridDamageArmor(C, VFS.UnlockArmor_HybridDamageTier.value)
      VFS.UnlockArmor_HybridDamageTierPrevFrame = VFS.UnlockArmor_HybridDamageTier.value
    end
    if VFS.UnlockArmor_RunicTier.value ~= VFS.UnlockArmor_RunicTierPrevFrame then
      UnlockLoadout_RunicArmor(C, VFS.UnlockArmor_RunicTier.value)
      VFS.UnlockArmor_RunicTierPrevFrame = VFS.UnlockArmor_RunicTier.value
    end
    if VFS.UnlockArmor_MusSpecial.value ~= VFS.UnlockArmor_MusSpecialPrevFrame then
      UnlockLoadout_SpecialArmor(C, VFS.UnlockArmor_MusSpecial.value, "Mus")
      VFS.UnlockArmor_MusSpecialPrevFrame = VFS.UnlockArmor_MusSpecial.value
    end
    if VFS.UnlockArmor_NifSpecial.value ~= VFS.UnlockArmor_NifSpecialPrevFrame then
      UnlockLoadout_SpecialArmor(C, VFS.UnlockArmor_NifSpecial.value, "Nif")
      VFS.UnlockArmor_NifSpecialPrevFrame = VFS.UnlockArmor_NifSpecial.value
    end
    if VFS.UnlockArmor_ValkSpecial.value ~= VFS.UnlockArmor_ValkSpecialPrevFrame then
      UnlockLoadout_SpecialArmor(C, VFS.UnlockArmor_ValkSpecial.value, "Val")
      VFS.UnlockArmor_ValkSpecialPrevFrame = VFS.UnlockArmor_ValkSpecial.value
    end
    if VFS.AddUniqueRunes.value ~= VFS.Unlock_AddUniqueRunes then
      AddUniqueRunes(C, VFS.AddUniqueRunes.value)
      VFS.Unlock_AddUniqueRunes = VFS.AddUniqueRunes.value
    end
    if VFS.AddArmorRunes.value ~= VFS.Unlock_AddArmorRunes then
      AddArmorRunes(C, VFS.AddArmorRunes.value)
      VFS.Unlock_AddArmorRunes = VFS.AddArmorRunes.value
    end
    if VFS.RuneDebugCreate.value ~= VFS.Unlock_RuneDebugCreate then
      AddDebugRunes(C, VFS.RuneDebugStat.value, VFS.RuneDebugPerk.value, VFS.RuneDebugTier.value)
      VFS.Unlock_RuneDebugCreate = VFS.RuneDebugCreate.value
    end
    if VFS.UpgradeArmor.value ~= VFS.UpgradeArmorPrevFrame then
      if VFS.UpgradeArmor.value then
        UpgradeArmor(C)
      end
      VFS.UpgradeArmorPrevFrame = VFS.UpgradeArmor.value
    end
    if VFS.UnlockAllSpecials.value == true and SpecialsUnlocked == false then
      Unlock_AllSpecials(C)
      SpecialsUnlocked = true
    end
    if VFS.UnlockAllTrinkets.value == true and TrinketsUnlocked == false then
      Unlock_AllBaseTrinkets()
      TrinketsUnlocked = true
    end
    if VFS.UnlockAllWeaponComponents.value == true and WeaponComponentsUnlocked == false then
      Unlock_AllBaseWeaponComponents()
      WeaponComponentsUnlocked = true
    end
    if VFS.UnlockAllFastTravel.value == true then
      UnlockAllFastTravel()
    end
    if VFS.DiscoverAllMap.value == true then
      DiscoverAllMap()
    end
    if ForceCheckMapState == false then
      ForceCheckMap()
      ForceCheckMapState = true
    end
    if VFS.UnlockAllMetersAndCiphers.value == true and unlockAllMetersAndCiphers == false then
      UnlockAllMetersAndCiphers()
      unlockAllMetersAndCiphers = true
    end
  end
  if playerCreature.GetAndClearCurrentPlayerLoadoutRequest ~= nil then
    local newPlayerLayout, numAddXP, numAddCurrency
    newPlayerLayout, numAddXP, numAddCurrency = playerCreature:GetAndClearCurrentPlayerLoadoutRequest()
    if newPlayerLayout == 1 then
      UnlockLoadout_Tier01(C, -1)
      AddBank_Tier01(C)
    end
    if newPlayerLayout == 2 then
      UnlockLoadout_Tier02(C, -1)
      AddBank_Tier02(C)
    end
    if newPlayerLayout == 3 then
      UnlockLoadout_Tier03(C, -1)
      AddBank_Tier03(C)
    end
    if newPlayerLayout == 4 then
      UnlockLoadout_Tier04(C, -1)
      AddBank_Tier04(C)
    end
    if newPlayerLayout == 5 then
      AddBank_Tier05(C)
      UnlockLoadout_Tier05(C, -1)
    end
    if newPlayerLayout == 6 then
      AddBank_Tier05(C)
      UnlockLoadout_Tier06(C, -1)
    end
    while 0 < numAddXP do
      AddBank_XP(C)
      numAddXP = numAddXP - 1
    end
    while 0 < numAddCurrency do
      AddBank_Hacksilver(C)
      numAddCurrency = numAddCurrency - 1
    end
  end
  if UnlockPlaytestVar == false then
    UnlockPlaytest(C)
    UnlockPlaytestVar = true
  end
  if game.Resources.SetDebugAddMode then
    game.Resources.SetDebugAddMode(false)
  end
  GiveTier1Recipes()
  traverselink.OnUpdate(C)
  if playerCreature.UpdateTargetedState then
    playerCreature:UpdateTargetedState()
  end
  playerVelocity = C:GetVelocity()
  SendInputDataToSon()
  SetInfluenceToTheaterOfOperation(playerCreature)
  playerHealthCurrent = game.Player.FindPlayer():MeterGetValue("Health")
  playerHealthMax = game.Player.FindPlayer():MeterGetMax("Health")
  if playerHealthCurrent > playerHealthMax then
    playerHealthCurrent = playerHealthMax
  end
  playerHealthPercent = math.abs(playerHealthCurrent / playerHealthMax) * 100
  local camShakeLarge = {
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 3
  }
  local fseVignetteHigh = {
    EffectName = "FSE_ColorCorrection_Flashbang",
    Duration = 1
  }
  local gapJumpButtonPress = pad.CrossDown
  local jointIndex = C:GetJointIndex("zeroJoint")
  local zeroJointFacingFwd = C:GetWorldJointForward(jointIndex)
  local offset = zeroJointFacingFwd:Normalized() * 30
  local facing = zeroJointFacingFwd:Normalized()
  local offsetZeroJoint = playerCreature.WorldPosition + offset
  GrabEnvProbes(C)
  GrabHipSelection(C)
  if axeIsAcquired == false and not game.Wallets.HasResource("HERO", "Axe") then
    game.Wallets.AddResource("HERO", "Axe", 1, "NO_TELEMETRY")
    game.UI.ClearNotification("Resource", "Axe")
    axeIsAcquired = true
  end
  if playerCreature:PickupIsAcquired("MimirHead") and playerCreature:IsInVehicle() == true and C:IsPlayingMove("MOV_Mimir_Head_Replace") == false and C:IsPlayingMove("MOV_BoatEnterPushOffLMimir") == false and C:IsPlayingMove("MOV_BoatEnterPushOffRMimir") == false and C:IsPlayingMove("MOV_BoatExitLMimir") == false and C:IsPlayingMove("MOV_BoatExitRMimir") == false then
    C:TriggerMoveEvent("Mimir_Head_Replace")
  end
  MimirHeadIdleSetup()
  AshPouchSetup()
  local isCurrentlyBlocking = playerCreature:HasMarker("Blocking")
  if wasBlocking == false and isCurrentlyBlocking == true then
    wasBlocking = true
    for weaponInfo in playerCreature:IterateActiveWeapons() do
      local shieldObj = weaponInfo.Weapon
      if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
        shieldObj:StartAnim("DefBlockEnter03")
        if playerCreature:PickupIsAcquired("KratosArmorTrinket_Parry") == true then
          shieldObj:StartMaterialAnim("kratosShield00_ON")
        end
        LD.PlaySound(shieldSoundEmitter, "SND_WPN_Shield_Draw")
        playerCreature:PickupAcquire("BlockingSwitch", 1)
      end
    end
  elseif wasBlocking == true and isCurrentlyBlocking == false then
    wasBlocking = false
    blockTimer = 0
    for weaponInfo in playerCreature:IterateActiveWeapons() do
      local shieldObj = weaponInfo.Weapon
      if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
        shieldObj:StartAnim("DefBlockExit03")
        if playerCreature:PickupIsAcquired("KratosArmorTrinket_Parry") == true then
          shieldObj:StartMaterialAnim("kratosShield00_OFF")
        end
        LD.PlaySound(shieldSoundEmitter, "SND_WPN_Shield_Stow")
        playerCreature:PickupAcquire("BlockingSwitch", 0)
      end
    end
  end
  local isCurrentlyBlockfull = playerCreature:HasMarker("Blockfull")
  if wasBlockFull == false and isCurrentlyBlockfull == true then
    wasBlockFull = true
    blockTimer = blockTimer + playerCreature:GetUnitTime()
    uiCalls.UI_Event_Block_Start()
  elseif wasBlockFull == true and isCurrentlyBlockfull == false then
    blockTimer = 0
    wasBlockFull = false
    uiCalls.UI_Event_Block_End()
  end
  if wasBlockFull == true and isCurrentlyBlockfull == true then
    blockTimer = blockTimer + playerCreature:GetUnitTime()
    if 3 <= blockTimer and playerCreature:PickupIsAcquired("Perk_Defense_EnhancedBlock") then
      playerCreature:PickupAcquire("Buff_EnhancedBlock")
    end
  end
  if engine.IsDebug() then
    bboard:Set("DEBUG_TurnOnPositionDistanceDebug", VFS.PositionDistanceDebug.value)
    if C:DebugIsSelectedCreature() then
      Update_PositionDistanceDebugTable()
    end
  end
  GrabHipSelection(C)
  local myHeading = C:GetWorldForward()
  local playerPos = C:GetWorldPosition()
  hipDelayTimer:Start()
  if 0 > playerVelocity:Dot(myHeading) and HipSelectionValue.Value == 0 then
    HipSelectionValue.Value = 1
  elseif 0 < playerVelocity:Dot(myHeading) and HipSelectionValue.Value == 1 then
    HipSelectionValue.Value = 0
  end
  if gapJumpButtonPress == true then
    DirToEnvProbe.ValueVec = facing
    PosToEnvProbe.ValueVec = offsetZeroJoint
  end
  local isCurrentlyAiming = playerCreature:HasMarker("Aiming")
  if wasAiming == false and isCurrentlyAiming == true then
    uiCalls.UI_Event_Aim_Start()
  elseif wasAiming == true and isCurrentlyAiming == false then
    uiCalls.UI_Event_Aim_End()
  end
  wasAiming = isCurrentlyAiming
  local isCurrentlyAimCapable = true
  if playerCreature.CanAim ~= nil then
    isCurrentlyAimCapable = playerCreature:CanAim() or playerCreature:HasMarker("Cranking")
    if not isCurrentlyAimCapable then
      local blades = playerCreature.Blades
      if blades ~= nil then
        isCurrentlyAimCapable = blades.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSInFlightOut
      end
    end
  end
  if not wasAimCapable and isCurrentlyAimCapable then
    uiCalls.UI_Event_Aim_Capable()
  elseif wasAimCapable and not isCurrentlyAimCapable then
    uiCalls.UI_Event_Aim_Incapable()
  end
  wasAimCapable = isCurrentlyAimCapable
  local isCurrentlyAttacking = playerCreature:HasMarker("Attacking")
  if wasAttacking == false and isCurrentlyAttacking == true then
    uiCalls.UI_Event_Attack_Start()
  elseif wasAttacking == true and isCurrentlyAttacking == false then
    uiCalls.UI_Event_Attack_End()
  end
  wasAttacking = isCurrentlyAttacking
  if inRageMode == true then
    if playerCreature:PickupGetStage("RageMode") == 0 then
      LuaHook_RageModeExit()
    end
    uiCalls.UI_Refresh_HUD()
  end
  if healthPrevFrame > playerHealthCurrent and playerHealthMaxPrevFrame == playerHealthMax then
    if playerCreature:HasMarker("MoveArmor") then
      game.FX.SubmitEffect(fseVignetteMoveArmor)
    else
      game.FX.SubmitEffect(fseVignetteTakeDmg)
    end
    perks.OnDamageReceived(playerHealthPercent, playerHealthLowThreshold, playerHealthCriticalThreshold)
    if playerCreature:PickupIsAcquired("MuspelheimSingleHitChallenge") then
      playerCreature:PickupRelinquish("MuspelheimSingleHitChallenge")
    end
    showLowHealthWarningTimer = showLowHealthWarningTimerMax
  end
  healthPrevFrame = playerHealthCurrent
  playerHealthMaxPrevFrame = playerHealthMax
  if lowHealthSFXCall == true and game.Cinematics.IsInCinematicMode() then
    game.Audio.StopSound("SND_UX_Health_Kratos_Low_Health_LP")
    lowHealthSFXCall = false
  end
  if playerHealthPercent > playerHealthLowThreshold then
    if playerCreature.Pad ~= nil and not padColorReset then
      playerCreature.Pad:ResetLightColor()
      padColorReset = true
    end
    if lowHealthSFXCall == true then
      game.Audio.StopSound("SND_UX_Health_Kratos_Low_Health_LP")
      lowHealthSFXCall = false
    end
    showLowHealthWarningTimer = showLowHealthWarningTimerMax
  elseif playerHealthPercent <= playerHealthLowThreshold and 0 < playerHealthPercent then
    if 0 < showLowHealthWarningTimer then
      if not game.Cinematics.IsInCinematicMode() then
        game.FX.SubmitEffect(conRumbleMedium)
        game.FX.SubmitEffect(fseVignetteTakeDmgCritical)
      end
      showLowHealthWarningTimer = showLowHealthWarningTimer - playerCreature:GetUnitTime()
    elseif not game.Cinematics.IsInCinematicMode() then
      game.FX.SubmitEffect(fseVignetteTakeDmgCriticalDelayed)
    end
    if playerCreature.Pad ~= nil then
      if playerHealthPercent <= playerHealthCriticalThreshold then
        playerCreature.Pad:SetLightColor(16711680)
      else
        playerCreature.Pad:SetLightColor(16733184)
      end
      padColorReset = false
    end
    if lowHealthSFXCall == false and not game.Cinematics.IsInCinematicMode() then
      game.Audio.PlaySound("SND_UX_Health_Kratos_Low_Health_LP")
      game.Audio.PlaySound("SND_UX_Health_Kratos_Low_Health_STNG")
      game.Audio.PlayBanterNonCritical("cbt_son_KratosCriticallyWeak")
      lowHealthSFXCall = true
    end
  end
  if playerCreature.ReticleTargetCreature ~= nil then
    if playerCreature.ReticleTargetCreature == reticleTargetCreaturePrevious and playerCreature:HasMarker("Aiming") then
      reticleTargetCreatureChangeTimer = reticleTargetCreatureChangeTimer + playerCreature:GetUnitTime()
    else
      reticleTargetCreatureChangeTimer = 0
    end
    reticleTargetCreaturePrevious = playerCreature.ReticleTargetCreature
  else
    reticleTargetCreatureChangeTimer = 0
  end
  if bboard then
    if playerCreature.ReticleTargetCreature then
      bboard:Set("ReticleTargetCreature", playerCreature.ReticleTargetCreature)
    else
      bboard:Set("ReticleTargetCreature", playerCreature)
    end
    if reticleTargetCreatureChangeTimer > reticleTargetCreatureTimeThresholdFast then
      bboard:Set("ReticleTargetCreatureTimeThresholdFast", true)
    else
      bboard:Set("ReticleTargetCreatureTimeThresholdFast", false)
    end
    if reticleTargetCreatureChangeTimer > reticleTargetCreatureTimeThreshold then
      bboard:Set("ReticleTargetCreatureTimeThreshold", true)
    else
      bboard:Set("ReticleTargetCreatureTimeThreshold", false)
    end
  end
  local inCombat = game.Combat.GetCombatStatus()
  local inPuppeteer = playerCreature:IsUnderPOIControl()
  son = game.AI.FindSon()
  local sonInWaitGate = false
  local updatedSpeedControlThisFrame
  if son ~= nil then
    sonbb = game.AI.FindSon():GetBlackboard()
    sonInWaitGate = sonbb ~= nil and sonbb:Exists("inWaitGate") and sonbb:IsBoolean("inWaitGate") and sonbb:GetBoolean("inWaitGate") == true
  end
  if activeSpeedControlSource then
    if inCombat == true or inPuppeteer or #speedControlZones == 0 and sonInWaitGate then
      SpeedControl_ClearControl()
    end
  elseif (0 < #speedControlZones or 0 < #speedControlSplines) and inCombat == false and not inPuppeteer and (#speedControlZones ~= 0 or not sonInWaitGate) then
    SpeedControl_UpdateActiveSource()
    updatedSpeedControlThisFrame = true
  end
  if activeSpeedControlSource and not updatedSpeedControlThisFrame then
    SpeedControl_UpdateActiveSource()
  end
  if VFS.HideSpeedControlInfo.value == false then
    Debug_PrintSpeedControlZonesAndSplines(sonInWaitGate)
  end
  if game.IsPhotoModeActive ~= nil and not game.IsPhotoModeActive() then
    if inCombat == false then
      local kratosMaxSpeedOverride = playerCreature:GetMaxSpeedOverride()
      if kratosMaxSpeedOverride ~= nil and 0 < kratosMaxSpeedOverride and kratosMaxSpeedOverride <= 4 or playerCreature.Pad:IsGameButtonDisabled(tweaks.ePad.kPadL3) or 0 < #speedControlSplines then
        if not playerCreature:PickupIsAcquired("ForceRageModeDisabledLTW") then
          playerCreature:PickupAcquire("ForceRageModeDisabledLTW")
        end
      elseif playerCreature:PickupIsAcquired("ForceRageModeDisabledLTW") then
        playerCreature:PickupRelinquish("ForceRageModeDisabledLTW")
      end
    elseif playerCreature:PickupIsAcquired("ForceRageModeDisabledLTW") then
      playerCreature:PickupRelinquish("ForceRageModeDisabledLTW")
    end
  end
  components.UpdateComponents(playerCreature, scriptComponents)
  if VFS.ShowWorldOffscreenIndicator.value then
    OffScreenRingUpate(C)
  end
  if not weaponsLoaded then
    PlayBladeAudioOnLoad()
  end
  if game.Cinematics.IsInCinematicMode() then
    LuaHook_ForceClearStatusEffects()
  end
end
local RemovePlayerPickupIfAcquired = function(pickupName)
  if playerCreature:PickupIsAcquired(pickupName) then
    if game.Pickup.NGP_RelinquishPickupAndClearProfile then
      game.Pickup.NGP_RelinquishPickupAndClearProfile(pickupName)
    else
      playerCreature:PickupRelinquish(pickupName)
    end
  end
end
local ResetResourceForNGP = function(resourceName)
  if game.Wallets.NGP_ResetResource then
    game.Wallets.NGP_ResetResource("HERO", resourceName)
  else
    local value = game.Wallets.GetResourceValue("HERO", resourceName)
    if 1 <= value then
      game.Wallets.RemoveResource("HERO", resourceName, value)
    end
  end
end
function OnNGPDataLoaded(creature)
  game.Wallets.GenerateRune("SINDRI00", "RuneCreator_Unique_NGP_CrashOldVersions")
  RemovePlayerPickupIfAcquired("MimirHead")
  ResetResourceForNGP("BifrostUnlock")
  RemovePlayerPickupIfAcquired("Bifrost")
  ResetResourceForNGP("ChiselUnlock")
  RemovePlayerPickupIfAcquired("Chisel")
  ResetResourceForNGP("FastTravelUnlock01")
  ResetResourceForNGP("FastTravelUnlock02")
  RemovePlayerPickupIfAcquired("FastTravelStone")
  local excludeFlags = {
    "Economy",
    "Experience",
    "PrimaryWeapon",
    "SecondaryWeapon",
    "SkillTree",
    "AxeFlame",
    "BladeFlame",
    "MaxHealthUpgrade",
    "MaxRageUpgrade",
    "ArmorChest",
    "ArmorWrist",
    "ArmorLegs",
    "ArmorShield",
    "SonArmor",
    "Upgrade",
    "SonSpecial",
    "Axe",
    "Blades",
    "ArmorTrinket",
    "WeaponComponent",
    "WeaponComponent_Blades",
    "GenerateRune",
    "RollCondition",
    "WeaponSpecial_Light",
    "WeaponSpecial_Heavy",
    "WeaponSpecial_Blades_Light",
    "WeaponSpecial_Blades_Heavy",
    "Beastiary",
    "Lore_Category_Tutorial",
    "ResurrectionStone",
    "NGPForceCopy"
  }
  local extraResources = game.Wallets.GetAllResources("HERO", excludeFlags)
  for _, resourceName in pairs(extraResources) do
    ResetResourceForNGP(resourceName)
  end
  game.Wallets.AddResource("HERO", "ResurrectionStoneTutorial", 1)
  game.Wallets.AddResource("HERO", "ResStoneSecondTutorial", 1)
  game.Wallets.AddResource("HERO", "ArmorUpgradeTutorial", 1)
  game.Wallets.AddResource("HERO", "LostItemTutorial", 1)
  game.Wallets.AddResource("HERO", "AxePommelTutorial", 1)
  game.Wallets.AddResource("HERO", "TalismanTutorial", 1)
  game.Wallets.AddResource("HERO", "EnchantmentTutorial", 1)
  game.Wallets.AddResource("HERO", "MapTutorial", 1)
  game.Wallets.AddResource("HERO", "CompassRadiusTutorial", 1)
  game.Level.SetVariable("TUT_ShownTalismanTutorial", true)
  game.Level.SetVariable("TUT_ShownSonSpecialTutorial", true)
  game.Level.SetVariable("TUT_ShownWeaponSpecialTutorial", true)
  game.Level.SetVariable("TUT_ShownWeaponComponentTutorial", true)
  game.UI.ClearNotificationsOfType("Map")
  game.Wallets.AddResource("HERO", "TierMarker", 6)
  if game.Wallets.NGP_GrantAllRecipesWithFlags ~= nil and game.Wallets.GetResourceValue("HERO", "NGPFlag") <= 0 then
    game.Wallets.NGP_GrantAllRecipesWithFlags("HERO", {
      "Sell",
      "NGPGrantImmediate"
    })
    LD.AddRecipe_Safe("HERO", "Recipe_KvasirEnchantment_Tier09")
    LD.AddRecipe_Safe("HERO", "Recipe_ParryEnchantment_Tier09")
  end
  local runeFlags = {
    "RuneCreator_Unique_Midgard",
    "RuneCreator_Unique_Jotunnheim",
    "Runestone_Tag_InfinityPower",
    "Relic6",
    "RuneCreator_Unique_Alfheim",
    "Runestone_Tag_InfinityReality",
    "Runestone_Tag_InfinitySoul",
    "Runestone_Tag_InfinitySpace",
    "RuneCreator_Unique_Vanaheim",
    "RuneCreator_Unique_Valkyrie01",
    "RuneCreator_Unique_Valkyrie02",
    "RuneCreator_Unique_Valkyrie03",
    "RuneCreator_Unique_Valkyrie04",
    "Runestone_Tag_Dragon01",
    "Runestone_Tag_Dragon02",
    "RuneCreator_Unique_Corruption",
    "RuneCreator_Unique_FireResist_Focus",
    "RuneCreator_Unique_FireResist_Defense",
    "RuneCreator_Unique_FireResist_Strength",
    "RuneCreator_Unique_FrostResist_Focus",
    "RuneCreator_Unique_FrostResist_Defense",
    "RuneCreator_Unique_SeidrResist_Runic",
    "RuneCreator_Unique_SeidrResist_Resistance",
    "RuneCreator_Unique_SeidrResist_Defense",
    "RuneCreator_Unique_AxeToss03",
    "RuneCreator_Unique_JotunnBoss",
    "RuneCreator_Unique_AlfheimBoss",
    "RuneCreator_Unique_T2Starter"
  }
  local runeList = game.Wallets.GetRunesWithFlags("HERO", runeFlags)
  for _, runeID in pairs(runeList) do
    game.Wallets.NGP_ForceSetSellRecipe("HERO", runeID, "Recipe_BreakDownEpicRune")
  end
  game.Wallets.AddResource("HERO", "NGPFlag", 1)
  game.Wallets.AddResource("HERO", "NGPFlag2", 1)
  LD.AddRecipe_Safe("HERO", "Recipe_OblivionStone_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_UnstableOre_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_LeiptrAlloy_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_GlacialCatalyst_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_UnyieldingCinders_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_ChaosFlame_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_FrozenFlame_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_XP_Small_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_XP_Large_Sellback")
  LD.AddRecipe_Safe("HERO", "Recipe_SonArmorBonus04")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorChest_Bonus01")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorWrist_Bonus01")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorLegs_Bonus01")
  creature:MeterSetValue("Health", creature:MeterGetMax("Health"))
end
function LuaHook_RageModePerkActivation()
  local HealthMeterCurrent = playerCreature.MeterGetValue(playerCreature, "Health")
  local RageMeterCurrent = playerCreature.MeterGetValue(playerCreature, "Blood")
  local newValue = HealthMeterCurrent * 0.25
  playerCreature:MeterSetValue("Health", HealthMeterCurrent - newValue)
  local newRageValue = RageMeterCurrent + 25
  if playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
function LuaHook_DropThrowable()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local throwObj = weaponInfo.Weapon
    if throwObj ~= nil and (throwObj:GetName() == "throwablevibrate" or throwObj:HasMarker("CombatThrowable")) then
      throwObj:CallScript("LuaHookDrop")
      game.Interact.EnableTags("ThrowableCrystal")
    end
  end
end
function LuaHook_ThrowAttached()
  game.Interact.EnableTags("ThrowableCrystal")
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local throwObj = weaponInfo.Weapon
    if throwObj ~= nil and (throwObj:GetName() == "throwablevibrate" or throwObj:HasMarker("CombatThrowable")) then
      throwObj:CallScript("LuaHookOnThrowRelease")
    end
  end
end
function LuaHook_AxeFrostOn()
  if AxeFrostState ~= "Level01" then
    for weaponInfo in playerCreature:IterateActiveWeapons() do
      local gameobj = weaponInfo.Weapon
      if gameobj ~= nil and gameobj:GetName() == "axe00" then
        if AxeFrostState == "Off" then
          gameobj:StartAnim("Axe02_Ice01")
          AxeFrostState = "Level01"
        elseif AxeFrostState == "Level02" then
          gameobj:StartAnim("Axe02_Ice01_Level2_OFF")
          gameobj:StartAnim("Axe02_Ice01")
          AxeFrostState = "Level02"
        end
      end
    end
  end
end
function LuaHook_DrainBladesOn()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj:GetName() == "explosive00" then
      print("Not yet!")
    end
  end
end
function LuaHook_DrainBladesOff()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj:GetName() == "explosive00" then
      print("Not yet!")
    end
  end
end
function LuaHook_FrostChargeOff()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj ~= nil and gameobj:GetName() == "axe00" then
      gameobj:StartMaterialAnim("Axe02_Ice01_Level2FULL_OFF")
      AxeFrostState = "Off"
    end
  end
end
function LuaHook_AxeFrostOnSlow()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj ~= nil and gameobj:GetName() == "axe00" then
      gameobj:StartMaterialAnim("Axe_Ice_ONOFF")
      AxeFrostState = "Level01"
    end
  end
end
function LuaHook_AxeFrostReset()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj ~= nil and gameobj:GetName() == "axe00" then
      gameobj:StartMaterialAnim("Axe_Ice_ONOFF")
      AxeFrostState = "Level01"
    end
  end
end
function LuaHook_BladeLightUp()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj ~= nil and gameobj:GetName() == "explosive00" then
      gameobj:StartMaterialAnim("blade_ONOFF")
    end
  end
end
function Update_PositionDistanceDebugTable()
  if VFS.PositionDistanceDebug.value == true then
    local positionDistanceDebugTable = {}
    if engine.IsDebug() then
      debugPosResult = DL.PositionDistanceDebug(playerCreature, debugPosStart, debugPosEnd, debugPosSwitch)
      debugPosStart = debugPosResult.debugPosStart
      debugPosEnd = debugPosResult.debugPosEnd
      debugPosDistanceXZ = debugPosResult.debugPosDistanceXZ
      debugPosDistanceY = debugPosResult.debugPosDistanceY
      debugPosSwitch = debugPosResult.debugPosSwitch
      if debugPosStart ~= nil then
        table.insert(positionDistanceDebugTable, {"Start: ", debugPosStart})
      end
      if debugPosEnd ~= nil then
        table.insert(positionDistanceDebugTable, {"End: ", debugPosEnd})
      end
      if debugPosDistanceXZ ~= nil then
        table.insert(positionDistanceDebugTable, {
          "Result - XZ: ",
          debugPosDistanceXZ
        })
      end
      if debugPosDistanceY ~= nil then
        table.insert(positionDistanceDebugTable, {
          "Result - Y: ",
          debugPosDistanceY
        })
      end
      if 0 < #positionDistanceDebugTable then
        positionDistanceDebugTable.TitleColor = engine.Vector.New(0, 100, 0)
        positionDistanceDebugTable.TitleAlpha = 225
        positionDistanceDebugTable.Title = "Position Distance Debug table"
        positionDistanceDebugTable.X, positionDistanceDebugTable.Y = 150, 18
        engine.DrawDebugTable(positionDistanceDebugTable)
      end
    end
  end
end
function LuaHookScript_SpecialReticleOn()
  uiCalls.UI_Event_Minigame_Start()
end
function LuaHookScript_SpecialReticleOff()
  uiCalls.UI_Event_Minigame_End()
end
function LuaHook_ValkyrieBanter()
  local player = game.Player.FindPlayer()
  local level = player.GroundLevel
  local valkyrieBanter = level:FindSingleGameObject("ValkyrieBanterController")
  if valkyrieBanter ~= nil then
    valkyrieBanter.Child:CallScript("ValkyriePostFightBanterCheck")
  end
end
function LuaHook_ValkyrieReminderCheck()
  local player = game.Player.FindPlayer()
  local level = player.GroundLevel
  local valkyrieBanter = level:FindSingleGameObject("ValkyrieBanterController")
  if valkyrieBanter ~= nil then
    valkyrieBanter.Child:CallScript("ValkyrieReminderCheck")
  end
end
function LuaHook_ValkyrieClearReminderTimer()
  local player = game.Player.FindPlayer()
  local level = player.GroundLevel
  local valkyrieBanter = level:FindSingleGameObject("ValkyrieBanterController")
  if valkyrieBanter ~= nil then
    valkyrieBanter.Child:CallScript("ClearReminderTimer")
  end
end
function LuaHook_ValkyrieHelmLootBanter()
  local player = game.Player.FindPlayer()
  local level = player.GroundLevel
  local valkyrieBanter = level:FindSingleGameObject("ValkyrieBanterController")
  if valkyrieBanter ~= nil then
    valkyrieBanter.Child:CallScript("ValkyriePostLootBanterCheck")
  end
end
function LuaHook_FrostMeterState()
end
function LuaHook_UI_PouchOn()
  local uiKratos = game.UI.FindCreatureByGOName("goHeroA00")
  if uiKratos then
    uiKratos:ShowJoint(uiKratos:GetJointIndex("ashPouch1"))
  end
end
function LuaHook_UI_PouchOff()
  local uiKratos = game.UI.FindCreatureByGOName("goHeroA00")
  if uiKratos then
    uiKratos:HideJoint(uiKratos:GetJointIndex("ashPouch1"))
  end
end
function LuaHook_UI_ShieldOn()
  local uiKratos = game.UI.FindCreatureByGOName("goHeroA00")
  if uiKratos then
    uiKratos:ShowJoint(uiKratos:GetJointIndex("JOshieldHolster1_LeftWrist1AutoTwist2_0"))
  end
end
function LuaHook_UI_ShieldOff()
  local uiKratos = game.UI.FindCreatureByGOName("goHeroA00")
  if uiKratos then
    uiKratos:HideJoint(uiKratos:GetJointIndex("JOshieldHolster1_LeftWrist1AutoTwist2_0"))
  end
end
function LuaHook_TurnRageModeOn()
  uiCalls.UI_Event_Turn_Rage_Meter_On()
end
function LuaHook_TurnRageModeOff()
  uiCalls.UI_Event_Turn_Rage_Meter_Off()
end
function LuaHook_RageModeEnter()
  game.Interact.DisableTags("NotInRageMode")
  uiCalls.UI_Event_Rage_Start()
end
function LuaHook_RageBool()
  inRageMode = true
end
function LuaHook_RageModeExit()
  uiCalls.UI_Event_Rage_End()
  game.Interact.EnableTags("NotInRageMode")
  inRageMode = false
end
function LuaHook_ForceCineRageModeExit()
  if playerCreature:PickupGetStage("RageMode") ~= 0 and playerCreature.ClearMarkedWeapon ~= nil then
    playerCreature:ClearMarkedWeapon()
  end
  playerCreature:PickupSetStage("RageMode", 0)
  uiCalls.UI_Event_Rage_End()
  game.Interact.EnableTags("NotInRageMode")
  inRageMode = false
  LuaHook_ForceClearStatusEffects()
end
function LuaHook_ForceClearStatusEffects()
  if playerCreature:PickupIsAcquired("Debuff_Hero_Frost") then
    playerCreature:PickupRelinquish("Debuff_Hero_Frost")
  end
  if playerCreature:PickupIsAcquired("Debuff_Hero_Freeze") then
    playerCreature:PickupRelinquish("Debuff_Hero_Freeze")
  end
  if playerCreature:PickupIsAcquired("Debuff_Hero_Burn") then
    playerCreature:PickupRelinquish("Debuff_Hero_Burn")
  end
  if playerCreature:PickupIsAcquired("Debuff_Hero_Poison_Short") then
    playerCreature:PickupRelinquish("Debuff_Hero_Poison_Short")
  end
  if playerCreature:PickupIsAcquired("Debuff_Hero_Blind") then
    playerCreature:PickupRelinquish("Debuff_Hero_Blind")
  end
  if playerCreature:PickupIsAcquired("Debuff_Hero_Daze") then
    playerCreature:PickupRelinquish("Debuff_Hero_Daze")
  end
  playerCreature:MeterSetValue("Frost", 0)
  playerCreature:MeterSetValue("Burn", 0)
  playerCreature:MeterSetValue("Poison", 0)
  playerCreature:MeterSetValue("Blind", 0)
  playerCreature:MeterSetValue("Daze", 0)
end
function LuaHook_RageGrabActivated()
  uiCalls.UI_Event_Rage_Grab()
end
function LuaHook_AlfheimRageMomentEnter()
  playerCreature:PickupAcquire("ForceRageModeHelper", 0)
  playerCreature:PickupAcquire("RageMode", 1)
  playerCreature:PickupActivate("RageMode")
  LuaHook_RageModeEnter()
  if playerCreature.SetWeaponMode ~= nil then
    playerCreature:SetWeaponMode("Bare", true)
  end
end
function LuaHook_AlfheimRageMomentExit()
  playerCreature:PickupAcquire("ForceRageModeHelper", 1)
  playerCreature:MeterSetValue("Blood", 0)
  LuaHook_RageModeExit()
  playerCreature:PickupSetStage("RageMode", 0)
end
function LuaHook_CSDarkOneEliteHang_Idle_ReplaySound()
  LD.ReplaySound(playerCreature:FindSingleSoundEmitterByName("SNDKratos"), "SND_CS_Kill_CSDarkOneEliteHang_Idle")
end
function LuaHook_CSDarkOneEliteHang_Idle_StopSound()
  StopSoundOnKratos(nil, "SND_CS_Kill_CSDarkOneEliteHang_Idle")
end
function LuaHook_BaldurRageEnter()
  playerCreature:MeterSetValue("Blood", 100)
  playerCreature:PickupAcquire("ForceRageModeHelper", 0)
  playerCreature:PickupAcquire("RageMode", 1)
  playerCreature:PickupActivate("RageMode")
  LuaHook_RageModeEnter()
end
function LuaHook_StoneMason_MMAChoke_RageEnter()
  playerCreature:PickupAcquire("RageMode", 1)
  playerCreature:PickupActivate("RageMode")
  LuaHook_RageModeEnter()
end
function LuaHook_StoneMason_Checkpoint_RageEnter()
  if playerCreature:MeterGetValue("Blood") < 125 then
    playerCreature:MeterSetValue("Blood", 125)
  end
  playerCreature:PickupAcquire("RageMode", 1)
  playerCreature:PickupActivate("RageMode")
  LuaHook_RageModeEnter()
  if playerCreature.SetWeaponMode ~= nil then
    playerCreature:SetWeaponMode("Bare", true)
  end
end
function LuaHook_BaldurRageExit()
  if playerCreature:PickupIsAcquired("ForceRageModeHelper") then
    playerCreature:PickupRelinquish("ForceRageModeHelper")
  end
end
function LuaHook_BaldurRageForceExit()
  if playerCreature:PickupIsAcquired("ForceRageModeHelper") then
    playerCreature:PickupRelinquish("ForceRageModeHelper")
  end
  playerCreature:MeterSetValue("Blood", 0)
end
function LuaHook_PlayShieldAnim_SM_BaldurSlingshot()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("phase1_csBaldurBladeSlingshotEnter")
    end
  end
end
function LuaHook_PlayShieldAnim_SM_BaldurElementTransition()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("csBaldurFirstElementalBurstFull")
    end
  end
end
function LuaHook_PlayShieldAnim_SM_ArenaDrop()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("phase0_csTransitionToPhase1")
    end
  end
end
function LuaHook_PlayShieldAnim_SM_BackToBackIdle()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("phase1_BackToBackIdle")
    end
  end
end
function LuaHook_PlayShieldAnim_SM_Ph1_BaldurEntrance()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("phase1_csBaldurEntrance")
    end
  end
end
function LuaHook_PlayShieldAnim_SM_ChiselSlam()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("phase2_csReadyChiselSlamExit")
    end
  end
end
function LuaHook_PlayShieldAnim_SM_MMAChokeRageBurst()
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local shieldObj = weaponInfo.Weapon
    if shieldObj ~= nil and shieldObj:GetName() == "kratosshield00" then
      shieldObj:StartAnim("csChokeMMA_SonDanger_KratosRageBurst")
    end
  end
end
function LuaHook_SummonFreyaVineTrap()
  local currentLevel = game.FindLevel("Stn980_BossShoulder")
  local targetPosition = playerCreature:GetWorldPosition()
  local targetForward = playerCreature:GetWorldForward()
  local targetLeft = playerCreature:GetWorldLeft()
  local navMeshPoint = game.NavMesh.ClosestPoint(targetPosition)
  local distanceFrontOfTarget = 0
  local distanceLeftOfTarget = 0
  local velocityMultiplier = 2.5
  local baldur = LD.GetSingleAIByMarker("baldur00")
  local baldurPosition = baldur:GetWorldPosition()
  local baldurForward = baldur:GetWorldForward()
  local baldurNavMeshPoint = game.NavMesh.ClosestPoint(baldurPosition)
  local distanceBetween = LD.GetXZDistanceBetweenTwoPoints(navMeshPoint, baldurNavMeshPoint)
  if playerCreature:IsInAir() == false and 3 < distanceBetween and DL.CheckCreatureContext(playerCreature:GetContext(), "FREYA_VINE_GRAB") == false then
    local kratosVine = game.AI.Spawn(currentLevel, navMeshPoint, targetForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
    kratosVine:AddMarker("SnareKratos")
  end
  if baldur:IsInAir() == false and DL.CheckCreatureContext(baldur:GetContext(), "FREYA_VINE_GRAB") == false then
    local baldurVine = game.AI.Spawn(currentLevel, baldurNavMeshPoint, baldurForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
    baldurVine:AddMarker("SnareBaldur")
  end
end
local Minigame_Failed_Count = 0
function LuaHook_Minigame_ResetFailedCount()
  Minigame_Failed_Count = 0
  if playerCreature:PickupIsAcquired("TRC_Disable_Rumble") then
    playerCreature:PickupRelinquish("TRC_Disable_Rumble")
  end
end
function LuaHook_Minigame_IncrementFailedCount()
  if 4 <= Minigame_Failed_Count then
    if playerCreature:PickupIsAcquired("TRC_Disable_Rumble") then
      playerCreature:PickupRelinquish("TRC_Disable_Rumble")
    end
    playerCreature:PickupAcquire("TRC_Disable_Rumble")
  else
    Minigame_Failed_Count = Minigame_Failed_Count + 1
  end
end
function LuaHook_HideMimirEye()
  mimirEyeVisible = true
  local mimir = playerCreature.MimirHead
  local eye = mimir:FindSingleGOByName("mimir00_eyeLeft")
  eye:HideJoint(0)
  eye:Hide()
  engine.Print("MimirHead: ", mimir, "LeftEye: ", eye, "Hiding Mimir's Eye Joint Number: ", mimir:GetJointIndex("JOLeftEye1"))
end
function LuaHook_ShowMimirEye()
  mimirEyeVisible = true
  local mimir = playerCreature.MimirHead
  local eye = mimir:FindSingleGOByName("mimir00_eyeLeft")
  eye:ShowJoint(0)
  eye:Show()
  engine.Print("MimirHead: ", mimir, "LeftEye: ", eye, "Showing Mimir's Eye Joint Number: ", mimir:GetJointIndex("JOLeftEye1"))
end
function LuaHook_BiFrostLightOn()
  if playerCreature.Pad ~= nil then
    playerCreature.Pad:SetLightColor(16777215)
  end
end
function LuaHook_BiFrostLightOff()
  if playerCreature.Pad ~= nil then
    playerCreature.Pad:ResetLightColor()
  end
end
function LuaHook_ShowTrollLoot()
  game.FindLevel("For800_TrollArena"):CallScript("ShowTrollLoot")
end
function LuaHook_ShowGuardianLoot()
  game.FindLevel("Hel600_GuardianArena"):CallScript("ShowGuardianLoot")
end
function LuaHook_HipSelection(C)
  if playerCreature.Pad ~= nil then
    local ButtonL3Down = playerCreature.Pad
    GrabHipSelection(C)
    if ButtonL3Down == true and HipSelectionValue.Value == 0 then
      HipSelectionValue.Value = 1
    elseif ButtonL3Down == true and HipSelectionValue.Value == 1 then
      HipSelectionValue.Value = 0
    end
  end
  print("The HipSelectionValue is", HipSelectionValue.Value)
end
function LuaHook_BlackBreath_DomeFX_On(ai)
  local foot500 = game.FindLevel("Foot500_Top")
  local blackBreathManager = foot500:FindSingleGameObject("BlackBreath_Manager")
  blackBreathManager:CallScript("LuaHook_BlackBreath_DomeFX_On")
end
function LuaHook_BlackBreath_DomeFX_Off(ai)
  local foot500 = game.FindLevel("Foot500_Top")
  local blackBreathManager = foot500:FindSingleGameObject("BlackBreath_Manager")
  blackBreathManager:CallScript("LuaHook_BlackBreath_DomeFX_Off")
end
function LuaHook_BlackBreath_DispelFX_On(ai)
  local foot500 = game.FindLevel("Foot500_Top")
  local blackBreathManager = foot500:FindSingleGameObject("BlackBreath_Manager")
  blackBreathManager:CallScript("LuaHook_BlackBreath_DispelFX_On")
end
function LuaHook_BlackBreath_BlastFX_Start(ai)
  local foot500 = game.FindLevel("Foot500_Top")
  local blackBreathManager = foot500:FindSingleGameObject("BlackBreath_Manager")
  blackBreathManager:CallScript("LuaHook_BlackBreath_BlastFX_Start")
end
function LuaHook_BlackBreath_BlastFX_Trigger(ai)
  local foot500 = game.FindLevel("Foot500_Top")
  local blackBreathManager = foot500:FindSingleGameObject("BlackBreath_Manager")
  blackBreathManager:CallScript("LuaHook_BlackBreath_BlastFX_Trigger")
end
function LuaHook_Peak550_InMouthDamage_HealthTickDown_Light(ai, data)
  local dragonActor
  for creature in game.Creature.IterateAllCreatures() do
    if creature:GetName() == "earthdragon00" then
      dragonActor = creature
      break
    end
  end
  if dragonActor ~= nil then
    dragonActor:CallScript("LuaHook_InMouthDamage_HealthTickDown_Light")
  end
end
function LuaHook_Peak550_InMouthDamage_HealthTickDown_Heavy(ai, data)
  local dragonActor
  for creature in game.Creature.IterateAllCreatures() do
    if creature:GetName() == "earthdragon00" then
      dragonActor = creature
      break
    end
  end
  if dragonActor ~= nil then
    dragonActor:CallScript("LuaHook_InMouthDamage_HealthTickDown_Heavy")
  end
end
function LuaHook_Peak550_DragonMouthHitLight(ai, data)
  local dragonActor
  for creature in game.Creature.IterateAllCreatures() do
    if creature:GetName() == "earthdragon00" then
      dragonActor = creature
      break
    end
  end
  dragonActor:TriggerMoveEvent("LE_Stg2_csDragonMouthHitLight")
end
function LuaHook_Peak550_DragonMouthHitHeavy(ai, data)
  local dragonActor
  for creature in game.Creature.IterateAllCreatures() do
    if creature:GetName() == "earthdragon00" then
      dragonActor = creature
      break
    end
  end
  dragonActor:TriggerMoveEvent("LE_Stg2_csDragonMouthHitHeavy")
end
function LuaHook_Peak550_SwapGiantCrystalToFinale(ai, data)
  local level = game.FindLevel("Peak550_DragonArena")
  level:CallScript("LuaHook_SwapGiantCrystalToFinale")
end
function LuaHook_Peak550_TriggerFinaleFX(ai, data)
  local level = game.FindLevel("Peak550_DragonArena")
  level:CallScript("LuaHook_TriggerFinaleFX")
end
function LuaHook_Peak550_FinaleWin(ai, data)
  local level = game.FindLevel("Peak550_DragonArena")
  level:CallScript("LuaHook_FinaleWin")
end
function LuaHook_Peak550_ForceAllHudOn(ai, data)
  local level = game.FindLevel("Peak550_DragonArena")
  level:CallScript("LuaHook_ForceAllHudOn")
end
function LuaHook_Peak540_Trigger_DragonBlow_VacuumFX(ai, data)
  local level = game.FindLevel("Peak540_PreDragonArena")
  level:CallScript("LuaHook_Trigger_DragonBlow_VacuumFX")
end
function LuaHook_Peak380_PushOffElevatorStart(ai, data)
  local level = game.FindLevel("Peak380_BigElevator")
  level:CallScript("LuaHook_PushOffElevatorStart")
end
function LuaHook_Peak380_SmashFaceWin(ai, data)
  local level = game.FindLevel("Peak380_BigElevator")
  level:CallScript("LuaHook_SmashFaceWin")
end
function LuaHook_Peak510_Trigger_PlatformEndBreak(ai, data)
  local level = game.FindLevel("Peak510_DragonTunnelLH")
  level:CallScript("LuaHook_Trigger_PlatformEndBreak")
end
function LuaHook_Peak510_SwapToStaticElevator(ai, data)
  local level = game.FindLevel("Peak510_DragonTunnelLH")
  level:CallScript("LuaHook_SwapToStaticElevator")
end
function LuaHook_Peak380_HideDragonElevator00(ai, data)
  local level = game.FindLevel("Peak380_BigElevator")
  level:CallScript("LuaHook_HideDragonElevator00")
end
function LuaHook_Peak510_EnableHUD(ai, data)
  local level = game.FindLevel("Peak510_DragonTunnelLH")
  level:CallScript("LuaHook_EnableHUD")
end
function LuaHook_Peak380_SwapPlatformVis_DragonIntro(ai, data)
  local level = game.FindLevel("Peak380_BigElevator")
  level:CallScript("LuaHook_SwapPlatformVis_DragonIntro")
end
function LuaHook_Stn400_BuckleStrapHitSwing(ai, data)
  local level = game.FindLevel("Stn400_HammerBase")
  level:CallScript("LuaHook_BuckleStrapHitSwing")
end
function LuaHook_Peak200_RockLiftStart(ai, data)
  local level = game.FindLevel("Peak080_Global")
  local crankScript = level:GetGameObject("CrankSetupManager")
  crankScript:CallScript("LuaHook_RockLiftStart")
end
function LuaHook_Peak200_RockLiftUp(ai, data)
  local level = game.FindLevel("Peak080_Global")
  local crankScript = level:GetGameObject("CrankSetupManager")
  crankScript:CallScript("LuaHook_RockLiftUp")
end
function LuaHook_Peak200_RockLiftWin(ai, data)
  local level = game.FindLevel("Peak080_Global")
  local crankScript = level:GetGameObject("CrankSetupManager")
  crankScript:CallScript("LuaHook_RockLiftWin")
end
function LuaHook_Peak200_RockLiftStruggle(ai, data)
  local level = game.FindLevel("Peak080_Global")
  local crankScript = level:GetGameObject("CrankSetupManager")
  crankScript:CallScript("LuaHook_RockLiftStruggle")
end
function LuaHook_Peak200_RockLiftFail(ai, data)
  local level = game.FindLevel("Peak080_Global")
  local crankScript = level:GetGameObject("CrankSetupManager")
  crankScript:CallScript("LuaHook_RockLiftFail")
end
function LuaHook_Peak200_RockLiftFail2(ai, data)
  local level = game.FindLevel("Peak080_Global")
  local crankScript = level:GetGameObject("CrankSetupManager")
  crankScript:CallScript("LuaHook_RockLiftFail2")
end
function LuaHook_SetStateHouseIn(ai, data)
  local level = game.FindLevel("For050_Sound")
  level:CallScript("LuaHook_SetStateHouseIn")
end
function LuaHook_SetStateHouseOut(ai, data)
  local level = game.FindLevel("For050_Sound")
  level:CallScript("LuaHook_SetStateHouseOut")
end
function LuaHook_SnowblindEnter(ai, data)
  PlaySoundOnKratos(nil, "SND_AMB_BED_Magni_Modi_Fight_Fog_LP")
end
function LuaHook_SnowblindExit(ai, data)
  StopSoundOnKratos(nil, "SND_AMB_BED_Magni_Modi_Fight_Fog_LP")
end
local SprintCount = 0
function LuaHook_SprintCounter(C)
  if SprintCount < 5 then
    SprintCount = SprintCount + 1
    print("Sprintcount =", SprintCount)
  elseif SprintCount == 5 then
    C:TriggerMoveEvent("kSprintCountReached")
    SprintCount = 0
  end
end
function LuaHook_SprintCounterReset(C)
  SprintCount = 0
end
function LuaHook_RequestTagTeam()
  _G.global.tagTeamPossible = false
  engine.SendHook("OnRequestTagTeamHook", game.AI.FindSon())
end
function LuaHook_SetQuestGiverMarker(crt, setMark)
  if setMark then
    crt:AddMarker("QuestGiverInteract")
  else
    crt:RemoveMarker("QuestGiverInteract")
  end
end
function OnResponseTagTeamHook(go, result)
  _G.global.tagTeamPossible = result
end
function LuaHook_GetLoot()
  if game.AI.FindSon() ~= nil then
    engine.SendHook("OnGetRuneAmmo", game.AI.FindSon())
  end
end
function OnFollowUpPromptCreate()
  mpicon.Create("WORLD_INTERACT")
end
function OnFollowUpPromptOff()
  mpicon.Off("WORLD_INTERACT")
end
function OnRecLootTableHook(go, result)
  _G.global.recLootTable = result
  if _G.global.inventory[result] == nil then
    _G.global.inventory[result] = 1
  else
    _G.global.inventory[result] = _G.global.inventory[result] + 1
  end
end
function OnSonRevive()
  playerCreature:TriggerMoveEvent("SonRevive")
end
function OnSonCoopJumpAttack()
  playerCreature:TriggerMoveEvent("SonCoop")
end
function LuaHookDecision_CanSonPerformSpecial()
  local sonAI = game.AI.FindSon()
  if sonAI == nil then
    return false
  end
  if sonAI.OwnedPOI ~= nil or sonAI:IsDoingSyncMove() or sonAI:HasMarker("TweakPOIResOnly") or sonAI:HasMarker("TweakLogicOnly") or sonAI:HasMarker("DisableCommandShot") or DL.CheckCreatureContext(sonAI:GetContext(), "SON_COOLDOWN") then
    return false
  end
  return true
end
function LuaHookDecision_CanShieldBash()
  local target = playerCreature:GetTargetCreature()
  if target ~= nil and (playerCreature.WorldPosition - target.WorldPosition):Length() <= 4 and target:PickupIsAcquired("Son_HoldMark") then
    return true
  end
  return false
end
function UnlockTier2Recipes()
  print("Giving Tier 2 recipes")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorWrist_TankSet_Tier02")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorLegs_TankSet_Tier02")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorChest_TankSet_Tier02")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorChest_DamageSet_Tier02")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorWrist_DamageSet_Tier02")
  LD.AddRecipe_Safe("HERO", "Recipe_KratosArmorLegs_DamageSet_Tier02")
end
local input = {}
input.SquareDown = false
input.UpDown = false
input.DownDown = false
input.R3Down = false
input.squareDownTime = 0
input.hookSent = false
input.startingInteract = false
local charging = false
local SendSwitchArrow = function(aison)
  engine.SendHook("OnCommandSonStart", game.AI.FindSon(), "SwitchArrow")
  if aison.RequestHighPriorityUpdate then
    aison:RequestHighPriorityUpdate()
  end
end
function SendInputDataToSon()
  local pad = playerCreature.Pad or fakePad
  local aison = game.AI.FindSon()
  local holdTimer = 0.3
  if aison ~= nil then
    local interactButtonPressInProgress = input.startingInteract
    local squareButtonStateChanged = pad.SquareDown ~= input.SquareDown
    if squareButtonStateChanged then
      if pad.SquareDown == true then
        if game.InteractZone.SonCanInteract and game.InteractZone.SonCanInteract() then
          input.SquareDown = true
          input.startingInteract = true
          interactButtonPressInProgress = true
          game.InteractZone.HandleSonInteractButtonPressed()
        elseif not aison:IsUnoccupied() and game.InteractZone.SonInteractButtonPressedOccupied then
          game.InteractZone.SonInteractButtonPressedOccupied()
        end
      elseif interactButtonPressInProgress then
        input.SquareDown = false
        input.startingInteract = false
      end
    end
    if not interactButtonPressInProgress then
      if pad.SquareDown == true then
        if input.SquareDown == false then
          input.SquareDown = true
          charging = true
          input.squareDownTime = 0
          engine.SendHook("OnCommandSonStart", aison, "Tap")
        end
        input.squareDownTime = input.squareDownTime + playerCreature:GetUnitTime()
        if charging == true and holdTimer <= input.squareDownTime then
          if playerCreature:PickupIsSlotUsed("SonSpecial") then
            local pickupname = playerCreature:PickupGetPickupNameInSlot("SonSpecial")
            if playerCreature:PickupIsAvailable(pickupname) then
              engine.SendHook("OnCommandSonStart", aison, "Charged")
            else
              engine.SendHook("OnCommandSonStart", aison, "Regular")
            end
          else
            engine.SendHook("OnCommandSonStart", aison, "Regular")
          end
          charging = false
          input.squareDownTime = 0
        end
      elseif input.SquareDown == true and charging == true then
        engine.SendHook("OnCommandSonStart", aison, "Regular")
        input.squareDownTime = 0
      end
    end
    if pad.UpDown and not game.UI.IsUpHandled() then
      if not game.UI.IsUpHandlerShowing() then
        game.UI.SetUpHandled()
        SendSwitchArrow(aison)
      end
    elseif input.UpDown and not pad.UpDown then
      if not game.UI.IsUpHandled() then
        game.UI.SetUpHandled()
        SendSwitchArrow(aison)
      end
      game.UI.ClearUpHandled()
    end
  end
  input.SquareDown = pad.SquareDown
  input.UpDown = pad.UpDown
  input.R3Down = pad.R3Down
  input.DownDown = pad.DownDown
end
function SetInfluenceToTheaterOfOperation(go)
  local son = game.AI.FindSon()
  if son == nil then
    return
  end
  local sonBB = son:GetBlackboard()
  if sonBB ~= nil then
    local activateInfluence = true
    if sonBB:Exists("IsInGoToTarget") and sonBB:GetBoolean("IsInGoToTarget") then
      activateInfluence = false
    end
    go:SetInfluenceConeIsEnabled(activateInfluence)
  end
end
function LuaHookDecision_IsLastEnemy(playerCreature)
  if #DL.FindLivingEnemies(playerCreature, 35) < 1 then
    return true
  end
  return false
end
function LuaHook_ForceSonFail(ai, data)
  engine.SendHook("OnCommandSonStart", game.AI.FindSon(), "Knife")
end
function LuaHook_FlyerSteal(playerCreature)
  local healthStoneCount = playerCreature:GetPlayerCounter("ShardHealth")
  local rageStoneCount = playerCreature:GetPlayerCounter("ShardRage")
  if 0 < healthStoneCount then
    playerCreature:SetPlayerCounter("ShardHealth", healthStoneCount - 1)
    uiCalls.UI_Event_SendDesignerMessage("Lost Health Stone -1", 1)
    playerCreature:SpawnProp("consumableHealthRune", playerCreature:GetWorldPosition() + engine.Vector.New(0, 0.3, -0.5))
  elseif 0 < rageStoneCount then
    playerCreature:SetPlayerCounter("ShardRage", rageStoneCount - 1)
    uiCalls.UI_Event_SendDesignerMessage("Lost Rage Stone -1", 1)
    playerCreature:SpawnProp("consumableRageRune", playerCreature:GetWorldPosition() + engine.Vector.New(0, 0.3, -0.5))
  else
    print("No Inventory")
  end
end
function LuaHook_TraverseLink_Vault1m(C)
  local traverseLink = C:GetTraverseLink()
  if translationDriver and rotationDriver and traverseLink then
    translationDriver.ValueVec = traverseLink.WarpLocation
    rotationDriver.ValueVec = traverseLink.WarpDirection
  end
end
function LuaHook_SetTrackingObjectOnSon(playerCreature)
  for attachmentInfo in playerCreature:IterateActiveWeapons() do
    print("tracking info is...", attachmentInfo.Weapon:GetName())
    if attachmentInfo.Weapon:GetName() == "throwablevibrate" then
      engine.SendHook("LuaHook_SetTrackingObject", game.AI.FindSon(), attachmentInfo.Weapon)
    end
  end
end
function LuaHook_ReflectProjectile(playerCreature)
  local arrowData = {}
  arrowData.Tweak = "ARR_DRAUGR_PROJECTILE_PARRY"
  arrowData.Creator = playerCreature
  arrowData.CreatorEmitJoint = "JOLeftWrist1"
  arrowData.EmitOffset = nil
  if playerCreature:GetLastAttacker() ~= nil then
    arrowData.Target = playerCreature:GetLastAttacker()
  else
    arrowData.TargetLocation = playerCreature:GetWorldPosition() + 10 * playerCreature:GetWorldFacing() + engine.Vector.New(0, 1.25, 0)
  end
  game.Combat.EmitArrow(arrowData)
end
global.beam_deflecting = false
function LuaHookScript_DeflectBeam(ai, data)
  print("Golem Deflect!")
  global.beam_deflecting = true
end
function LuaHookScript_DeflectBeam_Trigger(ai, data)
  if global.beam_deflecting then
    local attacker = ai:GetLastAttacker()
    attacker:TriggerMoveEvent("StunNow")
  end
end
function LuaHook_DeflectMissile(ai, data)
  print("deflecting missile")
  local target = ai:GetLastAttacker()
  local arrowData = {}
  arrowData.Tweak = "ARR_DEFLECTED_GOLEM_HEAT_MISSILE_V2"
  arrowData.Creator = ai
  arrowData.CreatorEmitJoint = "zeroJoint"
  arrowData.TargetLocation = ai:GetWorldPosition() + ai:GetWorldForward() * 35
  arrowData.Target = nil
  arrowData.EmitOffset = engine.Vector.New(0, 0.85, 0)
  game.Combat.EmitArrow(arrowData)
end
local followDist_min = 2
local followDist_stopRelease = 3.75
local followDist_sweetSpot = 4.5
local followDist_max = 12
local speedControl_inputLock = false
local speedControl_inputLock_sprint = false
local speedControl_inputLock_evade = false
local speedControl_inputLock_R1 = false
local speedControl_inputLock_R2 = false
local speedControl_inputLock_L1 = false
local speedControl_inputLock_L2 = false
speedControlZones = {}
speedControlSplines = {}
activeSpeedControlSource = nil
currentMaxSpeed = 10000
splineSpeedMinimized = false
function SpeedControl_AddZone(player, zoneObj, zoneSpeed)
  for _, zoneSet in ipairs(speedControlZones) do
    if zoneObj == zoneSet.obj then
      return
    end
  end
  table.insert(speedControlZones, {
    obj = zoneObj,
    speed = SpeedControl_ClampSpeed(zoneSpeed)
  })
end
function SpeedControl_RemoveZone(player, zoneObj)
  for i, zoneSet in ipairs(speedControlZones) do
    if zoneObj == zoneSet.obj then
      table.remove(speedControlZones, i)
      return
    end
  end
end
function SpeedControl_AddSpline(player, splineObj, followParams)
  for _, splineSet in ipairs(speedControlSplines) do
    if splineObj == splineSet.obj then
      return
    end
  end
  table.insert(speedControlSplines, {obj = splineObj, followParams = followParams})
end
function SpeedControl_RemoveSpline(player, splineObj)
  for i, splineSet in ipairs(speedControlSplines) do
    if splineObj == splineSet.obj then
      table.remove(speedControlSplines, i)
      return
    end
  end
end
function SpeedControl_UpdateActiveSource()
  local movementShouldBeMasked = false
  local attacksShouldBeMasked = false
  local sonCombatShouldBeUnavailable = false
  if #speedControlZones > 0 then
    movementShouldBeMasked = true
    activeSpeedControlSource = speedControlZones[1]
    local i = 2
    for i = 2, #speedControlZones do
      if speedControlZones[i].speed < activeSpeedControlSource.speed then
        activeSpeedControlSource = speedControlZones[i]
      end
    end
  end
  if 0 < #speedControlSplines then
    local player = game.Player.FindPlayer()
    local movementShouldBeMasked_Spline = false
    local attacksShouldBeMasked_Spline = false
    if player.SpeedControl_DetermineSplineSpeedAndInputLocks then
      speedControlSplines[1].speed, splineSpeedMinimized, movementShouldBeMasked_Spline, attacksShouldBeMasked_Spline = player:SpeedControl_DetermineSplineSpeedAndInputLocks(speedControlSplines[1].followParams.path, speedControlSplines[1].followParams.leadingCharacter, followDist_min, followDist_stopRelease, followDist_sweetSpot, followDist_max, splineSpeedMinimized)
    else
      movementShouldBeMasked, attacksShouldBeMasked = SpeedControl_DetermineSplineSpeedAndInputLocks()
    end
    if movementShouldBeMasked_Spline == true then
      movementShouldBeMasked = true
      sonCombatShouldBeUnavailable = true
    end
    if attacksShouldBeMasked_Spline == true then
      attacksShouldBeMasked = true
    end
    if #speedControlZones == 0 then
      activeSpeedControlSource = speedControlSplines[1]
    elseif speedControlSplines[1].speed < activeSpeedControlSource.speed then
      activeSpeedControlSource = speedControlSplines[1]
    end
  end
  local maskSprint = false
  local maskEvade = false
  local maskAttacks = false
  if movementShouldBeMasked == true then
    maskSprint = true
    maskEvade = true
  end
  if attacksShouldBeMasked == true then
    maskAttacks = true
  end
  if game.CHECK_FEATURE("SPEED_CONTROL_AVAILABILITY") then
    local son = game.AI.FindSon()
    if son ~= nil then
      if sonCombatShouldBeUnavailable then
        son:SetNewAvailabilityRequest("SpeedControl", {AvailableForCombat = false})
      else
        son:RemoveAvailabilityRequest("SpeedControl")
      end
    end
  end
  if #speedControlZones == 0 and #speedControlSplines == 0 then
    SpeedControl_ClearControl()
    return
  end
  if activeSpeedControlSource then
    currentMaxSpeed = activeSpeedControlSource.speed or 10000
    playerCreature:SetMaxSpeedOverride(currentMaxSpeed)
    SpeedControl_UpdateInputMasks(maskSprint, maskEvade, maskAttacks)
  end
end
function SpeedControl_ClearControl()
  activeSpeedControlSource = nil
  currentMaxSpeed = 10000
  playerCreature:ClearMaxSpeedOverride()
  SpeedControl_UpdateInputMasks(false, false, false)
  if game.CHECK_FEATURE("SPEED_CONTROL_AVAILABILITY") then
    local son = game.AI.FindSon()
    if son ~= nil then
      son:RemoveAvailabilityRequest("SpeedControl")
    end
  end
end
function SpeedControlSpline_PlayerIsTryingToMoveBackwards(path, playerProgression, playerSplinePos)
  local intentFwd = game.Camera.GetOrbitForward()
  intentFwd.y = 0
  intentFwd = intentFwd:Normalized() * playerCreature.Pad.NormalizedLeftStick.y
  local intentLeft = game.Camera.GetOrbitLeft()
  intentLeft.y = 0
  intentLeft = intentLeft:Normalized() * -playerCreature.Pad.NormalizedLeftStick.x
  local playerIntentPos = playerCreature.WorldPosition + (intentFwd + intentLeft):Normalized()
  local playerIntentProgression = path:GetProgression(playerIntentPos)
  local playerIntentSplinePos = path:GetPosition(playerIntentProgression)
  if engine.IsDebug() then
    engine.DrawLine(playerCreature.WorldPosition + playerCreature:GetWorldUp() * 0.5, playerIntentPos + playerCreature:GetWorldUp() * 0.5, color.yellow)
    engine.DrawTextInWorld(playerCreature.WorldPosition + playerCreature:GetWorldUp() * 1.1, "Player prog: " .. tostring(playerProgression) .. [[

Player Intent prog: ]] .. tostring(playerIntentProgression), color.yellow)
  end
  if playerProgression > playerIntentProgression then
    return true
  end
  return false
end
function SpeedControl_SetSplineSpeed_ConsiderBackwardsIntent(speed, path, playerProgression, playerSplinePos)
  if SpeedControlSpline_PlayerIsTryingToMoveBackwards(path, playerProgression, playerSplinePos) then
    speedControlSplines[1].speed = 3
  else
    speedControlSplines[1].speed = speed
  end
end
function SpeedControl_DetermineSplineSpeedAndInputLocks()
  local movementShouldBeMasked = false
  local attacksShouldBeMasked = false
  local player = game.Player.FindPlayer()
  local path = speedControlSplines[1].followParams.path
  local leadingCharacter = speedControlSplines[1].followParams.leadingCharacter
  local playerProgression = path:GetProgression(player.WorldPosition)
  local playerSplinePos = path:GetPosition(playerProgression)
  local currentFollowDistance = (leadingCharacter.WorldPosition - playerSplinePos):Length()
  if playerProgression > path:GetProgression(leadingCharacter.WorldPosition) then
    splineSpeedMinimized = true
    currentFollowDistance = -1
    SpeedControl_SetSplineSpeed_ConsiderBackwardsIntent(0.2, path, playerProgression, playerSplinePos)
    movementShouldBeMasked = true
    attacksShouldBeMasked = true
  elseif splineSpeedMinimized == false and currentFollowDistance > followDist_min or splineSpeedMinimized == true and currentFollowDistance > followDist_stopRelease then
    splineSpeedMinimized = false
    if currentFollowDistance > followDist_max then
      speedControlSplines[1].speed = 10000
    elseif currentFollowDistance > followDist_sweetSpot then
      local pct = (currentFollowDistance - followDist_sweetSpot) / (followDist_max - followDist_sweetSpot)
      speedControlSplines[1].speed = SpeedControl_ClampSpeed(3 + pct)
      movementShouldBeMasked = true
    elseif currentFollowDistance > followDist_min then
      local pct = (currentFollowDistance - followDist_min) / (followDist_sweetSpot - followDist_min)
      SpeedControl_SetSplineSpeed_ConsiderBackwardsIntent(SpeedControl_ClampSpeed(1 + 2 * pct), path, playerProgression, playerSplinePos)
      movementShouldBeMasked = true
      attacksShouldBeMasked = true
    else
      SpeedControl_SetSplineSpeed_ConsiderBackwardsIntent(0.2, path, playerProgression, playerSplinePos)
      movementShouldBeMasked = true
      attacksShouldBeMasked = true
    end
  else
    splineSpeedMinimized = true
    SpeedControl_SetSplineSpeed_ConsiderBackwardsIntent(0.2, path, playerProgression, playerSplinePos)
    movementShouldBeMasked = true
    attacksShouldBeMasked = true
  end
  if engine.IsDebug() then
    local leaderSpeed = leadingCharacter:GetVelocity():Length()
    path:DebugDraw(color.black, 45)
    engine.DrawTextInWorld(player.WorldPosition + player:GetWorldUp() * 2, [[
- YouShallNotPass Details -
Leader Speed: ]] .. tostring(leaderSpeed) .. [[

Follow Dist: ]] .. tostring(currentFollowDistance) .. [[

Current Max Speed for this spline:   ]] .. tostring(currentMaxSpeed), color.yellow)
    local rootPos = leadingCharacter.WorldPosition + player:GetWorldUp() * 1.5
    local flatDifIdentity = playerSplinePos - leadingCharacter.WorldPosition
    flatDifIdentity.y = 0
    flatDifIdentity = flatDifIdentity:Normalized()
    local dist1 = flatDifIdentity * followDist_min
    local dist2 = flatDifIdentity * followDist_sweetSpot
    local dist3 = flatDifIdentity * followDist_max
    engine.DrawLine(rootPos, rootPos + dist3, color.yellow)
    engine.DrawFillSphere(rootPos + dist1, 0.05, color.green)
    engine.DrawTextInWorld(rootPos + dist1 + player:GetWorldUp() * 0.1, "Anchor: 1.0 m/s", color.yellow)
    engine.DrawFillSphere(rootPos + dist2, 0.05, color.green)
    engine.DrawTextInWorld(rootPos + dist2 + player:GetWorldUp() * 0.1, "Anchor: 3.0 m/s", color.yellow)
    engine.DrawFillSphere(rootPos + dist3, 0.05, color.green)
    engine.DrawTextInWorld(rootPos + dist3 + player:GetWorldUp() * 0.1, "Anchor: 4.0 m/s", color.yellow)
    local playerDebugPoint = playerSplinePos
    playerDebugPoint.y = rootPos.y
    engine.DrawFillSphere(playerDebugPoint, 0.05, color.red)
  end
  return movementShouldBeMasked, attacksShouldBeMasked
end
function OnWeaponHitGameObject(Creature, Weapon, HitGameObject, HitInfo)
  game.FX.SubmitEffect(ffbRumbleThrow)
  local player = game.Player.FindPlayer()
  local isCreature = HitInfo.HitCreature
  local precisionHit = HitInfo.IsPrecision
  local isHeadshotTrue = HitInfo.IsHeadShot
  local isBlockedTrue = HitInfo.IsBlocked
  local partFlagsHit = HitInfo.PartFlags
  local throwModeName = HitInfo.ThrowName
  local concussionParams, currentRageMeter, currentComboMeter
  if throwModeName == "Axe_Toss_Rail" then
    if player:PickupGetStage("FrostSpecialAxeTossRail") <= 1 then
      concussionParams = {
        Tweak = "CNC_AXE_SPECIAL_RAIL_TOSS_HIT_REPLACE",
        EnemyId = player:GetID(),
        Creature = player
      }
      game.Combat.PlayConcussion(concussionParams)
      game.FX.SubmitEffect(ffbRumbleThrowHeavy)
    end
    if player:PickupGetStage("FrostSpecialAxeTossRail") == 2 then
      concussionParams = {
        Tweak = "CNC_AXE_SPECIAL_RAIL_TOSS_HIT_REPLACE_LVL02",
        EnemyId = player:GetID(),
        Creature = player
      }
      game.Combat.PlayConcussion(concussionParams)
      game.FX.SubmitEffect(ffbRumbleThrowHeavy)
    end
  end
  if throwModeName == "Axe_Toss_Horizontal_Critical" and game.Wallets.HasResource("HERO", "Axe_Tier01_Throw_CriticalThrowUpgrade") == true then
    concussionParams = {
      Tweak = "CNC_AXE_SPECIAL_TOSS_PROC",
      EnemyId = player:GetID(),
      Creature = player
    }
    game.Combat.PlayConcussion(concussionParams)
    game.FX.SubmitEffect(ffbRumbleThrowHeavy)
  end
  if throwModeName == "Axe_Toss_Horizontal_Critical_02" and game.Wallets.HasResource("HERO", "Axe_Tier01_Throw_CriticalThrowUpgrade") == true then
    concussionParams = {
      Tweak = "CNC_AXE_SPECIAL_DOUBLE_TOSS_PROC",
      EnemyId = player:GetID(),
      Creature = player
    }
    game.Combat.PlayConcussion(concussionParams)
    game.FX.SubmitEffect(ffbRumbleThrowHeavy)
  end
  if throwModeName == "Axe_Toss_Vertical_Charged" then
    concussionParams = {
      Tweak = "CNC_AXE_VERTICAL_TOSS_IMPACT",
      EnemyId = player:GetID(),
      Creature = player
    }
    game.Combat.PlayConcussion(concussionParams)
  end
  if throwModeName == "Axe_Toss_Vertical" and player:PickupIsAcquired("Effect_AxeCharged") then
    concussionParams = {
      Tweak = "CNC_AXE_SPECIAL_TOSS_PROC",
      EnemyId = player:GetID(),
      Creature = player
    }
    game.Combat.PlayConcussion(concussionParams)
  end
  if isBlockedTrue == 0 then
    if isCreature == 1 then
      if string.find(throwModeName, "Axe_Toss") ~= nil then
        if player:PickupIsAcquired("Buff_LightningAxe") == true then
          concussionParams = {
            Tweak = "CNC_AXE_MELEE_DAMAGE_PROC_LIGHTNING",
            EnemyId = player:GetID(),
            Creature = player
          }
          game.Combat.PlayConcussion(concussionParams)
          player:PickupRelinquish("Buff_LightningAxe")
        end
        if player:PickupIsAcquired("Buff_ValkyrieAxe") == true then
          concussionParams = {
            Tweak = "CNC_AXE_MELEE_DAMAGE_PROC_MASSIVE_EXPLOSION",
            EnemyId = player:GetID(),
            Creature = player
          }
          game.Combat.PlayConcussion(concussionParams)
          player:PickupRelinquish("Buff_ValkyrieAxe")
        end
        currentRageMeter = playerCreature.MeterGetValue(player, "Blood")
        player:MeterSetValue("Blood", currentRageMeter + 2)
        if player:PickupIsAcquired("Buff_MomentumFull") then
          perks.LuaHook_MomentumAxeIncrease()
          currentComboMeter = player.MeterGetValue(player, "Momentum")
          playerCreature:MeterSetValue("Momentum", currentComboMeter + 4)
          if player:PickupGetStage("Buff_MomentumFull") == 3 and player:AttributeGetValue("Difficulty") == 4 then
            concussionParams = {
              Tweak = "CNC_AXE_FROST_MOMENTUM_FULL_IMPOSSIBLE",
              EnemyId = player:GetID(),
              Creature = player
            }
            game.Combat.PlayConcussion(concussionParams)
          elseif player:PickupGetStage("Buff_MomentumFull") == 3 and 4 > player:AttributeGetValue("Difficulty") then
            concussionParams = {
              Tweak = "CNC_AXE_FROST_MOMENTUM_FULL",
              EnemyId = player:GetID(),
              Creature = player
            }
            game.Combat.PlayConcussion(concussionParams)
          end
        end
      end
      if isHeadshotTrue == 1 then
        if throwModeName ~= "Axe_Toss_Horizontal" then
        end
        if playerCreature:PickupIsAcquired("Perk_Throw_OnHeadshot_Cooldown") == true then
          playerCreature:CallScript("LuaHook_Perk_Throw_OnHeadshot_Cooldown")
        end
        if playerCreature:PickupIsAcquired("Perk_Throw_OnHeadshot_OffenseBuff") == true then
          playerCreature:CallScript("LuaHook_Perk_Throw_OnHeadshot_OffenseBuff")
        end
        if playerCreature:PickupIsAcquired("Perk_Throw_OnHeadshot_Runic") == true then
          playerCreature:CallScript("LuaHook_Perk_Throw_OnHeadshot_Runic")
        end
        if playerCreature:PickupIsAcquired("Perk_Throw_OnHeadshot_Rage") == true then
          playerCreature:CallScript("LuaHook_Perk_Throw_OnHeadshot_Rage")
        end
        if playerCreature:PickupIsAcquired("Perk_Throw_OnHeadshot_HealthDrain") == true then
          playerCreature:CallScript("LuaHook_Perk_Throw_OnHeadshot_HealthDrain")
        end
        if playerCreature:PickupIsAcquired("Perk_OnHeadShot_NidCurse_Heal") == true then
          playerCreature:CallScript("LuaHook_Perk_OnHeadShot_NidCurse_Heal")
        end
        if playerCreature:PickupGetStage("Perk_Offense_OnMeleeDamage_ProcLightning") == 2 and playerCreature:PickupIsAcquired("Buff_LightningAxe") ~= true then
          playerCreature:PickupAcquire("Buff_LightningAxe")
        end
        if throwModeName == "Axe_Toss_Horizontal" and game.Wallets.HasResource("HERO", "Axe_Tier01_Throw_Node01_SubNode03") == true then
          playerCreature:PickupAcquire("Effect_AxeRecallTimer")
        end
        if throwModeName == "Axe_Toss_Horizontal_Critical" and playerCreature.AttributeGetValue(playerCreature, "Focus") >= 125 then
          playerCreature:PickupAcquire("Effect_AxeRecallTimer")
          playerCreature:PickupSetStage("Effect_AxeRecallTimer", 1)
        end
      else
        game.FX.SubmitEffect(ffbRumbleThrow)
      end
    else
      game.FX.SubmitEffect(ffbRumbleThrow)
    end
  end
end
function SpeedControl_UpdateInputMasks(maskSprint, maskEvade, maskAttacks)
  if maskSprint == true then
    speedControl_inputLock_sprint = SpeedControl_DisableButton(speedControl_inputLock_sprint, tweaks.ePad.kPadL3)
  elseif maskSprint == false then
    speedControl_inputLock_sprint = SpeedControl_EnableButton(speedControl_inputLock_sprint, tweaks.ePad.kPadL3)
  end
  if maskEvade == true then
    speedControl_inputLock_evade = SpeedControl_DisableButton(speedControl_inputLock_evade, tweaks.ePad.kPadCross)
  elseif maskEvade == false then
    speedControl_inputLock_evade = SpeedControl_EnableButton(speedControl_inputLock_evade, tweaks.ePad.kPadCross)
  end
  if maskAttacks == true then
    speedControl_inputLock_R1 = SpeedControl_DisableButton(speedControl_inputLock_R1, tweaks.ePad.kPadR1)
    speedControl_inputLock_R2 = SpeedControl_DisableButton(speedControl_inputLock_R2, tweaks.ePad.kPadR2)
    speedControl_inputLock_L1 = SpeedControl_DisableButton(speedControl_inputLock_L1, tweaks.ePad.kPadL1)
    speedControl_inputLock_L2 = SpeedControl_DisableButton(speedControl_inputLock_L2, tweaks.ePad.kPadL2)
  elseif maskAttacks == false then
    speedControl_inputLock_R1 = SpeedControl_EnableButton(speedControl_inputLock_R1, tweaks.ePad.kPadR1)
    speedControl_inputLock_R2 = SpeedControl_EnableButton(speedControl_inputLock_R2, tweaks.ePad.kPadR2)
    speedControl_inputLock_L1 = SpeedControl_EnableButton(speedControl_inputLock_L1, tweaks.ePad.kPadL1)
    speedControl_inputLock_L2 = SpeedControl_EnableButton(speedControl_inputLock_L2, tweaks.ePad.kPadL2)
  end
end
function SpeedControl_DisableButton(bMaskedBySpeedControl, padButton)
  if bMaskedBySpeedControl == false then
    if not playerCreature.Pad:IsGameButtonDisabled(padButton) then
      playerCreature.Pad:DisableGameButton(padButton)
      return true
    else
      return false
    end
  end
  return true
end
function SpeedControl_EnableButton(bMaskedBySpeedControl, padButton)
  if bMaskedBySpeedControl == true then
    playerCreature.Pad:EnableGameButton(padButton)
  end
  return false
end
function SpeedControl_ClampSpeed(intendedMaxSpeed)
  if intendedMaxSpeed < 1 then
    return 1
  elseif 4 < intendedMaxSpeed then
    return 4
  end
  return intendedMaxSpeed
end
function Debug_PrintSpeedControlZonesAndSplines(sonInWaitGate)
  if not engine.IsDebug() then
    return
  end
  if #speedControlZones > 0 or 0 < #speedControlSplines then
    local tab = "   "
    local str = ""
    if activeSpeedControlSource then
      local o = activeSpeedControlSource.obj
      while o ~= nil do
        if o.IsRefNode then
          str = "(refnode)|" .. str
        end
        str = o:GetName() .. "|" .. str
        o = o.Parent
      end
    end
    local debugTable = {}
    debugTable.Title = "Speed Control Info"
    debugTable.X = 50
    debugTable.Y = 1
    debugTable[#debugTable + 1] = {
      "Player Max Speed: " .. tostring(currentMaxSpeed)
    }
    debugTable[#debugTable + 1] = {""}
    if activeSpeedControlSource then
      if activeSpeedControlSource.followParams ~= nil then
        debugTable[#debugTable + 1] = {
          "Active Source Type: Spline"
        }
      else
        debugTable[#debugTable + 1] = {
          "Active Source Type: Zone"
        }
      end
      debugTable[#debugTable + 1] = {
        "Active Source Path: " .. str
      }
    else
      debugTable[#debugTable + 1] = {
        "Active Source Type: None"
      }
      debugTable[#debugTable + 1] = {
        "Active Source Path: N/A"
      }
    end
    debugTable[#debugTable + 1] = {""}
    if speedControl_inputLock_sprint or speedControl_inputLock_evade or speedControl_inputLock_R1 or speedControl_inputLock_R2 or speedControl_inputLock_L1 or speedControl_inputLock_L2 then
      debugTable[#debugTable + 1] = {
        "Control Masks:"
      }
      if speedControl_inputLock_sprint then
        debugTable[#debugTable + 1] = {
          tab .. "Sprint"
        }
      end
      if speedControl_inputLock_evade then
        debugTable[#debugTable + 1] = {
          tab .. "Evade"
        }
      end
      if speedControl_inputLock_R1 or speedControl_inputLock_R2 or speedControl_inputLock_L1 or speedControl_inputLock_L2 then
        debugTable[#debugTable + 1] = {
          tab .. "Attacks"
        }
      end
      debugTable[#debugTable + 1] = {""}
    end
    local inCombat = game.Combat.GetCombatStatus()
    local inPup = playerCreature:IsUnderPOIControl()
    local waitGate = #speedControlZones == 0 and sonInWaitGate
    if inCombat == true or inPup or waitGate == true then
      debugTable[#debugTable + 1] = {
        "Suppressed by:"
      }
      if inCombat == true then
        debugTable[#debugTable + 1] = {
          tab .. "Combat"
        }
      end
      if inPup then
        debugTable[#debugTable + 1] = {
          tab .. "Puppeteer Approach"
        }
      end
      if waitGate == true then
        debugTable[#debugTable + 1] = {
          tab .. "Wait Gate"
        }
      end
      debugTable[#debugTable + 1] = {""}
    end
    debugTable[#debugTable + 1] = {
      "Zones being considered:"
    }
    for i, zoneObj in ipairs(speedControlZones) do
      debugTable[#debugTable + 1] = {
        tab .. tostring(i) .. ". " .. tostring(zoneObj.obj.Parent:GetName() .. " - " .. tostring(zoneObj.speed))
      }
    end
    debugTable[#debugTable + 1] = {
      "Splines being considered:"
    }
    for i, spline in ipairs(speedControlSplines) do
      debugTable[#debugTable + 1] = {
        tab .. tostring(i) .. ". " .. tostring(spline.obj.Parent:GetName() .. " - " .. tostring(spline.speed))
      }
    end
    engine.DrawDebugTable(debugTable)
  end
end
local offscreenindicatorName = "indicator"
local offscreenTable = {}
function OffScreenRingUpate(player)
  local enemiesAround = player:FindEnemies(40)
  for _, i in ipairs(enemiesAround) do
    if i:HasMarker("Attacking") and i:GetTargetCreature() == player and not i:CheckDecision("tweak_Decision_OnCamera") and not CreatureExistsInTable(i, offscreenTable) then
      local newEntry = {}
      newEntry.thisCreature = i
      newEntry.thisEffect = game.FX.Spawn(offscreenindicatorName, nil)
      table.insert(offscreenTable, newEntry)
    end
  end
  local tablesize = #offscreenTable
  for i = tablesize, 1, -1 do
    local thisCreature = offscreenTable[i].thisCreature
    if not (thisCreature ~= nil and thisCreature:HasMarker("Attacking")) or thisCreature:CheckDecision("tweak_Decision_OnCamera") then
      offscreenTable[i].thisEffect:Destroy()
      table.remove(offscreenTable, i)
    else
      local facing = (player.WorldPosition - thisCreature.WorldPosition):Normalized()
      offscreenTable[i].thisEffect:SetWorldFacing(facing)
      offscreenTable[i].thisEffect:SetWorldPosition(player.WorldPosition + player:GetWorldUp() * 1)
    end
  end
end
function CreatureExistsInTable(thisCreature, thisTable)
  for _, i in ipairs(thisTable) do
    if i.thisCreature == thisCreature then
      return true
    end
  end
  return false
end
local offscreenTableSon = {}
function OffScreenRingSonUpate(player)
  local i = game.AI.FindSon()
  if i == nil then
    return
  end
  local sonBB = i:GetBlackboard()
  local inCombat = false
  if sonBB ~= nil and sonBB:Exists("InCombat") and sonBB:GetNumber("InCombat") == 1 then
    inCombat = true
  end
  if inCombat == false then
    if 0 < #offscreenTableSon then
      offscreenTableSon[1].thisEffect:Destroy()
      table.remove(offscreenTableSon, 1)
    end
    return
  end
  if not i:CheckDecision("tweak_Decision_OnCamera") and not CreatureExistsInTable(i, offscreenTableSon) then
    local newEntry = {}
    newEntry.thisCreature = i
    newEntry.thisEffect = game.FX.Spawn(offscreenindicatorName, nil)
    table.insert(offscreenTableSon, newEntry)
  end
  local tablesize = #offscreenTableSon
  for i = tablesize, 1, -1 do
    local thisCreature = offscreenTableSon[i].thisCreature
    if thisCreature:CheckDecision("tweak_Decision_OnCamera") then
      offscreenTableSon[i].thisEffect:Destroy()
      table.remove(offscreenTableSon, i)
    else
      local facing = (player.WorldPosition - thisCreature.WorldPosition):Normalized()
      offscreenTableSon[i].thisEffect:SetWorldFacing(facing)
      offscreenTableSon[i].thisEffect:SetWorldPosition(player.WorldPosition + player:GetWorldUp() * 1)
    end
  end
end
function PlaySoundOnKratos(level, snd)
  LD.PlaySound(playerCreature:FindSingleSoundEmitterByName("SNDKratos"), snd)
end
function StopSoundOnKratos(level, snd)
  LD.StopSound(playerCreature:FindSingleSoundEmitterByName("SNDKratos"), snd)
end
function PlaySoundOnKratosMouth(level, snd)
  LD.PlaySound(playerCreature:FindSingleSoundEmitterByName("SNDMouth"), snd)
end
function StopSoundOnKratosMouth(level, snd)
  LD.StopSound(playerCreature:FindSingleSoundEmitterByName("SNDMouth"), snd)
end
function LuaHook_PlayOverheadFireOnRightBlade()
  LD.PlaySound(playerCreature:FindSingleSoundEmitterByName("SNDRightBlade"), "SND_WPN_Blades_Fire_Upgrade_Overhead_LP")
end
function LuaHook_PlayOverheadFireOnLeftBlade()
  LD.PlaySound(playerCreature:FindSingleSoundEmitterByName("SNDLeftBlade"), "SND_WPN_Blades_Fire_Upgrade_Overhead_LP")
end
function LuaHook_PlayInHandFireOnRightBlade()
  LD.PlaySound(playerCreature:FindSingleSoundEmitterByName("SNDRightBlade"), "SND_WPN_Blades_Fire_Upgrade_InHand_LP")
end
function LuaHook_PlayInHandFireOnLeftBlade()
  LD.PlaySound(playerCreature:FindSingleSoundEmitterByName("SNDLeftBlade"), "SND_WPN_Blades_Fire_Upgrade_InHand_LP")
end
function LuaHook_StopOverheadFireOnRightBlade()
  LD.StopSound(playerCreature:FindSingleSoundEmitterByName("SNDRightBlade"), "SND_WPN_Blades_Fire_Upgrade_Overhead_LP")
end
function LuaHook_StopOverheadFireOnLeftBlade()
  LD.StopSound(playerCreature:FindSingleSoundEmitterByName("SNDLeftBlade"), "SND_WPN_Blades_Fire_Upgrade_Overhead_LP")
end
function LuaHook_StopInHandFireOnRightBlade()
  LD.StopSound(playerCreature:FindSingleSoundEmitterByName("SNDRightBlade"), "SND_WPN_Blades_Fire_Upgrade_InHand_LP")
end
function LuaHook_StopInHandFireOnLeftBlade()
  LD.StopSound(playerCreature:FindSingleSoundEmitterByName("SNDLeftBlade"), "SND_WPN_Blades_Fire_Upgrade_InHand_LP")
end
function BreatheFrequencyRTPC()
  if game.Audio.GetBreathingFrequency then
    return game.Audio.GetBreathingFrequency(playerCreature)
  else
    return 0
  end
end
function BreatheAmplitudeRTPC()
  if game.Audio.GetBreathingAmplitude then
    return game.Audio.GetBreathingAmplitude(playerCreature)
  else
    return 0
  end
end
function MOV_PercentageRTPC()
  if playerCreature ~= nil then
    return playerCreature:GetActiveMovePercent() * 100
  else
    return 0
  end
end
function SoundDebug()
  InitBladeAudio(playerCreature)
  local lVelocity = GetVelocityRelativeToKratos(chainSoundEmitterL)
  local rVelocity = GetVelocityRelativeToKratos(chainSoundEmitterR)
  if lVelocity ~= 0 then
    lRelValue = lVelocity
    rRelValue = rVelocity
    lValue = chainSoundEmitterL:GetVelocity()
    rValue = chainSoundEmitterR:GetVelocity()
  end
  local debugTable = {}
  debugTable.Title = "Chain Velocity Relative to Kratos"
  debugTable.X = 15
  debugTable.Y = 12
  debugTable.TitleColor = engine.Vector.New(255, 0, 0)
  debugTable[#debugTable + 1] = {
    "Left Chain: ",
    lRelValue
  }
  debugTable[#debugTable + 1] = {
    "Right Chain: ",
    rRelValue
  }
  debugTable[#debugTable + 1] = {
    "Regular Velocity"
  }
  debugTable[#debugTable + 1] = {
    "Left Chain: ",
    lValue
  }
  debugTable[#debugTable + 1] = {
    "Right Chain: ",
    rValue
  }
  engine.DrawDebugTable(debugTable)
end
function GetVelocityRelativeToKratos(emitter)
  return emitter:GetVelocity() - playerCreature:FindSingleSoundEmitterByName("SNDKratos"):GetVelocity()
end
function UpdateChainVelocity()
end
function UpdateChainVelocityR()
  if chainSoundEmitterR ~= nil then
    return math.abs(GetVelocityRelativeToKratos(chainSoundEmitterR))
  end
end
function UpdateChainVelocityL()
  if chainSoundEmitterL ~= nil then
    return math.abs(GetVelocityRelativeToKratos(chainSoundEmitterL))
  end
end
function LuaHookDecision_TargetUseSafeSpots(player)
  local target = player:GetTargetCreature()
  if target ~= nil and target:HasMarker("UseSafeSpots") then
    return true
  end
  return false
end
function LuaHookDecision_BaldurCheckCloseThrow(ai, data)
  if ai ~= nil then
    local myLevel = game.FindLevel("For300_BossArena")
    local destinationPos = myLevel:FindSingleGameObject("Warp_Stage2_BaldurAgainstStatue"):GetWorldPosition()
    local dist = ai:GetWorldPosition() - destinationPos
    dist = dist.length
    if dist < 8 then
      return data:FindOutcomeBranchesEntry("Close")
    elseif dist < 15 then
      return data:FindOutcomeBranchesEntry("Medium")
    end
  end
  return data:FindOutcomeBranchesEntry("Far")
end
function LuaHook_ValkBlightStart()
  local thisLevel = playerCreature.GroundLevel
  if thisLevel == "WAD_Nid100_Entrance" or thisLevel == game.FindLevel("Nid100_Entrance") or thisLevel == game.FindLevel("Nid310_NWRoom") then
    LuaHook_NiflheimBlightStart()
    playerCreature:MeterSetValue("Health", playerCreature:MeterGetMax("Health"))
  end
end
function LuaHook_ValkBlightEnd()
  local thisLevel = playerCreature.GroundLevel
  if thisLevel == "WAD_Nid100_Entrance" or thisLevel == game.FindLevel("Nid100_Entrance") or thisLevel == game.FindLevel("Nid310_NWRoom") then
    LuaHook_NiflheimBlightEnd()
  end
end
function LuaHook_NiflheimBlightStart()
  playerCreature:PickupAcquire("Debuff_Hero_Blight_Persist")
  playerCreature:PickupAcquire("Debuff_Hero_Blight_Protection")
end
function LuaHook_NiflheimBlightEnd()
  if playerCreature:PickupIsAcquired("Debuff_Hero_Blight_Protection") then
    playerCreature:PickupRelinquish("Debuff_Hero_Blight_Protection")
  end
  timer.StartCreatureTimer(0.5, RemoveBlightPickupHelper)
end
function RemoveBlightPickupHelper()
  if playerCreature:PickupIsAcquired("Debuff_Hero_Blight_Persist") then
    playerCreature:PickupRelinquish("Debuff_Hero_Blight_Persist")
  end
end
function LuaHook_NiflheimBlightProtectionIncreaseSml()
  playerCreature:MeterSetValue("NiflheimBlightProtection", 10)
end
function LuaHook_NiflheimBlightProtectionIncreaseMed()
  playerCreature:MeterSetValue("NiflheimBlightProtection", 20)
end
function LuaHook_NiflheimBlightProtectionIncreaseLrg()
  playerCreature:MeterSetValue("NiflheimBlightProtection", 50)
end
function LuaHook_NiflheimBlightProtectionIncreaseFull()
  playerCreature:MeterSetValue("NiflheimBlightProtection", 200)
end
function LuaHook_CarryStartCheck(crt, data)
  local locomotionInfo = crt:GetLocomotionInfo()
  if locomotionInfo.TargetSpeed < 0.2 then
    return nil
  end
  return data:FindOutcomeBranchesEntry("WalkStart")
end
local MotionWarp = function(ai, rotation, position)
  if not warpLoc then
    warpLoc = ai:GetAnimDriver("WarpTranslate")
  end
  if not warpRot then
    warpRot = ai:GetAnimDriver("WarpRot")
  end
  warpRot.ValueVec = rotation
  warpLoc.ValueVec = position
end
function LuaHook_WarpTroll30Arena(ai, data)
  local syncObj = ai.GroundLevel:FindSingleGameObject("Cine_RetrieveHeart")
  if syncObj == nil then
    engine.Error("Missing synch object")
  end
  local rotateion = -syncObj:GetWorldLeft()
  local position = syncObj:GetWorldPosition()
  MotionWarp(ai, rotateion, position)
end
function LuaHook_WarpTroll00Arena(ai, data)
end
function LuaHook_GiveEvadeTimer()
  playerCreature:PickupAcquire("EvadeRollTimer", 0)
end
local ShouldDoRiftTutorial = function()
  if game.QuestManager.GetQuestState("Quest_Labor_RiftPockets_Bronze") == "Complete" then
    return false
  else
    return true
  end
end
function LuaHook_PocketRiftCombatStarted()
  riftEncounterStarted = true
  if game.Wallets.GetResourceValue("HERO", "RiftDeathCounter") >= 5 and ShouldDoRiftTutorial() == true and game.Wallets.GetResourceValue("HERO", "RiftTutorial") < 0 then
    game.Wallets.AddResource("HERO", "RiftTutorial", 1, "NO_TELEMETRY")
    uiCalls.SendSidebarDesignerMessage({
      Text = 44433,
      MessageVariant = uiCalls.msgParam.SIDEBAR_MEDIUM,
      DisplayTime = 12
    })
    game.UI.SoftSavePlayerState()
  end
end
function LuaHook_PocketRiftCombatSuccessful()
  riftEncounterStarted = false
end
function LuaHook_DeathCounterCheck()
  if riftEncounterStarted == true and ShouldDoRiftTutorial() == true and game.Wallets.GetResourceValue("HERO", "RiftDeathCounter") < 5 then
    game.Wallets.AddResource("HERO", "RiftDeathCounter", 1, "NO_TELEMETRY")
    game.UI.SoftSavePlayerState()
  end
end
function LuaHook_ClearWarpData()
  print("attemping to clear warp data! num 1")
  local gbl00 = game.FindLevel("Gbl000_FastTravel")
  if gbl00 ~= nil then
    gbl00:CallScript("ClearWarpData")
  end
  local bboard = playerCreature:GetPrivateBlackboard()
  if bboard and bboard:Exists("PlayerIsFastTraveling") then
    bboard:Erase("PlayerIsFastTraveling")
  end
  if bboard and bboard:Exists("FastTravelLoadRequested") then
    bboard:Erase("FastTravelLoadRequested")
  end
  if bboard and bboard:Exists("FinalDestinationMarker") then
    bboard:Erase("FinalDestinationMarker")
  end
end
function OnHitReaction(event)
end
function OnHitEnemy(event)
end
function LuaHookInternal_OnHitReaction(player, activeCreature, activeEnemyID, activeCollisionContext, wasBlocked, activeCollisionFlags, passivePartFlags, damage)
  local event = {
    source = activeCreature,
    collisionContext = activeCollisionContext,
    enemyId = activeEnemyID,
    isConcussion = false,
    wasBlocked = wasBlocked,
    hitFlags = activeCollisionFlags,
    partFlags = passivePartFlags,
    damage = damage
  }
  OnHitReaction(event)
end
function LuaHookInternal_OnHitEnemy(player, passiveCreature, passiveEnemyID, activeCollisionContext, wasBlocked, activeCollisionFlags, passivePartFlags, damage)
  local event = {
    target = passiveCreature,
    collisionContext = activeCollisionContext,
    enemyId = passiveEnemyID,
    isConcussion = false,
    wasBlocked = wasBlocked,
    hitFlags = activeCollisionFlags,
    partFlags = passivePartFlags,
    damage = damage
  }
  OnHitEnemy(event)
end
local bladesCounter = 0
function PlayBladeAudioOnLoad()
  bladesCounter = bladesCounter + 1
  local currentWeapon = playerCreature:GetCurrentWeapon()
  if currentWeapon ~= nil then
    print(currentWeapon)
    if currentWeapon == "Blades" then
      print("Kratos was holding his blades on load")
      LuaHook_PlayBladeChainAudio(playerCreature)
      weaponsLoaded = true
    elseif 10 <= bladesCounter then
      print("Kratos was legitimately not holding the blades on load")
      weaponsLoaded = true
    end
  end
end
function InitBladeAudio(player)
  chainSoundEmitterL = playerCreature:FindSingleSoundEmitterByName("SNDLeftChain")
  chainSoundEmitterR = playerCreature:FindSingleSoundEmitterByName("SNDRightChain")
  PlayBladeAudioHelper(player)
end
function LuaHook_PlayBladeChainAudio(player)
  if chainSoundEmitterL ~= nil and chainSoundEmitterR ~= nil then
    PlayBladeAudioHelper(player)
  else
    InitBladeAudio(player)
  end
end
function PlayBladeAudioHelper(player)
  game.Audio.SetWwiseSwitch(player, "WPN_Blades_Equip", "Equipped")
  LD.PlaySound(chainSoundEmitterL, "SND_WPN_Blades_Chain_Movement_LP")
  LD.PlaySound(chainSoundEmitterR, "SND_WPN_Blades_Chain_Movement_LP")
end
function LuaHook_StopBladeChainAudio(player)
  if chainSoundEmitterL ~= nil and chainSoundEmitterR ~= nil then
    game.Audio.SetWwiseSwitch(player, "WPN_Blades_Equip", "Unequipped")
    LD.StopSound(chainSoundEmitterL, "SND_WPN_Blades_Chain_Movement_LP")
    LD.StopSound(chainSoundEmitterR, "SND_WPN_Blades_Chain_Movement_LP")
  end
end
function LuaHook_DrainMomentumLoops(player, momentumValue)
  local axeObj
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    if weaponInfo.Weapon:GetName() == "axe00" then
      axeObj = weaponInfo.Weapon:FindSingleSoundEmitterByName("SNDAxe")
    end
  end
  if 25 <= momentumValue then
    if 75 <= momentumValue then
      if momentumValue == 100 then
        return
      elseif axeObj:IsPlaying("SND_WPN_Axe_Momentum_Stage3_LP") then
        LD.StopSound(axeObj, "SND_WPN_Axe_Momentum_Stage3_LP")
      end
    elseif axeObj:IsPlaying("SND_WPN_Axe_Momentum_Stage2_LP") then
      LD.StopSound(axeObj, "SND_WPN_Axe_Momentum_Stage2_LP")
    end
  elseif axeObj:IsPlaying("SND_WPN_Axe_Momentum_Stage1_LP") then
    LD.StopSound(axeObj, "SND_WPN_Axe_Momentum_Stage1_LP")
  end
end
function LuaHook_StopMomentumLoops(player)
  local axeObj
  for weaponInfo in playerCreature:IterateActiveWeapons() do
    local gameobj = weaponInfo.Weapon
    if gameobj ~= nil and gameobj:GetName() == "axe00" then
      axeObj = gameobj:FindSingleSoundEmitterByName("SNDAxe")
      if axeObj:IsPlaying("SND_WPN_Axe_Momentum_Stage3_LP") and not axeObj:IsStopping("SND_WPN_Axe_Momentum_Stage3_LP") then
        LD.StopSound(axeObj, "SND_WPN_Axe_Momentum_Stage3_LP")
      end
      if axeObj:IsPlaying("SND_WPN_Axe_Momentum_Stage2_LP") and not axeObj:IsStopping("SND_WPN_Axe_Momentum_Stage2_LP") then
        LD.StopSound(axeObj, "SND_WPN_Axe_Momentum_Stage2_LP")
      end
      if axeObj:IsPlaying("SND_WPN_Axe_Momentum_Stage1_LP") and not axeObj:IsStopping("SND_WPN_Axe_Momentum_Stage1_LP") then
        LD.StopSound(axeObj, "SND_WPN_Axe_Momentum_Stage1_LP")
      end
    end
  end
end
MimirHeadInterruptableStates = {
  "AttachmentIdle",
  "MimirDead",
  "MimirCombat"
}
function MimirHeadIdleSetup()
  if playerCreature:PickupIsAcquired("MimirHead") and playerCreature.MimirHead ~= nil then
    if not mimirEyeVisible and game.Level.GetVariable("CAL_MimirEyeAcquired") then
      LuaHook_ShowMimirEye()
    end
    if playerCreature.MimirHead.GetPrimaryAnimationName == nil then
      return
    end
    local MimirHeadState = playerCreature.MimirHead:GetPrimaryAnimationName()
    local canInterrupt = false
    for _, value in ipairs(MimirHeadInterruptableStates) do
      if MimirHeadState == value then
        canInterrupt = true
        break
      end
    end
    if canInterrupt then
      local desiredMimirHeadState = "AttachmentIdle"
      if playerCreature:PickupGetStage("MimirHead") == 1 then
        desiredMimirHeadState = "MimirDead"
      elseif game.Combat.GetCombatStatus() == true then
        desiredMimirHeadState = "MimirCombat"
      end
      if MimirHeadState ~= desiredMimirHeadState then
        playerCreature.MimirHead:PlayAnimationCycle({Animation = desiredMimirHeadState, Tween = 1})
      end
    end
  else
    mimirEyeVisible = false
  end
end
function AshPouchSetup()
  if not setupPouchOnStart then
    local cineNum = game.Level.GetVariable("CompletedCineNumber")
    if cineNum < 20 then
      LuaHook_UI_ShieldOff()
    else
      LuaHook_UI_ShieldOn()
    end
    if cineNum < 78 or 590 <= cineNum then
      HideAshPouch()
      LuaHook_UI_PouchOff()
    else
      LuaHook_UI_PouchOn()
    end
    setupPouchOnStart = true
  end
end
function LuaHook_PlayMomentumAxeConcussion(player)
  local concussionParams = {
    Tweak = "CNC_AXE_FROST_MOMENTUM_FULL_FIXED_POSITION",
    EnemyId = player:GetID(),
    Creature = player
  }
  game.Combat.PlayConcussion(concussionParams)
end
function LuaHook_SpawnGameObject(C, spawnArgs)
  C:SpawnGameObject(spawnArgs)
end
function LuaHook_Baldur2Fight_Punch()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  local peak800 = game.FindLevel("Peak800_DragonRide")
  if cineNum == 470 and peak800 ~= nil then
    peak800:GetGameObject("Peak800_Banter"):CallScript("KratosPunch_Banters")
  end
end
function HideMimirRopes()
  local mimirHead = playerCreature.MimirHead
  local ropeIndex = mimirHead:GetJointIndex("mimir00_Ropes")
  mimirHead:HideJoint(ropeIndex)
end
function ShowMimirRopes()
  local mimirHead = playerCreature.MimirHead
  local ropeIndex = mimirHead:GetJointIndex("mimir00_Ropes")
  mimirHead:ShowJoint(ropeIndex)
end
function HideAshPouch()
  local pouchIndex = playerCreature:GetJointIndex("ashPouch1")
  playerCreature:HideJoint(pouchIndex)
end
function ShowAshPouch()
  local pouchIndex = playerCreature:GetJointIndex("ashPouch1")
  playerCreature:ShowJoint(pouchIndex)
end
function PommelDaggerEquipped(currentPommel)
  return currentPommel == "WeaponComponent_Axe_Bonus01" or currentPommel == "Perk_Offense_OnMeleeDamage_HealthDrain" or currentPommel == "Perk_Offense_OnMeleeDamage_HealthDrain_Reinforce1" or currentPommel == "Perk_Offense_OnMeleeDamage_HealthDrain_Reinforce2"
end
function PommelMuspEquipped(currentPommel)
  return currentPommel == "Perk_Weapon_Muspelheim" or currentPommel == "Perk_Weapon_Muspelheim_Reinforce1" or currentPommel == "Perk_Weapon_Muspelheim_Reinforce2"
end
function Pommel04Equipped(currentPommel)
  return currentPommel == "Perk_Offense_AxeHeavyHold_RageBurst" or currentPommel == "Perk_Offense_AxeHeavyHold_RunicBuff" or currentPommel == "Perk_Offense_AxeHeavyHold_OffenseBuff" or currentPommel == "Perk_Offense_AxeHeavyHold_HealthBurst" or currentPommel == "Perk_Offense_AxeHeavyHold_HealthBurst_Reinforce1" or currentPommel == "Perk_Offense_AxeHeavyHold_HealthBurst_Reinforce2" or currentPommel == "Perk_Offense_AxeHeavyHold_Cooldown" or currentPommel == "Perk_Offense_AxeHeavyHold_Cooldown_Reinforce1" or currentPommel == "Perk_Offense_AxeHeavyHold_Cooldown_Reinforce2" or currentPommel == "WeaponComponent_Axe_Bonus02"
end
function Pommel05Equipped(currentPommel)
  return currentPommel == "WeaponComponent_Axe_Finisher" or currentPommel == "WeaponComponent_Axe_Finisher_Reinforce1" or currentPommel == "WeaponComponent_Axe_Finisher_Reinforce2"
end
function Pommel10Equipped(currentPommel)
  return currentPommel == "Perk_Offense_OnMeleeDamage_ProcFrost" or currentPommel == "Perk_Offense_OnMeleeDamage_ProcFrost_Reinforce1" or currentPommel == "Perk_Offense_OnMeleeDamage_ProcFrost_Reinforce2"
end
function PommelNidEquipped(currentPommel)
  return currentPommel == "Perk_Weapon_Niflheim" or currentPommel == "Perk_Weapon_Niflheim_Reinforce1" or currentPommel == "Perk_Weapon_Niflheim_Reinforce2"
end
function LuaHook_HideLongPommelIfEquipped()
  local myAxe = playerCreature.Axe
  if myAxe ~= nil then
    local currentPommel = playerCreature:PickupGetPickupNameInSlot("WeaponComponent")
    local myPommelIndex
    if PommelDaggerEquipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_dagger")
    elseif PommelMuspEquipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_musp")
    elseif Pommel04Equipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_04")
    elseif Pommel05Equipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_05")
    elseif Pommel10Equipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_10")
    elseif PommelNidEquipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_nid")
    end
    if myPommelIndex ~= nil then
      myAxe:HideJoint(myPommelIndex)
      local baseIndex = myAxe:GetJointIndex("axe_component_01")
      myAxe:ShowJoint(baseIndex)
    end
  end
end
function LuaHook_ShowLongPommelIfEquipped()
  local myAxe = playerCreature.Axe
  if myAxe ~= nil then
    local currentPommel = playerCreature:PickupGetPickupNameInSlot("WeaponComponent")
    local myPommelIndex
    if PommelDaggerEquipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_dagger")
    elseif PommelMuspEquipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_musp")
    elseif Pommel04Equipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_04")
    elseif Pommel05Equipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_05")
    elseif Pommel10Equipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_10")
    elseif PommelNidEquipped(currentPommel) then
      myPommelIndex = myAxe:GetJointIndex("axe_component_nid")
    end
    if myPommelIndex ~= nil then
      myAxe:ShowJoint(myPommelIndex)
      local baseIndex = myAxe:GetJointIndex("axe_component_01")
      myAxe:HideJoint(baseIndex)
    elseif currentPommel ~= "WeaponComponent_Axe_Default" then
      local baseIndex = myAxe:GetJointIndex("axe_component_01")
      myAxe:HideJoint(baseIndex)
    end
  end
end
function LuaHook_AccessibilityCheck()
  if game.GetRepeatedButtonPressChoice() == 1 and playerCreature.Pad.CircleDown then
    playerCreature:TriggerMoveEvent("LE_AccessibilityBranch")
  end
end
function LuaHook_RopeDrop(creature)
  if creature.GetTraversePath then
    local traversePath = creature:GetTraversePath()
    local go = traversePath:GetGameObject()
    go.Parent:CallScript("ChainedObjectDrop")
  end
end
function LuaHook_IncrementAxeQuest(creature)
  if game.GetNewGamePlus() == true then
    local axeStage = creature:PickupGetStage("Axe")
    if axeStage < 5 then
      LD.ActivateQuest("Quest_AxeUpgrade_Parent")
      game.QuestManager.IncrementQuestProgress("Quest_AxeUpgrade_Find", 1)
      local frozenFlameCount = game.Wallets.GetResourceValue("HERO", "AxeReinforcement")
      local success, progress, goal = game.QuestManager.GetQuestProgressAndGoal("Quest_AxeUpgrade_Find")
      if success and progress < axeStage + frozenFlameCount then
        game.QuestManager.IncrementQuestProgress("Quest_AxeUpgrade_Find", math.min(goal, axeStage + frozenFlameCount) - progress)
      end
      success, progress, goal = game.QuestManager.GetQuestProgressAndGoal("Quest_AxeUpgrade_Craft")
      if success and axeStage > progress then
        game.QuestManager.IncrementQuestProgress("Quest_AxeUpgrade_Craft", math.min(goal, axeStage) - progress)
      end
    end
  else
    LD.ActivateQuest("Quest_AxeUpgrade_Parent")
    game.QuestManager.IncrementQuestProgress("Quest_AxeUpgrade_Find", 1)
  end
end
function LuaHook_IncrementBladesQuest()
  local creature = game.Player.FindPlayer()
  if game.GetNewGamePlus() == true and creature:PickupIsAcquired("Blades") then
    local bladesStage = creature:PickupGetStage("Blades")
    if bladesStage < 4 then
      LD.ActivateQuest("Quest_BladesUpgrade_Parent")
      game.QuestManager.IncrementQuestProgress("Quest_BladesUpgrade_Find", 1)
      local chaosFlameCount = game.Wallets.GetResourceValue("HERO", "BladesReinforcement")
      local success, progress, goal = game.QuestManager.GetQuestProgressAndGoal("Quest_BladesUpgrade_Find")
      if success and progress < bladesStage + chaosFlameCount then
        game.QuestManager.IncrementQuestProgress("Quest_BladesUpgrade_Find", math.min(goal, bladesStage + chaosFlameCount) - progress)
      end
      success, progress, goal = game.QuestManager.GetQuestProgressAndGoal("Quest_BladesUpgrade_Craft")
      if success and bladesStage > progress then
        game.QuestManager.IncrementQuestProgress("Quest_BladesUpgrade_Craft", math.min(goal, bladesStage) - progress)
      end
    end
  else
    LD.ActivateQuest("Quest_BladesUpgrade_Parent")
    game.QuestManager.IncrementQuestProgress("Quest_BladesUpgrade_Find", 1)
  end
end
function LuaHook_CraftFirstBladesReinforce()
  game.Wallets.Craft("HERO", "Recipe_ReinforceBlades_Tier02")
end
function LuaHook_FinishQuestFirstBladesReinforce()
  game.QuestManager.IncrementQuestProgress("Quest_BladesUpgrade_Craft", 1)
end
function SetCurrentCarryObject(creature, obj)
  if obj ~= nil then
    currentCarry = obj
  end
end
function AttemptToDropCurrentCarry(creature, obj)
  if currentCarry ~= nil and creature:HasMarker("CrystalCarry") then
    currentCarry:CallScript("StartCarryExit")
  end
end
function ClearCurrentCarryObject()
  currentCarry = nil
end
function SetCurrentBaseObject(creature, obj)
  if obj ~= nil then
    currentBase = obj
    PassBaseToCrystal()
  end
end
function PassBaseToCrystal()
  if currentCarry ~= nil and currentBase ~= nil then
    currentCarry:CallScript("SetCurrentBaseOnCrystal", currentBase)
  end
end
function ClearCurrentBaseObject()
  currentBase = nil
end
function LuaHook_SetCrystalSocketed()
  if currentCarry ~= nil then
    currentCarry:CallScript("OnPutDown")
    currentCarry:CallScript("SetSocketed", true)
  end
end
function LuaHookDecision_RageR1SpeedUpCheck(player)
  local target = player:GetTargetCreature()
  if target ~= nil and DL.GetDistanceBetweenTwoObjects(player, target) < 5 then
    return true
  end
  return false
end
function LuaHookDecision_CanRageSeekPunchInAirToTarget(player)
  local target = player:GetTargetCreature()
  if target == nil then
    return false
  end
  local targetPos = target:GetWorldPosition()
  local playerPos = player:GetWorldPosition()
  playerPos.y = playerPos.y + 0.5
  targetPos.y = playerPos.y
  local playerToTarget = targetPos - playerPos
  targetPos = targetPos + playerToTarget:Normalized() * 0.5
  local hit = game.World.RaycastCollision(playerPos, targetPos, {
    SourceGameObject = player,
    EntityType = game.CollisionType.New("kEnvironment", "kInvisibleBarrier")
  }, false)
  if hit == nil then
    return true
  else
    return false
  end
end
function LuaHook_RemoveBloodFromHero(player)
  game.Combat.ForceBloodDecayInCombat(true)
end
function LuaHook_AddBlood_Baldur_MMA_Reaction(player)
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.1)
end
function LuaHook_AddBlood_Baldur_MMA_LeftHand(player)
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.4)
end
function LuaHook_AddBlood_Baldur_MMA_RightHand(player)
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.4)
end
function LuaHook_AddBlood_Baldur_Pummel(player)
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.025)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.025)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.025)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.05)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.1)
end
function LuaHook_AddBlood_Magni_Finisher(player)
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kBackAbdomen, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.2)
end
function LuaHook_Effort_Lift_Loop()
  PlaySoundOnKratosMouth(nil, "SND_vo_glb_cbt_exrt_nav_breath_lift_LP")
end
function LuaHook_Effort_Lift_Loop_Stop()
  StopSoundOnKratosMouth(nil, "SND_vo_glb_cbt_exrt_nav_breath_lift_LP")
end
function LuaHook_Effort_Push_Loop()
  PlaySoundOnKratosMouth(nil, "SND_vo_glb_cbt_exrt_nav_breath_push_LP")
end
function LuaHook_Effort_Push_Loop_Stop()
  StopSoundOnKratosMouth(nil, "SND_vo_glb_cbt_exrt_nav_breath_push_LP")
end
function LuaHook_Effort_Struggle_Loop()
  PlaySoundOnKratosMouth(nil, "SND_vo_glb_cbt_exrt_nav_breath_struggle_LP")
end
function LuaHook_Effort_Struggle_Loop_Stop()
  StopSoundOnKratosMouth(nil, "SND_vo_glb_cbt_exrt_nav_breath_struggle_LP")
end
function LuaHook_SetFrozenStateTrue(C, data)
  heroIsFrozen = true
end
function LuaHookDecision_IsDefaultRageModeInput(C, data)
  if game.GetEnterRageModeOptionNumber ~= nil and game.GetEnterRageModeOptionNumber() == 1 then
    return false
  end
  return true
end
function LuaHook_ClearRageModeUIMessage(C, data)
  uiCalls.DisableMechanicRage()
end
function SprintAccessibilityCheck(C)
  if C.Pad then
    if C.Pad.NormalizedLeftStick.y > 0.2 and (math.abs(C.Pad.DampedLeftStick.x) > 0.5 or math.abs(C.Pad.DampedLeftStick.y) > 0.5) then
      global.sprintAccessibilityTimeHeld = global.sprintAccessibilityTimeHeld + C:GetUnitTime()
      if global.sprintAccessibilityTimeHeld > game.GetAutoSprintDelay() then
        C:TriggerMoveEvent("kLE_SprintAccessibility")
        global.sprintAccessibilityTimeHeld = 0
      end
    else
      global.sprintAccessibilityTimeHeld = 0
    end
  end
end
