local timer = require("creature.timer")
local DL = require("design.DesignerLibrary")
local playerCreature = game.Player.FindPlayer()
local conRumbleLight = {EffectName = "FFB_MEDIUM", Duration = 1}
local currentRageMeter, currentComboMeter, talismanPickupStage, specialPickup, lightSpecialAvailable, heavySpecialAvailable
local perkChance = {}
perkChance.CriticalAxeThrow = 18
perkChance.CriticalAxeThrowHealth = 12
perkChance.BladeAirGrapple = 20
perkChance.Launch = 18
perkChance.AxeHeavyHold = 30
perkChance.AxeHeavyHoldHealth = 18
perkChance.ParryHigh = 24
perkChance.ParryLow = 16
perkChance.ProcMed = 3.25
perkChance.ProcLow = 2.75
perkChance.ProcUltraLow = 1.85
perkChance.ProcTimeBubble = 1
perkChance.WeaponSpecialHigh = 36
perkChance.WeaponSpecialLow = 18
perkChance.WeaponSpecialRunicKill = 35
perkChance.WeaponSpecial_InstantRefresh = 6
perkChance.BlockLow = 7
perkChance.TakeDamageVeryLow = 3
perkChance.TakeDamageLow = 6
perkChance.TakeDamageMed = 10
perkChance.EvadeBuff = 14
perkChance.EvadeHeal = 8
perkChance.LowHealth = 26
perkChance.OnKillHigh = 16
local hitCounterDrain = false
function LuckAttributeRoll(initialRoll)
  local Luck = playerCreature.AttributeGetValue(playerCreature, "Luck")
  local ModRoll
  local beginningRoll = initialRoll
  if 0 < Luck then
    local luckModPct = Luck / 125
    local finalMod = luckModPct + 1
    local ModRoll = finalMod * initialRoll
    return ModRoll
  else
    return beginningRoll
  end
end
local Activate_Buff_RageBurst = function()
  local playerCreature = game.Player.FindPlayer()
  if playerCreature:PickupIsAcquired("Buff_RageBurst") then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
local Activate_Buff_HealthBurst = function()
  local playerCreature = game.Player.FindPlayer()
  if playerCreature:PickupIsAcquired("Buff_HealthBurst") then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local Activate_Buff_CooldownBurst = function()
  local playerCreature = game.Player.FindPlayer()
  if playerCreature:PickupIsAcquired("Buff_CooldownBurst") then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local Activate_Buff_DefenseEnhancement = function()
  if playerCreature:PickupIsAcquired("Buff_DefenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_DefenseEnhancement")
  end
end
local Activate_Buff_RunicEnhancement = function()
  if playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_RunicEnhancement")
  end
end
local Activate_Buff_OffenseEnhancement = function()
  if playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local Activate_Buff_DamageShield = function()
  if playerCreature:PickupIsAvailable("Buff_Shield") then
    playerCreature:PickupActivate("Buff_Shield")
  end
  if playerCreature:PickupIsAcquired("Buff_Shield") ~= true then
    playerCreature:PickupAcquire("Buff_Shield")
  end
end
function MomentumClear()
  if playerCreature:HasMeter("Momentum") then
    playerCreature:MeterSetValue("Momentum", 0)
    playerCreature:CallScript("LuaHook_StopMomentumLoops")
    game.Audio.SetBusLevelRTPCValue("WPN_Axe_Momentum_Level", 0)
  end
  if playerCreature:HasMeter("MomentumBlades") then
    playerCreature:MeterSetValue("MomentumBlades", 0)
  end
  hitCounterDrain = false
end
local HitCounterStartDrain = function()
  hitCounterDrain = true
end
local LuaHook_MomentumAxeIncrease = function()
  hitCounterDrain = false
  if playerCreature:HasMeter("Momentum") then
    game.Audio.SetBusLevelRTPCValue("WPN_Axe_Momentum_Level", playerCreature:MeterGetValue("Momentum") / playerCreature:MeterGetMax("Momentum"))
  end
end
local LuaHook_MomentumBladesIncrease = function()
  hitCounterDrain = false
  if playerCreature:HasMeter("MomentumBlades") then
    game.Audio.SetBusLevelRTPCValue("WPN_Blades_Momentum_Level", playerCreature:MeterGetValue("MomentumBlades") / playerCreature:MeterGetMax("MomentumBlades"))
  end
end
local LuaHook_Perk_OnParry_NidCurse_Heal = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ParryHigh)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_NidCurseHeal") ~= true then
    playerCreature:PickupAcquire("Buff_NidCurseHeal")
  end
end
local LuaHook_Perk_Defense_OnParry_DefenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ParryHigh)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_DefenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_DefenseEnhancement")
  end
end
local LuaHook_Perk_Defense_OnParry_RunicBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ParryHigh)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_RunicEnhancement")
  end
end
local LuaHook_Perk_Defense_OnParry_OffenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ParryHigh)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Defense_OnParry_HealthBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ParryLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_Defense_OnParry_Shield = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ParryLow)
  if rand < activatePercent then
    if playerCreature:PickupIsAcquired("Buff_Shield") ~= true then
      playerCreature:PickupAcquire("Buff_Shield")
    end
    if playerCreature:PickupIsAvailable("Buff_Shield") then
      playerCreature:PickupActivate("Buff_Shield")
    end
  end
end
local LuaHook_Perk_WeaponSpecial_OnActivation_Shield = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialHigh)
  if rand < activatePercent then
    if playerCreature:PickupIsAcquired("Buff_Shield") ~= true then
      playerCreature:PickupAcquire("Buff_Shield")
    end
    if playerCreature:PickupIsAvailable("Buff_Shield") then
      playerCreature:PickupActivate("Buff_Shield")
    end
  end
end
local LuaHook_Perk_Defense_OnParryProjectile_Shield_Explode = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(25)
  if rand < activatePercent then
    if playerCreature:PickupIsAcquired("Buff_Shield_Explode") ~= true then
      playerCreature:PickupAcquire("Buff_Shield_Explode")
    end
    if playerCreature:PickupIsAvailable("Buff_Shield_Explode") then
      playerCreature:PickupActivate("Buff_Shield_Explode")
    end
  end
end
local LuaHook_Perk_Defense_OnBlock_Cooldown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.BlockLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Defense_OnBlock_Rage = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.BlockLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
local LuaHook_Perk_Defense_OnBlock_Rage_Flat = function()
  currentRageMeter = playerCreature.MeterGetValue(playerCreature, "Blood")
  playerCreature:MeterSetValue("Blood", currentRageMeter + 1)
end
local LuaHook_Perk_Defense_OnTakeDamage_Cooldown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.TakeDamageMed)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_FireProc = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(10)
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_FireProc") == 0 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow)
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_FireProc") == 1 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow + 2)
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_FireProc") == 2 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow + 4)
  end
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_ARMOR_PERK_FIRE_PROC",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_FireShield = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(10)
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_FireShield") == 0 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow)
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_FireShield") == 1 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow + 2)
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_FireShield") == 2 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow + 4)
  end
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_DamageShield") ~= true then
    playerCreature:PickupAcquire("Buff_DamageShield")
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_MuspBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(10)
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_MuspBuff") == 0 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow)
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_MuspBuff") == 1 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow + 2)
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_MuspBuff") == 2 then
    activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow + 4)
  end
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_Muspleheim") ~= true then
    playerCreature:PickupAcquire("Buff_Muspleheim")
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_Rage = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_DefenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.TakeDamageLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_DefenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_DefenseEnhancement")
  end
end
local LuaHook_Perk_OnKill_Any_React = function()
  local rand = math.random(0, 100)
  local activatePercent = 100
  local axeObject
  local currentWeapon = playerCreature:GetCurrentWeapon()
  for gameobj in game.Player.FindPlayer():IterateActiveWeapons() do
    if gameobj ~= nil and gameobj.Weapon ~= nil and gameobj.Weapon:GetName() == "axe00" then
      axeObject = gameobj.Weapon
    end
  end
  if currentWeapon ~= nil then
    if currentWeapon == "Axe" or axeObject.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSInFlightOut or axeObject.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSInFlightReturn or axeObject.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSSuspended then
      if playerCreature:PickupIsAcquired("WeaponComponent_NifleheimSpecial02") then
        activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_NidCurseHeal") ~= true then
          playerCreature:PickupAcquire("Buff_NidCurseHeal")
        end
      end
      if playerCreature:PickupIsAcquired("Debuff_Hero_Cursed") then
        playerCreature:PickupRelinquish("Debuff_Hero_Cursed")
        playerCreature:MeterSetValue("Cursed", 0)
      end
      if playerCreature:PickupIsAcquired("Perk_Kill_Any_HealthDrain") and playerCreature:PickupIsAcquired("Buff_HealthBurstSmall") ~= true then
        playerCreature:PickupAcquire("Buff_HealthBurstSmall")
      end
      if playerCreature:PickupIsAcquired("Perk_Flat_OnKill_HealthDrain") and playerCreature:PickupIsAcquired("Buff_HealthBurstSmall") ~= true then
        playerCreature:PickupAcquire("Buff_HealthBurstSmall")
      end
      if playerCreature:PickupIsAcquired("Perk_Flat_OnKill_Rage") and playerCreature:PickupIsAcquired("Buff_RageBurstSmall") ~= true then
        playerCreature:PickupAcquire("Buff_RageBurstSmall")
      end
      if playerCreature:PickupIsAcquired("WeaponComponent_Axe_Valkyrie02") then
        if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_03") == true then
          playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_03")
        end
        if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_02") == true then
          playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_03")
          playerCreature:PickupRelinquish("Buff_PowerOfTheValkyrie_02")
        end
        if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_01") == true then
          playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_02")
          playerCreature:PickupRelinquish("Buff_PowerOfTheValkyrie_01")
        end
        if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_01") ~= true and playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_02") ~= true and playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_03") ~= true then
          playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_01")
        end
      end
    end
    if currentWeapon == "Blades" then
      if playerCreature:PickupIsAcquired("WeaponComponent_Blades_OnKill_OffenseBuff") then
        activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
          playerCreature:PickupAcquire("Buff_OffenseEnhancement")
        end
      end
      if playerCreature:PickupIsAcquired("WeaponComponent_Blades_OnKill_DefenseBuff") then
        activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_DefenseEnhancement") ~= true then
          playerCreature:PickupAcquire("Buff_DefenseEnhancement")
        end
      end
      if playerCreature:PickupIsAcquired("WeaponComponent_Blades_OnKill_CooldownBurst") then
        activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
          playerCreature:PickupAcquire("Buff_CooldownBurst")
        end
      end
      if playerCreature:PickupIsAcquired("WeaponComponent_Blades_OnKill_RunicBuff") then
        activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
          playerCreature:PickupAcquire("Buff_RunicEnhancement")
        end
      end
      if playerCreature:PickupIsAcquired("WeaponComponent_Blades_OnKill_HealthBurst") then
        activatePercent = LuckAttributeRoll(perkChance.ProcMed)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
          playerCreature:PickupAcquire("Buff_HealthBurst")
        end
      end
      if playerCreature:PickupIsAcquired("WeaponComponent_Blades_OnKill_RageBurst") then
        activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
        if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
          playerCreature:PickupAcquire("Buff_RageBurst")
        end
      end
    end
    if playerCreature:PickupIsAcquired("Perk_Kill_Any_Cooldown") then
      activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
      if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
        playerCreature:PickupAcquire("Buff_CooldownBurst")
      end
    end
    if playerCreature:PickupIsAcquired("Perk_Kill_Any_OffenseBuff") then
      activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
      if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
        playerCreature:PickupAcquire("Buff_OffenseEnhancement")
      end
    end
    if playerCreature:PickupIsAcquired("Perk_Kill_Any_RunicBuff") then
      activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
      if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
        playerCreature:PickupAcquire("Buff_RunicEnhancement")
      end
    end
    if playerCreature:PickupIsAcquired("Perk_OnKill_NidCurse_Heal") then
      activatePercent = LuckAttributeRoll(perkChance.OnKillHigh)
      if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_NidCurseHeal") ~= true then
        playerCreature:PickupAcquire("Buff_NidCurseHeal")
      end
    end
  end
end
local LuaHook_Perk_Special_Kill_Callscript = function()
  local rand = math.random(0, 100)
  if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnKill_InstantRefresh") then
    local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecial_InstantRefresh)
    if rand < activatePercent then
      playerCreature:PickupAcquire("Buff_WeaponSpecialRefresh")
    end
  end
  if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnKill_CooldownSubtract") then
    local activatePercent = 100
    if rand < activatePercent then
      playerCreature:PickupAcquire("Buff_RunicEnhancement")
    end
  end
  if playerCreature:PickupIsAcquired("Perk_WeaponSpecial_OnKill_HealthBurst") then
    local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialRunicKill)
    if rand < activatePercent then
      playerCreature:PickupAcquire("Buff_HealthBurstSmall")
    end
  end
end
local LuaHook_Perk_Kill_Freeze = function()
  local rand = math.random(0, 100)
  local activatePercent = 0
  if playerCreature:PickupIsAcquired("Perk_Kill_Freeze_Cooldown") then
    activatePercent = LuckAttributeRoll(25)
    if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
      playerCreature:PickupAcquire("Buff_CooldownBurst")
    end
  end
  if playerCreature:PickupIsAcquired("Perk_Kill_Freeze_HealthDrain") then
    activatePercent = LuckAttributeRoll(25)
    if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
      playerCreature:PickupAcquire("Buff_HealthBurst")
    end
  end
end
local LuaHook_Perk_AxeHeavyHold_NidCurse_Heal = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_NidCurseHeal") ~= true then
    playerCreature:PickupAcquire("Buff_NidCurseHeal")
  end
end
local LuaHook_Perk_Damage_AxeHeavyHold_HealthBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHoldHealth)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_Offense_AxeHeavyHold_HealthBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHoldHealth)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_WeaponComponent_Axe_Valkyrie01 = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_ValkyrieAxe") ~= true then
    playerCreature:PickupAcquire("Buff_ValkyrieAxe")
  end
end
local LuaHook_WeaponComponent_Axe_Valkyrie02_AxeHeavyHold = function()
  if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_03") == true then
    playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_03")
  end
  if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_02") == true then
    playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_03")
    playerCreature:PickupRelinquish("Buff_PowerOfTheValkyrie_02")
  end
  if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_01") == true then
    playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_02")
    playerCreature:PickupRelinquish("Buff_PowerOfTheValkyrie_01")
  end
  if playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_01") ~= true and playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_02") ~= true and playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_03") ~= true then
    playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_01")
  end
end
local LuaHook_WeaponComponent_Blades_Muspelheim01 = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcUltraLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_Muspleheim") ~= true then
    playerCreature:PickupAcquire("Buff_Muspleheim")
  end
end
local LuaHook_WeaponComponent_Blades_Valkyrie01 = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcUltraLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_PowerOfTheValkyrie_01") ~= true then
    playerCreature:PickupAcquire("Buff_PowerOfTheValkyrie_01")
  end
end
local LuaHook_WeaponComponent_Blades_Nidavellir01 = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_AXE_MELEE_DAMAGE_NIDAVELLIR_PROC_BLADES",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_Perk_Damage_AxeHeavyHold_RageBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
local LuaHook_Perk_Offense_AxeHeavyHold_RageBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
local LuaHook_Perk_Damage_AxeHeavyHold_CooldownBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Offense_AxeHeavyHold_OffenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Offense_AxeHeavyHold_RunicBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_RunicEnhancement")
  end
end
local LuaHook_Perk_Offense_AxeHeavyHold_Cooldown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.AxeHeavyHold)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_HealthDrain = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_Proc = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_AXE_MELEE_DAMAGE_PROC",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_ProcLightning = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_AXE_MELEE_DAMAGE_PROC_LIGHTNING",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_WeaponComponent_Blades_OnDamage_ProcFire = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_BLADE_MELEE_DAMAGE_PROC",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_WeaponComponent_Blades_OnDamage_ProcBomb = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcLow)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_BLADE_MELEE_DAMAGE_PROC_BOMB",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_RandomBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent then
    local randomBuffSelection = math.random(0, 2)
    if randomBuffSelection == 0 then
      Activate_Buff_RunicEnhancement()
    end
    if randomBuffSelection == 1 then
      Activate_Buff_DefenseEnhancement()
    end
    if randomBuffSelection == 2 then
      Activate_Buff_OffenseEnhancement()
    end
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_RandomBuff = function()
  local rand = math.random(0, 100)
  local perkChanceStageBonus = 7
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_RandomBuff") == 1 then
    perkChanceStageBonus = 11
  end
  if playerCreature:PickupGetStage("Perk_Defense_OnTakeDamage_RandomBuff") == 2 then
    perkChanceStageBonus = 13
  end
  local activatePercent = LuckAttributeRoll(perkChanceStageBonus)
  if rand < activatePercent then
    local randomBuffSelection = math.random(0, 2)
    if randomBuffSelection == 0 then
      Activate_Buff_RunicEnhancement()
    end
    if randomBuffSelection == 1 then
      Activate_Buff_DefenseEnhancement()
    end
    if randomBuffSelection == 2 then
      Activate_Buff_OffenseEnhancement()
    end
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_ValkyrieBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_ValkyrieProtection") ~= true then
    playerCreature:PickupAcquire("Buff_ValkyrieProtection")
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_MassiveExplosion = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcLow)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_AXE_MELEE_DAMAGE_PROC_MASSIVE_EXPLOSION",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_DeathTouch = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcUltraLow)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_AXE_MELEE_DAMAGE_PROC_DEATH_TOUCH",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_TimeBubble = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcTimeBubble)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_TimeBubble") ~= true then
    playerCreature:PickupAcquire("Buff_TimeBubble")
  end
end
local LuaHook_Perk_Defense_OnTakeDamage_WitchTime = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.TakeDamageVeryLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_TimeBubble") ~= true then
    playerCreature:PickupAcquire("Buff_TimeBubble")
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_SuperArmor = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_SuperArmor") ~= true then
    playerCreature:PickupAcquire("Buff_SuperArmor")
    playerCreature:PickupSetStage("Buff_SuperArmor", 1)
  end
end
local LuaHook_WeaponComponent_NifleheimSpecial01 = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent then
    local concussionParams = {
      Tweak = "CNC_AXE_MELEE_DAMAGE_NIDAVELLIR_PROC",
      WorldLocation = playerCreature:GetWorldPosition(),
      EnemyId = playerCreature:GetID(),
      Creature = playerCreature
    }
    game.Combat.PlayConcussion(concussionParams)
  end
end
local LuaHook_WeaponComponent_NifleheimSpecial02 = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_Weapon_Niflheim = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_Axe_Nid") ~= true then
    playerCreature:PickupAcquire("Buff_Axe_Nid")
  end
end
local LuaHook_Perk_Weapon_Muspelheim = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcMed)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_Axe_Musp") ~= true then
    playerCreature:PickupAcquire("Buff_Axe_Musp")
  end
end
local LuaHook_Perk_Offense_OnMeleeDamage_Shield = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.ProcUltraLow)
  if rand < activatePercent then
    if playerCreature:PickupIsAcquired("Buff_Shield") ~= true then
      playerCreature:PickupAcquire("Buff_Shield")
    end
    if playerCreature:PickupIsAvailable("Buff_Shield") then
      playerCreature:PickupActivate("Buff_Shield")
    end
  end
end
local LuaHook_WeaponComponent_Blades_OnLaunch_Shield = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.Launch)
  if rand < activatePercent then
    if playerCreature:PickupIsAcquired("Buff_Shield") ~= true then
      playerCreature:PickupAcquire("Buff_Shield")
    end
    if playerCreature:PickupIsAvailable("Buff_Shield") then
      playerCreature:PickupActivate("Buff_Shield")
    end
  end
end
local LuaHook_WeaponComponent_Blades_OnLaunch_OffenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.Launch)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Defense_OnJustEvade_OffensiveBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.EvadeBuff)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Defense_OnJustEvade_CooldownBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.EvadeBuff)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Defense_OnJustEvade_HealthBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.EvadeHeal)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_Defense_OnJustEvade_DefensiveBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.EvadeBuff)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_DefenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_DefenseEnhancement")
  end
end
local LuaHook_Perk_Defense_OnJustEvade_RunicBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.EvadeBuff)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_RunicEnhancement")
  end
end
local LuaHook_Perk_Offense_OnLaunch_Shield = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.Launch)
  if rand < activatePercent then
    if playerCreature:PickupIsAcquired("Buff_Shield") ~= true then
      playerCreature:PickupAcquire("Buff_Shield")
    end
    if playerCreature:PickupIsAvailable("Buff_Shield") then
      playerCreature:PickupActivate("Buff_Shield")
    end
  end
end
local LuaHook_Perk_Offense_OnLaunch_OffenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.Launch)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Throw_OnDamage_Cooldown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Throw_OnHeadshot_Rage = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RageBurst") ~= true then
    playerCreature:PickupAcquire("Buff_RageBurst")
  end
end
local LuaHook_Perk_Throw_OnHeadshot_Runic = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrow)
  if rand < activatePercent then
    Activate_Buff_RunicEnhancement()
  end
end
local LuaHook_Perk_OnHeadShot_NidCurse_Heal = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_NidCurseHeal") ~= true then
    playerCreature:PickupAcquire("Buff_NidCurseHeal")
  end
end
local LuaHook_Perk_Throw_OnHeadshot_HealthDrain = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrowHealth)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_KratosArmorTrinket_RageGrab = function()
  if playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_Throw_OnHeadshot_OffenseBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Throw_OnHeadshot_Cooldown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.CriticalAxeThrow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Throw_AirGrapple_Offense = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.BladeAirGrapple)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_OffenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_OffenseEnhancement")
  end
end
local LuaHook_Perk_Throw_AirGrapple_Cooldown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.BladeAirGrapple)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_CooldownBurst") ~= true then
    playerCreature:PickupAcquire("Buff_CooldownBurst")
  end
end
local LuaHook_Perk_Throw_AirGrapple_Defense = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.BladeAirGrapple)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_DefenseEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_DefenseEnhancement")
  end
end
local LuaHook_Perk_Offense_OnMeleeDamageToWoundedEnemy_RageBurst = function()
  if playerCreature:PickupIsAcquired("ForceRageModeDisabled") == false and playerCreature:PickupIsAcquired("ForceRageModeDisabledLTW") == false then
    currentRageMeter = playerCreature.MeterGetValue(playerCreature, "Blood")
    playerCreature:MeterSetValue("Blood", currentRageMeter + 1)
  end
end
local OnUpdate = function(C)
  if playerCreature:HasMeter("Momentum") and hitCounterDrain == true and playerCreature:IsDoingSyncMove() == false then
    if playerCreature:MeterGetValue("Momentum") > 0 then
      game.Audio.SetBusLevelRTPCValue("WPN_Axe_Momentum_Level", playerCreature:MeterGetValue("Momentum") / playerCreature:MeterGetMax("Momentum"))
      playerCreature:CallScript("LuaHook_DrainMomentumLoops", playerCreature:MeterGetValue("Momentum"))
    else
      hitCounterDrain = false
    end
  end
  if playerCreature:HasMeter("MomentumBlades") and hitCounterDrain == true and playerCreature:IsDoingSyncMove() == false then
    if 0 < playerCreature:MeterGetValue("MomentumBlades") then
      game.Audio.SetBusLevelRTPCValue("WPN_Blades_Momentum_Level", playerCreature:MeterGetValue("MomentumBlades") / playerCreature:MeterGetMax("MomentumBlades"))
    else
      hitCounterDrain = false
    end
  end
  if playerCreature:PickupGetStage("Buff_MomentumFull") == 3 then
    if playerCreature:PickupIsAcquired("Perk_Flat_Momentum_Health") and playerCreature:PickupIsAcquired("Buff_HealthBurstSmall") == false then
      playerCreature:PickupAcquire("Buff_HealthBurstSmall")
    end
    if playerCreature:PickupIsAcquired("Perk_Flat_Momentum_Rage") and playerCreature:PickupIsAcquired("Buff_RageBurstSmall") == false then
      playerCreature:PickupAcquire("Buff_RageBurstSmall")
    end
  end
  if playerCreature:PickupIsAcquired("Buff_Shield_Explode") then
    if playerCreature:PickupGetStage("Buff_Shield_Explode") == 1 then
      game.FX.SubmitEffect(conRumbleLight)
    end
    if playerCreature:PickupGetStage("Buff_Shield_Explode") == 2 then
      playerCreature:PickupRelinquish("Buff_Shield_Explode")
    end
  end
  if playerCreature:PickupIsAcquired("Perk_Talisman_WeaponSpecials_Runic") then
    talismanPickupStage = playerCreature:PickupGetStage("Perk_Talisman_WeaponSpecials_Runic")
    if playerCreature:PickupIsSlotUsed("WeaponSpecial_Light") then
      specialPickup = playerCreature:PickupGetPickupNameInSlot("WeaponSpecial_Light")
      lightSpecialAvailable = playerCreature:PickupIsAvailable(specialPickup)
    else
      lightSpecialAvailable = true
    end
    if playerCreature:PickupIsSlotUsed("WeaponSpecial_Heavy") then
      specialPickup = playerCreature:PickupGetPickupNameInSlot("WeaponSpecial_Heavy")
      heavySpecialAvailable = playerCreature:PickupIsAvailable(specialPickup)
    else
      heavySpecialAvailable = true
    end
    if playerCreature:PickupIsAcquired("Buff_Talisman_WeaponSpecials_Runic") ~= true and (lightSpecialAvailable == false or heavySpecialAvailable == false) then
      playerCreature:PickupAcquire("Buff_Talisman_WeaponSpecials_Runic", talismanPickupStage)
    elseif playerCreature:PickupIsAcquired("Buff_Talisman_WeaponSpecials_Runic") and lightSpecialAvailable == true and heavySpecialAvailable == true then
      playerCreature:PickupRelinquish("Buff_Talisman_WeaponSpecials_Runic")
    end
  end
end
local OnDamageReceived = function(playerHealthPercent, playerHealthLowThreshold, playerHealthCriticalThreshold)
  MomentumClear()
  if playerCreature:PickupIsAcquired("Buff_OffenseEnhancement_Combo") == true then
    playerCreature:PickupRelinquish("Buff_OffenseEnhancement_Combo")
  end
  if playerHealthPercent < playerHealthLowThreshold and 0 < playerHealthPercent then
    local rand = math.random(0, 100)
    local LowHealthActivatePercent = LuckAttributeRoll(perkChance.LowHealth)
    if rand < LowHealthActivatePercent then
      if playerCreature:PickupIsAvailable("Perk_Defense_OnLowHealth_OffenseBuff") then
        Activate_Buff_OffenseEnhancement()
      end
      if playerCreature:PickupIsAvailable("Perk_Defense_OnLowHealth_DefenseBuff") then
        Activate_Buff_DefenseEnhancement()
      end
      if playerCreature:PickupIsAvailable("Perk_Defense_OnLowHealth_RunicBuff") then
        Activate_Buff_RunicEnhancement()
      end
      if playerCreature:PickupIsActive("Perk_Defense_OnLowHealth_BuffMuspleheim") then
        playerCreature:PickupAcquire("Buff_Muspleheim")
      end
    end
    if playerCreature:PickupIsActive("Perk_Survivability_Health_Regen") then
      Activate_Buff_DamageShield()
    end
    if playerCreature:PickupIsAvailable("Effect_LowHealth_Shield") then
      Activate_Buff_DamageShield()
      playerCreature:PickupActivate("Effect_LowHealth_Shield")
    end
    if playerCreature:PickupIsAvailable("Effect_LowHealth_Offense") then
      Activate_Buff_OffenseEnhancement()
      playerCreature:PickupActivate("Effect_LowHealth_Offense")
    end
  end
  if playerCreature:PickupIsAcquired("Debuff_Hero_Cursed") then
    playerCreature:MeterSetValue("CursedActive", playerCreature:MeterGetValue("Health"))
  end
end
local LuaHook_Perk_AxeWeaponSpecial_Throwdown = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialHigh)
  if rand < activatePercent then
    Activate_Buff_OffenseEnhancement()
  end
end
local LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialHigh)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_RunicEnhancement")
  end
end
local LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialLow)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_HealthBurst") ~= true then
    playerCreature:PickupAcquire("Buff_HealthBurst")
  end
end
local LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff = function()
  local rand = math.random(0, 100)
  local activatePercent = LuckAttributeRoll(perkChance.WeaponSpecialHigh)
  if rand < activatePercent and playerCreature:PickupIsAcquired("Buff_RunicEnhancement") ~= true then
    playerCreature:PickupAcquire("Buff_RunicEnhancement")
  end
end
local LuaDecision_GetGauntletPunchLevel = function(ai)
  local infinityTags = {
    "Runestone_Tag_InfinitySpace",
    "Runestone_Tag_InfinityPower",
    "Runestone_Tag_InfinityTime",
    "Runestone_Tag_InfinityReality",
    "Runestone_Tag_InfinityMind",
    "Runestone_Tag_InfinitySoul"
  }
  local infinityStoneCount = 0
  local infinityStones = game.Wallets.GetRunesWithFlags("HERO", infinityTags)
  for _, id in pairs(infinityStones) do
    local runeInfo = game.Wallets.GetRuneInfo("HERO", id)
    if runeInfo and (runeInfo.Pickup and runeInfo.Pickup == engine.Hash("KratosArmorTrinket_Gauntlet") or runeInfo.Pickup == engine.Hash("KratosArmorTrinket_Gauntlet_NGP")) then
      infinityStoneCount = infinityStoneCount + 1
    end
  end
  if infinityStoneCount == 1 then
    playerCreature:PickupSetStage("Effect_GauntletTrinketActivation", 1)
  end
  if infinityStoneCount == 2 then
    playerCreature:PickupSetStage("Effect_GauntletTrinketActivation", 1)
  end
  if infinityStoneCount == 3 then
    playerCreature:PickupSetStage("Effect_GauntletTrinketActivation", 2)
  end
  if infinityStoneCount == 0 then
    playerCreature:PickupSetStage("Effect_GauntletTrinketActivation", 0)
  end
end
local InstallHooks = function()
  _G.LuaHook_Perk_OnParry_NidCurse_Heal = LuaHook_Perk_OnParry_NidCurse_Heal
  _G.LuaHook_WeaponComponent_Blades_Muspelheim01 = LuaHook_WeaponComponent_Blades_Muspelheim01
  _G.LuaHook_WeaponComponent_Blades_Nidavellir01 = LuaHook_WeaponComponent_Blades_Nidavellir01
  _G.LuaHook_WeaponComponent_Blades_Valkyrie01 = LuaHook_WeaponComponent_Blades_Valkyrie01
  _G.LuaHook_Perk_AxeHeavyHold_NidCurse_Heal = LuaHook_Perk_AxeHeavyHold_NidCurse_Heal
  _G.LuaHook_Perk_OnHeadShot_NidCurse_Heal = LuaHook_Perk_OnHeadShot_NidCurse_Heal
  _G.LuaHook_Perk_Defense_OnTakeDamage_WitchTime = LuaHook_Perk_Defense_OnTakeDamage_WitchTime
  _G.LuaHook_WeaponComponent_Blades_OnDamage_ProcFire = LuaHook_WeaponComponent_Blades_OnDamage_ProcFire
  _G.LuaHook_WeaponComponent_Blades_OnDamage_ProcBomb = LuaHook_WeaponComponent_Blades_OnDamage_ProcBomb
  _G.LuaHook_WeaponComponent_Blades_OnLaunch_Shield = LuaHook_WeaponComponent_Blades_OnLaunch_Shield
  _G.LuaHook_WeaponComponent_Blades_OnLaunch_OffenseBuff = LuaHook_WeaponComponent_Blades_OnLaunch_OffenseBuff
  _G.LuaHook_Perk_Defense_OnParry_DefenseBuff = LuaHook_Perk_Defense_OnParry_DefenseBuff
  _G.LuaHook_Perk_Defense_OnParry_RunicBuff = LuaHook_Perk_Defense_OnParry_RunicBuff
  _G.LuaHook_WeaponComponent_Axe_Valkyrie01 = LuaHook_WeaponComponent_Axe_Valkyrie01
  _G.LuaHook_WeaponComponent_Axe_Valkyrie02_AxeHeavyHold = LuaHook_WeaponComponent_Axe_Valkyrie02_AxeHeavyHold
  _G.LuaHook_Perk_Defense_OnParry_OffenseBuff = LuaHook_Perk_Defense_OnParry_OffenseBuff
  _G.LuaHook_Perk_Defense_OnParry_HealthBurst = LuaHook_Perk_Defense_OnParry_HealthBurst
  _G.LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst = LuaHook_Perk_WeaponSpecial_OnActivation_HealthBurst
  _G.LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff = LuaHook_Perk_WeaponSpecial_OnActivation_RunicBuff
  _G.LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff = LuaHook_Perk_WeaponSpecial_OnRefresh_RunicBuff
  _G.LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst = LuaHook_Perk_WeaponSpecial_OnRefresh_HealthBurst
  _G.LuaHook_Perk_Defense_OnParry_Shield = LuaHook_Perk_Defense_OnParry_Shield
  _G.LuaHook_Perk_Defense_OnParryProjectile_Shield_Explode = LuaHook_Perk_Defense_OnParryProjectile_Shield_Explode
  _G.LuaHook_Perk_Defense_OnBlock_Cooldown = LuaHook_Perk_Defense_OnBlock_Cooldown
  _G.LuaHook_Perk_AxeWeaponSpecial_Throwdown = LuaHook_Perk_AxeWeaponSpecial_Throwdown
  _G.LuaHook_Perk_Defense_OnJustEvade_CooldownBurst = LuaHook_Perk_Defense_OnJustEvade_CooldownBurst
  _G.LuaHook_Perk_Defense_OnJustEvade_HealthBurst = LuaHook_Perk_Defense_OnJustEvade_HealthBurst
  _G.LuaHook_Perk_Defense_OnJustEvade_OffensiveBuff = LuaHook_Perk_Defense_OnJustEvade_OffensiveBuff
  _G.LuaHook_Perk_Defense_OnJustEvade_RunicBuff = LuaHook_Perk_Defense_OnJustEvade_RunicBuff
  _G.LuaHook_Perk_Defense_OnJustEvade_DefensiveBuff = LuaHook_Perk_Defense_OnJustEvade_DefensiveBuff
  _G.LuaHook_Perk_Defense_OnBlock_Rage = LuaHook_Perk_Defense_OnBlock_Rage
  _G.LuaHook_Perk_WeaponSpecial_OnActivation_Shield = LuaHook_Perk_WeaponSpecial_OnActivation_Shield
  _G.LuaHook_Perk_Defense_OnBlock_Rage_Flat = LuaHook_Perk_Defense_OnBlock_Rage_Flat
  _G.LuaHook_Perk_Defense_OnTakeDamage_Cooldown = LuaHook_Perk_Defense_OnTakeDamage_Cooldown
  _G.LuaHook_Perk_Defense_OnTakeDamage_Rage = LuaHook_Perk_Defense_OnTakeDamage_Rage
  _G.LuaHook_Perk_Defense_OnTakeDamage_FireProc = LuaHook_Perk_Defense_OnTakeDamage_FireProc
  _G.LuaHook_Perk_Defense_OnTakeDamage_FireShield = LuaHook_Perk_Defense_OnTakeDamage_FireShield
  _G.LuaHook_Perk_Defense_OnTakeDamage_MuspBuff = LuaHook_Perk_Defense_OnTakeDamage_MuspBuff
  _G.LuaHook_Perk_Defense_OnTakeDamage_DefenseBuff = LuaHook_Perk_Defense_OnTakeDamage_DefenseBuff
  _G.LuaHook_Perk_OnKill_Any_React = LuaHook_Perk_OnKill_Any_React
  _G.LuaHook_Perk_Special_Kill_Callscript = LuaHook_Perk_Special_Kill_Callscript
  _G.LuaHook_WeaponComponent_NifleheimSpecial01 = LuaHook_WeaponComponent_NifleheimSpecial01
  _G.LuaHook_WeaponComponent_NifleheimSpecial02 = LuaHook_WeaponComponent_NifleheimSpecial02
  _G.LuaHook_Perk_Weapon_Muspelheim = LuaHook_Perk_Weapon_Muspelheim
  _G.LuaHook_Perk_Weapon_Niflheim = LuaHook_Perk_Weapon_Niflheim
  _G.LuaHook_WeaponComponent_NifleheimSpecial02 = LuaHook_WeaponComponent_NifleheimSpecial02
  _G.LuaHook_Perk_Damage_AxeHeavyHold_CooldownBurst = LuaHook_Perk_Damage_AxeHeavyHold_CooldownBurst
  _G.LuaHook_Perk_Damage_AxeHeavyHold_HealthBurst = LuaHook_Perk_Damage_AxeHeavyHold_HealthBurst
  _G.LuaHook_Perk_Damage_AxeHeavyHold_RageBurst = LuaHook_Perk_Damage_AxeHeavyHold_RageBurst
  _G.LuaHook_Perk_Offense_OnLaunch_Shield = LuaHook_Perk_Offense_OnLaunch_Shield
  _G.LuaHook_Perk_Offense_OnLaunch_OffenseBuff = LuaHook_Perk_Offense_OnLaunch_OffenseBuff
  _G.LuaHook_Perk_Offense_AxeHeavyHold_Cooldown = LuaHook_Perk_Offense_AxeHeavyHold_Cooldown
  _G.LuaHook_Perk_Offense_AxeHeavyHold_OffenseBuff = LuaHook_Perk_Offense_AxeHeavyHold_OffenseBuff
  _G.LuaHook_Perk_Offense_AxeHeavyHold_HealthBurst = LuaHook_Perk_Offense_AxeHeavyHold_HealthBurst
  _G.LuaHook_Perk_Offense_AxeHeavyHold_RageBurst = LuaHook_Perk_Offense_AxeHeavyHold_RageBurst
  _G.LuaHook_Perk_Offense_AxeHeavyHold_RunicBuff = LuaHook_Perk_Offense_AxeHeavyHold_RunicBuff
  _G.LuaHook_Perk_Offense_OnMeleeDamage_HealthDrain = LuaHook_Perk_Offense_OnMeleeDamage_HealthDrain
  _G.LuaHook_Perk_Offense_OnMeleeDamage_Shield = LuaHook_Perk_Offense_OnMeleeDamage_Shield
  _G.LuaHook_Perk_Offense_OnMeleeDamage_ProcLightning = LuaHook_Perk_Offense_OnMeleeDamage_ProcLightning
  _G.LuaHook_Perk_Offense_OnMeleeDamage_ValkyrieBuff = LuaHook_Perk_Offense_OnMeleeDamage_ValkyrieBuff
  _G.LuaHook_Perk_Offense_OnMeleeDamage_RandomBuff = LuaHook_Perk_Offense_OnMeleeDamage_RandomBuff
  _G.LuaHook_Perk_Defense_OnTakeDamage_RandomBuff = LuaHook_Perk_Defense_OnTakeDamage_RandomBuff
  _G.LuaHook_Perk_Offense_OnMeleeDamage_MassiveExplosion = LuaHook_Perk_Offense_OnMeleeDamage_MassiveExplosion
  _G.LuaHook_Perk_Offense_OnMeleeDamage_DeathTouch = LuaHook_Perk_Offense_OnMeleeDamage_DeathTouch
  _G.LuaHook_Perk_Offense_OnMeleeDamage_TimeBubble = LuaHook_Perk_Offense_OnMeleeDamage_TimeBubble
  _G.LuaHook_Perk_Offense_OnMeleeDamage_SuperArmor = LuaHook_Perk_Offense_OnMeleeDamage_SuperArmor
  _G.LuaHook_Perk_Throw_OnDamage_Cooldown = LuaHook_Perk_Throw_OnDamage_Cooldown
  _G.LuaHook_Perk_Throw_OnHeadshot_Rage = LuaHook_Perk_Throw_OnHeadshot_Rage
  _G.LuaHook_Perk_Throw_OnHeadshot_OffenseBuff = LuaHook_Perk_Throw_OnHeadshot_OffenseBuff
  _G.LuaHook_Perk_Throw_OnHeadshot_Runic = LuaHook_Perk_Throw_OnHeadshot_Runic
  _G.LuaHook_Perk_Offense_OnMeleeDamage_Proc = LuaHook_Perk_Offense_OnMeleeDamage_Proc
  _G.LuaHook_Perk_Throw_OnHeadshot_HealthDrain = LuaHook_Perk_Throw_OnHeadshot_HealthDrain
  _G.LuaHook_Perk_Throw_OnHeadshot_Cooldown = LuaHook_Perk_Throw_OnHeadshot_Cooldown
  _G.LuaHook_Perk_Throw_AirGrapple_Defense = LuaHook_Perk_Throw_AirGrapple_Defense
  _G.LuaHook_Perk_Throw_AirGrapple_Cooldown = LuaHook_Perk_Throw_AirGrapple_Cooldown
  _G.LuaHook_Perk_Throw_AirGrapple_Offense = LuaHook_Perk_Throw_AirGrapple_Offense
  _G.LuaHook_KratosArmorTrinket_RageGrab = LuaHook_KratosArmorTrinket_RageGrab
  _G.LuaHook_Perk_Offense_OnMeleeDamageToWoundedEnemy_RageBurst = LuaHook_Perk_Offense_OnMeleeDamageToWoundedEnemy_RageBurst
  _G.LuaHook_MomentumAxeIncrease = LuaHook_MomentumAxeIncrease
  _G.LuaDecision_GetGauntletPunchLevel = LuaDecision_GetGauntletPunchLevel
end
return {
  InstallHooks = InstallHooks,
  OnUpdate = OnUpdate,
  OnDamageReceived = OnDamageReceived,
  LuaHook_MomentumAxeIncrease = LuaHook_MomentumAxeIncrease
}
