function SetupPOIStates(POIState)
  local poiSearchParameters_Auto = {
    FindArgs = {
      "PROJECTION",
      "AUTO",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return true
    end
  }
  local poiSearchParameters_Precombat = {
    FindArgs = {
      "PROJECTION",
      "PRECOMBAT",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return global.aggroState ~= "INAGGRO" and global.aggroState ~= "INCOMBAT"
    end
  }
  function POIState:GetSearchParameters(ai, global, constants)
    local parameters = {}
    table.insert(parameters, poiSearchParameters_Precombat)
    table.insert(parameters, poiSearchParameters_Auto)
    return parameters
  end
  local POI_PreCombat = POIState:TypeHandler("POI_PreCombat")
  function POI_PreCombat:IsAvailable(poi, ai, global, constants)
    return poi ~= nil and poi.Type == "PreCombat"
  end
  function POI_PreCombat:Enter(poi, ai, global, constants)
    self.poiPos = poi:GetWorldPosition()
    self.thisPOI = poi
  end
  function POI_PreCombat.Events:OnHitReaction(event, ai, global, constants)
    if self.thisPOI ~= nil then
      self.thisPOI:SendEvent("kEHitReaction")
    end
  end
  function POI_PreCombat:Update(poi, ai, global, constants)
    POIState:OnUpdateAwareness(ai, global, constants)
    self:ApproachPOI(ai, global, constants)
    if global.aggroState == "INAGGRO" or global.aggroState == "INCOMBAT" then
      poi:SendEvent("EndPOI")
    end
  end
end
return {
  SetupPOIStates = SetupPOIStates
}
