local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local weaponObject
local expireTime = 0.5
local holdTime = 0.75
local effects = {}
local lspirit, position, direction
local speed = 10
function OnScriptLoaded(level, go)
  effects[1] = game.FX.Spawn("LightningSpirit", level)
  effects[2] = game.FX.Spawn("LightningSpirit", level)
  effects[3] = game.FX.Spawn("LightningSpirit", level)
  position = go.WorldPosition
  effects[1]:SetWorldPosition(position)
  effects[2]:SetWorldPosition(position + engine.Vector.New(0, 0.25, 0))
  effects[3]:SetWorldPosition(position + engine.Vector.New(0, -0.25, 0))
  direction = game.Player.FindPlayer():GetWorldLeft()
end
function OnUpdate(level, go)
  expireTime = expireTime - level:GetUnitTime()
  if expireTime <= 0 then
    effects[1]:Destroy()
    effects[2]:Destroy()
    effects[3]:Destroy()
    go:Destroy()
  else
    position = position + direction * speed * level:GetUnitTime()
    effects[1]:SetWorldPosition(position)
    effects[2]:SetWorldPosition(position + engine.Vector.New(0, 0.25, 0))
    effects[3]:SetWorldPosition(position + engine.Vector.New(0, -0.25, 0))
    speed = speed * 0.85
  end
end
function UpdateAllEffects(level, go)
  local unittime = level:GetUnitTime()
  for _, i in pairs(effects) do
    i.Life = i.Life - unittime
    if i.Life <= 0 then
      i.Effect:Destroy()
      effects[_] = nil
    end
  end
end
