local DL = require("design.DesignerLibrary")
local phase = 0
local currentTimer = 0
local lightningStrike, camLoc, camRot
function OnScriptLoaded(level, go)
  camLoc = game.Player.FindPlayer().WorldPosition
  camRot = game.Camera.GetOrbitForward()
end
function OnUpdate(level, go)
  if phase == 0 then
    if 0.1 < currentTimer then
      local arrowData = {}
      arrowData.Target = nil
      arrowData.TargetLocation = camLoc + camRot * 3
      arrowData.Tweak = "ARR_ARROW_SHOCK_SCATTER_00"
      arrowData.Creator = game.AI.FindSon()
      arrowData.EmitLocation = camLoc + camRot * 3
      arrowData.EmitOffset = engine.Vector.New(0, 25, 0)
      game.Combat.EmitArrow(arrowData)
      phase = 1
    end
  elseif phase == 1 then
    if 0.4 < currentTimer then
      local arrowData = {}
      arrowData.Target = nil
      arrowData.TargetLocation = camLoc + camRot * 7
      arrowData.Tweak = "ARR_ARROW_SHOCK_SCATTER_00"
      arrowData.Creator = game.AI.FindSon()
      arrowData.EmitLocation = camLoc + camRot * 7
      arrowData.EmitOffset = engine.Vector.New(0, 25, 0)
      game.Combat.EmitArrow(arrowData)
      phase = 2
    end
  elseif phase == 2 then
    if 0.7 < currentTimer then
      local arrowData = {}
      arrowData.Target = nil
      arrowData.TargetLocation = camLoc + camRot * 11
      arrowData.Tweak = "ARR_ARROW_SHOCK_SCATTER_00"
      arrowData.Creator = game.AI.FindSon()
      arrowData.EmitLocation = camLoc + camRot * 11
      arrowData.EmitOffset = engine.Vector.New(0, 25, 0)
      game.Combat.EmitArrow(arrowData)
      phase = 3
    end
  else
    go:Destroy()
  end
  currentTimer = currentTimer + level:GetUnitTime()
end
