local timer = require("level.timer")
local DL = require("design.DesignerLibrary")
local expireTime = 35
local holdTime = 0.75
local origin, son
local enemyList = {}
local multiplier = 100
function OnScriptLoaded(level, go)
  son = game.AI.FindSon()
  local allenemies = game.Player.FindPlayer():FindEnemies(50)
  local distance = 9999
  local thisPos = go.WorldPosition
  if origin == nil then
    for _, i in ipairs(allenemies) do
      local thisDistance = (i.WorldPosition - thisPos):Length()
      if origin == nil then
        distance = thisDistance
        origin = i
      elseif thisDistance < distance then
        origin = i
        distance = thisDistance
      end
    end
  end
  if origin ~= nil then
    SetSparkAttribute()
  end
end
local currentLightningLevel = 0
local sparkTimer = 1
local sparkChance = 0.25
local currentSparkTimer = 0
function SetSparkAttribute()
  local getRuneLevel = origin:PickupGetStage("SonRune")
  sparkTimer = 0.3
  sparkChance = 1
  currentSparkTimer = 0
  if game.Wallets.HasResource("HERO", "SonPerk_ShockArrow_SparkRate") then
    multiplier = 0.5
  end
end
function OnUpdate(level, go)
  local getRuneLevel = -1
  if expireTime <= 0 or origin == nil or origin:IsDead() then
    if origin ~= nil and origin:PickupIsAcquired("SonRune_LightningGenerate") then
      origin:PickupRelinquish("SonRune_LightningGenerate")
    end
    go:Destroy()
    return
  end
  if origin:PickupIsAcquired("SonRune") == false then
    if origin:PickupIsAcquired("SonRune_LightningGenerate") then
      origin:PickupRelinquish("SonRune_LightningGenerate")
    end
    go:Destroy()
    return
  end
  if origin:PickupIsAcquired("SonRune") then
    local runestage = origin:PickupGetStage("SonRune")
    if runestage == 0 then
      sparkTimer = 1 * multiplier
      sparkChance = 1
    elseif runestage == 1 then
      sparkTimer = 0.75 * multiplier
      sparkChance = 1
    else
      sparkTimer = 0.5 * multiplier
      sparkChance = 1
    end
  end
  if currentSparkTimer > sparkTimer then
    currentSparkTimer = 0
    if math.random() < sparkChance then
      sparkTimer = math.random(0, 1) * 0.3 + 0.015
      local friendlyai = origin:FindFriendlies(8)
      local randomAISelectionIndex = 0
      if 0 < #friendlyai then
        for i = #friendlyai, 1, -1 do
          if friendlyai[i] == origin then
            table.remove(friendlyai, i)
          end
        end
        if 0 < #friendlyai then
          randomAISelectionIndex = math.random(1, #friendlyai)
        end
      end
      local randomvalue = math.random(0, 1)
      local arrowData = {}
      arrowData.Tweak = "ARR_SPARK_SPAWN"
      arrowData.Creator = son
      local newPos = origin:GetWorldJointPosition(origin:GetJointIndex("JOPelvis1"))
      local angle = DL.GetAngleFromVectors(son:GetWorldForward(), engine.Vector.New(1, 0, 0))
      arrowData.EmitOffset = (newPos - son.WorldPosition - engine.Vector.New(0, 0, -1)):RotateXZ(angle - 90) + engine.Vector.New(0, newPos.y, 0)
      if 0 < randomAISelectionIndex then
        arrowData.Target = friendlyai[randomAISelectionIndex]
        game.Combat.EmitArrow(arrowData)
      end
    end
  end
  local unitTime = level:GetUnitTime()
  expireTime = expireTime - unitTime
  currentSparkTimer = currentSparkTimer + unitTime
end
