local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local lineTrail, trackObject, startingPos, travelPercentage
local travelDistance = 0
local travelIncrement = 0.05
local travelSpeed = 40
local shockExploded = false
local trailName = "bifrost_projectile"
local concussionType = "CNC_LIGHTNING_AXE_COMBO"
local delayedInit = 0
local powerupHero = "none"
function OnScriptLoaded(level, go, ...)
end
function OnUpdate(level, go)
  if delayedInit == 1 then
    local sonBB = game.AI.FindSon():GetBlackboard()
    if sonBB:IsObject("ArrowTrackObject") then
      trackObject = sonBB:GetObject("ArrowTrackObject")
    end
    if sonBB:IsNumber("ArrowType") then
      local number = sonBB:GetNumber("ArrowType")
      if number == 0 then
        trailName = "ElectricShock_Line"
      end
    end
    if sonBB:IsNumber("ArrowTrackConcussion") then
      local number = sonBB:GetNumber("ArrowTrackConcussion")
      local axe
      if axe == nil then
        for weapon in game.Player.FindPlayer():IterateActiveWeapons() do
          if weapon ~= nil and weapon.Weapon ~= nil and weapon.Weapon:GetName() == "axe00" then
            axe = weapon.Weapon
            break
          end
        end
      end
      if axe ~= nil and axe == trackObject then
        if number == 100 then
          powerupHero = "axe"
        elseif number == 101 then
          powerupHero = "shield"
        else
          concussionType = "CNC_LIGHT_AXE_COMBO"
        end
      elseif number == 1 then
        concussionType = "CNC_LIGHTNING_AXE_COMBO"
      end
    end
    startingPos = go.WorldPosition
    travelPercentage = 0
    if trackObject ~= nil then
      if powerupHero == "axe" then
        travelDistance = (startingPos - DL.GetWorldJointPositionByName(trackObject, "weaponEmbedJoint")):Length()
      elseif powerupHero == "shield" then
        travelDistance = (startingPos - DL.GetWorldJointPositionByName(trackObject, "zerojoint")):Length()
      else
        travelDistance = (startingPos - trackObject.WorldPosition):Length()
      end
    end
    delayedInit = delayedInit + 1
  else
    delayedInit = delayedInit + 1
    if delayedInit == 1 then
      return
    end
  end
  if trackObject == nil then
    shockExploded = true
  end
  if shockExploded == false then
    if 1 <= travelPercentage then
      if powerupHero == "axe" then
        local player = game.Player.FindPlayer()
        if not player:PickupIsAcquired("SonRune_ShockPowerup") then
          player:PickupAcquire("SonRune_ShockPowerup")
        end
        player:PickupSetStage("SonRune_ShockPowerup", 1)
        player:TriggerMoveEvent("kLE_SonPowerUp")
        local effect = game.FX.Spawn("Electric_Hit_FX_JOBack3", level, {AutoDelete = true})
        effect:SetWorldPosition(DL.GetWorldJointPositionByName(trackObject, "weaponEmbedJoint"))
      elseif powerupHero == "shield" then
        local player = game.Player.FindPlayer()
        if not player:PickupIsAcquired("SonRune_ShockPowerup") then
          player:PickupAcquire("SonRune_ShockPowerup")
        end
        player:PickupSetStage("SonRune_ShockPowerup", 1)
        player:TriggerMoveEvent("kLE_SonPowerUp")
        local effect = game.FX.Spawn("Electric_Hit_FX_JOBack3", level, {AutoDelete = true})
        effect:SetWorldPosition(DL.GetWorldJointPositionByName(trackObject, "zerojoint"))
      else
        local concussionParams = {}
        concussionParams.WorldLocation = trackObject.WorldPosition
        concussionParams.Creature = game.AI.FindSon()
        concussionParams.EnemyId = DL.HashCreatureID(game.Player.FindPlayer(), "SON00")
        concussionParams.Tweak = concussionType
        game.Combat.PlayConcussion(concussionParams)
      end
      shockExploded = true
    else
      local newPos
      if powerupHero == "axe" then
        newPos = (DL.GetWorldJointPositionByName(trackObject, "weaponEmbedJoint") - startingPos) * travelPercentage + startingPos
      elseif powerupHero == "shield" then
        newPos = (DL.GetWorldJointPositionByName(trackObject, "zerojoint") - startingPos) * travelPercentage + startingPos
      else
        newPos = (trackObject.WorldPosition - startingPos) * travelPercentage + startingPos
      end
      MoveLineTrail(level, go, newPos)
      travelPercentage = travelPercentage + travelSpeed * level:GetUnitTime() / travelDistance
    end
  else
    engine.SendHook("LuaHook_RemoveTrackingObject", game.AI.FindSon())
    go:Destroy()
    if lineTrail ~= nil then
      lineTrail:Destroy()
    end
  end
end
function MoveLineTrail(level, go, newPos)
  if lineTrail == nil then
    lineTrail = game.FX.Spawn(trailName, level)
  end
  lineTrail:SetWorldPosition(newPos)
end
