local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local lineTrail, trackObject, startingPos, travelPercentage
local travelDistance = 0
local travelIncrement = 0.05
local travelSpeed = 2.5
local travelSpeedAcceleration = 1
local travelSpeedMax = 5
local shockExploded = false
local concussionType = "CNC_LIGHTNING_AXE_COMBO"
local delayedInit = 0
local powerupHero = "none"
function OnScriptLoaded(level, go, ...)
end
function OnUpdate(level, go)
  if delayedInit == 1 then
    local sonBB = game.AI.FindSon():GetBlackboard()
    if sonBB:IsObject("ArrowTrackObject") then
      trackObject = sonBB:GetObject("ArrowTrackObject")
    else
      trackObject = {}
      trackObject.WorldPosition = sonBB:GetVector("ArrowTrackLocation")
    end
    startingPos = go.WorldPosition
    travelPercentage = 0
    if trackObject ~= nil then
      travelDistance = (startingPos - trackObject.WorldPosition):Length()
    end
    delayedInit = delayedInit + 1
  else
    delayedInit = delayedInit + 1
    if delayedInit == 1 then
      return
    end
  end
  if trackObject == nil then
    shockExploded = true
  end
  if shockExploded == false then
    if 1 <= travelPercentage then
      local concussionParams = {}
      concussionParams.WorldLocation = trackObject.WorldPosition
      concussionParams.Creature = game.AI.FindSon()
      concussionParams.EnemyId = DL.HashCreatureID(game.Player.FindPlayer(), "SON00")
      concussionParams.Tweak = "CNC_LIGHT_ARC_SHOT_EXPLOSION"
      game.Combat.PlayConcussion(concussionParams)
      shockExploded = true
    else
      local newPos
      local parabola = math.sin(math.rad(travelPercentage * 180)) * 6 * (travelDistance / (travelDistance + 15))
      newPos = (trackObject.WorldPosition - startingPos) * travelPercentage + startingPos + engine.Vector.New(0, parabola, 0)
      MoveLineTrail(level, go, newPos)
      travelPercentage = travelPercentage + travelSpeed * level:GetUnitTime() / travelDistance
      travelSpeed = travelSpeed + travelSpeedAcceleration * level:GetUnitTime()
      if travelSpeed > travelSpeedMax then
        travelSpeed = travelSpeedMax
      end
      EmitArrows(level, newPos)
    end
  else
    engine.SendHook("LuaHook_RemoveTrackingObject", game.AI.FindSon())
    go:Destroy()
    if lineTrail ~= nil then
      lineTrail:Destroy()
    end
  end
end
local tickTimer = 0.3
local currentTickTimer = 0
local shotRadius = 10
function EmitArrows(level, newPos)
  if currentTickTimer >= tickTimer then
    currentTickTimer = 0
    local player = game.Player.FindPlayer()
    local enemies = player:FindEnemies(100)
    local enemiesInRange = {}
    for _, i in ipairs(enemies) do
      if (i.WorldPosition - newPos):Length() < shotRadius then
        table.insert(enemiesInRange, i)
      end
    end
    if 0 < #enemiesInRange then
      local randomIndex = math.random(1, #enemiesInRange)
      local son = game.AI.FindSon()
      local arrowData = {}
      arrowData.Tweak = "ARR_ARROW_LIGHT_ARC_MINI_LUA"
      arrowData.Creator = son
      local angle = DL.GetAngleFromVectors(son:GetWorldForward(), engine.Vector.New(1, 0, 0))
      arrowData.EmitOffset = (newPos - son.WorldPosition - engine.Vector.New(-0, 0, 0)):RotateXZ(angle - 90) + engine.Vector.New(0, newPos.y, 0)
      arrowData.Target = enemiesInRange[randomIndex]
      game.Combat.EmitArrow(arrowData)
    end
  end
  currentTickTimer = currentTickTimer + level:GetUnitTime()
end
function MoveLineTrail(level, go, newPos)
  if lineTrail == nil then
    lineTrail = game.FX.Spawn("ArcShot_Light_Shot_Orb", level)
  end
  lineTrail:SetWorldPosition(newPos)
end
