local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local orbObject
local projectileCount = 18
local projectiles = {}
local origin
local delayedInit = 0
function OnScriptLoaded(level, go, ...)
end
function SetPosition(level, thisArrow)
  local pos = engine.Vector.New(0, 0, thisArrow.distance):RotateXZ(thisArrow.rotation) + engine.Vector.New(0, thisArrow.height + thisArrow.heightOffset + math.sin(thisArrow.sinValue) * 0.25, 0)
  thisArrow.gameObject:SetWorldPosition(pos + origin)
end
function InitArrows(level, go)
  origin = game.Player.FindPlayer().WorldPosition
  for i = 1, projectileCount do
    local arrow = {}
    arrow.lifetime = i * 0.15 + 3
    arrow.rotation = math.random() * 360
    arrow.distance = 0
    arrow.maxDistance = math.random() * 4 + 3
    arrow.gameObject = game.FX.Spawn("bifrost_projectile", level)
    arrow.height = 0.5 + math.random() * 2
    arrow.heightOffset = 5 + math.random() * 6
    arrow.sinValue = math.random() * 6.28
    SetPosition(level, arrow)
    table.insert(projectiles, arrow)
  end
end
function OnUpdate(level, go)
  if delayedInit == 1 then
    InitArrows(level, go)
    delayedInit = delayedInit + 1
  else
    delayedInit = delayedInit + 1
    if delayedInit == 1 then
      return
    end
  end
  UpdateArrow(level)
  if #projectiles <= 0 then
    go:Destroy()
  end
end
function UpdateArrow(level)
  local sizeProjectile = #projectiles
  local unitTime = level:GetUnitTime()
  for i = sizeProjectile, 1, -1 do
    projectiles[i].lifetime = projectiles[i].lifetime - unitTime
    projectiles[i].heightOffset = projectiles[i].heightOffset * 0.99
    projectiles[i].distance = projectiles[i].distance + unitTime * 5
    projectiles[i].sinValue = projectiles[i].sinValue + unitTime * 6.28
    if projectiles[i].distance >= projectiles[i].maxDistance then
      projectiles[i].distance = projectiles[i].maxDistance
    end
    if projectiles[i].lifetime <= 0 then
      SpawnProjectile(level, projectiles[i].gameObject.WorldPosition)
      projectiles[i].gameObject:Destroy()
      table.remove(projectiles, i)
    else
      projectiles[i].rotation = projectiles[i].rotation + 90 * unitTime
      SetPosition(level, projectiles[i])
    end
  end
end
function SpawnProjectile(level, pos)
  local explosion = game.FX.Spawn("light_impact_Frozen", level, {AutoDelete = true})
  explosion:SetWorldPosition(pos)
  local player = game.Player.FindPlayer()
  local enemies = player:FindEnemies(45)
  if 0 < #enemies then
    local randomIndex = math.random(1, #enemies)
    local son = game.AI.FindSon()
    local arrowData = {}
    arrowData.Tweak = "ARR_ARROW_LIGHT_ARC_MINI_LUA"
    arrowData.Creator = son
    local angle = DL.GetAngleFromVectors(son:GetWorldForward(), engine.Vector.New(1, 0, 0))
    arrowData.EmitOffset = (pos - son.WorldPosition - engine.Vector.New(-0, 0, 0)):RotateXZ(angle - 90) + engine.Vector.New(0, pos.y, 0)
    arrowData.Target = enemies[randomIndex]
    game.Combat.EmitArrow(arrowData)
  end
end
