local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local lightningObj
local delayedInit = 0
local origin, player
local lightningBeams = {}
function OnScriptLoaded(level, go, ...)
  player = game.Player.FindPlayer()
  origin = player.WorldPosition + player:GetWorldForward() * 10
end
function AddLightning(level, location, target, size)
  local lightningColumn = {}
  lightningColumn.location = location
  lightningColumn.size = size
  lightningColumn.target = target
  lightningColumn.lifetime = 3.5
  lightningColumn.explosionTime = 0.01
  lightningColumn.explosionTimeMax = 1
  lightningColumn.speed = 4
  lightningColumn.spawned = false
  lightningColumn.goColumn = game.FX.Spawn("ElectricBreath_Beam_FX", level)
  lightningColumn.goColumn:SetWorldOrientation(90, 0, 0)
  lightningColumn.goColumn:SetWorldPosition(location)
  lightningColumn.goGround = game.FX.Spawn("Electric_Ground_Shock", level)
  lightningColumn.goGround:SetWorldPosition(location)
  table.insert(lightningBeams, lightningColumn)
end
function UpdateLightning(level)
  local sizeProjectile = #lightningBeams
  local unitTime = level:GetUnitTime()
  for i = sizeProjectile, 1, -1 do
    lightningBeams[i].lifetime = lightningBeams[i].lifetime - unitTime
    lightningBeams[i].explosionTime = lightningBeams[i].explosionTime - unitTime
    if lightningBeams[i].spawned == false and lightningBeams[i].goColumn ~= nil and lightningBeams[i].goGround ~= nil then
      lightningBeams[i].spawned = true
      lightningBeams[i].goColumn:SetScale(lightningBeams[i].size)
      lightningBeams[i].goGround:SetScale(lightningBeams[i].size * 3)
    end
    if lightningBeams[i].lifetime <= 0 then
      lightningBeams[i].goColumn:Destroy()
      lightningBeams[i].goGround:Destroy()
      table.remove(lightningBeams, i)
    else
      if lightningBeams[i].target ~= nil then
        local direction = (lightningBeams[i].target.WorldPosition - lightningBeams[i].location):Normalized() * lightningBeams[i].speed * unitTime
        lightningBeams[i].location = lightningBeams[i].location + direction
        lightningBeams[i].goColumn:SetWorldPosition(lightningBeams[i].location - engine.Vector.New(0, 1, 0))
        lightningBeams[i].goGround:SetWorldPosition(lightningBeams[i].location + engine.Vector.New(0, 0.15, 0))
      end
      if lightningBeams[i].explosionTime <= 0 then
        lightningBeams[i].explosionTime = lightningBeams[i].explosionTimeMax
        local concussionParams = {}
        concussionParams.WorldLocation = lightningBeams[i].location
        concussionParams.Creature = game.AI.FindSon()
        concussionParams.EnemyId = DL.HashCreatureID(game.Player.FindPlayer(), "SON00")
        concussionParams.Tweak = "CNC_RAIN_SHOCK_EXPLOSION"
        game.Combat.PlayConcussion(concussionParams)
      end
    end
  end
end
function SendOutLightning(level)
  local enemies = player:FindEnemies(45)
  AddLightning(level, origin, nil, 0.5)
  for _, i in ipairs(enemies) do
    AddLightning(level, origin, i, 0.2)
  end
end
function OnUpdate(level, go)
  if delayedInit == 1 then
    delayedInit = delayedInit + 1
  else
    delayedInit = delayedInit + 1
    if delayedInit == 1 then
      SendOutLightning(level)
      return
    end
  end
  UpdateLightning(level)
  if #lightningBeams <= 0 then
    go:Destroy()
  end
end
