local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local summonedGO, summonedGO2
local state = "introAnim"
local state2 = "introAnim"
local counter = 0
local position, position2, slamPosition, clawFX, clawFX2, indexNum, indexNum2, unitTime, velocity, velocity2, direction, direction2
function OnScriptLoaded(level, go)
  summonedGO = game.FX.Spawn("bear10", level)
  summonedGO2 = game.FX.Spawn("bear10", level)
  local camFacing = game.Camera.GetOrbitForward()
  camFacing.y = 0
  slamPosition = game.Player.FindPlayer().WorldPosition + camFacing * 10
  position = slamPosition + (camFacing * 10):RotateXZ(40)
  position2 = slamPosition + (camFacing * 15):RotateXZ(-40)
  summonedGO:SetWorldPosition(position)
  summonedGO2:SetWorldPosition(position2)
  local spawnfx = game.FX.Spawn("SonTeleport_Enter", level, {AutoDelete = true})
  spawnfx:SetWorldPosition(position)
  local spawnfx2 = game.FX.Spawn("SonTeleport_Enter", level, {AutoDelete = true})
  spawnfx2:SetWorldPosition(position2)
end
function OnUpdate(level, go)
  unitTime = level:GetUnitTime()
  counter = counter + 1
  if counter == 1 then
    return
  end
  Bear1Update(level, go)
  Bear2Update(level, go)
end
function Bear2Update(level, go)
  if state2 == "introAnim" then
    summonedGO2:StartMaterialAnim("navCanterF")
    direction2 = (slamPosition - summonedGO2.WorldPosition):Normalized()
    summonedGO2:SetWorldFacing(direction2)
    state2 = "approach"
  elseif state2 == "approach" then
    local newPos = summonedGO2.WorldPosition
    newPos = newPos + direction2 * 10 * unitTime
    summonedGO2:SetWorldPosition(newPos)
    if (slamPosition - newPos):Length() < 8 then
      state2 = "introFinish"
    end
  elseif state2 == "introFinish" then
    summonedGO2:StartMaterialAnim("attSlam_1")
    indexNum2 = summonedGO2:GetJointIndex("JORightToe1")
    if indexNum2 ~= nil then
      clawFX2 = game.FX.Spawn("bifrost_projectile", level)
      clawFX2:SetWorldPosition(summonedGO2:GetWorldJointPosition(indexNum))
    end
    state2 = "slam"
    local inSeconds = 0.6333333
    velocity2 = (slamPosition - summonedGO2.WorldPosition):Length() / inSeconds
  elseif state2 == "slam" then
    UpdateClawEffect2(level, go)
    local newPos = summonedGO2.WorldPosition + direction2 * velocity2 * unitTime
    summonedGO2:SetWorldPosition(newPos)
    if summonedGO2.AnimFrame > 19 then
      state2 = "explosion"
      local concussionParams = {}
      concussionParams.WorldLocation = summonedGO2.WorldPosition
      concussionParams.Creature = game.AI.FindSon()
      concussionParams.EnemyId = DL.HashCreatureID(game.Player.FindPlayer(), "SON00")
      concussionParams.Tweak = "CNC_LIGHT_ARC_SHOT_EXPLOSION"
      game.Combat.PlayConcussion(concussionParams)
    end
  elseif state2 == "explosion" then
    local spawnfx = game.FX.Spawn("SonTeleport_Enter", level, {AutoDelete = true})
    spawnfx:SetWorldPosition(summonedGO2.WorldPosition)
    clawFX2:Destroy()
    summonedGO2:Destroy()
    state2 = "done"
  end
end
function Bear1Update(level, go)
  if state == "introAnim" then
    summonedGO:StartMaterialAnim("navIdle")
    direction = (slamPosition - summonedGO.WorldPosition):Normalized()
    summonedGO:SetWorldFacing(direction)
    state = "introFinish"
  elseif state == "introFinish" then
    summonedGO:StartMaterialAnim("attSlam")
    indexNum = summonedGO:GetJointIndex("JOLeftToe1")
    if indexNum ~= nil then
      clawFX = game.FX.Spawn("bifrost_projectile", level)
      clawFX:SetWorldPosition(summonedGO:GetWorldJointPosition(indexNum))
    end
    state = "slam"
    local inSeconds = 0.6333333
    velocity = (slamPosition - summonedGO.WorldPosition):Length() / inSeconds
  elseif state == "slam" then
    UpdateClawEffect(level, go)
    local newPos = summonedGO.WorldPosition + direction * velocity * unitTime
    summonedGO:SetWorldPosition(newPos)
    if summonedGO.AnimFrame > 19 then
      state = "explosion"
      local concussionParams = {}
      concussionParams.WorldLocation = summonedGO.WorldPosition
      concussionParams.Creature = game.AI.FindSon()
      concussionParams.EnemyId = DL.HashCreatureID(game.Player.FindPlayer(), "SON00")
      concussionParams.Tweak = "CNC_LIGHT_ARC_SHOT_EXPLOSION"
      game.Combat.PlayConcussion(concussionParams)
    end
  elseif state == "explosion" then
    local spawnfx = game.FX.Spawn("SonTeleport_Enter", level, {AutoDelete = true})
    spawnfx:SetWorldPosition(summonedGO.WorldPosition)
    clawFX:Destroy()
    summonedGO:Destroy()
    state = "done"
  end
end
local fxSize = 1
local fxIncrease = 3
function UpdateClawEffect(level, go)
  if clawFX ~= nil then
    clawFX:SetWorldPosition(summonedGO:GetWorldJointPosition(indexNum))
    clawFX:SetScale(fxSize)
    fxSize = fxSize + fxIncrease * unitTime
  end
end
local fxSize2 = 1
local fxIncrease2 = 3
function UpdateClawEffect2(level, go)
  if clawFX2 ~= nil then
    clawFX2:SetWorldPosition(summonedGO2:GetWorldJointPosition(indexNum2))
    clawFX2:SetScale(fxSize2)
    fxSize2 = fxSize2 + fxIncrease2 * unitTime
  end
end
