local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local son
local arrows = {}
local wolves = {}
local unitTime = 0.016
wolves[1] = {}
wolves[1].fenrir = nil
wolves[1].emitter = nil
wolves[1].locomotionSetting = {}
wolves[1].locomotionSetting.acceleration = 10
wolves[1].locomotionSetting.direction = engine.Vector.New(0, 0, 1)
wolves[1].locomotionSetting.speed = 15
wolves[1].locomotionSetting.maxSpeed = 30
wolves[1].locomotionSetting.location = engine.Vector.New(0, 0, 0)
wolves[1].legTrail1 = nil
wolves[1].ankleTrail1 = nil
wolves[1].legTrail2 = nil
wolves[1].ankleTrail2 = nil
wolves[1].target = nil
wolves[1].state = "nospawn"
wolves[1].targets = {}
wolves[1].targetIndex = 0
wolves[1].delayTimer = 0.35
wolves[1].delayTimerMax = 0.35
wolves[1].spawnLoc = nil
wolves[1].firstTarget = true
wolves[1].spawnfx = nil
wolves[1].scale = 2
wolves[1].hitCounter = 0
wolves[1].expName = ""
wolves[2] = {}
wolves[2].fenrir = nil
wolves[2].emitter = nil
wolves[2].locomotionSetting = {}
wolves[2].locomotionSetting.acceleration = 10
wolves[2].locomotionSetting.direction = engine.Vector.New(0, 0, 1)
wolves[2].locomotionSetting.speed = 15
wolves[2].locomotionSetting.maxSpeed = 30
wolves[2].locomotionSetting.location = engine.Vector.New(0, 0, 0)
wolves[2].legTrail1 = nil
wolves[2].ankleTrail1 = nil
wolves[2].legTrail2 = nil
wolves[2].ankleTrail2 = nil
wolves[2].target = nil
wolves[2].state = "nospawn"
wolves[2].targets = {}
wolves[2].targetIndex = 0
wolves[2].delayTimer = 0.35
wolves[2].delayTimerMax = 0.35
wolves[2].spawnLoc = nil
wolves[2].firstTarget = true
wolves[2].spawnfx = nil
wolves[2].scale = 3
wolves[2].hitCounter = 0
wolves[2].expName = "_2"
wolves[3] = {}
wolves[3].fenrir = nil
wolves[3].emitter = nil
wolves[3].locomotionSetting = {}
wolves[3].locomotionSetting.acceleration = 10
wolves[3].locomotionSetting.direction = engine.Vector.New(0, 0, 1)
wolves[3].locomotionSetting.speed = 15
wolves[3].locomotionSetting.maxSpeed = 30
wolves[3].locomotionSetting.location = engine.Vector.New(0, 0, 0)
wolves[3].legTrail1 = nil
wolves[3].ankleTrail1 = nil
wolves[3].legTrail2 = nil
wolves[3].ankleTrail2 = nil
wolves[3].target = nil
wolves[3].state = "nospawn"
wolves[3].targets = {}
wolves[3].targetIndex = 0
wolves[3].delayTimer = 0.35
wolves[3].delayTimerMax = 0.35
wolves[3].spawnLoc = nil
wolves[3].firstTarget = true
wolves[3].spawnfx = nil
wolves[3].scale = 2
wolves[3].hitCounter = 0
wolves[3].expName = "_3"
local upgradeLevel = 3
local doneWithEverything = false
local spawnMaterialAnimName = "creatureON"
local summonFXName = "Bifrost_Wolf_Summon_Spawn"
local originalOrientation
local arrowTypeIsLight = true
local waitForSpawnTime = 10
local rumbleParams = {EffectName = "FFB_MEDIUM", Duration = 0.3}
local shakeParams = {
  EffectName = "FSE_SHAKE_GENERIC_LARGE",
  Duration = 0.3
}
function OnScriptLoaded(level, go)
  son = game.AI.FindSon()
  local groundLoc = game.NavMesh.ClosestLocation(go.WorldPosition, son)
  local yHeight = son.WorldPosition.y
  if groundLoc ~= nil and groundLoc.Position ~= nil then
    yHeight = groundLoc.Position.y - 0.15
  end
  if son:PickupIsAcquired("SonArrow_Shock") then
    arrowTypeIsLight = false
    spawnMaterialAnimName = "creature_shock"
    summonFXName = "SonTeleport_Enter_Shock"
  end
  upgradeLevel = game.Wallets.GetResourceValue("HERO", "SummonFenrir")
  local hero = game.Player.FindPlayer()
  if hero:PickupIsAcquired("SummonFenrir") then
    upgradeLevel = hero:PickupGetStage("SummonFenrir") + 1
  end
  if upgradeLevel == nil or upgradeLevel <= 0 then
    upgradeLevel = 1
  end
  originalOrientation = son:GetWorldForward()
  local target = son:GetTargetCreature()
  if target ~= nil then
    originalOrientation = (target.WorldPosition - son.WorldPosition):Normalized()
  end
  originalOrientation.y = 0
  local rightVector = -son:GetWorldLeft() * 1
  local counter = 1
  for i = 1, upgradeLevel do
    wolves[i].spawnLoc = go.WorldPosition + rightVector * counter
    if counter == 0 then
      wolves[i].spawnLoc = wolves[i].spawnLoc + originalOrientation
    end
    counter = counter - 1
    wolves[i].spawnLoc.y = yHeight
    local newTargetOrder = {}
    if i == 1 then
      newTargetOrder = GetClusteredEnemies()
    else
      local currentTargets = GetRandomTargets()
      if #currentTargets == 1 then
        newTargetOrder = {
          currentTargets[1],
          currentTargets[1],
          currentTargets[1]
        }
      elseif #currentTargets == 2 then
        newTargetOrder = {
          currentTargets[1],
          currentTargets[2],
          currentTargets[1]
        }
      else
        newTargetOrder = currentTargets
      end
    end
    wolves[i].targets = newTargetOrder
  end
  SpawnArrowLogic(level, go)
end
function FindLivingEnemiesExludeMarker(ai, radius, marker)
  local enemies = ai:FindEnemies(radius)
  for i = #enemies, 1, -1 do
    if enemies[i]:GetCreature():GetHitPoints() <= 0 or enemies[i]:HasMarker(marker) or enemies[i]:HasMarker("Dormant") or enemies[i]:HasMarker("DoNotEvaluate") then
      table.remove(enemies, i)
    end
  end
  return enemies
end
function GetClusteredEnemies()
  local currentTargets = FindLivingEnemiesExludeMarker(game.Player.FindPlayer(), 50, "DoNotTarget")
  local clusters = {}
  local biggestCluster = 1
  for _, i in ipairs(currentTargets) do
    local thisCluster = i:FindFriendlies(6)
    if biggestCluster < #thisCluster then
      table.insert(thisCluster, i)
      clusters = thisCluster
      biggestCluster = #thisCluster
    end
  end
  if 0 < #clusters and clusters[#clusters] == nil then
    table.remove(clusters, #clusters)
  end
  local randos = GetRandomTargets()
  for i = #randos, 1, -1 do
    for _, m in ipairs(clusters) do
      if m == randos[i] then
        table.remove(randos, i)
        break
      end
    end
  end
  for _, i in ipairs(randos) do
    table.insert(clusters, i)
  end
  local clusterCount = #clusters
  if 3 <= clusterCount then
    return clusters
  elseif clusterCount == 2 then
    return {
      clusters[1],
      clusters[2],
      clusters[1]
    }
  elseif clusterCount == 1 then
    return {
      clusters[1],
      clusters[1],
      clusters[1]
    }
  elseif clusterCount == 0 then
    local numTargets = #currentTargets
    if 3 <= numTargets then
      return currentTargets
    elseif numTargets == 2 then
      return {
        currentTargets[1],
        currentTargets[2],
        currentTargets[1]
      }
    elseif numTargets == 1 then
      return {
        currentTargets[1],
        currentTargets[1],
        currentTargets[1]
      }
    end
  end
  return currentTargets
end
function GetRandomTargets()
  local currentTargets = FindLivingEnemiesExludeMarker(game.Player.FindPlayer(), 50, "DoNotTarget")
  local newTargetOrder = {}
  while 1 <= #currentTargets do
    local randomIndex = math.random(1, #currentTargets)
    table.insert(newTargetOrder, currentTargets[randomIndex])
    table.remove(currentTargets, randomIndex)
  end
  return newTargetOrder
end
function LuaHook_FenrirSummon1(level, go, spawnedObject)
  spawnedObject:ShowJoint(spawnedObject:GetJointIndex("fenrir_stream"))
  wolves[1].fenrir = spawnedObject
  wolves[1].fenrir:SetWorldPosition(wolves[1].spawnLoc)
  wolves[1].fenrir:SetWorldFacing(son:GetWorldForward())
  wolves[1].state = "spawnLeader"
  SoundSpawnWolf(spawnedObject, 1)
  game.FX.SubmitEffect(rumbleParams)
  game.FX.SubmitEffect(shakeParams)
end
function LuaHook_FenrirSummon2(level, go, spawnedObject)
  spawnedObject:ShowJoint(spawnedObject:GetJointIndex("fenrir_stream"))
  wolves[2].fenrir = spawnedObject
  wolves[2].fenrir:SetWorldPosition(wolves[2].spawnLoc)
  wolves[2].fenrir:SetWorldFacing(son:GetWorldForward())
  wolves[2].spawnDelay = 0.5
  wolves[2].state = "spawnDelay"
  SoundSpawnWolf(spawnedObject, 2)
end
function LuaHook_FenrirSummon3(level, go, spawnedObject)
  spawnedObject:ShowJoint(spawnedObject:GetJointIndex("fenrir_stream"))
  wolves[3].fenrir = spawnedObject
  wolves[3].fenrir:SetWorldPosition(wolves[3].spawnLoc)
  wolves[3].fenrir:SetWorldFacing(son:GetWorldForward())
  wolves[3].spawnDelay = 1
  wolves[3].state = "spawnDelay"
  SoundSpawnWolf(spawnedObject, 3)
end
function SpawnArrows(level, go, location, timer, wolfIndex)
  local spawnLocation = son:GetWorldJointPosition(son:GetJointIndex("JORightIndexA1"))
  local arrow = {}
  local distance = (spawnLocation - location):Length()
  arrow.location = location
  arrow.direction = (location - spawnLocation):Normalized()
  arrow.speed = distance / timer
  arrow.timer = timer
  arrow.wolfIndex = wolfIndex
  arrow.gameObject = nil
  if arrowTypeIsLight then
    arrow.gameObject = game.FX.Spawn("bifrost_projectile", level)
    arrow.gameObject:SetWorldPosition(spawnLocation)
  else
    arrow.gameObject = game.FX.Spawn("ElectricShock_Arrow", level)
    arrow.gameObject:SetWorldPosition(spawnLocation)
  end
  table.insert(arrows, arrow)
end
function UpdateArrows(level, go)
  local sizeArrows = #arrows
  for i = sizeArrows, 1, -1 do
    local thisProjectile = arrows[i]
    if thisProjectile.timer <= 0 then
      wolves[thisProjectile.wolfIndex].state = "spawn"
      thisProjectile.gameObject:Destroy()
      table.remove(arrows, i)
    else
      thisProjectile.timer = thisProjectile.timer - unitTime
      local newPos = thisProjectile.gameObject.WorldPosition + thisProjectile.direction * unitTime * thisProjectile.speed
      thisProjectile.gameObject:SetWorldPosition(newPos)
      thisProjectile.gameObject:SetWorldFacing(thisProjectile.direction)
    end
  end
end
function SpawnArrowLogic(level, go)
  local sonRight = son:GetWorldLeft()
  local offsetValue = {
    engine.Vector.New(0, 0, 0),
    -sonRight,
    sonRight
  }
  local sonSpawnArrowLocation = son.WorldPosition + son:GetWorldForward() * 3 + engine.Vector.New(0, -1.75, 0)
  local groundLoc = game.NavMesh.ClosestLocation(sonSpawnArrowLocation, son)
  local finalPos = sonSpawnArrowLocation
  if groundLoc ~= nil and groundLoc.Position ~= nil then
    finalPos = groundLoc.Position
  end
  for i = 1, upgradeLevel do
    wolves[i].spawnLoc = finalPos + offsetValue[i]
    SpawnArrows(level, go, finalPos + offsetValue[i], 0.1, i)
  end
  SoundSpawnArrows()
end
function OnUpdate(level, go)
  local player = game.Player.FindPlayer()
  unitTime = level:GetUnitTime()
  UpdateArrows(level, go)
  for j = 1, upgradeLevel do
    if wolves[j].state == "spawn" then
      local spawnTemplate = {
        SpawnObject = "goFenrir00",
        HookName = "LuaHook_FenrirSummon" .. j,
        Level = level
      }
      go:SpawnGameObject(spawnTemplate)
      wolves[j].spawnfx = game.FX.Spawn(summonFXName, level, {AutoDelete = true})
      wolves[j].locomotionSetting.location = wolves[j].spawnLoc
      wolves[j].spawnfx:SetWorldPosition(wolves[j].spawnLoc)
      wolves[j].state = "waitSpawn"
    elseif wolves[j].state == "waitSpawn" then
      waitForSpawnTime = waitForSpawnTime - unitTime
      if waitForSpawnTime < 0 then
        doneWithEverything = true
      end
    elseif wolves[j].state == "spawnLeader" then
      if 0 < #wolves[j].targets then
        wolves[j].state = "acquireTarget"
      else
        wolves[j].state = "noEnemy"
      end
    elseif wolves[j].state == "spawnDelay" then
      wolves[j].fenrir:StartMaterialAnim(spawnMaterialAnimName)
      wolves[j].fenrir:JumpAnimationToFrame(14, {
        Animation = "attSwarmEnter"
      })
      wolves[j].state = "delayCountDown"
    elseif wolves[j].state == "delayCountDown" then
      wolves[j].spawnDelay = wolves[j].spawnDelay - unitTime
      if 0 >= wolves[j].spawnDelay then
        if 0 < #wolves[j].targets then
          wolves[j].state = "acquireTarget"
        else
          wolves[j].state = "noEnemy"
        end
      end
    elseif wolves[j].state == "acquireTarget" then
      wolves[j].targetIndex = wolves[j].targetIndex + 1
      local validTarget = false
      for q, r in ipairs(wolves[j].targets) do
        if r ~= nil then
          validTarget = true
          wolves[j].target = r
          table.remove(wolves[j].targets, q)
          break
        end
      end
      if validTarget == true and wolves[j].target ~= nil and wolves[j].fenrir ~= nil then
        local direction = (wolves[j].target.WorldPosition - wolves[j].fenrir.WorldPosition):Normalized()
        direction.y = 0
        wolves[j].fenrir:SetWorldFacing(direction)
        wolves[j].state = "attackEnter"
      else
        wolves[j].state = "noEnemy"
      end
      if wolves[j].spawnfx ~= nil then
        wolves[j].spawnfx:SetScale(1.5)
      end
    elseif wolves[j].state == "attackEnter" then
      wolves[j].fenrir:StartMaterialAnim(spawnMaterialAnimName)
      if wolves[j].hitCounter < 3 then
        wolves[j].fenrir:JumpAnimationToFrame(39, {
          Animation = "attChargeEnter"
        })
        wolves[j].delayTimer = 0.5
      else
        wolves[j].state = "attack"
        wolves[j].fenrir:StartMaterialAnim("attChargeStraightLoop")
      end
      wolves[j].state = "attackAnim"
    elseif wolves[j].state == "attackAnim" then
      wolves[j].delayTimer = wolves[j].delayTimer - unitTime
      if 0 >= wolves[j].delayTimer then
        wolves[j].state = "attack"
        wolves[j].fenrir:StartMaterialAnim("attChargeStraightLoop")
      end
    elseif wolves[j].state == "attack" then
      if wolves[j].target == nil then
        wolves[j].state = "acquireTarget"
      else
        local direction = (wolves[j].target.WorldPosition - wolves[j].locomotionSetting.location):Normalized()
        wolves[j].fenrir:SetWorldFacing(direction)
        wolves[j].locomotionSetting.location = wolves[j].locomotionSetting.location + direction * wolves[j].locomotionSetting.speed * level:GetUnitTime()
        wolves[j].fenrir:SetWorldPosition(wolves[j].locomotionSetting.location)
        local wolf_xz = wolves[j].fenrir.WorldPosition
        local target_xz = wolves[j].target.WorldPosition
        if (wolf_xz - target_xz):Length() < 7 then
          wolves[j].fenrir:StartMaterialAnim("attChargeBite03")
          wolves[j].state = "lungeEnter"
          SoundPounce(wolves[j])
        end
      end
    elseif wolves[j].state == "lungeEnter" then
      if wolves[j].target == nil then
        wolves[j].state = "acquireTarget"
      else
        local direction = (wolves[j].target.WorldPosition - wolves[j].locomotionSetting.location):Normalized()
        wolves[j].fenrir:SetWorldFacing(direction)
        wolves[j].locomotionSetting.location = wolves[j].locomotionSetting.location + direction * wolves[j].locomotionSetting.speed * level:GetUnitTime()
        wolves[j].fenrir:SetWorldPosition(wolves[j].locomotionSetting.location)
        local wolf_xz = wolves[j].fenrir.WorldPosition
        local target_xz = wolves[j].target.WorldPosition
        if 1.5 > (wolf_xz - target_xz):Length() then
          wolves[j].state = "lungeExit"
          local facing = wolves[j].fenrir:GetWorldForward()
          wolves[j].fenrir:SetWorldFacing(facing)
          local concussionParams = {}
          concussionParams.WorldLocation = wolves[j].target.WorldPosition
          local jointIndex = wolves[j].target:FindJointIndex("JOPelvis1")
          if jointIndex ~= nil then
            concussionParams.WorldLocation = wolves[j].target:GetWorldJointPosition(jointIndex)
          end
          concussionParams.Creature = game.AI.FindSon()
          concussionParams.EnemyId = DL.HashCreatureID(game.Player.FindPlayer(), "SON00")
          if wolves[j].hitCounter == 2 then
            if arrowTypeIsLight then
              concussionParams.Tweak = "CNC_LIGHT_SUMMON_EXPLOSION_LAUNCH" .. wolves[j].expName
            else
              concussionParams.Tweak = "CNC_SHOCK_SUMMON_EXPLOSION_LAUNCH" .. wolves[j].expName
            end
          elseif arrowTypeIsLight then
            concussionParams.Tweak = "CNC_LIGHT_SUMMON_EXPLOSION" .. wolves[j].expName
          else
            concussionParams.Tweak = "CNC_SHOCK_SUMMON_EXPLOSION" .. wolves[j].expName
          end
          game.FX.SubmitEffect(rumbleParams)
          game.FX.SubmitEffect(shakeParams)
          SoundImpact(wolves[j])
          game.Combat.PlayConcussion(concussionParams)
          wolves[j].fenrir:StartMaterialAnim(spawnMaterialAnimName)
        end
      end
    elseif wolves[j].state == "lungeExit" then
      local direction = wolves[j].fenrir:GetWorldForward()
      direction.y = 0
      if wolves[j].fenrir.AnimFrame < 34 then
        if wolves[j].fenrir.AnimFrame < 25 then
          wolves[j].locomotionSetting.location = wolves[j].locomotionSetting.location + direction * wolves[j].locomotionSetting.speed * level:GetUnitTime() * 0.75
          wolves[j].fenrir:SetWorldPosition(wolves[j].locomotionSetting.location)
        else
          wolves[j].locomotionSetting.location = wolves[j].locomotionSetting.location + direction * wolves[j].locomotionSetting.speed * level:GetUnitTime() * 0.25
          wolves[j].fenrir:SetWorldPosition(wolves[j].locomotionSetting.location)
        end
      end
      if wolves[j].fenrir.AnimFrame > 20 then
        wolves[j].state = "scurry"
      end
    elseif wolves[j].state == "scurry" then
      wolves[j].hitCounter = wolves[j].hitCounter + 1
      if wolves[j].hitCounter >= 3 then
        wolves[j].state = "allAttacksDone"
      else
        wolves[j].state = "acquireTarget"
        wolves[j].spawnfx = game.FX.Spawn(summonFXName, level, {AutoDelete = true, Scale = 1.5})
        wolves[j].spawnfx:SetWorldPosition(wolves[j].locomotionSetting.location)
      end
      local direction = wolves[j].fenrir:GetWorldForward()
      direction.y = 0
      wolves[j].locomotionSetting.location = wolves[j].locomotionSetting.location + direction * wolves[j].locomotionSetting.speed * level:GetUnitTime() * 0.25
      wolves[j].fenrir:SetWorldPosition(wolves[j].locomotionSetting.location)
    elseif wolves[j].state == "allAttacksDone" then
      wolves[j].fenrir:StartMaterialAnim("attSwarmEnter")
      wolves[j].state = "fadeOut"
      wolves[j].delayTimer = 0.45
      local raycastHit = game.World.RaycastCollision(wolves[j].locomotionSetting.location + engine.Vector.New(0, 3, 0), wolves[j].locomotionSetting.location - engine.Vector.New(0, 8, 0), {
        SourceGameObject = game.AI.FindSon(),
        EntityType = game.CollisionType.New("kEnvironment")
      })
      if raycastHit ~= nil and 0.5 < math.abs(raycastHit.Position.y - wolves[j].locomotionSetting.location.y) then
        wolves[j].state = "popOut"
      end
      local facing = wolves[j].fenrir:GetWorldForward()
      facing.y = 0
      wolves[j].fenrir:SetWorldFacing(facing)
    elseif wolves[j].state == "noEnemy" then
      if wolves[j].fenrir == nil then
        wolves[j].state = "popOut"
        return
      end
      wolves[j].fenrir:StartMaterialAnim(spawnMaterialAnimName)
      wolves[j].fenrir:StartMaterialAnim("attSwarmEnter")
      wolves[j].state = "fadeOut"
      wolves[j].delayTimer = 0.45
      local raycastHit = game.World.RaycastCollision(wolves[j].locomotionSetting.location + engine.Vector.New(0, 3, 0), wolves[j].locomotionSetting.location - engine.Vector.New(0, 8, 0), {
        SourceGameObject = game.AI.FindSon(),
        EntityType = game.CollisionType.New("kEnvironment")
      })
      if raycastHit ~= nil and 0.5 < math.abs(raycastHit.Position.y - wolves[j].locomotionSetting.location.y) then
        wolves[j].state = "popOut"
      end
      local facing = wolves[j].fenrir:GetWorldForward()
      facing.y = 0
      wolves[j].fenrir:SetWorldFacing(facing)
    elseif wolves[j].state == "fadeOut" then
      wolves[j].delayTimer = wolves[j].delayTimer - unitTime
      if 0 >= wolves[j].delayTimer then
        if wolves[j].fenrir ~= nil then
          SoundDespawn(wolves[j])
          wolves[j].fenrir:StartMaterialAnim("creatureOFF")
        end
        wolves[j].state = "overTransition"
      end
    elseif wolves[j].state == "popOut" then
      wolves[j].state = "over"
      if wolves[j].fenrir ~= nil then
        wolves[j].spawnfx = game.FX.Spawn(summonFXName, level, {AutoDelete = true})
        wolves[j].spawnfx:SetWorldPosition(wolves[j].fenrir.WorldPosition)
        wolves[j].fenrir:Destroy()
      end
    elseif wolves[j].state == "overTransition" then
      if wolves[j].fenrir ~= nil then
        if wolves[j].fenrir.AnimTime > 0.9 then
          wolves[j].state = "over"
          wolves[j].spawnfx = game.FX.Spawn(summonFXName, level, {AutoDelete = true})
          wolves[j].spawnfx:SetWorldPosition(wolves[j].fenrir.WorldPosition)
          wolves[j].fenrir:Destroy()
        end
      else
        wolves[j].state = "over"
      end
    end
  end
  local done = true
  if doneWithEverything == false then
    for i = 1, upgradeLevel do
      if wolves[i].state ~= "over" then
        done = false
      end
    end
    doneWithEverything = done
  else
    for i = 1, upgradeLevel do
      if wolves[i].fenrir ~= nil then
        wolves[i].fenrir:Destroy()
      end
      wolves[i].state = "over"
    end
    go:Destroy()
  end
end
function DestroySummons()
  for i = 1, 3 do
    if wolves[i].fenrir ~= nil and wolves[i].state ~= "over" then
      wolves[i].state = "fadeOut"
      wolves[i].delayTimer = 0
    end
  end
end
function SoundSpawnArrows()
end
function SoundSpawnWolf(animal, index)
  wolves[index].emitter = animal:FindSingleSoundEmitterByName("SNDSpawn")
  if arrowTypeIsLight == true then
    LD.PlaySound(wolves[index].emitter, "SND_CHR_Son_Magic_Summon_Wolf_A_Spawn")
    LD.PlaySound(wolves[index].emitter, "SND_CHR_Son_Magic_Summon_Wolf_A_LP")
  else
    LD.PlaySound(wolves[index].emitter, "SND_CHR_Son_Magic_Summon_Wolf_B_Spawn")
    LD.PlaySound(wolves[index].emitter, "SND_CHR_Son_Magic_Summon_Wolf_B_LP")
  end
end
function SoundPounce(wolf)
  LD.PlaySoundRingOut(wolf.emitter, "SND_CHR_Son_Magic_Summon_Wolf_Vocal_Jump")
end
function SoundImpact(wolf)
  if arrowTypeIsLight == true then
    LD.PlaySoundRingOut(wolf.emitter, "SND_CHR_Son_Magic_Summon_Wolf_A_Energy_Blast")
  else
    LD.PlaySoundRingOut(wolf.emitter, "SND_CHR_Son_Magic_Summon_Wolf_B_Energy_Blast")
  end
end
function SoundDespawn(wolf)
  LD.PlaySoundRingOut(wolf.emitter, "SND_CHR_Son_Magic_Summon_Wolf_Vocal_Howl")
  if arrowTypeIsLight == true then
    LD.PlaySoundRingOut(wolf.emitter, "SND_CHR_Son_Magic_Dissapate_A")
  else
    LD.PlaySoundRingOut(wolf.emitter, "SND_CHR_Son_Magic_Dissapate_B")
  end
end
