local timer = require("level.timer")
local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local bboardUtil = require("game.BlackboardUtil")
local fenrir, son, sonBB
local expireTime = 10
local performedAction = false
function OnScriptLoaded(level, go)
  son = game.AI.FindSon()
  if son:GetTargetCreature() ~= nil then
    local location = son.WorldPosition + son:GetWorldLeft()
    local spawnpos = game.NavMesh.ClosestLocation(location, son)
    local facing = (son:GetTargetCreature().WorldPosition - spawnpos.Position):Normalized()
    fenrir = game.AI.Spawn(level, spawnpos.Position, facing, "CRT_Fenrir00", "BRA_AttBigBite")
  end
end
function OnUpdate(level, go)
  expireTime = expireTime - level:GetUnitTime()
  if performedAction == false and fenrir ~= nil then
    performedAction = true
    engine.SendHook("SetToSonCombatTarget", fenrir)
    fenrir:TriggerMoveEvent("kLE_Attack")
  end
  if expireTime < 0 or fenrir ~= nil and (fenrir:HasMarker("SummonDespawn") or fenrir:IsInNavigationMove()) then
    if fenrir ~= nil then
      fenrir:Destroy()
    end
    go:Destroy()
  end
end
