local statemachine = require("ai.statemachine")
local poilib = require("behavior.poi")
local Brain = statemachine.StateMachine.New("StandardFemaleNPC")
local Idle = Brain:State("Idle")
constants = {}
global = {}
function SetupPOIStates(POIState)
  local poiSearchParameters_Auto = {
    FindArgs = {
      "FREYA",
      "AUTO",
      MatchAll = true
    },
    Filter = function(poi, ads, ai, global, constants)
      return true
    end
  }
  function POIState:GetSearchParameters(ai, global, constants)
    local parameters = {}
    table.insert(parameters, poiSearchParameters_Auto)
    return parameters
  end
  return {
    SetupPOIStates = SetupPOIStates
  }
end
local UsePOI = poilib.NewPOIState(Brain, "UsePOI")
poilib.AllowPOIFromStates(Idle)
SetupPOIStates(UsePOI)
function OnAIUpdate(ai)
  statemachine.UpdateAll(creature_states, ai, global, constants)
  local debugTable = statemachine.GetDebugTable(creature_states, ai)
  if debugTable then
    engine.DrawDebugTable(debugTable)
  end
end
creature_states = {Brain}
function _G.OnAICreateLuaState(ai)
  statemachine.StartAll(ai, creature_states, ai, global, constants)
  _G.OnAICreateLuaState = nil
end
function Brain:SelectNextState(ai, global, constants)
  if poilib.IsPOIActive() then
    return UsePOI
  else
    return Idle
  end
end
