local statemachine = require("ai.statemachine")
local tablex = require("core.tablex")
local picklelib = require("core.pickle")
local DL = require("design.DesignerLibrary")
local LD = require("design.LevelDesignLibrary")
local timer = require("creature.timer")
Brain_Core = require("behavior.corebrain")
constants = {}
global = {}
function detectAggroStateFromSpawnMove(ai)
  local spawnContext = ai:GetContext()
  if DL.CheckCreatureContext(spawnContext, "INCOMBAT") then
    global.aggroState = "INCOMBAT"
  elseif DL.CheckCreatureContext(spawnContext, "UNAWARE") then
    global.aggroState = "UNAWARE"
  elseif DL.CheckCreatureContext(spawnContext, "NONHOSTILE") then
    global.aggroState = "NONHOSTILE"
  elseif DL.CheckCreatureContext(spawnContext, "PASSIVE") then
    global.aggroState = "PASSIVE"
  end
end
function LuaHook_ArenaPoke_ZoneCheck(ai, data)
  local availableZones = {
    "Stn920_MountainSideZone",
    "Stn920_CenterZone",
    "Stn920_ChasmSideZone"
  }
  local player = game.Player.FindPlayer()
  local baldur = LD.GetSingleAIByMarker("baldur00")
  for i = #availableZones, 1, -1 do
    if player:InsideZone(availableZones[i]) or baldur:InsideZone(availableZones[i]) then
      table.remove(availableZones, i)
    end
  end
  for i = 1, #availableZones do
    print(availableZones[i] .. " IS AVAILABLE")
  end
  local random = math.random(1, #availableZones)
  local selectedZone = availableZones[random]
  print("SELECTED ZONE: " .. selectedZone)
  return data:FindOutcomeBranchesEntry(selectedZone)
end
function LuaHook_SummonVineTrapInstant(ai, data)
  local currentLevel = ai.Level
  local player = game.Player.FindPlayer()
  local targetPosition = player:GetWorldPosition()
  local targetForward = player:GetWorldForward()
  local targetLeft = player:GetWorldLeft()
  local navMeshPoint = game.NavMesh.ClosestPoint(targetPosition)
  local distanceFrontOfTarget = 0
  local distanceLeftOfTarget = 0
  local velocityMultiplier = 2.5
  local baldur = LD.GetSingleAIByMarker("baldur00")
  local baldurPosition = baldur:GetWorldPosition()
  local baldurForward = baldur:GetWorldForward()
  local baldurNavMeshPoint = game.NavMesh.ClosestPoint(baldurPosition)
  local distanceBetween = LD.GetXZDistanceBetweenTwoPoints(navMeshPoint, baldurNavMeshPoint)
  if distanceBetween == nil then
    distanceBetween = 0
  end
  if player:IsInAir() == false and 3 < distanceBetween and DL.CheckCreatureContext(player:GetContext(), "FREYA_VINE_GRAB") == false then
    local kratosVine = game.AI.Spawn(currentLevel, navMeshPoint, targetForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
    kratosVine:AddMarker("SnareKratos")
  end
  if baldur:IsInAir() == false and DL.CheckCreatureContext(baldur:GetContext(), "FREYA_VINE_GRAB") == false then
    local baldurVine = game.AI.Spawn(currentLevel, baldurNavMeshPoint, baldurForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
    baldurVine:AddMarker("SnareBaldur")
  end
end
function LuaHook_SummonVineTrapSlow(ai, data)
  local currentLevel = ai.Level
  local player = game.Player.FindPlayer()
  local targetPosition = player:GetWorldPosition()
  local targetForward = player:GetWorldForward()
  local targetLeft = player:GetWorldLeft()
  local navMeshPoint = game.NavMesh.ClosestPoint(targetPosition)
  local distanceFrontOfTarget = 0
  local distanceLeftOfTarget = 0
  local velocityMultiplier = 2.5
  local baldur = LD.GetSingleAIByMarker("baldur00")
  local baldurPosition = baldur:GetWorldPosition()
  local baldurForward = baldur:GetWorldForward()
  local baldurNavMeshPoint = game.NavMesh.ClosestPoint(baldurPosition)
  local distanceBetween = LD.GetXZDistanceBetweenTwoPoints(navMeshPoint, baldurNavMeshPoint)
  local nearbyPlayer = player:FindEnemies(3)
  local numNearbyPlayer = 0
  local nearbyBaldur = baldur:FindEnemies(3)
  local numNearbyBaldur = 0
  if distanceBetween == nil then
    distanceBetween = 0
  end
  for _, k_creature in ipairs(nearbyPlayer) do
    if k_creature ~= player and 0 < k_creature:GetHitPoints() and k_creature:GetName() == "FreyaVines00" then
      numNearbyPlayer = numNearbyPlayer + 1
    end
  end
  for _, b_creature in ipairs(nearbyBaldur) do
    if b_creature ~= player and 0 < b_creature:GetHitPoints() and b_creature:GetName() == "FreyaVines00" then
      numNearbyBaldur = numNearbyBaldur + 1
    end
  end
  if player:IsInAir() == false and numNearbyPlayer == 0 and 3 < distanceBetween and DL.CheckCreatureContext(player:GetContext(), "FREYA_VINE_GRAB") == false then
    local kratosVine = game.AI.Spawn(currentLevel, navMeshPoint, targetForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
    kratosVine:AddMarker("SnareKratosTimer")
  end
  if baldur:IsInAir() == false and numNearbyBaldur == 0 and DL.CheckCreatureContext(baldur:GetContext(), "FREYA_VINE_GRAB") == false then
    local baldurVine = game.AI.Spawn(currentLevel, baldurNavMeshPoint, baldurForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
    baldurVine:AddMarker("SnareBaldur")
  end
end
function LuaHook_SummonVineHazards(ai)
  local player = game.Player.FindPlayer()
  local baldur = LD.GetSingleAIByMarker("baldur00")
  local currentLevel = ai.Level
  local vineLocators = currentLevel:FindGameObjects("Ph1_FreyaVine_*")
  print(#vineLocators)
  for i = 1, #vineLocators do
    do
      local vineString = "Ph1_FreyaVine_" .. i
      print(vineString)
      local selectedVine = currentLevel:FindSingleGameObject(vineString)
      local vinePosition = selectedVine:GetWorldPosition()
      local vineForward = selectedVine:GetWorldForward()
      local navMeshPoint = game.NavMesh.ClosestPoint(vinePosition)
      print(navMeshPoint)
      local random = math.random(1, 25) / 10
      timer.StartCreatureTimer(random, function()
        local playerPosition = player:GetWorldPosition()
        local distanceBetweenPlayerAndVine = LD.GetXZDistanceBetweenTwoPoints(navMeshPoint, playerPosition)
        local baldurPosition = baldur:GetWorldPosition()
        local distanceBetweenBaldurAndVine = LD.GetXZDistanceBetweenTwoPoints(navMeshPoint, baldurPosition)
        if 3 < distanceBetweenPlayerAndVine and 3 < distanceBetweenBaldurAndVine then
          local spawnedVine = game.AI.Spawn(currentLevel, navMeshPoint, vineForward, "CRT_FreyaVines00", "BRA_SpawnSnareVines")
          spawnedVine:AddMarker("HazardMode")
        end
      end)
    end
  end
end
function LuaHookDecision_IsBaldurPhaseTransition(ai, data)
  local baldur = LD.GetSingleAIByMarker("baldur00")
  if baldur:HasMarker("StageTransition") then
    return true
  else
    return false
  end
end
function LuaHook_GetBaldurHealth()
  local baldur = LD.GetSingleAIByMarker("baldur00")
  local baldurHealth = baldur:MeterGetValue("Health")
  return baldurHealth
end
function OnAIPostSpawn(ai)
  detectAggroStateFromSpawnMove(ai)
  if not ai:PickupIsAcquired("StoneMason_Chisel") then
    ai:PickupAcquire("StoneMason_Chisel")
  end
  ai:AddMarker("DoNotEvaluate")
  global.targetParams = "FIND_TARGET_PARAMETERS_COMBAT_KRATOS_AND_BALDUR"
  global.DTree = "DTR_STONEMASON00_OFFENSIVE"
end
function OnAIUpdate(ai)
  global.currentPosition = ai:GetWorldPosition()
  if Brain_Core:GetDebugTable(ai) then
    local debugTable = {}
    table.insert(debugTable, {
      "Current Pos: ",
      global.currentPosition
    })
    Brain_Core:AddCustomDebugTable(debugTable)
  end
end
function Brain_Core:OnUpdateCombat(ai, global, constants)
end
function _G.OnAICreateLuaState(ai)
  _G.OnAICreateLuaState = nil
end
picklelib.Install()
function Pickle(GO)
  return {
    global = global
  }
end
function Unpickle(GO, t)
  global = t.global
end
