local statemachine = require("ai.statemachine")
local picklelib = require("core.pickle")
local DL = require("design.DesignerLibrary")
local locomotion = require("creature.locomotion")
local globalLuaHooks = require("design.GlobalLuaHooks")
local timer = require("creature.timer")
local LD = require("design.LevelDesignLibrary")
locomotion.Install()
Brain_Core = require("behavior.corebrain")
constants = {}
global = {}
local powerLevel = "1"
local pLevelInt = 0
local travelerType, travelerSoundEmitter
global.comboBreakThreshold = 0
global.curHealth = 0
global.prevDamageTaken = 0
global.armorFrontDamage = 0
global.armorBackDamage = 0
global.armorFrontState = 0
global.armorBackState = 0
global.armorLeftShoulderState = 0
global.armorRightShoulderState = 0
global.armorLeftForearmState = 0
global.armorRightForearmState = 0
global.armorLeftLegState = 0
global.armorRightLegState = 0
dropCraftingResource = false
armorJointAppendString = ""
function LuaHook_ResetComboBreak()
  _G.global.comboBreakThreshold = 0
end
function HideJointIfValid(ai, jointName)
  pcall(function()
    local jointIndex = ai:GetJointIndex(jointName)
    if jointIndex ~= nil then
      ai:HideJoint(jointIndex)
    end
  end)
end
function ShowJointIfValid(ai, jointName)
  pcall(function()
    local jointIndex = ai:GetJointIndex(jointName)
    if jointIndex ~= nil then
      ai:ShowJoint(jointIndex)
    end
  end)
end
function LuaHook_AddBlood_Cleave_Impact(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kBackAbdomen, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLeg, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLeg, 0.1)
end
function LuaHook_AddBlood_Traveler_Ram(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kBackAbdomen, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLeg, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLeg, 0.1)
end
function LuaHook_AddBlood_Traveler_Punch(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLeg, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLeg, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kBackAbdomen, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLeg, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLeg, 0.1)
end
function LuaHook_AddBlood_Traveler_ArmorRip(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBack, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kBackAbdomen, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLeg, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLeg, 0.1)
end
function OnAIPostSpawn(ai)
  global.curHealth = ai:GetHitPoints()
  setupCharacter(ai)
end
function Brain_Core:OnSetPowerlevelOverrideCustom(ai, global, constants, level, isElite, forced)
  powerLevel = level
  ToggleCharacterConfig(ai, forced)
end
function setupCharacter(ai)
  local moveName = ""
  ai:PickupAcquire("Platemail_MFX_Pickup", 0)
  ai:HideJoint(ai:GetJointIndex("SCRIPTED_Wounds1"))
  ai:HideJoint(ai:GetJointIndex("SCRIPTED_Wounds2"))
  ai:HideJoint(ai:GetJointIndex("SCRIPTED_Wounds3"))
  ai:HideJoint(ai:GetJointIndex("SCRIPTED_Wounds4"))
  ai:HideJoint(ai:GetJointIndex("SCRIPTED_Wounds5"))
  if StartConfig ~= nil then
    if StartConfig.TravelerType ~= nil then
      travelerType = StartConfig.TravelerType
    end
    if StartConfig.EliteDifficulty ~= nil and StartConfig.EliteDifficulty and not ai:PickupIsAcquired("Traveler00_Elite") then
      ai:PickupAcquire("Traveler00_Elite")
    end
    if StartConfig.SpawnMove ~= nil then
      moveName = StartConfig.SpawnMove
    end
  end
  ToggleCharacterConfig(ai, not game.CHECK_FEATURE("PREEMPT_SPAWN_CONFIG"))
  if moveName ~= "" then
    ai:ForceMove(moveName)
  end
  if game.GetNewGamePlus() then
    ai:AddMarker("DifficultyRamp1")
    ai:AddMarker("DifficultyRamp2")
  end
end
function ToggleCharacterConfig(ai, override)
  if powerLevel == "1" then
    pLevelInt = 1
  elseif powerLevel == "2" then
    pLevelInt = 2
  elseif powerLevel == "3" then
    pLevelInt = 3
  elseif powerLevel == "4" then
    pLevelInt = 4
  elseif powerLevel == "5" then
    pLevelInt = 5
  elseif powerLevel == "6" then
    pLevelInt = 6
  elseif powerLevel == "7" then
    pLevelInt = 7
  elseif powerLevel == "8" then
    pLevelInt = 8
  else
    pLevelInt = powerLevel
  end
  ai:HideJoint(ai:GetJointIndex("CNmainSkirtPatch1"))
  ai:HideJoint(ai:GetJointIndex("CNfrontSkirtPatch1"))
  ai:HideJoint(ai:GetJointIndex("CN_00_strapPatch1"))
  ai:HideJoint(ai:GetJointIndex("CN_00_flagsPatch1"))
  ai:HideJoint(ai:GetJointIndex("CN_10_crotchPlatePatch1"))
  ai:HideJoint(ai:GetJointIndex("CN_20_helmetClothPatch2"))
  if travelerType ~= nil then
    if travelerType == "Turtle" then
      ai:ShowJoint(ai:GetJointIndex("CNmainSkirtPatch1"))
      ai:ShowJoint(ai:GetJointIndex("CN_10_crotchPlatePatch1"))
      ai:ShowJoint(ai:GetJointIndex("CNfrontSkirtPatch1"))
      if 4 < pLevelInt then
        if override ~= nil and override == true then
          ai:SetCharacterConfig("SeidrHand_veryhard")
        end
        game.Audio.SetWwiseSwitch(ai, "CHR_Type", "Seidr")
      else
        if override ~= nil and override == true then
          ai:SetCharacterConfig("SeidrHand_moderate")
        end
        game.Audio.SetWwiseSwitch(ai, "CHR_Type", "Seidr")
      end
      armorJointAppendString = "_10_"
      if not ai:PickupIsAcquired("Traveler_SuperBackArmor") then
        ai:PickupAcquire("Traveler_SuperBackArmor")
      end
    elseif travelerType == "Berserker" then
      ai:ShowJoint(ai:GetJointIndex("CNmainSkirtPatch1"))
      ai:ShowJoint(ai:GetJointIndex("CN_20_helmetClothPatch2"))
      ai:ShowJoint(ai:GetJointIndex("CNfrontSkirtPatch1"))
      if 4 < pLevelInt then
        if override ~= nil and override == true then
          ai:SetCharacterConfig("Helwalker_veryhard")
        end
        game.Audio.SetWwiseSwitch(ai, "CHR_Type", "Helwalker")
      else
        if override ~= nil and override == true then
          ai:SetCharacterConfig("Helwalker_moderate")
        end
        game.Audio.SetWwiseSwitch(ai, "CHR_Type", "Helwalker")
      end
      armorJointAppendString = "_20_"
      if not ai:PickupIsAcquired("Traveler_Berserker") then
        ai:PickupAcquire("Traveler_Berserker")
      end
    else
      ai:ShowJoint(ai:GetJointIndex("CNmainSkirtPatch1"))
      ai:ShowJoint(ai:GetJointIndex("CN_00_strapPatch1"))
      ai:ShowJoint(ai:GetJointIndex("CN_00_flagsPatch1"))
      if not ai:PickupIsAcquired("Traveler_Basic") then
        ai:PickupAcquire("Traveler_Basic")
      end
      if 4 < pLevelInt then
        if override ~= nil and override == true then
          ai:SetCharacterConfig("SeidrEye_veryhard")
        end
        game.Audio.SetWwiseSwitch(ai, "CHR_Type", "Seidr")
      else
        if override ~= nil and override == true then
          ai:SetCharacterConfig("SeidrEye_moderate")
        end
        game.Audio.SetWwiseSwitch(ai, "CHR_Type", "Seidr")
      end
    end
    travelerSoundEmitter = ai:FindSingleSoundEmitterByName("SNDMouth")
    if travelerSoundEmitter ~= nil then
      LD.PlaySound(travelerSoundEmitter, "SND_CHR_Traveler_Flag_LP")
    else
      print("Can't found the default emitter for SND_CHR_Traveler_Flag_LP")
    end
  end
  if not ai:PickupIsAcquired("TravelerSword") then
    ai:PickupAcquire("TravelerSword")
  end
  if not ai:PickupIsAcquired("TravelerArmor") then
    ai:PickupAcquire("TravelerArmor")
  end
  if not ai:PickupIsAcquired("TravelerRune_ArmorRepair") then
    ai:PickupAcquire("TravelerRune_ArmorRepair")
  end
  timer.StartCreatureTimer(0.01, function()
    for activeWeapon in ai:IterateActiveWeapons() do
      local gameobj = activeWeapon.Weapon
      if ai:PickupIsAcquired("Traveler_SuperBackArmor") then
        gameobj:SetCharacterConfig("config20")
      elseif ai:PickupIsAcquired("Traveler_Berserker") then
        gameobj:SetCharacterConfig("config10")
      else
        gameobj:SetCharacterConfig("config00")
      end
    end
  end)
  if ai:AttributeGetValue("Difficulty") == 4 then
    local cineVar = game.Level.GetVariable("CompletedCineNumber")
    if ai:PickupIsAcquired("Traveler00_PowerLevel") and (180 <= cineVar and 1 >= ai:PickupGetStage("Traveler00_PowerLevel") or 250 <= cineVar and 2 >= ai:PickupGetStage("Traveler00_PowerLevel") or 380 <= cineVar and 3 >= ai:PickupGetStage("Traveler00_PowerLevel") or 490 <= cineVar and 4 >= ai:PickupGetStage("Traveler00_PowerLevel")) and (ai.GroundLevel == nil or ai.GroundLevel ~= nil and string.find(ai.GroundLevel.Name, "Msp") == nil) then
      ai:PickupAcquire("PowerLevelBoost")
    end
  end
  DL.NewGamePlusLevelBoost(ai, "Traveler00_PowerLevel")
end
function OnAIUpdate(ai)
  if ai:PickupIsAcquired("Traveler_SuperBackArmor") and ai:IsPlayingMove("MOV_TravelerBackArmor") == false then
    ai:TriggerMoveEvent("LE_TravelerBackArmor")
  end
end
function _G.OnAICreateLuaState(ai)
  _G.OnAICreateLuaState = nil
end
function Brain_Core:OnUpdateCombat(ai, global, constants, dTreeParams)
  if ai ~= nil and ai:PickupIsAcquired("Debuff_Slow") then
    ai:PickupRelinquish("Debuff_Slow")
  end
  if global.comboBreakThreshold > 0 then
    global.comboBreakThreshold = global.comboBreakThreshold - ai:GetUnitTime() * 15
    if global.comboBreakThreshold < 0 then
      global.comboBreakThreshold = 0
    end
  end
  if self:GetDebugTable(ai) then
    local debugTable = {}
    table.insert(debugTable, {
      "L Shoulder Armor State:",
      global.armorLeftShoulderState
    })
    table.insert(debugTable, {
      "R Shoulder Armor State:",
      global.armorRightShoulderState
    })
    table.insert(debugTable, {
      "L Forearm Armor State:",
      global.armorLeftForearmState
    })
    table.insert(debugTable, {
      "R Forearm Armor State:",
      global.armorRightForearmState
    })
    table.insert(debugTable, {
      "L Leg Armor State:",
      global.armorLeftLegState
    })
    table.insert(debugTable, {
      "R Leg Armor State:",
      global.armorRightLegState
    })
    self:AddCustomDebugTable(debugTable)
  end
end
local woundState = 0
local woundHealthThreshold = 135
function DoWound(ai)
  local rand = math.random(1, 5)
  ai:ShowJoint(ai:GetJointIndex("SCRIPTED_Wounds" .. rand))
end
function Brain_Core:OnHitReaction(event, ai, global, constants)
  global.prevDamageTaken = global.curHealth - ai:GetHitPoints()
  global.comboBreakThreshold = global.comboBreakThreshold + global.prevDamageTaken
  global.curHealth = ai:GetHitPoints()
  if ai:GetHitPoints() < woundHealthThreshold then
    DoWound(ai)
    woundHealthThreshold = woundHealthThreshold - 10
  end
end
function LuaHook_ClearArrow(ai, data)
  game.Combat.RemoveArrows(ai)
end
function LuaHook_CheckCanReact(ai)
  if ai:MeterGetValue("CD_ComboBreaker") >= 99 then
    return false
  end
  return true
end
function LuaHook_ResetComboBreak()
  global.comboBreakThreshold = 0
end
function LuaHook_CheckComboBreak(ai, data)
  if global.comboBreakThreshold > 80 then
    ai:TriggerMoveEvent("kLEGuardComboBreak")
    global.comboBreakThreshold = 0
  end
end
function ArmorDamageIncrement(ai, partname, armorStateNum)
  HideJointIfValid(ai, "TestBSPristine")
  HideJointIfValid(ai, armorJointAppendString .. partname .. "Pristine")
  HideJointIfValid(ai, armorJointAppendString .. partname .. "Damaged1")
  HideJointIfValid(ai, armorJointAppendString .. partname .. "Damaged2")
  HideJointIfValid(ai, armorJointAppendString .. partname .. "Damaged3")
  if armorStateNum == 0 then
    ShowJointIfValid(ai, armorJointAppendString .. partname .. "Pristine")
  elseif armorStateNum < 4 then
    ShowJointIfValid(ai, armorJointAppendString .. partname .. "Damaged" .. armorStateNum)
  end
end
function BreakLeftForearm(ai, checkCounter)
  print("BreakLeftForearm")
  if global.armorLeftForearmState <= 3 then
    global.armorLeftForearmState = global.armorLeftForearmState + 1
    ArmorDamageIncrement(ai, "LeftForearmPlate", global.armorLeftForearmState)
    UpdateArmorSwitches(ai)
  elseif 0 < checkCounter then
    checkCounter = checkCounter - 1
    BreakRightForearm(ai, checkCounter)
  end
end
function BreakRightForearm(ai, checkCounter)
  print("BreakRightForearm")
  if global.armorRightForearmState <= 3 then
    global.armorRightForearmState = global.armorRightForearmState + 1
    ArmorDamageIncrement(ai, "RightForearmPlate", global.armorRightForearmState)
    UpdateArmorSwitches(ai)
  elseif 0 < checkCounter then
    checkCounter = checkCounter - 1
    BreakLeftLeg(ai, checkCounter)
  end
end
function BreakLeftLeg(ai, checkCounter)
  print("BreakLeftLeg")
  if global.armorLeftLegState <= 3 then
    global.armorLeftLegState = global.armorLeftLegState + 1
    ArmorDamageIncrement(ai, "LeftLegPlate", global.armorLeftLegState)
    UpdateArmorSwitches(ai)
  elseif 0 < checkCounter then
    checkCounter = checkCounter - 1
    BreakRightLeg(ai, checkCounter)
  end
end
function BreakRightLeg(ai, checkCounter)
  print("BreakRightLeg")
  if global.armorRightLegState <= 3 then
    global.armorRightLegState = global.armorRightLegState + 1
    ArmorDamageIncrement(ai, "RightLegPlate", global.armorRightLegState)
    UpdateArmorSwitches(ai)
  elseif 0 < checkCounter then
    checkCounter = checkCounter - 1
    BreakLeftForearm(ai, checkCounter)
  end
end
function ArmorBreakRandomPiece(ai, numToBreak)
  print("ArmorBreakRandomPiece")
  local global = _G.global
  for _ = 1, numToBreak do
    local rand = math.random(1, 4)
    DL.switch(rand):caseof({
      [1] = function()
        BreakLeftForearm(ai, 3)
      end,
      [2] = function()
        BreakRightForearm(ai, 3)
      end,
      [3] = function()
        BreakLeftLeg(ai, 3)
      end,
      [4] = function()
        BreakRightLeg(ai, 3)
      end,
      default = function()
      end,
      missing = function()
      end
    })
  end
end
local armorMaxStage = 7
local hp1 = 450
local hp2 = 400
local hp3 = 350
local hp4 = 300
local hp5 = 250
local hp6 = 200
local hp7 = 150
local hp8 = 100
local curHealthMin = hp1
local hackHealthTimer = 0
function LuaHook_TravelerDecrementHealthHack(ai, data)
  if hackHealthTimer < game.GetGameTime() then
    ai:StartMaterialAnim("Armor_hit")
    local newHealth = ai:GetHitPoints() - 10
    if newHealth > curHealthMin + 10 then
      ai:MeterSetValue("Health", newHealth)
    end
    hackHealthTimer = game.GetGameTime() + 0.4
  end
end
local finalChestState = 4
function LuaHook_ArmorDamageForceChestOff(ai, data)
  ArmorDamageIncrement(ai, "ChestPlate", 4)
end
function LuaHook_ArmorDamageKeepChest(ai, data)
  finalChestState = 3
  LuaHook_ArmorDamage(ai, data)
end
function LuaHook_ArmorDamage(ai, data)
  print("LuaHook_ArmorDamage")
  local global = _G.global
  global.armorFrontState = ai:PickupGetStage("TravelerArmor")
  if global.armorFrontState == armorMaxStage then
    game.Audio.PlayBanterNonCritical("Traveler Front Armor Broken")
  else
    game.Audio.PlayBanterNonCritical("Traveler Front Armor Damaged")
  end
  if global.armorFrontState == 0 then
    print("TravelerArmor Stage 1")
    ArmorBreakRandomPiece(ai, 3)
    ai:MeterSetValue("Health", hp1)
    curHealthMin = hp2
    ai:StartMaterialAnim("Armor_hit")
  elseif global.armorFrontState == 1 then
    print("TravelerArmor Stage 2")
    ArmorBreakRandomPiece(ai, 1)
    ArmorDamageIncrement(ai, "ChestPlate", 1)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 1)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 1)
    ArmorDamageIncrement(ai, "NeckPlate", 1)
    ArmorDamageIncrement(ai, "BackPlate", 1)
    ArmorDamageIncrement(ai, "Helmet", 1)
    ai:MeterSetValue("Health", hp2)
    curHealthMin = hp3
    ai:StartMaterialAnim("Armor_hit_TriggerDamageState")
    ai:StartMaterialAnim("Armor_damageState_01")
  elseif global.armorFrontState == 2 then
    print("TravelerArmor Stage 3")
    ArmorBreakRandomPiece(ai, 3)
    ArmorDamageIncrement(ai, "ChestPlate", 1)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 1)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 1)
    ArmorDamageIncrement(ai, "NeckPlate", 1)
    ArmorDamageIncrement(ai, "BackPlate", 1)
    ArmorDamageIncrement(ai, "Helmet", 1)
    ai:AddMarker("DifficultyRamp1")
    ai:MeterSetValue("Health", hp3)
    curHealthMin = hp4
    ai:StartMaterialAnim("Armor_hit")
  elseif global.armorFrontState == 3 then
    print("TravelerArmor Stage 4 (Gets Stunned)")
    ArmorBreakRandomPiece(ai, 1)
    ArmorDamageIncrement(ai, "ChestPlate", 2)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 2)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 2)
    ArmorDamageIncrement(ai, "BackPlate", 2)
    ArmorDamageIncrement(ai, "NeckPlate", 2)
    ArmorDamageIncrement(ai, "Helmet", 2)
    ai:AddMarker("TravelerArmorRipReady")
    ai:AddMarker("DifficultyRamp1")
    ai:AddMarker("DifficultyRamp2")
    ai:MeterSetValue("Health", hp4)
    curHealthMin = hp5
    ai:StartMaterialAnim("Armor_hit_TriggerDamageState")
    ai:StartMaterialAnim("Armor_damageState_02")
  elseif global.armorFrontState == 4 then
    print("TravelerArmor Stage 5")
    ArmorBreakRandomPiece(ai, 3)
    ArmorDamageIncrement(ai, "ChestPlate", 2)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 2)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 2)
    ArmorDamageIncrement(ai, "BackPlate", 2)
    ArmorDamageIncrement(ai, "NeckPlate", 2)
    ArmorDamageIncrement(ai, "Helmet", 2)
    ai:AddMarker("DifficultyRamp1")
    ai:AddMarker("DifficultyRamp2")
    ai:MeterSetValue("Health", hp5)
    curHealthMin = hp6
    ai:StartMaterialAnim("Armor_hit")
    ai:AddMarker("TravelerArmorRipReady")
  elseif global.armorFrontState == 5 then
    print("TravelerArmor Stage 6")
    ArmorBreakRandomPiece(ai, 1)
    ArmorDamageIncrement(ai, "ChestPlate", 3)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 3)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 3)
    ArmorDamageIncrement(ai, "BackPlate", 3)
    ArmorDamageIncrement(ai, "NeckPlate", 3)
    ArmorDamageIncrement(ai, "Helmet", 3)
    ai:AddMarker("DifficultyRamp1")
    ai:AddMarker("DifficultyRamp2")
    ai:MeterSetValue("Health", hp6)
    curHealthMin = hp7
    ai:StartMaterialAnim("Armor_hit_TriggerDamageState")
    ai:StartMaterialAnim("Armor_damageState_03")
    ai:AddMarker("TravelerArmorRipReady")
  elseif global.armorFrontState == 6 then
    print("TravelerArmor Stage 7")
    ArmorBreakRandomPiece(ai, 3)
    ArmorDamageIncrement(ai, "ChestPlate", 3)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 3)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 3)
    ArmorDamageIncrement(ai, "BackPlate", 3)
    ArmorDamageIncrement(ai, "NeckPlate", 3)
    ArmorDamageIncrement(ai, "Helmet", 3)
    ai:AddMarker("DifficultyRamp1")
    ai:AddMarker("DifficultyRamp2")
    ai:MeterSetValue("Health", hp7)
    curHealthMin = hp8
    ai:StartMaterialAnim("Armor_hit")
    ai:AddMarker("TravelerArmorRipReady")
  elseif global.armorFrontState == 7 then
    print("TravelerArmor Stage 8")
    ArmorBreakRandomPiece(ai, 1)
    ArmorDamageIncrement(ai, "ChestPlate", finalChestState)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 4)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 3)
    ArmorDamageIncrement(ai, "BackPlate", 4)
    ArmorDamageIncrement(ai, "NeckPlate", 4)
    ArmorDamageIncrement(ai, "Helmet", 4)
    ai:AddMarker("TravelerArmorBroken")
    ai:AddMarker("DifficultyRamp1")
    ai:AddMarker("DifficultyRamp2")
    ai:MeterSetValue("Health", hp8)
    curHealthMin = 0
    ai:StartMaterialAnim("Armor_hit")
  end
  UpdateArmorSwitches(ai)
end
function LuaHook_PlaySwordGlow(ai, data)
  for activeWeapon in ai:IterateActiveWeapons() do
    local gameobj = activeWeapon.Weapon
    gameobj:StartMaterialAnim("tsword00_charge01")
  end
end
function LuaHookDecision_NGPRune(ai, data)
  if global.armorFrontState >= 1 then
    return true
  else
    return false
  end
end
function LuaHookDecision_DifficultyRampLessThanEqual1(ai, data)
  if ai:HasMarker("DifficultyRamp1") == true then
    return true
  else
    return false
  end
end
function LuaHookDecision_DifficultyRampLessThanEqual2(ai, data)
  if ai:HasMarker("DifficultyRamp2") == true then
    return true
  else
    return false
  end
end
function LuaHook_RepairArmorRune(ai, data)
  local global = _G.global
  game.Audio.PlayBanterNonCritical("Traveler Armor Repaired")
  if not ai:PickupIsAcquired("TravelerArmor") then
    ai:PickupAcquire("TravelerArmor")
    ai:PickupSetStage("TravelerArmor", 3)
    ArmorDamageIncrement(ai, "ChestPlate", 3)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 3)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 3)
    global.armorFrontDamage = 210
  elseif global.armorFrontState == 3 then
    ai:PickupSetStage("TravelerArmor", 2)
    ArmorDamageIncrement(ai, "ChestPlate", 2)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 2)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 2)
    global.armorFrontDamage = 140
  elseif global.armorFrontState == 2 then
    ai:PickupSetStage("TravelerArmor", 1)
    ArmorDamageIncrement(ai, "ChestPlate", 1)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 1)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 1)
    global.armorFrontDamage = 70
  elseif global.armorFrontState == 1 then
    ai:PickupSetStage("TravelerArmor", 0)
    ArmorDamageIncrement(ai, "ChestPlate", 0)
    ArmorDamageIncrement(ai, "RightShoulderPlate", 0)
    ArmorDamageIncrement(ai, "LeftShoulderPlate", 0)
    global.armorFrontDamage = 0
  end
end
function LuaHook_RepairArmorRune_StatusCheck(ai, data)
  if _G.global.armorFrontState == 0 and _G.global.armorBackState == 0 then
    return data:FindOutcomeBranchesEntry("RepairComplete")
  end
end
picklelib.Install()
function Pickle(GO)
  return {
    global = global
  }
end
function Unpickle(GO, t)
  global = t.global
end
local armorTorso = true
local armorLegs = true
local armorArms = true
function UpdateArmorSwitches(ai)
  if global.armorLeftForearmState >= 4 and 4 <= global.armorRightForearmState and armorArms then
    armorArms = false
    game.Audio.SetWwiseSwitch(ai, "Armor_Arms", "Off")
  end
  if 4 <= global.armorLeftLegState and 4 <= global.armorRightLegState and armorLegs then
    armorLegs = false
    game.Audio.SetWwiseSwitch(ai, "Armor_Legs", "Off")
  end
  if armorTorso and global.armorFrontState == 7 then
    armorTorso = false
    game.Audio.SetWwiseSwitch(ai, "Armor_Torso", "Off")
    game.Audio.SetWwiseSwitch(ai, "Armor_Helmet", "Off")
  end
end
