local statemachine = require("ai.statemachine")
local tablex = require("core.tablex")
local components = require("design.components")
local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local timer = require("creature.timer")
local lookAtConsts = require("game.lookAtConsts")
local breathEffect
local troll_variant_package = require("troll.package")
local troll_specific_package
local mpicon = require("ui.mpicon")
local globalLuaHooks = require("design.GlobalLuaHooks")
local contextactionlibrary = require("level.contextactionlibrary")
contextactionlibrary.InstallHooks()
Brain_Core = require("behavior.corebrain")
constants = {}
global = {}
global.ai = nil
global.target = {}
local goPlayerCreature
local trollUniqueName = "Dau\195\176i Kaupma\195\176r"
local trollBossBarIcon = "\198\156"
local hasBrother = false
local myBrother
local variantNum = 1
local healthBarOnAggro = true
local soundEmitterTroll
_G.thisLookAtEntry = nil
attachments = {}
global.TrollFightPhase = "START"
global.trollWeapon = nil
global.trollName = nil
global.passiveModeTimer = 0
global.angleToDesiredPosition = nil
global.forceStanding = false
local markerWeakspotJointIndexTop, markerWeakspotJointIndexBottom, markerPlayerCollisionJointIndex
local bossHealthBarOn = false
local bossHealthBarType = "BOSS_HEALTH_BAR_TROLL"
function LuaHook_ShowHealth(ai)
  if ai:PickupIsAcquired("TrollFirstBrother") then
    bossHealthBarType = "BOSS_HEALTH_BAR_TROLL1"
  end
  if ai:PickupIsAcquired("TrollTwinBrother") then
    bossHealthBarType = "BOSS_HEALTH_BAR_TROLL2"
  end
  if bossHealthBarOn == false then
    mpicon.level.Create(ai:GetGameObject(), bossHealthBarType)
    mpicon.level.SetTextObjectText(ai, bossHealthBarType, "bossName", trollUniqueName)
    mpicon.level.SetTextObjectText(ai, bossHealthBarType, "icon", trollBossBarIcon)
    if not ai:PickupIsAcquired("TrollNoFire") and not ai:PickupIsAcquired("TrollTwinBrother") and not ai:PickupIsAcquired("TrollFirstBrother") then
      mpicon.level.PlayAnimation(ai, bossHealthBarType, 0, "bossHealthBar_ToggleStunMeterOn")
    end
    if ai.SetOverrideStatusEffectIconParent ~= nil then
      ai:SetOverrideStatusEffectIconParent("BOSS_HEALTH_BAR_TROLL")
    end
    bossHealthBarOn = true
    healthBarOnAggro = true
  end
end
function LuaHook_HideHealth(ai)
  if bossHealthBarOn == true then
    mpicon.level.Off(ai:GetGameObject(), bossHealthBarType)
    bossHealthBarOn = false
  end
end
local setTrollFightPhase = function(ai, global, constants)
  if not ai:PickupIsAcquired("TrollPhase") then
    ai:PickupAcquire("TrollPhase")
  end
end
local SetupActiveWeapon = function(ai)
  for activeWeapon in ai:IterateActiveWeapons() do
    global.trollWeapon = activeWeapon.Weapon
    if global.trollWeapon ~= nil then
      if global.trollName == "troll00" then
        if variantNum == 1 or variantNum == nil then
          global.trollWeapon:SetCharacterConfig("trollStone00")
        elseif variantNum == 2 then
          global.trollWeapon:SetCharacterConfig("trollStone00_moderate")
        else
          global.trollWeapon:SetCharacterConfig("trollStone00_veryhard")
        end
      elseif global.trollName == "troll10" then
        if variantNum == 1 or variantNum == nil then
          global.trollWeapon:SetCharacterConfig("trollStone10")
        else
          global.trollWeapon:SetCharacterConfig("trollStone10_veryhard")
        end
      elseif global.trollName == "troll20" then
        if variantNum == 1 or variantNum == nil then
          global.trollWeapon:SetCharacterConfig("trollStone20")
          if ai:PickupIsAcquired("TrollTwinBrother") then
            global.trollWeapon:SetCharacterConfig("trollStone20_ice")
          end
        else
          global.trollWeapon:SetCharacterConfig("trollStone20_veryhard")
        end
      end
      local joint = global.trollWeapon:FindJointIndex("JOMarkerWeakspotTop")
      if joint then
        markerWeakspotJointIndexTop = global.trollWeapon:GetJointIndex("JOMarkerWeakspotTop")
        global.trollWeapon:HideJoint(markerWeakspotJointIndexTop)
      end
      joint = global.trollWeapon:FindJointIndex("JOMarkerWeakspotBottom")
      if joint then
        markerWeakspotJointIndexBottom = global.trollWeapon:GetJointIndex("JOMarkerWeakspotBottom")
        global.trollWeapon:HideJoint(markerWeakspotJointIndexBottom)
      end
      joint = global.trollWeapon:FindJointIndex("JOPlayerCollision")
      if joint then
        markerPlayerCollisionJointIndex = global.trollWeapon:GetJointIndex("JOPlayerCollision")
      end
    end
  end
end
function OnAIPostSpawn(ai)
  print(troll_specific_package)
  goPlayerCreature = game.Player.FindPlayer()
  global.ai = ai
  setupCharacter(ai)
  if ai.AddLookAtPriorityOverride then
    _G.thisLookAtEntry = game.AddGlobalLookAtTarget(ai, engine.Vector.New(0, 5, 0), lookAtConsts.TargetType.BadGuy)
  end
  if ai:GetID() == DL.HashCreatureID(ai, "TROLL10") then
    troll_specific_package = require("troll10.package")
  elseif ai:GetID() == DL.HashCreatureID(ai, "TROLL20") then
    troll_specific_package = require("troll20.package")
  elseif ai:GetID() == DL.HashCreatureID(ai, "TROLL30") then
    troll_specific_package = require("troll30.package")
  end
  ai:HideJoint(ai:GetJointIndex("shieldJoint"))
  ai:HideJoint(ai:GetJointIndex("phaseSphereJoint"))
end
function Brain_Core:OnSetPowerlevelOverrideCustom(ai, global, constants, level, isElite, forced)
  global.trollName = ai:GetName()
  ToggleCharacterConfig(ai, forced)
end
function setupCharacter(ai)
  local moveName = ""
  global.trollName = ai:GetName()
  if StartConfig ~= nil then
    if global.trollName == "troll00" and StartConfig.TrollNoFire ~= nil and StartConfig.TrollNoFire == true and not ai:PickupIsAcquired("TrollNoFire") then
      ai:PickupAcquire("TrollNoFire")
    end
    if global.trollName == "troll20" and (StartConfig.Variant == "Variant1" or StartConfig.Variant == nil) then
      if StartConfig.TwinBrother ~= nil and StartConfig.TwinBrother == true then
        if not ai:PickupIsAcquired("TrollTwinBrother") then
          ai:PickupAcquire("TrollTwinBrother")
          hasBrother = true
        end
      elseif not ai:PickupIsAcquired("TrollFirstBrother") then
        ai:PickupAcquire("TrollFirstBrother")
        hasBrother = true
      end
    end
    if StartConfig.HealthBarOnAggro ~= nil and StartConfig.HealthBarOnAggro == false then
      healthBarOnAggro = false
    end
    if StartConfig.SafeSpotOnKill ~= nil and StartConfig.SafeSpotOnKill == true then
      ai:AddMarker("UseSafeSpots")
    end
  end
  ai:HideJoint(ai:GetJointIndex("WeakSpotLegJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotLegRagJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotArmJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotArmRagJoint"))
  global.WeakSpotLeg = false
  global.WeakSpotArm = false
  global.WeakSpotMarker = false
  if global.trollName == "troll00" or global.trollName == "troll10" then
    if breathEffect == nil then
      breathEffect = game.FX.Spawn("FX_troll_Breath", nil, {
        Joint = "JOJaw1",
        GameObject = ai,
        DeleteWithCreature = true
      })
      breathEffect:SetAnimFloatChannelDriver(ai, "sliderfloatchannels._breathfxintensity")
      print("Breath playing")
    end
  elseif global.trollName == "troll20" then
    ai:PickupAcquire("Troll20StoneBody")
  end
  ToggleCharacterConfig(ai, not game.CHECK_FEATURE("PREEMPT_SPAWN_CONFIG"))
  soundEmitterTroll = ai:FindSingleSoundEmitterByName("SNDSpawn")
  DL.NewGamePlusLevelBoost(ai, "Troll00_PowerLevel")
  DL.NewGamePlusLevelBoost(ai, "Troll10_PowerLevel")
  DL.NewGamePlusLevelBoost(ai, "Troll20_PowerLevel")
end
function Brain_Core:OnDeath(ai, attacker, deathByDespawn)
  if breathEffect ~= nil then
    breathEffect:Destroy()
  end
end
function ToggleCharacterConfig(ai, override)
  if ai:PickupIsAcquired("TrollStone") ~= true then
    ai:PickupAcquire("TrollStone")
  end
  if global.trollName == "troll00" then
    if StartConfig.Variant == "Variant2" then
      variantNum = 2
      global.DTree = "DTR_TROLL00_OFFENSIVE_V2"
    elseif StartConfig.Variant == "Variant3" then
      variantNum = 3
      if override ~= nil and override == true then
        ai:SetCharacterConfig("troll00_veryhard")
      end
    elseif override ~= nil and override == true then
      ai:SetCharacterConfig("troll00")
    end
    timer.StartCreatureTimer(0.01, function()
      SetupActiveWeapon(ai)
    end)
  elseif global.trollName == "troll10" then
    if StartConfig.Variant == "Variant2" or StartConfig.Variant == "Variant3" then
      variantNum = 2
      if override ~= nil and override == true then
        ai:SetCharacterConfig("troll10_veryhard")
      end
      global.DTree = "DTR_TROLL10_OFFENSIVE_V2"
    elseif override ~= nil and override == true then
      ai:SetCharacterConfig("troll10")
    end
    timer.StartCreatureTimer(0.01, function()
      SetupActiveWeapon(ai)
    end)
  elseif global.trollName == "troll20" then
    if StartConfig.Variant == "Variant2" or StartConfig.Variant == "Variant3" then
      variantNum = 2
      if override ~= nil and override == true then
        ai:SetCharacterConfig("troll20_veryhard")
      end
      global.DTree = "DTR_TROLL20_OFFENSIVE_V2"
    elseif override ~= nil and override == true then
      ai:SetCharacterConfig("troll20")
      if ai:PickupIsAcquired("TrollTwinBrother") then
        ai:SetCharacterConfig("troll20_ice")
      end
    end
    timer.StartCreatureTimer(0.01, function()
      SetupActiveWeapon(ai)
    end)
  elseif global.trollName == "troll30" then
    if override ~= nil and override == true then
      ai:SetCharacterConfig("troll30")
    end
    trollUniqueName = "[MSG:" .. 39411 .. "]"
  end
  if global.trollName == "troll00" then
    trollBossBarIcon = "\198\156"
    if variantNum == 1 then
      trollUniqueName = "[MSG:" .. 39407 .. "]"
    elseif variantNum == 2 then
      trollUniqueName = "[MSG:" .. 39413 .. "]"
    else
      trollUniqueName = "[MSG:" .. 39408 .. "]"
    end
  elseif global.trollName == "troll10" then
    trollBossBarIcon = "\198\157"
    if variantNum == 1 then
      trollUniqueName = "[MSG:" .. 39409 .. "]"
    elseif variantNum == 2 then
      trollUniqueName = "[MSG:" .. 39410 .. "]"
    end
  elseif global.trollName == "troll20" then
    if variantNum == 1 then
      trollUniqueName = "[MSG:" .. 39412 .. "]"
      trollBossBarIcon = "\198\165"
      if ai:PickupIsAcquired("TrollTwinBrother") then
        trollUniqueName = "[MSG:" .. 39676 .. "]"
        trollBossBarIcon = "\198\160"
      end
    elseif variantNum == 2 then
      trollUniqueName = "[MSG:" .. 39414 .. "]"
      trollBossBarIcon = "\198\165"
    end
  end
  local levelName = ai.Level.Name
  if string.find(levelName, "Xpl250") ~= nil then
    trollUniqueName = "[MSG:" .. 39415 .. "]"
  end
end
function OnAIUpdate(ai)
  if global.trollWeapon == nil and global.trollName then
    SetupActiveWeapon(ai)
  end
  setTrollFightPhase(ai, global, constants)
  components.UpdateComponents(ai, attachments)
end
function _G.OnAICreateLuaState(ai)
  components.StartComponents(ai, attachments)
  _G.OnAICreateLuaState = nil
end
function Brain_Core:OnEnterCombat(ai, global, constants)
  if global.trollName ~= "troll30" and healthBarOnAggro == true then
    LuaHook_ShowHealth(ai, nil)
  end
  if global.trollName == "troll20" then
    if ai:PickupIsAcquired("TrollFirstBrother") then
      ai:PickupSetStage("TrollFirstBrother", 1)
    elseif ai:PickupIsAcquired("TrollTwinBrother") then
      ai:PickupSetStage("TrollTwinBrother", 1)
    end
  end
end
local brotherRegenTimer = 0
function Brain_Core:OnUpdateCombat(ai, global, constants, dTreeParams)
  if global.passiveModeTimer > 0 then
    global.passiveModeTimer = global.passiveModeTimer - ai:GetFrameTime()
    if global.passiveModeTimer <= 0 then
      constants.fightKnowledgeInputs.Zones.Default.Aggressive[1].Constraints[1].Min = constants.fightPosDataDefault.AggressiveMinDistance
      constants.fightKnowledgeInputs.Zones.Default.Aggressive[1].Constraints[1].Max = constants.fightPosDataDefault.AggressiveMaxDistance
      ai:RevertAggressivePriority()
    end
  end
  if hasBrother == true then
    if myBrother == nil then
      local enemies = DL.FindLivingEnemies(goPlayerCreature, 200)
      for i = 1, #enemies do
        if enemies[i]:GetName() == "troll20" and enemies[i] ~= ai then
          myBrother = enemies[i]
        end
      end
    else
      if brotherRegenTimer >= game.GetGameTime() and ai:MeterGetValue("Health") + 70 < myBrother:MeterGetValue("Health") then
        brotherRegenTimer = 0
      end
      if brotherRegenTimer < game.GetGameTime() and myBrother ~= nil and 1 <= ai:MeterGetValue("Health") and myBrother:MeterGetValue("Health") > ai:MeterGetValue("Health") + 5 and myBrother:MeterGetValue("Health") > 10 then
        ai:MeterSetValue("Health", ai:MeterGetValue("Health") + 1)
        local healCost = 0.5
        local difficulty = ai:AttributeGetValue("Difficulty")
        if difficulty == 1 then
          healCost = 0.7
        elseif difficulty == 3 then
          healCost = 0.4
        elseif difficulty == 4 then
          healCost = 0.2
        end
        myBrother:MeterSetValue("Health", myBrother:MeterGetValue("Health") - healCost)
      end
    end
  end
end
function Brain_Core:OnExitCombat(ai, global, constants)
  if global.trollName ~= "troll30" then
    LuaHook_HideHealth(ai, nil)
  end
end
local hitFxTimer = 0
function PlayHitFX(hitFXName, jointName, ai)
  if hitFxTimer < game.GetGameTime() then
    game.FX.Spawn(hitFXName, nil, {
      Joint = jointName,
      GameObject = goPlayerCreature,
      DeleteWithCreature = true
    })
    hitFxTimer = game.GetGameTime() + 0.5
  end
end
function PlayTrollConcussion(ai, concussionType)
  local concussionParams = {}
  concussionParams = {
    Tweak = concussionType,
    WorldLocation = ai:GetWorldPosition(),
    GameObject = ai,
    EnemyId = ai:GetID()
  }
  game.Combat.PlayConcussion(concussionParams)
end
function Brain_Core:OnHitReaction(event, ai, global, constants)
  if global.trollName == "troll20" then
    local isThrowable = false
    local repelPlayer = false
    if ai:HasHitFlag("HIT_THROWABLE", event.hitFlags) then
      isThrowable = true
    end
    if isThrowable == false then
      if ai:HasHitFlag("HIT_BLADES", event.hitFlags) and ai:PickupIsAcquired("TrollFirstBrother") then
        repelPlayer = true
      elseif ai:HasHitFlag("HIT_AXE", event.hitFlags) and ai:PickupIsAcquired("TrollTwinBrother") then
        repelPlayer = true
        PlayHitFX("impact_ring_small", "JOMeleeWeapon1", ai)
      end
    end
    if repelPlayer then
      if ai:PickupIsAcquired("TrollTwinBrother") then
        PlayTrollConcussion(ai, "CNC_AXE_REJECT_FROST")
        PlayTrollConcussion(ai, "CNC_AXE_REJECT")
      else
        PlayTrollConcussion(ai, "CNC_AXE_REJECT_BURN")
        PlayTrollConcussion(ai, "CNC_AXE_REJECT")
      end
    else
      brotherRegenTimer = game.GetGameTime() + 5
    end
  end
end
function LuaHook_HideMarkerPlayerCollision(ai)
  if global.trollName == "troll00" or global.trollName == "troll10" then
    global.trollWeapon:HideJoint(markerPlayerCollisionJointIndex)
  end
end
function LuaHook_ShowMarkerPlayerCollision(ai)
  if global.trollName == "troll00" or global.trollName == "troll10" then
    global.trollWeapon:ShowJoint(markerPlayerCollisionJointIndex)
  end
end
function LuaHook_PlayTroll30RoarWinds()
  LD.PlaySound(goPlayerCreature:FindSingleSoundEmitterByName("SNDMouth"), "SND_CHR_Troll30_Wind_Roar_Gust_LP")
end
function LuaHook_StopTroll30RoarWinds()
  LD.StopSound(goPlayerCreature:FindSingleSoundEmitterByName("SNDMouth"), "SND_CHR_Troll30_Wind_Roar_Gust_LP")
end
function LuaHook_PlayKratosDrag()
  LD.PlaySound(goPlayerCreature:FindSingleSoundEmitterByName("SNDKratos"), "SND_CHR_Kratos_Dragged_Dirt_LP")
end
function LuaHook_StopKratosDrag()
  LD.StopSound(goPlayerCreature:FindSingleSoundEmitterByName("SNDKratos"), "SND_CHR_Kratos_Dragged_Dirt_LP")
end
function LuaHook_PlayTeleportAudio()
  LD.PlaySound(soundEmitterTroll, "SND_CHR_Troll30_Teleport_Disappear")
end
function LuaHook_StopTeleportAudio()
  LD.PlaySound(soundEmitterTroll, "SND_CHR_Troll30_Teleport_Appear")
end
function LuaHook_TrollSurprise(ai)
  game.Audio.SetWwiseSwitch(ai, "CHR_Variation", "CHR_Variation_01")
end
function LuaHook_Sound_MarkerGlowOn(ai)
  LD.PlaySound(global.trollWeapon:FindSingleSoundEmitterByName("SNDtrollStone*"), "SND_CHR_Troll_Marker_Glow_A_LP")
end
function LuaHook_Sound_MarkerGlowOff(ai)
  LD.StopSound(global.trollWeapon:FindSingleSoundEmitterByName("SNDtrollStone*"), "SND_CHR_Troll_Marker_Glow_A_LP")
end
function LuaHook_SpawnBurstOut()
  if game.FindLevel("Riv420_ForestBoarStart") then
    game.Audio.StartMusic("SND_MX_RIV_troll_fight_intro")
  end
end
function LuaHook_SpawnClimbHole()
  if game.FindLevel("Peak200_ChimneyLow") ~= nil then
    game.FindLevel("Peak200_ChimneyLow"):GetGameObject("CombatScripts"):CallScript("peak200spawnclimbhole")
  end
end
function LuaHook_CSRageBeatdownTroll30Finisher()
  if game.FindLevel("Hel600_GuardianArena") then
    game.Audio.StartMusic("SND_MX_HEL_guardian_fight_p6_out")
  elseif game.FindLevel("Xpl250_FuneralInterior") then
    game.Audio.StartMusic("SND_MX_XPL200_troll_fight_cs_kill")
  elseif game.FindLevel("Cal200_Shore") then
    game.Audio.StartMusic("SND_MX_XPL600_troll_fight_cs_kill")
  elseif game.FindLevel("Stn610_POIIntroCombat") then
    game.Audio.StartMusic("SND_MX_STN_banquet_fight_troll_cs_kill")
  elseif game.FindLevel("Peak200_ChimneyLow") then
    game.FindLevel("Peak200_ChimneyLow"):GetGameObject("CombatScripts"):CallScript("peak200TrollCS")
  elseif game.FindLevel("Riv420_ForestBoarStart") then
    game.FindLevel("Riv420_ForestBoarStart"):CallScript("riv420TrollCSMusic")
  elseif game.FindLevel("Cal410_FinaleTowerFight") then
    game.FindLevel("Cal410_FinaleTowerFight"):GetGameObject("encounterControl"):CallScript("rbrMusicWave4CSTrollDeath")
  elseif game.FindLevel("cal500_runevault") then
    game.FindLevel("cal500_runevault"):GetGameObject("Encounters"):CallScript("runeTrollDeath")
  end
end
function LuaHook_Death01()
  if game.FindLevel("Xpl250_FuneralInterior") then
    game.FindLevel("Xpl250_FuneralInterior"):CallScript("trollDeathMus")
  elseif game.FindLevel("Cal200_Shore") then
    game.FindLevel("Cal200_Shore"):CallScript("xpl600TrollDeathMusic")
  elseif game.FindLevel("Stn610_POIIntroCombat") then
    game.FindLevel("Stn610_POIIntroCombat"):CallScript("stn610TrollDeadMusic")
  elseif game.FindLevel("Peak200_ChimneyLow") then
    game.FindLevel("Peak200_ChimneyLow"):GetGameObject("CombatScripts"):CallScript("peak200TrollDead")
  elseif game.FindLevel("Riv420_ForestBoarStart") then
    game.FindLevel("Riv420_ForestBoarStart"):CallScript("riv420TrollDead")
  elseif game.FindLevel("Cal410_FinaleTowerFight") then
    game.FindLevel("Cal410_FinaleTowerFight"):GetGameObject("encounterControl"):CallScript("rbrMusicWave4TrollDeath")
  elseif game.FindLevel("Cal500_runevault") then
    game.FindLevel("Cal500_runevault"):GetGameObject("Encounters"):CallScript("runeTrollDeath")
  end
end
function LuaHook_AddBlood_Troll_RageEnter(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLeg, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLeg, 0.2)
end
function LuaHook_AddBlood_Troll_RageBeatDown(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.1)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.2)
end
function LuaHook_AddBlood_Troll_RageFinisher(ai, data)
  local player = game.Player.FindPlayer()
  player:AddBlood(game.GameObject.eRegionId.kHead, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftChest, 1)
  player:AddBlood(game.GameObject.eRegionId.kRightChest, 1)
  player:AddBlood(game.GameObject.eRegionId.kFrontAbdomen, 1)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontUpperArm, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontUpperArm, 0.8)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLowerArm, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftFrontLeg, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kRightFrontLeg, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kBackAbdomen, 0.6)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackUpperArm, 0.4)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLowerArm, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kLeftBackLeg, 0.2)
  player:AddBlood(game.GameObject.eRegionId.kRightBackLeg, 0.2)
end
