local DL = require("design.DesignerLibrary")
local uiCalls = require("ui.uicalls")
function LuaHook_TrollHideTuskFrame1(ai, data)
  if _G.global.trollName == "troll00" then
    ai:HideJoint(ai:GetJointIndex("troll00_csKillHide1"))
  elseif _G.global.trollName == "troll10" then
    ai:HideJoint(ai:GetJointIndex("troll10_csKillHide1"))
  elseif _G.global.trollName == "troll20" then
    ai:HideJoint(ai:GetJointIndex("troll20_csKillHide1"))
  elseif _G.global.trollName == "troll30" then
    ai:HideJoint(ai:GetJointIndex("troll30_csKillHide1"))
  end
end
function LuaHook_TrollHideTusk(ai, data)
  if _G.global.trollName == "troll00" then
    ai:HideJoint(ai:GetJointIndex("troll00_csKillHide1"))
    ai:HideJoint(ai:GetJointIndex("troll00_csKillHide2"))
  elseif _G.global.trollName == "troll10" then
    ai:HideJoint(ai:GetJointIndex("troll10_csKillHide1"))
    ai:HideJoint(ai:GetJointIndex("troll10_csKillHide2"))
  elseif _G.global.trollName == "troll20" then
    ai:HideJoint(ai:GetJointIndex("troll20_csKillHide1"))
    ai:HideJoint(ai:GetJointIndex("troll20_csKillHide2"))
  elseif _G.global.trollName == "troll30" then
    ai:HideJoint(ai:GetJointIndex("troll30_csKillHide1"))
  end
end
local rageGrabTextShow = false
function LuaHook_RageGrabTextShow(C, data)
  if not rageGrabTextShow and C.PercentageOfHealth > 5 then
    rageGrabTextShow = true
    uiCalls.SendSidebarDesignerMessage({
      Text = 40867,
      AdvanceType = uiCalls.msgParam.INFINITE_TIMER
    })
  end
end
function LuaHook_RageGrabTextHide(C, data)
  if rageGrabTextShow then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    rageGrabTextShow = false
  end
end
function LuaHook_TrollAdvancePhase(ai, data)
  if ai:PickupIsAcquired("TrollPhase") then
    local phase = ai:PickupGetStage("TrollPhase")
    ai:PickupSetStage("TrollPhase", phase + 1)
  end
end
function LuaHookDecision_TrollTriggerTaunt(ai, data)
  if _G.global.tauntTimer ~= nil and _G.global.tauntTimer <= 0 then
    data:FindOutcomeBranchesEntry("True")
    _G.global.tauntTimer = 10
  end
end
function LuaHook_TrollComboChain(ai, data)
  if math.random(100) < 5 then
    return true
  end
  return false
end
function LuaHook_TrollDropHealthConsumable(ai, data)
  local chance = ai:LookupFloatConstant("TROLL_RAGE_PUNCH_LOOT_CHANCE")
  if chance < math.random() then
    return
  end
  local index = ai:GetJointIndex("JOHead1")
  local pos = ai:GetWorldJointPosition(index)
  local dir = ai:GetWorldForward()
  pos = pos + dir * math.random(0.15, 0.5)
  local spawnArgs = {
    SpawnObject = "golootGenericHealthRune",
    OffsetPosition = pos,
    Level = game.Level.GetPermLevel()
  }
  game.Player.FindPlayer():CallScript("LuaHook_SpawnGameObject", spawnArgs)
end
function LuaHook_SetInCombatForceTarget(C, data)
  _G.global.aggroState = "INCOMBAT"
  if _G.goPlayerCreature ~= nil then
    C:SetCombatTarget(_G.goPlayerCreature)
  end
end
function LuaHook_SpawnTrollStoneBreakable(ai, data)
  local spawnTrollStone = {
    SpawnObject = "gotrollStone05",
    HookName = "onStoneCreated"
  }
  ai:SpawnGameObject(spawnTrollStone)
end
function onStoneCreated(go, stone)
  _G.global.trollWeapon = stone
  local creature = go:GetCreature()
  local spawnLocation = creature:GetWorldJointPosition(creature:GetJointIndex("JOMeleeWeapon1"))
  local spawnFacing = creature:GetWorldJointForward(creature:GetJointIndex("JOMeleeWeapon1"))
  _G.global.trollWeapon:SetWorldPosition(spawnLocation)
  _G.global.trollWeapon:SetWorldFacing(spawnFacing)
end
function LuaHook_Troll_StoneMatAnim_GlowOff(ai, data)
end
function LuaHook_Troll_StoneMatAnim_GlowOn(ai, data)
end
function LuaHook_MatAnim_MarkerOn(ai, data)
end
function LuaHook_MatAnim_MarkerLoop(ai, data)
end
function LuaHook_MatAnim_MarkerOff(ai, data)
end
local rageAnimOn = false
function LuaHook_MatAnim_MarkerOn_Rage(ai, data)
  if rageAnimOn == false then
    _G.global.trollWeapon:StartMaterialAnim("trollstone00_FXReveal_RAGE")
    rageAnimOn = true
  end
end
function LuaHook_MatAnim_MarkerLoop_Rage(ai, data)
  LuaHook_MatAnim_MarkerOn_Rage(ai, data)
end
function LuaHook_MatAnim_MarkerOff_Rage(ai, data)
  if rageAnimOn == true then
    _G.global.trollWeapon:StartMaterialAnim("trollstone00_FXConceal_RAGE")
    rageAnimOn = false
  end
end
function LuaHook_MatAnim_IceOn(ai, data)
  if _G.global.trollName == "troll00" then
    ai:StartMaterialAnim("Troll00_FX_LegReveal01_Ice")
  elseif _G.global.trollName == "troll10" then
    ai:StartMaterialAnim("Troll10_FX_LegReveal01_Ice")
  end
end
function LuaHook_MatAnim_IceOff(ai, data)
  if _G.global.trollName == "troll00" then
    ai:StartMaterialAnim("Troll00_FX_LegConceal01_Ice")
  elseif _G.global.trollName == "troll10" then
    ai:StartMaterialAnim("Troll10_FX_LegConceal01_Ice")
  end
end
function LuaHook_MatAnim_LegOn(ai, data)
  if _G.global.trollName == "troll10" then
    ai:StartMaterialAnim("Troll10_FX_LegReveal01")
  end
  ai:ShowJoint(ai:GetJointIndex("WeakSpotLegJoint"))
  ai:ShowJoint(ai:GetJointIndex("WeakspotLegRagJoint"))
end
function LuaHook_MatAnim_LegOff(ai, data)
  if _G.global.trollName == "troll10" then
    ai:StartMaterialAnim("Troll10_FX_LegConceal01")
  end
  ai:HideJoint(ai:GetJointIndex("WeakSpotLegJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotLegRagJoint"))
end
function LuaHook_MatAnim_ArmOn(ai, data)
  if _G.global.trollName == "troll10" then
    ai:StartMaterialAnim("Troll10_FX_ArmReveal01")
  end
  ai:ShowJoint(ai:GetJointIndex("WeakspotArmJoint"))
  ai:ShowJoint(ai:GetJointIndex("WeakspotArmRagJoint"))
end
function LuaHook_MatAnim_ArmOff(ai, data)
  if _G.global.trollName == "troll10" then
    ai:StartMaterialAnim("Troll10_FX_ArmConceal01")
  end
  ai:HideJoint(ai:GetJointIndex("WeakspotArmJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotArmRagJoint"))
end
function LuaHook_Weakspot_LegOn(ai, data)
  ai:ShowJoint(ai:GetJointIndex("WeakSpotLegJoint"))
  ai:ShowJoint(ai:GetJointIndex("WeakspotLegRagJoint"))
  _G.global.WeakSpotLeg = true
end
function LuaHook_Weakspot_LegOff(ai, data)
  ai:HideJoint(ai:GetJointIndex("WeakSpotLegJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotLegRagJoint"))
  _G.global.WeakSpotLeg = false
end
function LuaHook_Weakspot_ArmOn(ai, data)
  ai:ShowJoint(ai:GetJointIndex("WeakspotArmJoint"))
  ai:ShowJoint(ai:GetJointIndex("WeakspotArmRagJoint"))
  _G.global.WeakSpotArm = true
end
function LuaHook_Weakspot_ArmOff(ai, data)
  ai:HideJoint(ai:GetJointIndex("WeakspotArmJoint"))
  ai:HideJoint(ai:GetJointIndex("WeakspotArmRagJoint"))
  _G.global.WeakSpotArm = false
end
function LuaHook_CheckWeakSpotLeg(ai, data)
  if _G.global.WeakSpotLeg then
    local anim = string.format("Troll%s_FX_LegConceal01", _G.global.trollName:match("%d%d"))
    ai:StartMaterialAnim(anim)
    ai:HideJoint(ai:GetJointIndex("WeakspotLegJoint"))
    ai:HideJoint(ai:GetJointIndex("WeakspotLegRagJoint"))
    _G.global.WeakSpotLeg = false
    if ai:PickupIsAcquired("TrollFireAura") then
      ai:PickupSetStage("TrollFireAura", 1)
    end
  end
end
function LuaHook_CheckWeakSpotArm(ai, data)
  if _G.global.WeakSpotArm then
    ai:StartMaterialAnim("Troll00_FX_ArmConceal_fast01")
    ai:HideJoint(ai:GetJointIndex("WeakspotArmJoint"))
    ai:HideJoint(ai:GetJointIndex("WeakspotArmRagJoint"))
    _G.global.WeakSpotArm = false
    if ai:PickupIsAcquired("TrollFireAura") then
      ai:PickupSetStage("TrollFireAura", 1)
    end
  end
end
function LuaHook_CheckWeakSpotMarker(ai, data)
  if _G.global.WeakSpotMarker then
    local stoneanim = string.format("trollstone%s_FXConceal", _G.global.trollName:match("%d%d"))
    _G.global.trollWeapon:StartMaterialAnim(stoneanim)
    LuaHook_HideMarkerWeakspotTop(ai, data)
  end
end
function LuaHook_ShowMarkerWeakspotTop(ai)
  if _G.global.trollName == "troll00" or _G.global.trollName == "troll10" then
    if _G.global.WeakSpotMarker == true then
      return
    end
    _G.global.trollWeapon:ShowJoint(_G.global.trollWeapon:GetJointIndex("JOMarkerWeakspotTop"))
    _G.global.trollWeapon:AddAimAssist({
      Joint = "JOMarkerWeakspotTop",
      Group = "AXE",
      Angle = 15,
      MaxRadius = 2.5,
      ZoomSnapScreenAngle = 15,
      ZoomSnapRadius = 2.5,
      MaxDistance = -1
    })
    _G.global.WeakSpotMarker = true
  else
    print("ERROR!! - troll20 or troll30 is attempting to toggle weapon-marker weakspots but they need to be included in LuaHook_ShowMarkerWeakspotTop")
    return
  end
end
function LuaHook_ShowMarkerWeakspotBottom(ai)
  if _G.global.trollName == "troll00" or _G.global.trollName == "troll10" then
    _G.global.trollWeapon:ShowJoint(_G.global.trollWeapon:GetJointIndex("JOMarkerWeakspotBottom"))
    _G.global.trollWeapon:AddAimAssist({
      Joint = "JOMarkerWeakspotBottom",
      Group = "AXE",
      Angle = 15,
      MaxRadius = 2.5,
      ZoomSnapScreenAngle = 15,
      ZoomSnapRadius = 2.5,
      MaxDistance = -1
    })
  else
    print("ERROR!! - troll20 or troll30 is attempting to toggle weapon-marker weakspots but they need to be included in LuaHook_ShowMarkerWeakspotBottom")
    return
  end
end
function LuaHook_HideMarkerWeakspotTop(ai)
  if _G.global.trollName == "troll00" or _G.global.trollName == "troll10" then
    _G.global.trollWeapon:HideJoint(_G.global.trollWeapon:GetJointIndex("JOMarkerWeakspotTop"))
    _G.global.trollWeapon:RemoveAimAssist({
      Joint = "JOMarkerWeakspotTop",
      Group = "AXE",
      Angle = 15,
      MaxRadius = 2.5
    })
    _G.global.WeakSpotMarker = false
  else
    print("ERROR!! - troll20 or troll30 is attempting to toggle weapon-marker weakspots but they need to be included in LuaHook_HideMarkerWeakspotTop")
    return
  end
end
function LuaHook_HideMarkerWeakspotBottom(ai)
  if _G.global.trollName == "troll00" or _G.global.trollName == "troll10" then
    _G.global.trollWeapon:HideJoint(_G.global.trollWeapon:GetJointIndex("JOMarkerWeakspotBottom"))
    _G.global.trollWeapon:RemoveAimAssist({
      Joint = "JOMarkerWeakspotBottom",
      Group = "AXE",
      Angle = 15,
      MaxRadius = 2.5
    })
  else
    print("ERROR!! - troll20 or troll30 is attempting to toggle weapon-marker weakspots but they need to be included in LuaHook_HideMarkerWeakspotBottom")
    return
  end
end
