local useAltPattern = 0
local SpawnIceEndPosition = function(ai, location)
  local collisionParams = {
    SourceGameObject = ai,
    ExcludeGameObject = ai,
    EntityType = game.CollisionType.New("kInvisibleBarrier", "kEnvironment"),
    CollidesWith = game.CollisionType.New("kEnvironment")
  }
  local endPos = engine.Vector.New(location.x, location.y, location.z)
  location.y = location.y + 1.5
  local hit = game.World.RaycastCollision(location, endPos, collisionParams)
  if hit then
    endPos = hit.Position
  end
  local iceSpike = game.FX.Spawn("Troll10_IceSpike", ai.Level, {EffectCreator = ai})
  iceSpike:SetWorldPosition(endPos)
end
function LuaHook_SpawnIceSpikes(ai, data)
  if ai:HasMarker("SpikeStrong") then
    useAltPattern = math.random(100)
  end
  local player = game.Player.FindPlayer()
  local heroForward = player:GetWorldForward()
  local heroLeft = player:GetWorldLeft()
  local offset, offset_width, endPos
  if 50 < useAltPattern then
    for i = -1, 1, 2 do
      print("i is ", i)
      for j = 1, -1, -2 do
        local heroLocation = player:GetWorldPosition()
        offset = heroForward * j * 2.75
        heroLocation = heroLocation + offset
        offset_width = heroLeft * i * 2.75
        heroLocation = heroLocation + offset_width
        SpawnIceEndPosition(ai, heroLocation)
      end
    end
  else
    for j = -1, 1 do
      local heroLocation = player:GetWorldPosition()
      offset = heroForward * (3.5 - math.abs(j) * 3.2)
      heroLocation = heroLocation + offset
      offset_width = heroLeft * j * 2.5
      heroLocation = heroLocation + offset_width
      SpawnIceEndPosition(ai, heroLocation)
    end
    if ai:HasMarker("SpikeStrong") then
      local heroLocation = player:GetWorldPosition()
      offset = heroForward * -3.5
      heroLocation = heroLocation + offset
      SpawnIceEndPosition(ai, heroLocation)
    end
  end
end
