local DL = require("design.DesignerLibrary")
local stompCount = 1
function LuaHook_SpawnSpotsSlam(ai)
  local player = game.Player.FindPlayer()
  local increment = 2
  local stepStart = stompCount
  local stepIncrement = 1
  if ai:PickupIsAcquired("TrollPhase") and 2 < ai:PickupGetStage("TrollPhase") then
    increment = 2
    stepStart = -4
    stepIncrement = 2
  end
  local aiLocation = player:GetWorldPosition()
  local aiForward = player:GetWorldForward()
  local aiLeft = player:GetWorldLeft()
  local stepRange = 1
  local stepWRange = 1
  local avoidanceList = ai:FindFriendlies(30)
  table.insert(avoidanceList, player)
  table.insert(avoidanceList, game.AI.FindSon())
  for i = stepStart, stompCount, stepIncrement do
    for j = -2, 2, increment do
      local offset = aiForward * i * stepRange
      aiLocation = aiLocation + offset
      local offset_width = aiLeft * j * stepWRange
      aiLocation = aiLocation + offset_width
      local spawnNav = game.NavMesh.ClosestLocation(aiLocation, ai)
      if spawnNav ~= nil then
        local spawnPos = spawnNav:FindConnectedLocationInRadius(0.1)
        local spawnPosValid = true
        for _, k in ipairs(avoidanceList) do
          if k ~= nil and DL.GetDistance(spawnPos, k) < 1.5 then
            spawnPosValid = false
            break
          end
        end
        if spawnPosValid then
          local warning = game.FX.Spawn("TrollRockMine", ai.Level, {EffectCreator = ai})
          warning:SetWorldPosition(spawnPos)
        end
      end
    end
  end
  stompCount = stompCount + 1
  if 6 <= stompCount then
    stompCount = 1
  end
end
function LuaHook_ResetStomp(ai)
  stompCount = 0
end
function OnSpawn(level, obj, spawnedObj)
  local player = game.Player.FindPlayer()
  obj:SetWorldPosition(player:GetWorldPosition())
  obj:SetWorldFacing(player:GetWorldForward())
end
