local DL = require("design.DesignerLibrary")
local triggered = false
local life_timer = 7
local creator, player
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  creator = level:FindSingleGameObject("gotroll30")
  local livingenemies = DL.FindLivingEnemies(player, 90)
  for _, enemy in pairs(livingenemies) do
    if string.find(enemy:GetName(), "troll") then
      creator = enemy
      break
    end
  end
  local bossScript = level:FindSingleGameObject("GuardianTroll_Scripting")
  game.SubObject.SetUpdateDisableDistance(obj, 50)
end
function OnUpdate(level, obj)
  if not triggered and life_timer <= 0 then
    OrbExpired(obj)
    return
  elseif not triggered and creator ~= nil and (creator:HasMarker("HitStagger") or creator:HasMarker("React")) then
    OrbExpired(obj)
    return
  end
  life_timer = life_timer - level:GetUnitTime()
end
function DetonateSelf(level, obj)
  print("hit")
  if not triggered then
    local concussionParams = {
      Tweak = "CNC_MAGIC_ORB_PREMATURE_EXPLODE",
      WorldLocation = obj:GetWorldPosition(),
      GameObject = obj,
      EnemyId = player:GetID()
    }
    game.Combat.PlayConcussion(concussionParams)
    triggered = true
    obj:Destroy()
    local bossScript = level:FindSingleGameObject("GuardianTroll_Scripting")
    bossScript:CallScript("SetHasDestroyByPlayer")
  end
end
function OnHitByWeapon(level, obj, attacker, weapon)
  DetonateSelf(level, obj)
end
function OnHitByConcussion(level, obj, concussionOwner, hitFlags, context)
  DetonateSelf(level, obj)
end
function OrbExpired(obj)
  if not triggered then
    local concussionParams = {
      Tweak = "CNC_MAGIC_ORB_EXPIRED",
      WorldLocation = obj:GetWorldPosition(),
      GameObject = obj,
      EnemyId = player:GetID()
    }
    game.Combat.PlayConcussion(concussionParams)
    triggered = true
  end
  obj:Destroy()
end
