local troll
local EXPLOSION_DELAY = 0.35
local explode_timer = EXPLOSION_DELAY
local life_timer = 5
function OnScriptLoaded(level, obj)
  local enemies = game.Player.FindPlayer():FindEnemies(80)
  for _, ai in ipairs(enemies) do
    if ai:GetName() == "troll30" then
      troll = ai
      break
    end
  end
  TriggerExplosion(level, obj)
  life_timer = troll:LookupFloatConstant("TROLL30_WAVE_DURATION")
  game.SubObject.SetUpdateDisableDistance(obj, 50)
end
function OnUpdate(level, obj)
  if life_timer <= 0 then
    obj:Destroy()
    return
  end
  if 0 < explode_timer then
    explode_timer = explode_timer - level:GetUnitTime()
    if explode_timer <= 0 then
      TriggerExplosion(level, obj)
      explode_timer = EXPLOSION_DELAY
    end
  end
  life_timer = life_timer - level:GetUnitTime()
end
function TriggerExplosion(lvl, obj)
  if obj == nil then
    return
  end
  local concussionParams = {
    Tweak = "CNC_MAGIC_WAVE_EXPLOSION",
    WorldLocation = obj:GetWorldPosition(),
    GameObject = troll,
    EnemyId = troll:GetID()
  }
  game.Combat.PlayConcussion(concussionParams)
end
