local DL = require("design.DesignerLibrary")
local stompCount = 1
local minRange = 6
local maxRange = 15
local stepRange = 2.5
local stepWRange = 1.5
local spawnCount = 0
local resetPositionTimer = 0
local SetStandBackMode = function(ai, global, constants, timer)
  constants.fightKnowledgeInputs.Zones.Default.Aggressive[1].Constraints[1].Min = 3
  constants.fightKnowledgeInputs.Zones.Default.Aggressive[1].Constraints[1].Max = 25
  ai:SetAggressivePriority(20)
  global.passiveModeTimer = timer
  resetPositionTimer = 1.5
end
local SpawnEnemy = function(ai, spawnPos)
  local clone = game.AI.Spawn(ai.Level, spawnPos, ai:GetWorldForward(), "CRT_Projection00", "BRA_SpawnFromTroll30", {PowerLevel = "3", BodyType = "Hellwalker"}, "Projection_helwalker_moderate")
  if clone then
    clone:SetAIDeathCallback(ai, "OnCloneDeath")
    spawnCount = spawnCount + 1
  end
end
local SpawnClonesLight = function(ai)
  local aiLocation = ai:GetWorldPosition()
  local aiForward = ai:GetWorldForward()
  local aiLeft = ai:GetWorldLeft()
  for i = -1, 1 do
    local offset = aiForward * 1 * stepRange
    aiLocation = aiLocation + offset
    local offset_width = aiLeft * i * stepWRange
    aiLocation = aiLocation + offset_width
    local spawnPos = game.NavMesh.ClosestLocation(aiLocation, ai):FindConnectedLocationInRadius(0.5)
    engine.DrawFillSphere(spawnPos, 0.5, 65280, 3)
    SpawnEnemy(ai, spawnPos)
  end
end
local SpawnClonesHeavy = function(ai)
  local increment = 2
  local aiLocation = ai:GetWorldPosition()
  local aiForward = ai:GetWorldForward()
  local aiLeft = ai:GetWorldLeft()
  if 3 < spawnCount then
    return
  end
  if stompCount == 2 then
    stompCount = -stompCount
  elseif stompCount == 3 then
    stompCount = 0
  end
  for j = -1, 1, increment do
    local offset = aiForward * stompCount * stepRange
    aiLocation = aiLocation + offset
    local offset_width = aiLeft * j * stepWRange
    aiLocation = aiLocation + offset_width
    local spawnPos = game.NavMesh.ClosestLocation(aiLocation, ai):FindConnectedLocationInRadius(0.5)
    SpawnEnemy(ai, spawnPos)
  end
  stompCount = stompCount + 1
end
function LuaHook_SpawnClones(ai)
  if 4 < spawnCount then
    return
  end
  SpawnClonesLight(ai)
  SetStandBackMode(ai, _G.global, _G.constants, 30)
end
function LuaHook_CanSummonClones(ai)
  local max = 2
  if ai:PickupGetStage("TrollPhase") == 2 then
    max = 3
  elseif ai:PickupGetStage("TrollPhase") == 3 then
    max = 4
  end
  if max <= spawnCount then
    return false
  end
  return true
end
function OnCloneDeath(ai, data)
  print("death")
  spawnCount = spawnCount - 1
  if spawnCount <= 0 then
    _G.constants.fightKnowledgeInputs.Zones.Default.Aggressive[1].Constraints[1].Min = _G.constants.fightPosDataDefault.AggressiveMinDistance
    _G.constants.fightKnowledgeInputs.Zones.Default.Aggressive[1].Constraints[1].Max = _G.constants.fightPosDataDefault.AggressiveMaxDistance
    ai:RevertAggressivePriority()
  end
end
function LuaHook_IncreaseFightDistance(ai)
  SetStandBackMode(ai, _G.global, _G.constants, 9)
end
function LuaHook_MarkerPowerOn(ai, data)
  if _G.global.trollWeapon ~= nil then
    _G.global.trollWeapon:HideJoint(_G.global.trollWeapon:GetJointIndex("JOLights"))
  end
end
function _G.Brain_Core:OnBroadcastReaction(event, ai, global, constants)
  if not ai:IsInNavigationMove() or ai:PickupGetStage("TrollPhase") < 2 then
    return
  end
  if not DL.CheckCreatureContext(event.broadcastContext, "HERO_SPECIAL_ATTACK") then
    return
  end
  local target = ai:GetTargetCreature()
  if target:HasMarker("Aiming") == true then
    print("Kratos is aiming. evade")
    if math.random(100) > 50 then
      ai:TriggerMoveEvent("kLE_TeleportL")
    else
      ai:TriggerMoveEvent("kLE_TeleportR")
    end
  end
end
function _G.Brain_Core:OnHitReaction(event, ai, global, constants)
  if ai:HasMarker("CanTeleport") and ai:PickupGetStage("TrollPhase") >= 2 then
    ai:TriggerMoveEvent("kLE_TeleportNow")
  end
end
function _G.Brain_Core:OnUpdateMotion(ai, global, constants, actuatorData, avoidanceArgs)
  if 0 < resetPositionTimer then
    resetPositionTimer = resetPositionTimer - ai:GetUnitTime()
    actuatorData.Destination = ai:GetWorldPosition()
  end
end
