local LD = require("design.LevelDesignLibrary")
local STATE_INIT, STATE_PRIMED, STATE_EXPLODE, STATE_DESTROYED = 0, 1, 2, 3
local thisEmitter
local state = STATE_INIT
local objectPosition, explosionTime
function OnScriptLoaded(level, obj)
  objectPosition = obj:GetWorldPosition()
end
function OnStart(level, obj)
  EmitExplosiveWave(level, obj)
end
function OnUpdate(level, obj)
end
function EmitExplosiveWave(level, obj)
  local arrowData = {}
  arrowData.Tweak = "ARR_EXPLOSIVE_WAVE_LUA"
  arrowData.Level = level
  arrowData.EmitLocation = objectPosition
  arrowData.TargetLocation = objectPosition + obj:GetWorldForward() * 20
  game.Combat.EmitArrow(arrowData)
  engine.DrawLine(objectPosition, arrowData.TargetLocation, 16711680, 3)
  obj:Destroy()
end
