local LD = require("design.LevelDesignLibrary")
local timerLib = require("level.timer")
local STATE_INIT, STATE_PRIMED, STATE_EXPLODE, STATE_DESTROYED = 0, 1, 2, 3
local thisEmitter
local state = STATE_INIT
local explosionDelay = 1.5
local ExplosionTimer, objectPosition, creatureOwner
function OnScriptLoaded(level, obj)
  thisEmitter = obj:FindSingleSoundEmitterByName("SNDiceSpike")
  objectPosition = obj:GetWorldPosition()
  creatureOwner = obj:GetEffectObjectCreator()
  LD.PlaySound(thisEmitter, "SND_CHR_Troll_Ice_Atk_Juggernaut_Pillar_Erupt")
  ExplosionTimer = StartLevelTimer(explosionDelay, function()
    TriggerExplosion(obj)
  end)
  ExplosionTimer:Restart()
end
function OnUpdate(level, obj)
  if state == STATE_INIT then
    state = STATE_PRIMED
    LD.PlaySound(thisEmitter, "SND_CHR_Troll_Ice_Atk_Juggernaut_Pillar_Stress_LP")
  elseif state == STATE_EXPLODE then
    obj:Destroy()
    state = STATE_DESTROYED
  end
end
function TriggerExplosion(obj)
  print(creatureOwner)
  local concussionParams = {
    Tweak = "CNC_ICICLE_JUGG_ICE_SPIKE",
    WorldLocation = objectPosition,
    Creature = creatureOwner,
    EnemyId = creatureOwner:GetID()
  }
  game.Combat.PlayConcussion(concussionParams)
  obj:Hide()
  obj:HideCollision()
  LD.StopSound(thisEmitter, "SND_CHR_Troll_Ice_Atk_Juggernaut_Pillar_Stress_LP")
  state = STATE_EXPLODE
end
