local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local player
local STATE_INIT, STATE_PRIMED, STATE_TRIGGERED, STATE_EXPLODE, STATE_DESTROYED = 0, 1, 2, 3, 4
local trigger_time = 2
local timer = 0
local state = STATE_INIT
local rockMineEmitter
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
end
local mainTroll, secondTroll
function OnStart(level, obj)
  print("mine start")
  trigger_time = math.random(18, 24)
  local enemies = DL.FindLivingEnemies(player, 200)
  for i = 1, #enemies do
    if enemies[i]:GetName() == "troll20" then
      if mainTroll == nil then
        mainTroll = enemies[i]
      elseif secondTroll == nil then
        secondTroll = enemies[i]
      end
    end
  end
end
local TriggerExplosion = function(obj)
  LD.StopSound(rockMineEmitter, "SND_CHR_Troll_Stone_Atk_MarkerSlam_PillarCook_LP")
  local owner = obj:GetEffectObjectCreator()
  if owner ~= nil then
    local concussionParams = {
      Tweak = "CNC_ROCK_MINE_EXLOPDE",
      WorldLocation = obj:GetWorldPosition(),
      Creature = owner,
      EnemyId = owner:GetID()
    }
    game.Combat.PlayConcussion(concussionParams)
  end
  obj:Hide()
  obj:HideCollision()
end
function OnUpdate(level, obj)
  if state == STATE_INIT then
    timer = timer + level:GetUnitTime()
    if 1.5 <= timer then
      timer = 0
      state = STATE_PRIMED
    end
    if rockMineEmitter == nil then
      rockMineEmitter = obj:FindSingleSoundEmitterByName("SNDtemptrollrockmine")
      LD.PlaySound(rockMineEmitter, "SND_CHR_Troll_Stone_Atk_MarkerSlam_PillarErupt")
      LD.PlaySound(rockMineEmitter, "SND_CHR_Troll_Stone_Atk_MarkerSlam_PillarCook_LP")
    end
  elseif state == STATE_PRIMED then
    timer = timer + level:GetUnitTime()
    local owner = obj:GetEffectObjectCreator()
    if timer >= trigger_time then
      TriggerExplosion(obj)
      timer = 0
      state = STATE_EXPLODE
    elseif obj ~= nil and owner ~= nil then
      if game.AIUtil.Distance(obj, player) <= 2 or mainTroll ~= nil and game.AIUtil.Distance(obj, mainTroll) < 2.75 or secondTroll ~= nil and game.AIUtil.Distance(obj, secondTroll) < 2.75 then
        timer = 0
        state = STATE_TRIGGERED
      end
    elseif obj == nil or owner == nil then
      timer = 0
      state = STATE_TRIGGERED
    end
  elseif state == STATE_TRIGGERED then
    timer = timer + level:GetUnitTime()
    TriggerExplosion(obj)
    timer = 0
    state = STATE_EXPLODE
  elseif state == STATE_EXPLODE then
    timer = timer + level:GetUnitTime()
    if 1 <= timer then
      obj:Destroy()
      state = STATE_DESTROYED
    end
  end
end
function OnConcussionHit(level, obj, attacker, hitflags, context)
  if attacker:GetName() == "troll20" then
    TriggerExplosion(obj)
    timer = 0
    state = STATE_EXPLODE
  end
end
function OnHitByConcussion(level, obj, attacker, hitFlags, context)
  if attacker:GetName() == "troll20" then
    TriggerExplosion(obj)
    timer = 0
    state = STATE_EXPLODE
  end
end
function OnHitByCreature(obj, test, test2)
  TriggerExplosion(obj)
  timer = 0
  state = STATE_EXPLODE
end
function OnHitByWeapon(level, obj, weapon, weaponOwnerCreature, hitflags, context)
  TriggerExplosion(obj)
  timer = 0
  state = STATE_EXPLODE
end
