require("level.timer")
thisLevel = nil
thisGO = nil
enemyPuppeteer = nil
breakable = nil
notBrokenYet = true
synchJointFacing = nil
synchJointLocation = nil
enemyPickup = "GruntShield"
cooldown = 60
maxPickups = 0
usedPickups = 0
weaponRackActive = true
function OnScriptLoaded(level, go)
  thisLevel = level
  thisGO = go
  breakable = go:GetBreakable()
  local jointIndex = go:GetJointIndex("synchJoint")
  synchJointFacing = go:GetWorldJointForward(jointIndex)
  synchJointLocation = go:GetWorldJointPosition(jointIndex)
  if go:FindLuaTableAttribute("enemyPickup") ~= nil and go:FindLuaTableAttribute("enemyPickup") ~= "" then
    enemyPickup = go:FindLuaTableAttribute("enemyPickup")
  end
  if go:FindLuaTableAttribute("cooldown") ~= nil and go:FindLuaTableAttribute("cooldown") ~= "" then
    cooldown = go:FindLuaTableAttribute("cooldown")
  end
  if go:FindLuaTableAttribute("maxPickups") ~= nil and go:FindLuaTableAttribute("maxPickups") ~= "" then
    maxPickups = go:FindLuaTableAttribute("maxPickups")
  end
  if go:FindLuaTableAttribute("maxPickups") ~= nil and go:FindLuaTableAttribute("maxPickups") ~= "" then
    weaponRackActive = go:FindLuaTableAttribute("weaponRackActive")
  end
end
function OnUpdate(level, go)
  if notBrokenYet and breakable.Broken then
    notBrokenYet = false
    weaponRackActive = false
    if enemyPuppeteer ~= nil then
      enemyPuppeteer:Clear()
      enemyPuppeteer:DetachPuppet()
    end
  end
  if (usedPickups < maxPickups or maxPickups == 0) and enemyPuppeteer == nil and notBrokenYet and weaponRackActive then
    enemyPuppeteer = game.Puppeteer.NewEngagement(go, "POI_WeaponRack")
    enemyPuppeteer:Advertise("BANDIT:WEAPONRACK")
    enemyPuppeteer:OnEngaged(BanditEngaged)
    enemyPuppeteer:OnEvent(BanditDisengage, "kEHitReaction")
  end
end
function BanditEngaged(thisPuppeteer)
  if enemyPuppeteer ~= nil then
    enemyPuppeteer:Clear()
    enemyPuppeteer:Approach({
      pos = synchJointLocation,
      speed = 3.8,
      stop = false
    })
    enemyPuppeteer:OnEvent(BanditDisengage, "kEHitReaction")
    enemyPuppeteer:OnArrival(BanditArrivedAtDestination, {
      pos = synchJointLocation,
      radius = 0.5
    })
  end
end
function BanditArrivedAtDestination(thisPuppeteer)
  if enemyPuppeteer ~= nil then
    enemyPuppeteer:Clear()
    if thisPuppeteer ~= nil then
      thisPuppeteer:Align({
        pos = synchJointLocation,
        aligntime = 0.2,
        facing = synchJointFacing
      })
    end
    enemyPuppeteer:OnComplete(BanditEquipWeapon)
    enemyPuppeteer:OnEvent(BanditDisengage, "kEHitReaction")
  end
end
function BanditEquipWeapon(thisPuppeteer)
  if enemyPuppeteer ~= nil then
    enemyPuppeteer:Clear()
    enemyPuppeteer:StartMove("MOV_EquipWpnRackShield")
    usedPickups = usedPickups + 1
    enemyPuppeteer:OnEvent(BanditDisengage, "kEHitReaction")
    enemyPuppeteer:OnComplete(BanditDisengage)
  end
end
function BanditDisengage(thisPuppeteer)
  if enemyPuppeteer ~= nil then
    local cooldownTimer = StartLevelTimer(cooldown, OnCooldownDone)
    enemyPuppeteer:Clear()
    enemyPuppeteer:DetachPuppet()
  end
end
function OnCooldownDone(timer)
  enemyPuppeteer = nil
end
function ActivateWeaponRack(thisPuppeteer)
  weaponRackActive = true
end
function DeactivateWeaponRack(thisPuppeteer)
  weaponRackActive = false
end
