local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local thisObj, player, damageMonitor
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  local trigger = thisObj:FindSingleGOByName("DamageZone")
  damageMonitor = monitors.CreateEntityZoneMonitor(player, trigger)
  damageMonitor:OnEnter(DamagePlayer)
  game.SubObject.Sleep(obj)
end
function DamagePlayer()
  local concussionParams = {
    Tweak = "CNC_SpikeFloorInstant",
    WorldLocation = player.WorldPosition,
    GameObject = thisObj,
    EnemyId = player:GetID()
  }
  game.Combat.PlayConcussion(concussionParams)
end
