local locomotion = require("creature.locomotion")
local thisLevel, player, splineName
local settings = {}
local enabled
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  splineName = obj:GetLuaTableAttribute("SplineObject")
  settings.Radius = obj:GetLuaTableAttribute("Radius")
  settings.MaxTranslationAngle = obj:GetLuaTableAttribute("MaxTranslationAngle")
  settings.MaxRotationAngle = obj:GetLuaTableAttribute("MaxRotationAngle")
  settings.MaxPadAngle = 120
  settings.TaperDistance = 15
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if enabled then
    Enable()
  end
end
function OnSaveCheckpoint(level, obj)
  return {enabled = enabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
function Enable()
  local curve = thisLevel:FindSingleNavCurve(splineName)
  if player and curve then
    enabled = true
    locomotion.FollowNavCurve(player, curve, settings)
  end
end
function Disable()
  if player then
    enabled = false
    locomotion.FollowNavCurve(player, nil)
  end
end
