LD = require("design.LevelDesignLibrary")
timer = require("level.timer")
bboardUtil = require("game.BlackboardUtil")
thisLevel = nil
thisGO = nil
sonPuppeteer = nil
hasTriggered = false
lookForMove = false
moveName = ""
zoneTrigger = false
zoneName = ""
function OnScriptLoaded(level, go)
  if go:FindLuaTableAttribute("LookForMove") ~= nil then
    lookForMove = go:FindLuaTableAttribute("LookForMove")
  end
  if go:FindLuaTableAttribute("MoveName") ~= nil then
    moveName = go:FindLuaTableAttribute("MoveName")
  end
  if go:FindLuaTableAttribute("ZoneTrigger") ~= nil then
    zoneTrigger = go:FindLuaTableAttribute("ZoneTrigger")
  end
  if go:FindLuaTableAttribute("ZoneName") ~= nil then
    zoneName = go:FindLuaTableAttribute("ZoneName")
  end
end
function OnUpdate(level, go)
  thisGO = go
  if lookForMove == true then
    if hasTriggered == false and game.Player.FindPlayer():IsPlayingMove(moveName) then
      hasTriggered = true
      sonPuppeteer = game.Puppeteer.New(go, "TakedownLoc", game.AI.FindSon())
      sonPuppeteer:Advertise("SON:AUTO")
      sonPuppeteer:OnEngaged(EngagedWithPOI)
    end
  elseif zoneTrigger == true and hasTriggered == false and game.Player.FindPlayer():IsInsideEntityZone(zoneName) then
    hasTriggered = true
    sonPuppeteer = game.Puppeteer.New(go, "TakedownLoc", game.AI.FindSon())
    sonPuppeteer:Advertise("SON:AUTO")
    sonPuppeteer:OnEngaged(EngagedWithPOI)
  end
end
function EngagedWithPOI(thisPuppeteer)
  sonPuppeteer:Clear()
  local jointIndex = thisGO:GetJointIndex("FirstPosition")
  local jointPosition = thisGO:GetWorldJointPosition(jointIndex)
  sonPuppeteer:Approach({
    pos = jointPosition,
    speed = 5,
    stop = true
  })
  sonPuppeteer:OnArrival(ArrivedAtDestination, {pos = jointPosition, radius = 0.5})
end
function SpotEnemy(thisPuppeteer)
  sonPuppeteer:Clear()
  local jointIndex = thisGO:GetJointIndex("SecondPosition")
  local jointPosition = thisGO:GetWorldJointPosition(jointIndex)
  sonPuppeteer:Approach({
    pos = jointPosition,
    speed = 1,
    stop = true
  })
  sonPuppeteer:OnArrival(UnsheathBow, {pos = jointPosition, radius = 0.5})
end
function UnsheathBow(thisPuppeteer)
  sonPuppeteer:Clear()
  sonPuppeteer:StartMove("MOV_UnsheathStalk_E3")
  local jointIndex = thisGO:GetJointIndex("ThirdPosition")
  local jointPosition = thisGO:GetWorldJointPosition(jointIndex)
  engine.DrawFillSphere(jointPosition, 5, 16711935, 10)
  sonPuppeteer:Approach({
    pos = jointPosition,
    speed = 1,
    stop = true
  })
  sonPuppeteer:OnArrival(ArrivedAtDestination, {pos = jointPosition, radius = 0.5})
end
function ArrivedAtDestination(thisPuppeteer)
  sonPuppeteer:Clear()
  sonPuppeteer:SetType("TakeDown")
  sonPuppeteer:StartMove("MOV_ShootBowSpecial_Enter")
  sonPuppeteer:OnEvent(FinishedShooting, "done")
end
function FinishedShooting(thisPuppeteer)
  sonPuppeteer:Clear()
  sonPuppeteer:DetachPuppet()
end
function Disengage(thisPuppeteer)
  sonPuppeteer:Clear()
  sonPuppeteer:DetachPuppet()
end
