local class = require("core.class")
local IOpenClose = class.Class("IOpenClose")
function IOpenClose:init(openAnimName, closeAnimName, openCloseAnimName)
  self.openAnimName = openAnimName
  self.closeAnimName = closeAnimName
  self.openCloseAnimName = openCloseAnimName
  self.toggleValue = "closed"
end
function IOpenClose:Open(level, go)
  go:StartAnim(self.openAnimName)
end
function IOpenClose:Close(level, go)
  go:StartAnim(self.closeAnimName)
end
function IOpenClose:OpenClose(level, go)
  go:StartAnim(self.openCloseAnimName)
end
function IOpenClose:Toggle(level, go)
  if self.toggleValue == "closed" then
    if self.openAnimName then
      go:StartAnim(self.openAnimName)
    else
      go:PlayAnimToPercent(1, 1)
    end
    self.toggleValue = "opened"
  else
    if self.closeAnimName then
      go:StartAnim(self.closeAnimName)
    else
      go:PlayAnimToPercent(0, -1)
    end
    self.toggleValue = "closed"
  end
end
return {IOpenClose = IOpenClose}
