local thisObj
local lootAcquired = false
local marker = "squirrelLoot"
local lootObject, thisLevel
function OnScriptLoaded(level, obj)
  thisObj = obj
  obj:AddMarker(marker)
  lootObject = obj:GetLuaTableAttribute("LootObject")
  thisLevel = level
end
function OnStart(level, obj)
  if lootAcquired then
    RemoveLootMarker()
  end
end
function ObjectLooted()
  lootAcquired = true
  RemoveLootMarker()
end
function RemoveLootMarker()
  if thisObj:HasMarker(marker) then
    thisObj:RemoveMarker(marker)
  end
end
function SpawnLoot(level, go, position)
  local lootObjectSpawnArgs = {
    SpawnObject = lootObject,
    HookName = "OnLootSpawn",
    OffsetPosition = position,
    Level = thisLevel,
    Velocity = engine.Vector.New(math.random() - 0.5, 3.5, math.random() - 0.5)
  }
  thisObj:SpawnGameObject(lootObjectSpawnArgs)
  ObjectLooted()
end
function OnLootSpawn(level, go, spawnedObject)
  lootAcquired = true
end
function OnSaveCheckpoint(level)
  return {lootAcquired = lootAcquired}
end
function OnRestoreCheckpoint(level, savedInfo)
  lootAcquired = savedInfo.lootAcquired
end
