local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local LM = require("level.loadmonitor")
local alfheimTrenchRoof = false
local trenchRoofCheck = false
local pulseOn = false
function OnFirstStart(level)
  GameObjects.BEAM_FX_POST:Hide()
  GameObjects.Skydome_Dark:Show()
  GameObjects.Skydome_Light:Hide()
  GameObjects.AnimateWaterOnly:Show()
  GameObjects.MAIN_01_Parent:Show()
  GameObjects.MAIN_02_Parent:Show()
  GameObjects.MAIN_03_Parent:Show()
  GameObjects.MAIN_04_Parent:Show()
  GameObjects.AnimateWaterOnly_HAPPY:Hide()
  GameObjects.MAIN_01_Parent_HAPPY:Hide()
  GameObjects.MAIN_02_Parent_HAPPY:Hide()
  GameObjects.MAIN_03_Parent_HAPPY:Hide()
  GameObjects.MAIN_04_Parent_HAPPY:Hide()
  HideTemple()
  HideRing()
end
function OnStart(level)
  local monitor = LM.CreateLoadMonitor()
  monitor:AddCallback({
    Wads = {"BoatGlobal"},
    Functions = {
      ToggleFishSpawn
    }
  })
  local player = game.Player.FindPlayer()
  if player:InsideZone("entityZone_InsideTemple") then
    HideTemple()
    HideRing()
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    GameObjects.Skydome_Dark:Hide()
    GameObjects.Skydome_Light:Show()
    GameObjects.AnimateWaterOnly:Hide()
    GameObjects.MAIN_01_Parent:Hide()
    GameObjects.MAIN_02_Parent:Hide()
    GameObjects.MAIN_03_Parent:Hide()
    GameObjects.MAIN_04_Parent:Hide()
    GameObjects.AnimateWaterOnly_HAPPY:Show()
    GameObjects.MAIN_01_Parent_HAPPY:Show()
    GameObjects.MAIN_02_Parent_HAPPY:Show()
    GameObjects.MAIN_03_Parent_HAPPY:Show()
    GameObjects.MAIN_04_Parent_HAPPY:Show()
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    GameObjects.Skydome_Dark:Show()
    GameObjects.Skydome_Light:Hide()
    GameObjects.AnimateWaterOnly:Show()
    GameObjects.MAIN_01_Parent:Show()
    GameObjects.MAIN_02_Parent:Show()
    GameObjects.MAIN_03_Parent:Show()
    GameObjects.MAIN_04_Parent:Show()
    GameObjects.AnimateWaterOnly_HAPPY:Hide()
    GameObjects.MAIN_01_Parent_HAPPY:Hide()
    GameObjects.MAIN_02_Parent_HAPPY:Hide()
    GameObjects.MAIN_03_Parent_HAPPY:Hide()
    GameObjects.MAIN_04_Parent_HAPPY:Hide()
  end
  if LD.GetEntityVariable("ALF_TrenchOpen") == false then
    GameObjects.MAIN_01_Parent_HAPPY:JumpAnimToFrame(0)
    GameObjects.MAIN_02_Parent_HAPPY:JumpAnimToFrame(0)
    GameObjects.MAIN_03_Parent_HAPPY:JumpAnimToFrame(0)
    GameObjects.MAIN_04_Parent_HAPPY:JumpAnimToFrame(0)
    GameObjects.MAIN_01_Parent_HAPPY:PauseAnim()
    GameObjects.MAIN_02_Parent_HAPPY:PauseAnim()
    GameObjects.MAIN_03_Parent_HAPPY:PauseAnim()
    GameObjects.MAIN_04_Parent_HAPPY:PauseAnim()
  end
end
function SetBoatSpeed()
  local data = {}
  data.TargetMaxSpeed = 6
  data.TargetMaxRotationSpeed = 80
  data.TargetAcceleration = 12.5
  data.TargetAngularAcceleration = 160
  data.MaxSpeedChangeRate = 6
  data.MaxRotationSpeedChangeRate = 100
  data.AccelerationChangeRate = 6
  data.AngularAccelerationChangeRate = 100
  game.Boat.SetGlobalSpeedControlData(data)
end
function ResetBoatSpeed()
  local data = {}
  data.TargetMaxSpeed = 9
  data.TargetMaxRotationSpeed = 80
  data.TargetAcceleration = 12.5
  data.TargetAngularAcceleration = 160
  data.MaxSpeedChangeRate = 6
  data.MaxRotationSpeedChangeRate = 100
  data.AccelerationChangeRate = 6
  data.AngularAccelerationChangeRate = 100
  game.Boat.SetGlobalSpeedControlData(data)
end
function ClearBoatOverrides()
  game.Boat.ClearGlobalSpeedControlData()
end
function ToggleFishSpawn()
  local fishWad = game.FindLevel("BoatGlobal")
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    fishWad:FindGameObject("SwimSpawner").Child:CallScript("Enable")
    fishWad:FindGameObject("JumpOutLowSpawner").Child:CallScript("Enable")
    fishWad:FindGameObject("JumpOutSpawner").Child:CallScript("Enable")
  else
    fishWad:FindGameObject("SwimSpawner").Child:CallScript("Disable")
    fishWad:FindGameObject("JumpOutLowSpawner").Child:CallScript("Disable")
    fishWad:FindGameObject("JumpOutSpawner").Child:CallScript("Disable")
  end
end
function DisableMainDock()
  GameObjects.Boat_Dock_1.LuaObjectScript.DisableAndClear()
end
function EnableMainDock()
  GameObjects.Boat_Dock_1.LuaObjectScript.Enable()
end
function SpawnBackupBoat()
  GameObjects.Boat_Dock_2.LuaObjectScript.SpawnVehicle()
end
function DisableIslandDock()
  GameObjects.Boat_Dock_2.LuaObjectScript.Disable()
end
function EnableIslandDock()
  GameObjects.Boat_Dock_2.LuaObjectScript.Enable()
end
function ExitBoat_IslandDock()
  game.Level.SetVariable("ALF_AtIslandDock", true)
  local alf320 = game.FindLevel("Alf320_TrenchADark")
  if alf320 ~= nil then
    alf320:CallScript("ExitBoat_IslandDock")
  end
  if LD.GetEntityVariable("ALF_LakeRunesFound") and LD.GetEntityVariable("ALF_LightAcquired") == false then
    DisableIslandDock()
    game.Compass.SetDesignerForcedHide(true)
  end
end
function EnterBoat_IslandDock()
  game.Level.SetVariable("ALF_AtIslandDock", false)
  local alf320 = game.FindLevel("Alf320_TrenchADark")
  if alf320 ~= nil then
    alf320:CallScript("EnterBoat_IslandDock")
  end
end
function EnterBoat_MainDock()
  game.Level.SetVariable("ALF_AtMainDock", false)
end
function ExitBoat_MainDock()
  game.Level.SetVariable("ALF_AtMainDock", true)
end
function ActivateTrenchRoof()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    GameObjects.MAIN_01_Parent:PlayAnimToEnd()
    GameObjects.MAIN_02_Parent:PlayAnimToEnd()
    GameObjects.MAIN_03_Parent:PlayAnimToEnd()
    GameObjects.MAIN_04_Parent:PlayAnimToEnd()
    GameObjects.MAIN_01_Parent_HAPPY:PlayAnimToEnd()
    GameObjects.MAIN_02_Parent_HAPPY:PlayAnimToEnd()
    GameObjects.MAIN_03_Parent_HAPPY:PlayAnimToEnd()
    GameObjects.MAIN_04_Parent_HAPPY:PlayAnimToEnd()
  end
end
function CloseTrenchRoof()
  if LD.GetEntityVariable("ALF_LightAcquired") == true and LD.GetEntityVariable("ALF_TrenchOpen") == true and LD.GetEntityVariable("ALF_TrenchClosing") == true and LD.GetEntityVariable("ALF_TrenchClosed") == false and alfheimTrenchRoof == false then
    alfheimTrenchRoof = true
    GameObjects.MAIN_01_Parent:JumpAnimToFrame(560)
    GameObjects.MAIN_01_Parent:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_02_Parent:JumpAnimToFrame(560)
    GameObjects.MAIN_02_Parent:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_03_Parent:JumpAnimToFrame(560)
    GameObjects.MAIN_03_Parent:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_04_Parent:JumpAnimToFrame(560)
    GameObjects.MAIN_04_Parent:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_01_Parent_HAPPY:JumpAnimToFrame(560)
    GameObjects.MAIN_01_Parent_HAPPY:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_02_Parent_HAPPY:JumpAnimToFrame(560)
    GameObjects.MAIN_02_Parent_HAPPY:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_03_Parent_HAPPY:JumpAnimToFrame(560)
    GameObjects.MAIN_03_Parent_HAPPY:PlayAnimToFrame(0, -1)
    GameObjects.MAIN_04_Parent_HAPPY:JumpAnimToFrame(560)
    GameObjects.MAIN_04_Parent_HAPPY:PlayAnimToFrame(0, -1)
  end
end
function TurnOnTemple()
  GameObjects.reflect_temple:Show()
  local alf690 = game.FindLevel("Alf690_LakeLightLH")
  if alf690 ~= nil then
    LD.CallFunctionAfterDelay(function()
      alf690:CallScript("TurnOff_690RingAndBeam")
    end, 0.1)
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    GameObjects.BEAM_FX_PRE:Show()
    GameObjects.BEAM_FX_POST:Hide()
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    GameObjects.BEAM_FX_PRE:Hide()
    GameObjects.BEAM_FX_POST:Show()
    GameObjects.RedGodRays:Hide()
  end
end
function TurnOffTemple()
  GameObjects.reflect_temple:Hide()
  local alf690 = game.FindLevel("Alf690_LakeLightLH")
  if alf690 ~= nil then
    LD.CallFunctionAfterDelay(function()
      alf690:CallScript("TurnOn_690RingAndBeam")
    end, 0.1)
  end
end
function HideRing()
  GameObjects.reflect_ring:Hide()
end
function HideTemple()
  GameObjects.reflect_temple:Hide()
  local alf690 = game.FindLevel("Alf690_LakeLightLH")
  if alf690 ~= nil then
    LD.CallFunctionAfterDelay(function()
      alf690:CallScript("TurnOn_690RingAndBeam")
    end, 0.1)
  end
end
function ShowRing()
  GameObjects.reflect_ring:Show()
end
function ShowTemple()
  GameObjects.reflect_temple:Show()
  local alf690 = game.FindLevel("Alf690_LakeLightLH")
  if alf690 ~= nil then
    LD.CallFunctionAfterDelay(function()
      alf690:CallScript("TurnOff_690RingAndBeam")
    end, 0.1)
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    GameObjects.BEAM_FX_PRE:Show()
    GameObjects.BEAM_FX_POST:Hide()
  end
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    GameObjects.BEAM_FX_PRE:Hide()
    GameObjects.BEAM_FX_POST:Show()
    GameObjects.RedGodRays:Hide()
  end
end
function EnableBeachDock()
  timer.StartLevelTimer(28, function()
    GameObjects.DockPoint_200_Beach.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(28, function()
    GameObjects.Boat_Dock_1.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(28, function()
    GameObjects.Boat_Dock_2.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(28, function()
    GameObjects.DockPoint_110_Beach.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(28, function()
    GameObjects.DockPoint_210_Beach.LuaObjectScript.Enable()
  end)
  local alf200 = game.FindLevel("Alf200_MazeDark")
  if alf200 ~= nil then
    alf200:CallScript("HideBoatIC")
  end
end
function CallBridgeDisappearsPOI()
  local alf300 = game.FindLevel("Alf300_LakeDark")
  if alf300 ~= nil then
    local poi_BridgeDisappears_Obj = alf300:GetGameObject("POI_AlfSonLightBridgeObscured")
    poi_BridgeDisappears_Obj:CallScript("LightBridgeSequence")
  end
end
function LoadCheck_Cal120()
  game.UI.LoadCheck("Cal120_Airlock", "Cal130_TempleInt")
end
function LoadCheck_200()
  game.UI.LoadCheck("Alf200_MazeDark", "Alf150_BridgeDark")
end
function LoadCheck_210()
  game.UI.LoadCheck("Alf210_LakeDarkLH", "Alf200_MazeDark")
end
function LoadCheck_300()
  game.UI.LoadCheck("Alf300_LakeDark")
end
function LoadCheck_340()
  game.UI.LoadCheck("Alf340_TrenchBDark")
end
function LoadCheck_390()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    game.UI.LoadCheck("Alf390_TempleExtLH")
  end
end
function LoadCheck_600690()
  game.UI.LoadCheck("Alf600_TempleInt", "Alf690_LakeLightLH")
end
function LoadCheck_320370()
  game.UI.LoadCheck("Alf320_TrenchADark", "Alf370_MoatScripting", "Alf300_LakeDark")
end
function FirePulse()
  GameObjects.AnimatedPulseWind:JumpAnimToPercent(0)
  GameObjects.AnimatedPulseWind:PlayAnimToEnd()
end
