local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kratosActor, sonActor, boatActor, boat_Start, boat_Start_Fwd, cineBoat, boatHelper
local boatDown = false
local cineEnterCamera_AreYouSerious
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 215 then
    CreateActorsAndPositions()
    SetSpawnFunctions()
    if boatDown == false then
      SetBoatInTendrils()
    elseif boatDown == true then
      BoatDropInitial()
    end
  end
end
function OnUpdate()
  if cineEnterCamera_AreYouSerious ~= nil then
    cineEnterCamera_AreYouSerious:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  return {boatDown = boatDown}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boatDown = savedInfo.boatDown
end
function CreateActorsAndPositions()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  boatActor = actor.Actor.New("Boat")
  boat_Start = LD.GetWorldJointPosition("Cine_AreYouSerious", "Boat_Start")
  boat_Start_Fwd = LD.GetWorldJointForward("Cine_AreYouSerious", "Boat_Start")
end
function SetSpawnFunctions()
  boatActor:SetSpawnFunction(function()
    if cineBoat == nil or not cineBoat then
      cineBoat = game.AI.Spawn(thisLevel, boat_Start, boat_Start_Fwd, "CRT_Boat00", "BRA_AreYouSerious_Idle")
      boatHelper = cineBoat:FindSingleGOByName("puppeteerHelper")
      boatHelper.LuaObjectScript.DisableInteractZone()
      boatHelper.LuaObjectScript.SetVehicleConfiguration(thisLevel, thisObj, cineBoat, "Alfheim")
    end
    return cineBoat
  end)
end
function EnableCineInteractZone()
  GameObjects.AreYouSerious_InteractZone.LuaObjectScript.Enable()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("AlfheimBoat_Release")
  end, 0.8)
end
function SetBoatInTendrils()
  local seqSetup = ND.CreateCineSequence(thisLevel, thisObj, "areYouSerious_Setup")
  local areYouSeriousIdle_ActorTable = {}
  seqSetup:SpawnActorAndWait(boatActor)
  seqSetup:ActorSync(boatActor, {
    Slaves = areYouSeriousIdle_ActorTable,
    Branch = "BRA_AreYouSerious_Setup",
    ReferenceJoint = "AreYouSerious_SynchJoint"
  })
  seqSetup:StartSequence()
end
function BoatDropInitial()
  local seqDrop = ND.CreateCineSequence(thisLevel, thisObj, "areYouSerious_Drop")
  local areYouSeriousDrop_ActorTable = {}
  seqDrop:SpawnActorAndWait(boatActor)
  seqDrop:ActorSync(boatActor, {
    Slaves = areYouSeriousDrop_ActorTable,
    Branch = "BRA_AreYouSerious_Idle",
    ReferenceJoint = "AreYouSerious_SynchJoint"
  })
  seqDrop:StartSequence()
end
function BoatDrop()
  local seqDrop = ND.CreateCineSequence(thisLevel, thisObj, "areYouSerious_Drop")
  local areYouSeriousDrop_ActorTable = {}
  seqDrop:ActorSync(boatActor, {
    Slaves = areYouSeriousDrop_ActorTable,
    Branch = "BRA_AreYouSerious_Drop",
    ReferenceJoint = "AreYouSerious_SynchJoint"
  })
  seqDrop:Do(function()
    boatDown = true
  end)
  seqDrop:StartSequence()
end
function BuildCineSeq()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local seq = ND.CreateCineSequence(thisLevel, thisObj, "Are You Serious Cinematic")
    local areYouSerious_ActorTable = {
      {Actor = sonActor},
      {Actor = kratosActor}
    }
    seq:SetPostSkipMusic("SND_MX_ALF_start_master")
    seq:MarkAbleToSkip()
    seq:SpawnActorAndWait(boatActor)
    seq:RequestCineModeAndWait(kratosActor, thisObj)
    seq:Do(StartCineEnter_AreYouSerious)
    seq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_AreYouSerious",
      ReferenceJoint = "AreYouSerious_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = true,
      prevent_path_eval = true,
      radius = ND.StopTurnRadius,
      weapon_state = "bare"
    })
    seq:ActorSync(boatActor, {
      Slaves = areYouSerious_ActorTable,
      Branch = "BRA_AreYouSerious",
      ReferenceJoint = "AreYouSerious_SynchJoint"
    })
    seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    seq:SetCompletedCineNumber(215)
    seq:StopPuppetingActor(sonActor)
    seq:StopPuppetingActor(kratosActor)
    seq:StopPuppetingActor(boatActor)
    seq:Do(ReEnableBoat)
    seq:Do(MotherElfBanter)
    seq:Do(StartAlfQuestNext)
    seq:StartSequence()
  end
end
function ReEnableBoat()
  boatHelper.LuaObjectScript.EnableInteractZone()
  boatHelper.LuaObjectScript.NotifyDockSystem_PlayerEnteringBoat(thisLevel, thisObj, cineBoat)
end
function MotherElfBanter()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("MotherElf")
  end, 0.5)
end
function StartAlfQuestNext()
  game.QuestManager.ProposeQuestState("Quest_Alfheim_Objective150", "Complete")
end
function StartCineEnter_AreYouSerious()
  cineEnterCamera_AreYouSerious = CCEC.CineEnterCamera.New("ENV_CineEnter_AreYouSerious", 7)
  cineEnterCamera_AreYouSerious:SetCallback(DestroyCineEnter_AreYouSerious)
  cineEnterCamera_AreYouSerious:Start()
end
function DestroyCineEnter_AreYouSerious()
  cineEnterCamera_AreYouSerious = nil
  game.SubObject.Sleep(thisObj)
end
