local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local player, pad
local pulseLow = true
local SNDPulseLow, SNDPulseMed, SNDPulseHigh, SNDPulseOff, SNDBeam500
local pulseEntZones = {}
local zoneMonitorMed, zoneMonitorHigh, zoneMonitorOff, pulseLowtimer, pulseMedtimer, pulseHightimer
local pulseMedtimerOn = false
local pulseHightimerOn = false
local revisitMus = false
scurryEvents = {
  "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf200",
  "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf200",
  "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf200",
  "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf210",
  "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf210",
  "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf210"
}
local scurryEmitters = {}
local playingTendrilMusic = false
local playingTendrilFailMusic
local boatDockingState = 0
local dockingState_Docked = 0
local dockingState_EnteringFromDock = 1
local dockingState_InBoat = 2
local dockingState_DockingOnDock = 3
local dockingState_EnteringFromBeach = 4
local dockingState_DockingOnBeach = 5
local dockingState_Beached = 6
local boat, boatRightEnterFromDockInteractZone, boatLeftEnterFromDockInteractZone, boatEnterFromBeachInteractZone
local playerInTrench = false
local zoneMonitorTrench
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  pad = player.Pad
  AudioTime()
  ScurryEmittersInit()
  SNDBeam500 = GameObjects.SNDGrpAlfLightCurve:FindSingleSoundEmitterByName("SNDBeam500")
  game.Audio.StartMusicMaster("SND_MX_ALF_start_master")
end
function OnFirstStart(level)
  HideTrenchSoundZones()
  HideLightZone()
  HideTempleZones()
  Hide490Zones()
end
function OnStart(level)
  local inputMaskState = LD.GetEntityVariable("ALF_InputMaskStage")
  if LD.GetEntityVariable("ALF_InputMaskStage") == 500 then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
  elseif inputMaskState == 550 then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadR3)
  elseif inputMaskState == 490 then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadR3)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
  elseif inputMaskState == 340 then
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
  elseif inputMaskState == 555 then
    pad:EnableGameButton(tweaks.ePad.kPadCircle)
    pad:DisableGameButton(tweaks.ePad.kPadSquare)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadCross)
    pad:DisableGameButton(tweaks.ePad.kPadUp)
    pad:DisableGameButton(tweaks.ePad.kPadLeft)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL2)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadR3)
  elseif inputMaskState == 600 then
    pad:DisableGameButton(tweaks.ePad.kPadCircle)
    pad:DisableGameButton(tweaks.ePad.kPadTriangle)
    pad:DisableGameButton(tweaks.ePad.kPadDown)
    pad:DisableGameButton(tweaks.ePad.kPadRight)
    pad:DisableGameButton(tweaks.ePad.kPadL1)
    pad:DisableGameButton(tweaks.ePad.kPadL3)
    pad:DisableGameButton(tweaks.ePad.kPadR1)
    pad:DisableGameButton(tweaks.ePad.kPadR2)
    pad:DisableGameButton(tweaks.ePad.kPadR3)
    pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
    pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  end
  PlayLightLoop()
end
function Emitters100TreesOn()
  GameObjects.SNDGrpTreeLeavesAlf100:Show()
end
function Emitters100TreesOff()
  GameObjects.SNDGrpTreeLeavesAlf100:Hide()
end
function Emitters200TreesOn()
  GameObjects.SNDGrpTreeLeavesAlf200:Show()
end
function Emitters200TreesOff()
  GameObjects.SNDGrpTreeLeavesAlf200:Hide()
end
function Emitters200PreCaveOn()
  GameObjects.SNDGrpLapPreCaveAlf200:Show()
  GameObjects.SNDGrpLapCaveAlf200:Show()
end
function Emitters200PreCaveOff()
  GameObjects.SNDGrpLapPreCaveAlf200:Hide()
end
function Emitters200PostCaveOn()
  GameObjects.SNDGrpLapPostCaveAlf200:Show()
  GameObjects.SNDGrpLapCaveAlf200:Show()
end
function Emitters200PostCaveOff()
  GameObjects.SNDGrpLapPostCaveAlf200:Hide()
end
function Emitters300RiverOn()
  GameObjects.SNDgrpAlf300_WaterLapRiver:Show()
end
function Emitters300RiverOff()
  GameObjects.SNDgrpAlf300_WaterLapRiver:Hide()
end
function Emitters300LakeOn()
  GameObjects.SNDgrpAlf300_WaterLapLake:Show()
  GameObjects.SNDgrpAlf300:Show()
  GameObjects.SNDGrpLapCaveAlf200:Hide()
  if LD.GetEntityVariable("ALF_TrenchOpen") == false or LD.GetEntityVariable("ALF_TrenchClosing") then
    GameObjects.SNDgrpAlf300_WaterLapLakeHide:Show()
  else
    GameObjects.SNDgrpAlf300_WaterLapLakeHide:Hide()
  end
end
function Emitters300LakeOff()
  GameObjects.SNDgrpAlf300_WaterLapLake:Hide()
  GameObjects.SNDgrpAlf300_WaterLapLakeHide:Hide()
end
function EnterTrench()
  print("EnterTrenchZones")
  GameObjects.SNDgrpAlf340:Show()
  GameObjects.SNDgrpAlf300:Hide()
  GameObjects.SNDgrpAlf300_River:Hide()
  GameObjects.SNDgrpAlf300_WaterLapLake:Hide()
  GameObjects.SNDgrpAlf300_WaterLapLakeHide:Hide()
  ShowTrenchSoundZones()
end
function ExitTrench()
  print("ExitTrenchZones")
  GameObjects.SNDgrpAlf340:Hide()
  GameObjects.SNDgrpAlf300:Show()
  GameObjects.SNDgrpAlf300_River:Show()
  GameObjects.SNDgrpAlf300_WaterLapLake:Show()
  HideTrenchSoundZones()
end
function ScurryEmittersInit()
  scurryEmitters = {
    GameObjects.SNDEntZnAnmlScurryAlf200_1,
    GameObjects.SNDEntZnAnmlScurryAlf200_2,
    GameObjects.SNDEntZnAnmlScurryAlf200_3,
    GameObjects.SNDEntZnAnmlScurryAlf210_1,
    GameObjects.SNDEntZnAnmlScurryAlf210_2,
    GameObjects.SNDEntZnAnmlScurryAlf210_3
  }
end
function AudioTime()
  SNDPulseLow = GameObjects.SNDGrpPulseLow:FindSingleSoundEmitterByName("SNDPulseLow")
  SNDPulseMed = GameObjects.SNDGrpPulseMed:FindSingleSoundEmitterByName("SNDPulseMed")
  SNDPulseHigh = GameObjects.SNDGrpPulseHigh:FindSingleSoundEmitterByName("SNDPulseHigh")
  SNDPulseOff = GameObjects.SNDGrpPulseOff:FindSingleSoundEmitterByName("SNDPulseOff")
  pulseLowtimer = timers.StartLevelTimer(50, PulseLow)
  pulseLowtimer.autoreset = true
  zoneMonitorMed = monitors.CreateEntityZoneMonitor(player, "SNDGrpEntZnPulseMedium")
  zoneMonitorMed:OnEnter(PulseMedOn)
  zoneMonitorHigh = monitors.CreateEntityZoneMonitor(player, "SNDGrpEntZnPulseHigh")
  zoneMonitorHigh:OnEnter(PulseHighOn)
  zoneMonitorOff = monitors.CreateEntityZoneMonitor(player, "HIVE_INTERIOR")
  zoneMonitorOff:OnEnter(PulseOffOn)
  GameObjects.SNDGrpLapPreCaveAlf200:Hide()
  GameObjects.SNDGrpLapPostCaveAlf200:Hide()
  GameObjects.SNDGrpLapCaveAlf200:Hide()
  GameObjects.SNDGrpTreeLeavesAlf200:Hide()
  GameObjects.SNDgrpAlf300_WaterLapRiver:Hide()
  GameObjects.SNDgrpAlf300_WaterLapLake:Hide()
  GameObjects.SNDgrpAlf300:Hide()
  GameObjects.SNDgrpAlf340:Hide()
  pulseEntZones = {
    zoneMonitorMed,
    zoneMonitorHigh,
    zoneMonitorOff
  }
end
function PulseLow()
  LD.PlaySound(SNDPulseLow, "SND_EVNT_Hive_Pulse_Low")
  local alf000 = game.FindLevel("Alf000_SkyDark")
  if alf000 ~= nil then
    alf000:CallScript("FirePulse")
  end
  local alf075 = game.FindLevel("Alf075_Lighting")
  if alf075 ~= nil then
    alf075:CallScript("FirePulse")
  end
end
function PulseMedOn()
  pulseLowtimer:Stop()
  pulseMedtimer = timers.StartLevelTimer(20, PulseMed)
  pulseMedtimer.autoreset = true
  pulseMedtimerOn = true
  zoneMonitorMed:Stop()
  zoneMonitorMed = nil
end
function PulseMed()
  LD.PlaySound(SNDPulseMed, "SND_EVNT_Hive_Pulse_Medium")
  local alf005 = game.FindLevel("Alf005_SkyInt")
  if alf005 ~= nil then
    alf005:CallScript("FirePulse")
  end
  local alf075 = game.FindLevel("Alf075_Lighting")
  if alf075 ~= nil then
    alf075:CallScript("FirePulse")
  end
  local alf390 = game.FindLevel("Alf390_TempleExtLH")
  if alf390 ~= nil then
    alf390:CallScript("FirePulse")
  end
  local alf440 = game.FindLevel("Alf440_HiveExtLH")
  if alf440 ~= nil then
    alf440:CallScript("FirePulse")
  end
  local alf450 = game.FindLevel("Alf450_HiveExt")
  if alf450 ~= nil then
    alf450:CallScript("FirePulse")
  end
  local alf490 = game.FindLevel("Alf490_HiveIntLh")
  if alf490 ~= nil then
    alf490:CallScript("FirePulse")
  end
end
function PulseHighOn()
  pulseLowtimer:Stop()
  if pulseMedtimerOn == true then
    pulseMedtimer:Stop()
  end
  pulseHightimer = timers.StartLevelTimer(20, PulseHigh)
  pulseHightimer.autoreset = true
  pulseHightimerOn = true
  zoneMonitorHigh:Stop()
  zoneMonitorHigh = nil
end
function PulseHigh()
  LD.PlaySound(SNDPulseHigh, "SND_EVNT_Hive_Pulse_High")
  local alf005 = game.FindLevel("Alf005_SkyInt")
  if alf005 ~= nil then
    alf005:CallScript("FirePulse")
  end
  local alf490 = game.FindLevel("Alf490_HiveIntLH")
  if alf490 ~= nil then
    alf490:CallScript("FirePulse")
  end
  local alf500 = game.FindLevel("Alf500_HiveInt")
  if alf500 ~= nil then
    alf500:CallScript("FirePulse")
  end
end
function PulseOffOn()
  pulseLowtimer:Stop()
  if pulseHightimerOn == true then
    pulseHightimer:Stop()
  end
  zoneMonitorOff:Stop()
  zoneMonitorOff = nil
  PulseOff()
end
function PulseOff()
  if GameObjects.SNDGrpPulseOff:FindSingleSoundEmitterByName("SNDPulseOff") ~= nil then
    LD.StopSound(SNDPulseLow, "SND_EVNT_Hive_Pulse_Low")
    LD.StopSound(SNDPulseMed, "SND_EVNT_Hive_Pulse_Medium")
    LD.StopSound(SNDPulseHigh, "SND_EVNT_Hive_Pulse_High")
    SNDPulseOff:Start("SND_EVNT_Hive_Pulse_Off_LP")
  end
end
function StopAllPulseSound(level)
  StopAndNilMonitor(pulseLowtimer)
  StopAndNilMonitor(zoneMonitorMed)
  StopAndNilMonitor(zoneMonitorHigh)
  StopAndNilMonitor(zoneMonitorOff)
  LD.StopSound(SNDPulseLow, "SND_EVNT_Hive_Pulse_Low")
  LD.StopSound(SNDPulseMed, "SND_EVNT_Hive_Pulse_Medium")
  LD.StopSound(SNDPulseHigh, "SND_EVNT_Hive_Pulse_High")
  LD.StopSound(SNDPulseOff, "SND_EVNT_Hive_Pulse_Off_LP")
  StopPulseZones()
end
function StopPulseZones()
  for i = 1, #pulseEntZones do
    pulseEntZones[i]:Stop()
  end
end
function StartPulseZones()
  for i = 1, #pulseEntZones do
    pulseEntZones[i]:Start()
  end
end
function StopAndNilMonitor(monitor)
  if monitor ~= nil then
    monitor:Stop()
    monitor = nil
  end
end
function Alf200Scurry1()
  LD.PlaySound(scurryEmitters[1].SoundEmitters[1], "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf200")
end
function Alf200Scurry2()
  LD.PlaySound(scurryEmitters[2].SoundEmitters[1], "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf200")
end
function Alf200Scurry3()
  LD.PlaySound(scurryEmitters[3].SoundEmitters[1], "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf200")
end
function Alf210Scurry1()
  LD.PlaySound(scurryEmitters[4].SoundEmitters[1], "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf210")
end
function Alf210Scurry2()
  LD.PlaySound(scurryEmitters[5].SoundEmitters[1], "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf210")
end
function Alf210Scurry3()
  LD.PlaySound(scurryEmitters[6].SoundEmitters[1], "SND_AMB_EMIT_FOL_Rustle_Critter_Scurry_Alf210")
end
function HideHiveZones()
  print("HideHiveZones")
  GameObjects.SNDGrpZnHive:Hide()
  GameObjects.SNDGrpZnTempleHallway:Hide()
end
function ShowHiveZones()
  print("ShowHiveZones")
  GameObjects.SNDGrpZnHive:Show()
  GameObjects.SNDGrpZnTempleHallway:Show()
end
function HideTempleZones()
  print("HideTempleZones")
  GameObjects.SNDGrpZnCylAlf600:Hide()
end
function ShowTempleZones()
  print("ShowTempleZones")
  GameObjects.SNDGrpZnCylAlf600:Show()
end
function HideLightZone()
  print("HideLightZones")
  GameObjects.SNDGrpZnInsideLight:Hide()
end
function ShowLightZone()
  print("ShowLightZones")
  GameObjects.SNDGrpZnInsideLight:Show()
end
function ShowTrenchSoundZones()
  print("ShowTrenchZones")
  GameObjects.SNDZnGrpTrench:Show()
end
function HideTrenchSoundZones()
  print("HideTrenchZones")
  GameObjects.SNDZnGrpTrench:Hide()
end
function Hide490Zones()
  print("Hide490Zones")
  GameObjects.SNDGrpZn490:Hide()
end
function Show490Zones()
  print("Show490Zones")
  GameObjects.SNDGrpZn490:Show()
end
function Hide320BridgeZone()
  GameObjects.SNDGrpZn320Bridge:Hide()
end
function Show320BridgeZone()
  GameObjects.SNDGrpZn320Bridge:Show()
end
function PlayLightLoop()
  LD.CallFunctionAfterDelay(function()
    LD.PlaySound(SNDBeam500, "SND_ELEC_Alfheim_Light_Beam_01_LP", true)
  end, 0.2)
end
function PlayLightLoop2()
end
function WaterZonesOff()
  print("WaterZonesOff")
  GameObjects.SNDZnAlf300_1:HideSoundEmitterVolume()
  GameObjects.SNDZnAlf300_1Delay:HideSoundEmitterVolume()
end
function WaterZonesOn()
  print("WaterZonesOn")
  GameObjects.SNDZnAlf300_1:ShowSoundEmitterVolume()
  GameObjects.SNDZnAlf300_1Delay:ShowSoundEmitterVolume()
end
function youWereWrongMusic()
  game.Audio.StartMusic("SND_MX_ALF_heard_her_voice")
end
function templeEntranceMusic()
  game.Audio.StartMusic("SND_MX_ALF_temple_entrance")
end
function puzzleInMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_ALF_hive_entrance_puzzle_in")
end
function puzzleOutMusic()
  game.Audio.StartMusic("SND_MX_ALF_hive_entrance_puzzle_out")
end
function revisitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 and revisitMus == true then
    game.Audio.StartMusic("SND_MX_ALF_revisit_explore_in")
  end
end
function revisitMusicIdle()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 then
    game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
    revisitMus = true
  end
end
function musicChiselIn()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 then
    game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
    revisitMus = true
  end
end
function musicChiselOut()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 and revisitMus == true then
    game.Audio.StartMusic("SND_MX_ALF_revisit_explore_in")
  end
end
