local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local CCOS = require("camera.camera_oneshot")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local Encounter01, Encounter02, Encounter03, Encounter04, SpawnLocationObj, player, pad, thisLevel, oneShotFirstAlfRune, Area_1_Encounter_1, Area_1_Encounter_2
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  DarkoneIntro_Area_1_Fight_1()
  DarkoneIntro_Return_Fight_1()
end
function OnFirstStart(level)
  GameObjects.TendrilAxeTarget_02.Child.LuaObjectScript.Disable()
end
function OnStart(level)
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    GameObjects.LeadTheWay.LuaObjectScript.Disable()
    GameObjects.CA_LakeOverlook.LuaObjectScript.Disable()
    GameObjects.CA_FirstTendril.LuaObjectScript.Disable()
    GameObjects.CA_FirstTendril_touch.LuaObjectScript.Disable()
    GameObjects.CA_SecondTendril.LuaObjectScript.Disable()
    GameObjects.CA_DoubleTendril.LuaObjectScript.Disable()
    GameObjects.CA_RuneRead_01.LuaObjectScript.Disable()
    GameObjects.LTW_StartZone:HideEntityVolume()
    GameObjects.LTW_Update_Close:HideEntityVolume()
    GameObjects.LTW_Update_Ahead:HideEntityVolume()
    GameObjects.RuneRead_BeforeGroup:JumpAnimToFrame(1)
    GameObjects.RuneRead_AfterGroup:JumpAnimToFrame(1)
    GameObjects.CA_RuneRead_01.LuaObjectScript.Disable()
    local eliteInteractZone = GameObjects.SonReadRune01_Alt.Child.Child.LuaObjectScript.GetInteractZone()
    eliteInteractZone:SetXZRange(12)
    eliteInteractZone:SetYRange(5)
    eliteInteractZone:SetAngle(90)
    eliteInteractZone:SetHintXZRange(18)
    eliteInteractZone:SetHintAngle(180)
  else
    local eliteInteractZone = GameObjects.SonReadRune01.Child.Child.LuaObjectScript.GetInteractZone()
    eliteInteractZone:SetXZRange(12)
    eliteInteractZone:SetYRange(5)
    eliteInteractZone:SetAngle(90)
    eliteInteractZone:SetHintXZRange(18)
    eliteInteractZone:SetHintAngle(180)
  end
  if Area_1_Encounter_1:WasRunning() then
    Area_1_Encounter_1:Start()
  end
  SoundOnStart()
  GameObjects.ColStopPlayer:HideCollision()
  TurnOffSlowDownLogic()
end
function OnUpdate(level)
  if oneShotFirstAlfRune ~= nil then
    oneShotFirstAlfRune:Update()
  end
end
function DisableCARuneRead01()
  GameObjects.CA_RuneRead_01.LuaObjectScript.Disable()
  GameObjects.SonReadRune01_Alt.Child:FindSingleGOByName("GenericSonInteract").LuaObjectScript.Disable()
  GameObjects.RuneRead_AfterGroup:Hide()
  GameObjects.CA_RuneRead_01.LuaObjectScript.Disable()
end
function EnableSecondTendril()
  GameObjects.TendrilAxeTarget_02.Child.LuaObjectScript.Enable()
  GameObjects.TendrilSHellIC:HideCollision()
  GameObjects.TendrilAxeTarget_02.Child.LuaObjectScript.SoundInit()
end
function Bridge1EncounterComplete()
  GameObjects.CA_Alert_PrePickupDrop.LuaObjectScript.Disable()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  LD.SetEntityVariable("BridgeFight01", true)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Btr_BridgeDark.LuaObjectScript.PostFirstFightBanter()
  end, 4)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Base")
end
function PreFightBanter()
  LD.SetEntityVariable("PreBridgeFight01", true)
end
function Animate150Trees()
end
function PlaytestLogoEnd()
end
function InputMask_On()
  pad:DisableGameButton(tweaks.ePad.kPadCross)
end
function InputMask_Off()
  pad:EnableGameButton(tweaks.ePad.kPadCross)
end
function TurnOffSlowDownLogic()
  GameObjects.SlowDownZone_TendrilIntro:HideEntityVolume()
  GameObjects.NoDodgeRoll_TendrilIntro:HideEntityVolume()
  InputMask_Off()
end
function TurnOnSlowDownLogic()
  GameObjects.SlowDownZone_TendrilIntro:ShowEntityVolume()
  GameObjects.NoDodgeRoll_TendrilIntro:ShowEntityVolume()
end
function MomfrontationSpoof()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 245 <= cineNum and cineNum < 250 then
    game.Level.SetVariable("CompletedCineNumber", 250)
    local alf300 = game.FindLevel("Alf300_LakeDark")
    if alf300 ~= nil then
      local momfrontationObject = alf300:GetGameObject("Cine_Momfrontation")
      momfrontationObject:CallScript("HideDisableBoatLoreZone")
      momfrontationObject:CallScript("EnableDock")
    end
    game.Audio.SetBanterFact("disableBoatLoreInWAD", false)
  end
end
function Enable_LTW()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    GameObjects.LeadTheWay.LuaObjectScript.Enable()
  end
end
function Disable_LTW()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    GameObjects.LeadTheWay.LuaObjectScript.Disable()
  end
end
function Enable_LTW_Reverse()
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    GameObjects.LeadTheWay_Reverse.LuaObjectScript.Enable()
    GameObjects.LeadTheWay.LuaObjectScript.Disable()
  end
end
function Disable_LTW_Reverse()
  if LD.GetEntityVariable("ALF_LightAcquired") == true then
    GameObjects.LeadTheWay_Reverse.LuaObjectScript.Disable()
  end
end
function Update_LTW_CloseFollow_Bridge()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local newParams = {}
    newParams = {
      LeaderDistance_Wait = 10,
      LeaderDistance_Continue = 6,
      LeaderDistance_Backtrack = 18,
      LeaderDistance_BacktrackDone = 14
    }
    GameObjects.LeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(newParams)
  end
end
function Update_LTW_Back2Lead()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local newParams = {}
    newParams = {
      LeaderDistance_Wait = 15,
      LeaderDistance_Continue = 10,
      LeaderDistance_Backtrack = 20,
      LeaderDistance_BacktrackDone = 15
    }
    GameObjects.LeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(newParams)
  end
end
function AlfheimTendrilTutorial()
  TurnOnSlowDownLogic()
  GameObjects.CA_FirstTendril_touch.LuaObjectScript.Disable()
  GameObjects.TendrilTutSheet:HideCollision()
  for _, x in pairs(GameObjects.TutorialTendrilGeo.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  timer.StartLevelTimer(1, function()
    GameObjects.CA_SecondTendril.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(1.1, function()
    GameObjects.CA_FirstTendril.LuaObjectScript.Disable()
  end)
end
function AlfheimTendrilTutorial2()
  GameObjects.TendrilTutSheet2:HideCollision()
  for _, x in pairs(GameObjects.Tendril2Geo.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  timer.StartLevelTimer(1, function()
    GameObjects.CA_RuneRead_01.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(1.1, function()
    GameObjects.CA_SecondTendril.LuaObjectScript.Interrupt()
    GameObjects.CA_SecondTendril.LuaObjectScript.Disable()
  end)
  timer.StartLevelTimer(1, function()
    GameObjects.CA_RuneRead_01.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(4, TurnOffSlowDownLogic)
end
function Tendril_Simple_Pickup()
  GameObjects.chest_common_tier1_alf150_1.LuaObjectScript.Enable()
  for _, x in pairs(GameObjects.ChestHiveGeo.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
end
function AlfheimFirstNestBreak()
  GameObjects.TendrilNestSheet:HideCollision()
  GameObjects.NavObstacle_H01:HideNavObstacle()
  GameObjects.NavObstacle_H02:HideNavObstacle()
  for _, x in pairs(GameObjects.NestGeoBlocker.Children) do
    x.Child.LuaObjectScript.StartDecay()
  end
  timer.StartLevelTimer(0.5, function()
    GameObjects.CA_LakeOverlook.LuaObjectScript.Enable()
  end)
  timer.StartLevelTimer(0.6, function()
    GameObjects.CA_DoubleTendril.LuaObjectScript.Disable()
  end)
end
function StartBridgeFight()
  Area_1_Encounter_1:Start()
end
function DarkoneIntro_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Dark One Intro Fight Alf150", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneAlf150",
    StartMusic = "SND_MX_ALF_dark_ones_intro_fight_in",
    StopMusic = "SND_MX_ALF_dark_ones_intro_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DarkOne_N_SFBR",
      spawnLocators = "A1_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13
    },
    {
      spawners = "DarkOne_N_SFBF",
      spawnLocators = "A1_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15
    },
    {
      spawners = "DarkOne_N_SFL10",
      spawnLocators = "A1_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 11
    }
  })
  Area_1_Encounter_1:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
    InputMask_Off()
  end)
  Area_1_Encounter_1:OnStart(function()
    timer.StartLevelTimer(15, function()
      game.Compass.SetDesignerForcedHide(false)
    end)
  end)
  Area_1_Encounter_1:OnComplete(Bridge1EncounterComplete)
end
function DarkoneIntro_Return_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Bridge Return Fight Alf150", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneAlf150",
    RepopulationEncounter = true
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "DarkOne_4_SFL10",
      spawnLocators = "A2_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "DarkOne_5_SFA",
      spawnLocators = "A2_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3,
      powerLevel = powerLevel02
    }
  })
  Area_1_Encounter_2:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Attack"), {
    cineRequirement = {339, 950}
  })
end
function StartBridgeRuneRead()
  StartOneShotRuneRead()
end
function StartOneShotRuneRead()
  oneShotFirstAlfRune = CCOS.OneShotCamera.New("PLYR_RuneRead_Alf", 12, nil)
  oneShotFirstAlfRune:Start()
  oneShotFirstAlfRune:SetCallback(DestroyOneShotRuneRead)
  player:SetMaxSpeedOverride(1.5)
  InputMask_On()
  GameObjects.ColStopPlayer:ShowCollision()
end
function RuneReadInteractDone()
  LD.CallFunctionAfterDelay(function()
    player:ClearMaxSpeedOverride()
    InputMask_Off()
    GameObjects.ColStopPlayer:HideCollision()
  end, 2)
end
function DestroyOneShotRuneRead()
  oneShotFirstAlfRune = nil
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function AreaAnnounceBridge()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    uiCalls.UI_Event_DiscoverLocation("Alfheim Bridge")
  end
end
function OnEvaluateLoadGroup_Lighting()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function SoundOnStart()
  GameObjects.SonReadRune01.LuaObjectScript.WallRuneReadSoundSetup()
end
function musicTendrilIntro_Second()
  LD.CallFunctionAfterDelay(function()
    game.Audio.StartMusic("SND_MX_ALF_dark_murders_light")
  end, 0.75)
end
