local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local thisObj, thisLevel, player, kratosActor, tendrilIntroSeq
local bTendrilIntro_Win = false
local bBloodGate = false
local bBloodGate_ThirdMiss = false
local bBloodGate_Won = false
local bloodGateMissCounter = 0
local bPostFightBanter = false
local bPostFirstFightPlayed = false
local bTendrilChest = false
local bLikeADream = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    CreateActorsAndPositions()
    BanterTendrilIntro_AxeSwing()
    HideBloodGateBanter()
  end
  GameObjects.BanterZone_BloodGate.LuaObjectScript.DisableConsoleError("BloodGate")
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {
    bTendrilIntro_Win = bTendrilIntro_Win,
    bPostFightBanter = bPostFightBanter,
    bLikeADream = bLikeADream,
    bTendrilChest = bTendrilChest
  }
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  bTendrilIntro_Win = savedInfo.bTendrilIntro_Win
  bPostFightBanter = savedInfo.bPostFightBanter
  bLikeADream = savedInfo.bLikeADream
  bTendrilChest = savedInfo.bTendrilChest
end
function CreateActorsAndPositions()
  kratosActor = actor.Actor.New("KratosAlfheimBanter", game.Player.FindPlayer)
end
function BanterTendrilIntro()
  if bTendrilIntro_Win == false then
    tendrilIntroSeq = ND.CreateCineSequence(thisLevel, thisObj, "tendrilIntro")
    tendrilIntroSeq:Do(function()
      game.Audio.PlayBanter("TendrilIntro")
    end)
    tendrilIntroSeq:StartSequence()
  end
end
function BanterTendrilIntro_AxeSwing()
  if bTendrilIntro_Win == false then
    local tendrilIntro_AxeSwingSeq = ND.CreateCineSequence(thisLevel, thisObj, "tendrilIntro_AxeSwing")
    tendrilIntro_AxeSwingSeq:BeginMultipleWait()
    tendrilIntro_AxeSwingSeq:WaitForActorInZone(kratosActor, "BtrZone_TendrilAttack")
    tendrilIntro_AxeSwingSeq:WaitForFunctionTrue(function()
      return player:HasMarker("Attacking")
    end)
    tendrilIntro_AxeSwingSeq:EndMultipleWait()
    tendrilIntro_AxeSwingSeq:WaitSeconds(1.2)
    tendrilIntro_AxeSwingSeq:Do(function()
      if not bTendrilIntro_Win then
        game.Audio.PlayBanter("TendrilIntro_AxeSwing")
      end
    end)
    tendrilIntro_AxeSwingSeq:StartSequence()
  end
end
function BanterTendrilIntro_Win()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("TendrilIntro_Win")
  end, 0.8)
  bTendrilIntro_Win = true
end
function BanterTendrilIntro_Second()
  game.Audio.PlayBanter("TendrilIntro_Second")
  LD.CallFunctionAfterDelay(function()
    game.Audio.StartMusic("SND_MX_ALF_dark_murders_light")
  end, 0.75)
end
function TendrilChest()
  if game.Level.GetVariable("BridgeFight01") == false and bLikeADream == true and bTendrilChest == false then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("TendrilChest_Success")
    end, 1.5)
    bTendrilChest = true
  end
end
function PlayedLikeADreamBanter()
  bLikeADream = true
end
function PlayLikeADreamFromCA()
  if not bLikeADream then
    game.Audio.PlayBanter("LikeADream", nil, nil, false)
    bLikeADream = true
  end
end
function PostFirstFightBanter()
  if game.Level.GetVariable("BridgeFight01") == true and bPostFightBanter == false and bBloodGate == false then
    PlayBanterPostFight()
    bPostFightBanter = true
    bBloodGate = true
    LD.CallFunctionAfterDelay(BridgeFightComplete, 6)
  end
end
function PlayBanterPostFight()
  if game.Level.GetVariable("CompletedCineNumber") == 210 then
    game.Audio.PlayBanter("055_PostFirstFight")
    LD.CallFunctionAfterDelay(function()
      bPostFirstFightPlayed = true
    end, 4)
  end
end
function HideBloodGateBanter()
  GameObjects.Btr_BloodGate_Group:Hide()
end
function BridgeFightComplete()
  if bBloodGate_Won == false then
    GameObjects.Btr_BloodGate_Group:Show()
  end
end
function BanterBloodGate_ThirdMiss()
  if not bBloodGate_ThirdMiss then
    bloodGateMissCounter = bloodGateMissCounter + 1
    if 2 < bloodGateMissCounter then
      game.Audio.PlayBanter("BloodGate_ThirdMiss")
      bBloodGate_ThirdMiss = true
    end
  end
end
function BanterBloodGate_Win()
  bBloodGate_Won = true
  if bPostFirstFightPlayed == true then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanterNonCritical("BloodGate_Win")
    end, 1)
  end
end
