local ND = require("design.NarrativeDesignLibrary")
local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, freyaActor, cine_lights_210
local playerLeftZone = false
local treeBranches, cineEnterCamera_AlfheimArrival
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  cine_lights_210 = GameObjects.Cine_Start_210
  HideCineLights()
  treeBranches = GameObjects.alfheimBranches.Child
  if game.Level.GetVariable("CompletedCineNumber") < 210 then
    SetupActors()
    SpawnFreya()
  end
end
function StartCineEnter_AlfheimArrival()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_AlfheimArrival = CCEC.CineEnterCamera.New("ENV_CineEnter_AlfheimArrival", 7)
  cineEnterCamera_AlfheimArrival:SetCallback(DestroyCineEnter_AlfheimArrival)
  cineEnterCamera_AlfheimArrival:Start()
end
function DestroyCineEnter_AlfheimArrival()
  cineEnterCamera_AlfheimArrival = nil
  game.SubObject.Sleep(thisObj)
end
function LockCameraControls()
  local recenterToLock = {
    TimeStart = 0,
    TimeDuration = 5,
    LockRecenter = 1,
    YawRange = -1,
    TriggerLeft = 0,
    TriggerRight = 0,
    ReturnLeft = 180,
    ReturnRight = -180,
    PitchRange = -1,
    ReturnDown = -90,
    ReturnUp = 90
  }
  game.Camera.Recenter(recenterToLock)
end
function OnUpdate()
  if cineEnterCamera_AlfheimArrival ~= nil then
    cineEnterCamera_AlfheimArrival:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {playerLeftZone = playerLeftZone}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  playerLeftZone = savedInfo.playerLeftZone
end
function SpawnFreya()
  freyaActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_AlfheimHenge", "Fre_AlfheimArrival_StartJoint", "CRT_Freya00", "BRA_Spawn", "freya")
  end)
end
function SetupActors()
  kraActor = actor.Actor.New("ALFHEIM HENGE: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("ALFHEIM HENGE: Son Actor", game.AI.FindSon)
  freyaActor = actor.Actor.New("ALFHEIM HENGE: Freya Actor")
end
function SetupCineSequence(level, obj, doorObjchild)
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Alfheim Henge Sequence")
  local slaveTable = {
    {
      Actor = sonActor,
      Branch = "BRA_AlfheimHengeFULL"
    },
    {
      Actor = freyaActor,
      Branch = "BRA_AlfheimHengeFULL"
    },
    {
      Obj = treeBranches,
      Anim = "narAlfArrival000CineScene"
    },
    {
      Obj = doorObjchild,
      Anim = "narAlfArrival000CineScene"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_ALF_start_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(EnableSonCombatAvailability)
  cineSeq:Do(LockCameraControls)
  cineSeq:Do(StartCineEnter_AlfheimArrival)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_AlfheimHengeFULL",
    ReferenceJoint = "AlfheimArrival_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  cineSeq:SpawnActorAndWait(freyaActor)
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(ShowBranches)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTable,
    Branch = "BRA_AlfheimHengeFULL",
    ReferenceJoint = "AlfheimArrival_SynchJoint"
  })
  cineSeq:Do(function()
    LD.CallFunctionAfterDelay(ActivityFeed, 19)
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(freyaActor)
  cineSeq:DespawnActor(freyaActor)
  cineSeq:Do(HideCineLights)
  cineSeq:Do(function()
    LD.CallFunctionAfterDelay(StayByMeBanter, 1)
  end)
  cineSeq:SetCompletedCineNumber(210)
  cineSeq:WaitSeconds(6)
  cineSeq:Do(StartQuestParent)
  cineSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "06_Alfheim_015_BridgeStart"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  cineSeq:StartSequence()
end
function EnableSonCombatAvailability()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function ActivityFeed()
  game.SubmitActivityFeedStory("04_AlfheimArrival")
end
function StartQuestParent()
  game.QuestManager.ProposeQuestState("Quest_Foothills_Objective503", "Complete")
  LD.ActivateQuest("Quest_Foothills_to_Alfheim")
  game.Compass.SetDesignerForcedHide(false)
end
function PlayCineLights()
  cine_lights_210:Show()
  cine_lights_210:JumpAnimToFrame(0)
  cine_lights_210:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_210:Hide()
end
function ShowBranches()
  treeBranches:Show()
end
function StayByMeBanter()
  if playerLeftZone == false then
    game.Audio.PlayBanter("StayByMe")
    LD.CallFunctionAfterDelay(StayByMeLingerBanter, 15)
  end
end
function StayByMeLingerBanter()
  if playerLeftZone == false then
    game.Audio.PlayBanter("StayByMe_Linger")
    LD.CallFunctionAfterDelay(StayByMeLinger2Banter, 25)
  end
end
function StayByMeLinger2Banter()
  if playerLeftZone == false then
    game.Audio.PlayBanter("StayByMe_Linger2")
  end
end
function StayByMeLinger_LeftZone()
  playerLeftZone = true
end
