local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local collisionCheck = require("camera.collisioncheck")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, darkOneActor, lightOneActor, sentryKillSeq
local sentryKilledTriggered = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    CreateActors()
    SpawnDarkOne()
    SpawnLightOne()
  end
end
function OnSaveCheckpoint(level, obj)
  return {sentryKilledTriggered = sentryKilledTriggered}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  sentryKilledTriggered = savedInfo.sentryKilledTriggered
end
function SpawnDarkOne()
  darkOneActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_Sentry", "Sentry_DarkOne", "CRT_DarkOne00", "BRA_AlfSentryKillEnter", "darkone")
  end)
end
function SpawnLightOne()
  lightOneActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_Sentry", "Sentry_LightOne", "CRT_LightOne00", "BRA_AlfSentryKillEnter", "lightone")
  end)
end
function CreateActors()
  darkOneActor = actor.Actor.New("darkone")
  lightOneActor = actor.Actor.New("lightone")
end
function SentryKillEnterSequence()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    sentryKillSeq = ND.CreateCineSequence(thisLevel, thisObj, "Sentry Kill Sequence")
    local cineSeq_ActorTable = {
      {
        Actor = darkOneActor,
        Branch = "BRA_AlfSentryKillEnter"
      }
    }
    sentryKillSeq:SpawnActorAndWait(darkOneActor)
    sentryKillSeq:SpawnActorAndWait(lightOneActor)
    sentryKillSeq:RequestCineModeAndWait(lightOneActor, thisObj, true)
    sentryKillSeq:ActorSync(lightOneActor, {
      Slaves = cineSeq_ActorTable,
      Branch = "BRA_AlfSentryKillEnter",
      ReferenceJoint = "SentryKill_SynchJoint"
    })
    sentryKillSeq:StartSequence()
  end
end
function CineSentryKillExit_Delay()
  LD.CallFunctionAfterDelay(CineSentryKillExit, 1)
end
function CineSentryKillExit()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local sentryKill_Exit_Seq = LD.CreateCineSequence(thisLevel, thisObj, "Sentry Kill EXIT Sequence")
    local sentryKill_Exit_ActorTable = {
      {
        Actor = darkOneActor,
        Branch = "BRA_AlfSentryKillExit"
      }
    }
    sentryKill_Exit_Seq:WaitForSequence(sentryKillSeq)
    sentryKill_Exit_Seq:ActorSync(lightOneActor, {
      Slaves = sentryKill_Exit_ActorTable,
      Branch = "BRA_AlfSentryKillExit",
      ReferenceJoint = "SentryKill_SynchJoint"
    })
    sentryKill_Exit_Seq:Do(LightOneIntroBanter)
    sentryKill_Exit_Seq:WaitForAndCompleteCineMode(lightOneActor, thisObj)
    sentryKill_Exit_Seq:Do(DisableCineSentryLookat)
    sentryKill_Exit_Seq:DespawnActor(lightOneActor)
    sentryKill_Exit_Seq:DespawnActor(darkOneActor)
    sentryKill_Exit_Seq:Do(function()
      game.World.StoreCheckpoint({
        OverrideObject = GameObjects.CheckpointOverride_SentryKill
      })
    end)
    sentryKill_Exit_Seq:StartSequence()
  end
end
function DisableCineSentryLookat()
  LD.CallFunctionAfterDelay(function()
    GameObjects.EnvStim_SeeLightOne.LuaObjectScript.DisableEventEmitter()
  end, 4)
end
function LightOneIntroBanter()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("LightOneIntro")
  end, 1)
end
