local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local collisionCheck = require("camera.collisioncheck")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local thisObj, thisLevel, player, pad, DOActor, LightOne
local pickupDropPlayed = false
local oneShotCamPickupDrop, disabledButtons
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if pickupDropPlayed == false then
    StartLightOneLoop()
  else
    HideLightOne()
  end
end
function OnUpdate(level, go)
  if oneShotCamPickupDrop ~= nil then
    oneShotCamPickupDrop:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {pickupDropPlayed = pickupDropPlayed}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  pickupDropPlayed = savedInfo.pickupDropPlayed
end
function SpawnDarkOne()
  print("========= SPAWN DARK ONES ===========")
  DOActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "POI_PickupDrop_Group", "DarkOneDock_SpawnJoint", "CRT_DarkOne00", "BRA_envAlfPickupDropExit", "darkone", {PowerLevel = "2", Variant = "QuickSpear"})
  end)
end
function StartLightOneLoop()
  LightOne = GameObjects.LightOne_PickupDrop.Child
  LightOne:StartAnim("envAlfPickupDropLoop")
end
function HideLightOne()
  LightOne = GameObjects.LightOne_PickupDrop.Child
  LightOne:Hide()
end
function CreateActors()
  print("========= CREATE ACTORS ===========")
  DOActor = actor.Actor.New("PICK UP DROP: Dark One Actor")
  SpawnDarkOne()
end
function PickupDropSequence()
  print("=============== PICK UP DROP SEQUENCE ============")
  CreateActors()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  LD.CallFunctionAfterDelay(function()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "ALERT_BEHAVIOR_CONTEXT_CONFIG")
  end, 0.5)
  local pickupDropSeq2 = LD.CreateCineSequence(thisLevel, thisObj, "Pick Up Drop Sequence")
  local pickupDrop_ActorTable2 = {
    {
      Obj = LightOne,
      Anim = "envAlfPickupDropExit"
    }
  }
  pickupDropSeq2:SpawnActorAndWait(DOActor)
  pickupDropSeq2:ActorSync(DOActor, {
    Slaves = pickupDrop_ActorTable2,
    Branch = "BRA_envAlfPickupDropExit",
    ReferenceJoint = "PickUpDrop_SynchJoint"
  })
  pickupDropSeq2:Do(PlayBanter)
  pickupDropSeq2:Do(CameraPlayPickupDrop)
  pickupDropSeq2:Do(DoNotRepeat)
  pickupDropSeq2:WaitForActorMoveComplete(DOActor)
  pickupDropSeq2:DespawnActor(DOActor)
  pickupDropSeq2:StartSequence()
end
function DoNotRepeat()
  if pickupDropPlayed == false then
    pickupDropPlayed = true
  end
end
function PlayBanter()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("LightOneDeathDrop", PickUpDropBanterDone)
  end, 5)
end
function PickUpDropBanterDone()
end
function CameraPlayPickupDrop()
  game.SubObject.Wake(thisObj)
  oneShotCamPickupDrop = CCOS.OneShotCamera.New("PLYR_Nar_POIPickupDrop", 10, nil)
  oneShotCamPickupDrop:Start()
  oneShotCamPickupDrop:SetCallback(DestroyOneShotPickup)
  player:SetMaxSpeedOverride(3)
  player:CallScript("LuaHook_ForceCineRageModeExit")
  DisableSequenceButtons()
  timers.StartLevelTimer(10, function()
    player:ClearMaxSpeedOverride()
    EnableSequenceButtons()
  end)
end
function DestroyOneShotPickup()
  game.SubObject.Sleep(thisObj)
  oneShotCamPickupDrop = nil
end
function DisableSequenceButtons()
  if disabledButtons == nil then
    disabledButtons = {}
  end
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadCross)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadSquare)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadR1)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadR2)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadR3)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadL1)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadL2)
  DisableButtonIfCurrentlyEnabled(tweaks.ePad.kPadL3)
end
function DisableButtonIfCurrentlyEnabled(button)
  if not pad:IsGameButtonDisabled(button) then
    print("MG - disabling " .. tostring(button))
    pad:DisableGameButton(button)
    table.insert(disabledButtons, button)
  end
end
function EnableSequenceButtons()
  for _, b in ipairs(disabledButtons) do
    print("MG - enabling " .. tostring(b))
    pad:EnableGameButton(b)
  end
  disabledButtons = nil
end
