local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local Player, thisLevel, Area_1_Encounter_1
local PatrolStarted = false
local PatrolStarted2 = false
local Draugr01, Draugr02, bShowTheBoat
local BoatTendrilsDissipated = 0
local varIsShopping = false
local varBoatHintFired, ZoneMonitorAggroEnemy, TiggerZone, boatCAReached
function OnScriptLoaded(level)
  thisLevel = level
  Player = game.Player.FindPlayer()
  bShowTheBoat = false
end
function OnStart()
  if game.Level.GetVariable("ALF_TrenchOpen") == false then
    game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", false)
  end
  CheckStatueStatus()
end
function OnFirstStart(level)
  Player:CallScript("UnlockTier2Recipes")
end
function CheckStatueStatus()
  if LD.GetEntityVariable("ALF_LightAcquired") then
    GameObjects.Decorative_Statue200A:Show()
  else
    GameObjects.Decorative_Statue200A:Hide()
  end
end
function StartShopping()
  varIsShopping = true
end
function StopShopping()
  varIsShopping = false
  LD.CallFunctionAfterDelay(Enable_CA_LookAtBoat, 3)
end
function CountDownToBoatHint()
  LD.CallFunctionAfterDelay(CheckBoatHint, 20)
end
function CheckBoatHint()
  if varIsShopping == false and varBoatHintFired ~= true then
    Enable_CA_LookAtBoat()
  end
end
function GoFindBoat()
  if varBoatHintFired ~= true then
    varBoatHintFired = true
    GameObjects.Zone_FindBoatArea:HideEntityVolume()
    LD.CompleteQuest("Quest_Alfheim_Objective100")
  end
end
function StartAlfQuest_End()
  LD.CompleteQuest("Quest_Alfheim_Objective700")
end
function BridgeMoveZone200()
end
function Enable_CA_LookAtBoat()
  if not boatCAReached then
    GameObjects.ContextAction_LookAtBoat.LuaObjectScript.Enable()
  end
end
function EnterBoatCA()
  boatCAReached = true
  GoFindBoat()
end
function RemoveAllCA()
  boatCAReached = true
  GameObjects.ContextAction_LookAtBoat.LuaObjectScript.Disable()
end
function StartShopBanter()
  local level = game.FindLevel("Alf200_MazeDark")
  local smallShop = level:GetGameObject("SmallShop_NoFT")
  smallShop:FindSingleGOByName("TalkInteract_SM").LuaObjectScript.AttemptToTriggerGreeting()
end
function TendrilBoatDrop()
  GameObjects.TendrilAxeTarget.Child:Hide()
  GameObjects.BoatTendrilIC:Hide()
  GameObjects.ContextAction_LookAtBoat.LuaObjectScript.Disable()
  TendrilBoatEnable()
  bShowTheBoat = true
  local alf000 = game.FindLevel("Alf000_SkyDark")
  if alf000 ~= nil then
    local cine_AreYouSerious_Obj = alf000:GetGameObject("Cine_AreYouSerious")
    cine_AreYouSerious_Obj:CallScript("BoatDrop")
  end
  for _, v in pairs(GameObjects.BoatHive.Children) do
    v.Child.LuaObjectScript.StartDecay()
  end
  SetBoatSpeed()
end
function HideBoatIC()
  GameObjects.Boat_Fallen_IC:HideCollision()
end
function SetBoatSpeed()
  local data = {}
  data.TargetMaxSpeed = 6
  data.TargetMaxRotationSpeed = 80
  data.TargetAcceleration = 12.5
  data.TargetAngularAcceleration = 160
  data.MaxSpeedChangeRate = 6
  data.MaxRotationSpeedChangeRate = 100
  data.AccelerationChangeRate = 6
  data.AngularAccelerationChangeRate = 100
  game.Boat.SetGlobalSpeedControlData(data)
end
function GetBool_bShowTheBoat()
  if bShowTheBoat == true then
    local fnf = thisLevel:GetGameObject("FireAndForgetV3_LookAtBoat").Child
    fnf.LuaObjectScript.UseCineLock()
  end
  return bShowTheBoat
end
function TendrilBoatEnable()
  local alf000 = game.FindLevel("Alf000_SkyDark")
  if alf000 ~= nil then
    local cine_AreYouSerious_Obj = alf000:GetGameObject("Cine_AreYouSerious")
    cine_AreYouSerious_Obj:CallScript("EnableCineInteractZone")
  end
end
function BoatPickup200On()
  timer.StartLevelTimer(1, function()
    GameObjects.LootDropIntoWater:PlayAnimToEnd()
  end)
end
function Tendril_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Tendril Fight Alf200", {CheckpointOnComplete = false})
  Area_1_Encounter_1:AddWave({
    requiredWaveCompletion = 50,
    {
      spawners = "Flyer_SABU*",
      spawnLocators = "A1_B_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {0.5, 1},
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = {0.2, 0.5}
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Flyer_SABU*",
      spawnLocators = "A1_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {2, 5},
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = {3, 5}
    },
    {
      spawners = "DarkOne_N_SFA*",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = {1, 3}
    }
  })
  Area_1_Encounter_1:OnComplete(TendrilBoatEnable)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    boatCAReached = boatCAReached
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  boatCAReached = savedInfo.boatCAReached
end
function OnEvaluateLoadGroup_Lighting()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function Alf300_Bookmark_TrenchStartSetup()
end
