local LD = require("design.LevelDesignLibrary")
local thisObj, player, son, kraPuppeteer, sonPuppeteer, cine_lights_220
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  cine_lights_220 = GameObjects.Cine_Start_220
  HideCineLights()
end
function PreSonOverwhelmedBanter()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    game.Audio.PlayBanter("PreSonOverwhelmed", SonOverwhelmedSequence)
    GameObjects.Cine_SonOverwhelmed_Group:HideEntityVolume()
    local data = {}
    data.TargetMaxSpeed = 4.5
    data.TargetMaxRotationSpeed = 80
    data.TargetAcceleration = 12.5
    data.TargetAngularAcceleration = 160
    data.MaxSpeedChangeRate = 6
    data.MaxRotationSpeedChangeRate = 100
    data.AccelerationChangeRate = 6
    data.AngularAccelerationChangeRate = 100
    game.Boat.SetGlobalSpeedControlData(data)
    EnableManualCineMode()
  end
end
function SonOverwhelmedSequence()
  if game.Level.GetVariable("CompletedCineNumber") >= 215 and game.Level.GetVariable("CompletedCineNumber") < 220 then
    kraPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SonOverwhelmedCineKra", player)
    sonPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_SonOverwhelmedCineSon", son)
    local oldParent = cine_lights_220.Parent
    local boat = game.Boat.GetPlayerBoat()
    boat:AddChild(cine_lights_220, boat:GetJointIndex("zeroJoint"), 1)
    PlayCineLights()
    kraPuppeteer:StartMove("MOV_AlfSonOverwhelmedCine")
    sonPuppeteer:StartMove("MOV_AlfSonOverwhelmedCine")
    kraPuppeteer:OnComplete(function()
      kraPuppeteer = nil
      HideCineLights()
      cine_lights_220:Unparent()
      oldParent:AddChild(cine_lights_220)
    end)
    sonPuppeteer:OnComplete(function()
      sonPuppeteer = nil
      game.Level.SetVariable("CompletedCineNumber", 220)
      DisableManualCineMode()
      game.World.StoreCheckpoint()
    end)
  end
end
function PlayCineLights()
  cine_lights_220:Show()
  cine_lights_220:JumpAnimToFrame(0)
  cine_lights_220:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_220:Hide()
end
function EnableManualCineMode()
  game.Cinematics.EnableCinematicMode()
  local pad = game.Player.FindPlayer().Pad
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadCircle)
  game.Player.FindPlayer():CallScript("LuaHook_ForceCineRageModeExit")
end
function DisableManualCineMode()
  game.Cinematics.DisableCinematicMode()
  local pad = game.Player.FindPlayer().Pad
  pad:EnableGameButton(tweaks.ePad.kPadUp)
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
end
