local LD = require("design.LevelDesignLibrary")
local collisionCheck = require("camera.collisioncheck")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, son, lightOneActor, lightOneActor2
local lookRunPlayed = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if LD.GetEntityVariable("ALF_LakeDiscovered") == false and lookRunPlayed == false then
    CreateActors()
    SpawnLookRunLO()
    SpawnLookRunLO2()
    LookRunLoopSequence()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {lookRunPlayed = lookRunPlayed}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  lookRunPlayed = savedInfo.lookRunPlayed
end
function SpawnLookRunLO()
  lightOneActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_LookRun_Group", "LightOne1_SpawnJoint", "CRT_LightOne00", "BRA_envAlfLookRunLoop", "lightone")
  end)
end
function SpawnLookRunLO2()
  lightOneActor2:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_LookRun_Group", "LightOne2_SpawnJoint", "CRT_LightOne00", "BRA_envAlfLookRunLoop1", "lightone")
  end)
end
function CreateActors()
  lightOneActor = actor.Actor.New("lightone")
  lightOneActor2 = actor.Actor.New("lightone2")
end
function LookRunLoopSequence()
  if LD.GetEntityVariable("ALF_LakeDiscovered") == false then
    local lookRunSeq = ND.CreateCineSequence(thisLevel, thisObj, "Look Run Sequence")
    local cineSeq_ActorTable = {
      {
        Actor = lightOneActor2,
        Branch = "BRA_envAlfLookRunLoop1"
      }
    }
    lookRunSeq:SpawnActorAndWait(lightOneActor)
    lookRunSeq:SpawnActorAndWait(lightOneActor2)
    lookRunSeq:RequestCineModeAndWait(lightOneActor, thisObj, true)
    lookRunSeq:ActorSync(lightOneActor, {
      Slaves = cineSeq_ActorTable,
      Branch = "BRA_envAlfLookRunLoop",
      ReferenceJoint = "LookRun_SynchJoint"
    })
    lookRunSeq:StartSequence()
  end
end
function PlayNotOurConcernBanter()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    local sonPupp = game.Puppeteer.NewForce(thisObj, "POI_AlfSonBoatLookBU", son)
    sonPupp:StartMove("MOV_SonBoatLookBU")
    sonPupp:OnComplete(function()
      sonPupp = nil
    end)
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("NotOurConcern")
    end, 2)
    LD.CallFunctionAfterDelay(LookRunExit, 4)
    game.Audio.StartMusic("SND_MX_ALF_boat_by_elves")
  end
end
function LookRunExit()
  if LD.GetEntityVariable("ALF_LakeDiscovered") == false and lookRunPlayed == false then
    local data = {}
    data.TargetMaxSpeed = 6
    data.TargetMaxRotationSpeed = 80
    data.TargetAcceleration = 12.5
    data.TargetAngularAcceleration = 160
    data.MaxSpeedChangeRate = 6
    data.MaxRotationSpeedChangeRate = 100
    data.AccelerationChangeRate = 6
    data.AngularAccelerationChangeRate = 100
    game.Boat.SetGlobalSpeedControlData(data)
    local lookRunExitSeq = ND.CreateCineSequence(thisLevel, thisObj, "Look Run Sequence Exit")
    local cineSeq_ActorTable2 = {
      {
        Actor = lightOneActor2,
        Branch = "BRA_envAlfLookRunExit1"
      }
    }
    lookRunExitSeq:RequestCineModeAndWait(lightOneActor, thisObj, true)
    lookRunExitSeq:ActorSync(lightOneActor, {
      Slaves = cineSeq_ActorTable2,
      Branch = "BRA_envAlfLookRunExit",
      ReferenceJoint = "LookRun_SynchJoint"
    })
    lookRunExitSeq:WaitForActorPuppeteerComplete(lightOneActor)
    lookRunExitSeq:StopPuppetingActor(lightOneActor)
    lookRunExitSeq:DespawnActor(lightOneActor)
    lookRunExitSeq:DespawnActor(lightOneActor2)
    lookRunExitSeq:Do(function()
      lookRunPlayed = true
    end)
    lookRunExitSeq:StartSequence()
  end
end
