local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timer = require("level.timer")
local TempleComplete = false
local player
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
end
function OnUpdate(level)
  if LD.GetEntityVariable("ALF_LightAcquired") == true and TempleComplete == false then
    TempleComplete = true
    GameObjects.Alf300_LoadZone_2_1:HideEntityVolume()
    GameObjects.Alf300_LoadZone_2_4:HideEntityVolume()
    GameObjects.Alf300_LoadZone_2_3:HideEntityVolume()
    GameObjects.Alf300_LoadZone_2_390:HideEntityVolume()
    GameObjects.Alf300_LoadZone_2_5:ShowEntityVolume()
    GameObjects.Alf300_LoadZone_2_6:ShowEntityVolume()
    for _, bridge in pairs(GameObjects.LongTemporalBridges.Children) do
      if bridge.LuaObjectScript and bridge.LuaObjectScript.IsTemporalObject then
        bridge.LuaObjectScript.Enable()
      else
        bridge:Show()
      end
    end
    GameObjects.LongTemporalBridges:Show()
    game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", true)
    GameObjects.Quest_Alf_700:ShowEntityVolume()
  end
end
function OnStart(level, obj)
  CheckStatueStatus()
  GameObjects.CA_BeforeCombat.LuaObjectScript.Disable()
  if game.Level.GetVariable("ALF_TrenchOpen") == false then
    game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", false)
  end
end
function OnFirstStart(level)
  GameObjects.LongTemporalBridges:Hide()
  GameObjects.Alf300_LoadZone_2_2:HideEntityVolume()
  GameObjects.Alf300_LoadZone_2_5:HideEntityVolume()
  GameObjects.Alf300_LoadZone_2_6:HideEntityVolume()
  GameObjects.Quest_Alf_700:HideEntityVolume()
  GameObjects.Alf300_LoadZone_Gate_300:HideEntityVolume()
  GameObjects.Alf300_LoadZone_Gate_690:HideEntityVolume()
  local alf000 = game.FindLevel("Alf000_SkyDark")
  if alf000 ~= nil then
    alf000:CallScript("TurnOnTemple")
  end
end
function SetLakeDiscovered()
  LD.SetEntityVariable("ALF_LakeDiscovered", true)
end
function LightOnesWalkAbove()
  if LD.GetEntityVariable("CompletedCineNumber") < 247 then
    GameObjects.LightOnesAbove:Show()
    GameObjects.Anim_LO_1:JumpAnimToFrame(730)
    GameObjects.Anim_LO_1:PlayAnimCycle(0.1)
    GameObjects.Anim_LO_2:JumpAnimToFrame(810)
    GameObjects.Anim_LO_2:PlayAnimCycle(0.094)
    GameObjects.Anim_LO_3:JumpAnimToFrame(890)
    GameObjects.Anim_LO_3:PlayAnimCycle(0.084)
    GameObjects.Anim_LO_4:JumpAnimToFrame(920)
    GameObjects.Anim_LO_4:PlayAnimCycle(0.096)
    GameObjects.Anim_LO_5:JumpAnimToFrame(1000)
    GameObjects.Anim_LO_5:PlayAnimCycle(0.093)
    GameObjects.Anim_LO_6:JumpAnimToFrame(1080)
    GameObjects.Anim_LO_6:PlayAnimCycle(0.077)
    GameObjects.Anim_LO_7:JumpAnimToFrame(550)
    GameObjects.Anim_LO_7:PlayAnimCycle(0.098)
    GameObjects.Anim_LO_8:JumpAnimToFrame(620)
    GameObjects.Anim_LO_8:PlayAnimCycle(0.089)
    GameObjects.Anim_LO_9:JumpAnimToFrame(670)
    GameObjects.Anim_LO_9:PlayAnimCycle(0.08)
    GameObjects.Anim_LO_10:JumpAnimToFrame(300)
    GameObjects.Anim_LO_10:PlayAnimCycle(0.099)
    GameObjects.Anim_LO_11:JumpAnimToFrame(330)
    GameObjects.Anim_LO_11:PlayAnimCycle(0.091)
    GameObjects.Anim_LO_12:JumpAnimToFrame(360)
    GameObjects.Anim_LO_12:PlayAnimCycle(0.086)
    GameObjects.Anim_LO_13:JumpAnimToFrame(390)
    GameObjects.Anim_LO_13:PlayAnimCycle(0.1)
    GameObjects.Anim_LO_14:JumpAnimToFrame(420)
    GameObjects.Anim_LO_14:PlayAnimCycle(0.09)
    GameObjects.Anim_LO_15:JumpAnimToFrame(450)
    GameObjects.Anim_LO_15:PlayAnimCycle(0.08)
    GameObjects.Anim_LO_16:JumpAnimToFrame(480)
    GameObjects.Anim_LO_16:PlayAnimCycle(0.097)
    GameObjects.Anim_LO_21:JumpAnimToFrame(760)
    GameObjects.Anim_LO_21:PlayAnimCycle(0.07)
    GameObjects.Anim_LO_22:JumpAnimToFrame(600)
    GameObjects.Anim_LO_22:PlayAnimCycle(0.094)
    GameObjects.Anim_LO_23:JumpAnimToFrame(890)
    GameObjects.Anim_LO_23:PlayAnimCycle(0.074)
    GameObjects.Anim_LO_24:JumpAnimToFrame(456)
    GameObjects.Anim_LO_24:PlayAnimCycle(0.096)
    GameObjects.Anim_LO_25:JumpAnimToFrame(590)
    GameObjects.Anim_LO_25:PlayAnimCycle(0.093)
    GameObjects.Anim_LO_26:JumpAnimToFrame(689)
    GameObjects.Anim_LO_26:PlayAnimCycle(0.077)
    GameObjects.Anim_LO_27:JumpAnimToFrame(410)
    GameObjects.Anim_LO_27:PlayAnimCycle(0.098)
    GameObjects.Anim_LO_28:JumpAnimToFrame(540)
    GameObjects.Anim_LO_28:PlayAnimCycle(0.089)
    GameObjects.Anim_LO_29:JumpAnimToFrame(670)
    GameObjects.Anim_LO_29:PlayAnimCycle(0.08)
    GameObjects.Anim_LO_30:JumpAnimToFrame(700)
    GameObjects.Anim_LO_30:PlayAnimCycle(0.079)
    GameObjects.Anim_LO_31:JumpAnimToFrame(830)
    GameObjects.Anim_LO_31:PlayAnimCycle(0.091)
    GameObjects.Anim_LO_32:JumpAnimToFrame(960)
    GameObjects.Anim_LO_32:PlayAnimCycle(0.07)
    GameObjects.Anim_LO_33:JumpAnimToFrame(1000)
    GameObjects.Anim_LO_33:PlayAnimCycle(0.073)
    GameObjects.Anim_LO_34:JumpAnimToFrame(1110)
    GameObjects.Anim_LO_34:PlayAnimCycle(0.1)
    GameObjects.Anim_LO_35:JumpAnimToFrame(500)
    GameObjects.Anim_LO_35:PlayAnimCycle(0.088)
    GameObjects.Anim_LO_36:JumpAnimToFrame(990)
    GameObjects.Anim_LO_36:PlayAnimCycle(0.08)
  else
    GameObjects.LightOnesAbove:Hide()
  end
end
function CheckStatueStatus()
  if LD.GetEntityVariable("ALF_LightAcquired") then
    LightOnesWalkAbove()
  else
    GameObjects.LightOnesAbove:Hide()
  end
end
function LightOnesReturnLoadZone()
  game.Level.SetVariable("LightOnesReturnDone", true)
  GameObjects.Alf300_LoadZone_2_2:ShowEntityVolume()
end
function DoorOpenFrom300()
  GameObjects.Alf300_LoadZone_Gate_300:HideEntityVolume()
  GameObjects.Alf300_LoadZone_Gate_690:ShowEntityVolume()
end
function DoorOpenFrom690()
  GameObjects.Alf300_LoadZone_Gate_300:ShowEntityVolume()
  GameObjects.Alf300_LoadZone_Gate_690:HideEntityVolume()
end
function AreaAnnounce_Alf300()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    uiCalls.UI_Event_DiscoverLocation("Alfheim")
    LD.SetMarkerState("CALT_120_ALF_FT", 1)
    LD.CheckMapDiscoveryState()
  end
end
function AreaAnnounce_Dgn110()
  uiCalls.UI_Event_DiscoverLocation("Secret Temple")
  LD.CheckMapDiscoveryState()
end
function AreaAnnounce_Dgn210()
  uiCalls.UI_Event_DiscoverLocation("Alfheim Beach")
  LD.CheckMapDiscoveryState()
end
function AreaAnnounce_Trench()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    uiCalls.UI_Event_DiscoverLocation("Alfheim Trench")
    LD.CheckMapDiscoveryState()
  end
end
function AreaAnnounce_Temple()
  if LD.GetEntityVariable("ALF_LightAcquired") == false then
    uiCalls.UI_Event_DiscoverLocation("Temple Entrance")
    LD.CheckMapDiscoveryState()
  end
end
function alfheimLeftExploreCrystalOn()
  game.Level.SetVariable("BridgeLeftExp", true)
end
function alfheimLeftExploreCrystalOff()
  game.Level.SetVariable("BridgeLeftExp", false)
end
function Tendril_Pirate()
  LD.SetEntityVariable("Tendril_Pirate", true)
end
function StartFightRift110()
  local alfDgn110 = game.FindLevel("AlfDgn110_Main")
  if alfDgn110 ~= nil then
    alfDgn110:CallScript("StartRiftFight")
    timer.StartLevelTimer(9, function()
      GameObjects.LootPocketRift110.LuaObjectScript.SpawningDone()
    end)
  end
end
function RespawnRift110()
  local alfDgn110 = game.FindLevel("AlfDgn110_Main")
  if alfDgn110 ~= nil then
    alfDgn110:CallScript("RespawnRiftObject")
  end
end
function ResetRiftState()
  GameObjects.LootPocketRift110.LuaObjectScript.ResetCombatState()
end
function StopRiftFight()
  GameObjects.LootPocketRift110.LuaObjectScript.StopCombatState()
end
function ResetRiftFight_NGP()
  GameObjects.LootPocketRift110.LuaObjectScript.ResetCombatState()
end
function PlayRiftSound()
  GameObjects.LootPocketRift110.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function Tendril_DropDown_Setup()
  LD.SetEntityVariable("Tendril_DropDown", true)
end
function Tendril_Single01()
  LD.SetEntityVariable("Tendril_Single01", true)
  LD.CallFunctionAfterDelay(function()
    GameObjects.LootDropIntoWater:PlayAnimToEnd()
  end, 1)
end
function FlipRuneSymbol()
  GameObjects.RuneSymbolSpinner:JumpAnimToFrame(0)
  GameObjects.RuneSymbolSpinner:PlayAnimToEnd()
end
function BanterSlowWalk_On()
  player:SetMaxSpeedOverride(3)
end
function BanterSlowWalk_Off()
  player:ClearMaxSpeedOverride()
end
function LoadCheck_210()
  game.UI.LoadCheck("Alf210_LakeDarkLH")
end
function LoadCheck_370()
  game.UI.LoadCheck("Alf370_MoatScripting", "Alf345_TrenchBDarkTWR")
end
function LoadCheck_Dgn210()
  game.UI.LoadCheck("AlfDgn210_Main")
end
function LoadCheck_Dgn110()
  game.UI.LoadCheck("AlfDgn110_Main")
end
function LoadCheck_690()
  if game.Level.GetVariable("ALF_LightAcquired") == true then
    game.UI.LoadCheck("Alf690_LakeLightLH")
  end
end
function StartAlfQuest_BlueDoor()
  LD.CompleteQuest("Quest_Alfheim_Objective380")
  game.Compass.SetGatewayMarkerIsOpen("ALF_690_Helper_03", false)
end
function Objective380Failsafe()
  LD.CompleteQuest("Quest_Alfheim_Objective380")
  game.Compass.SetGatewayMarkerIsOpen("ALF_690_Helper_03", false)
end
function StartAlfQuest695()
  LD.CompleteQuest("Quest_Alfheim_Objective690")
  game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", false)
  game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper", false)
  game.Compass.SetGatewayMarkerIsOpen("ALF_340_Helper_08", true)
  game.Compass.OnWarp()
  GameObjects.Btr_AnyOtherWay1:HideEntityVolume()
end
function Objective690Failsafe()
  LD.CompleteQuest("Quest_Alfheim_Objective690")
  game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", false)
  game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper", false)
  game.Compass.SetGatewayMarkerIsOpen("ALF_340_Helper_08", true)
  game.Compass.OnWarp()
end
function StartAlfQuest700()
  LD.CompleteQuest("Quest_Alfheim_Objective695")
  game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper_Dock", true)
  game.Compass.SetGatewayMarkerIsOpen("ALF_300_Helper", true)
  LD.CallFunctionAfterDelay(SoftSave, 1)
end
function SoftSave()
  game.SubObject.SoftSave()
end
function OnEvaluateLoadGroup_Lighting0()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting1()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting2()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting3()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting4()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting5()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting6()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting7()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting8()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function OnEvaluateLoadGroup_Lighting9()
  if game.Level.GetVariable("ALF_LightAcquired") == false then
    return "LightingPre"
  elseif game.Level.GetVariable("ALF_LightAcquired") == true then
    return "LightingPost"
  end
end
function Alf300_Bookmark_LakeReturnSetup()
end
function Alf300_Bookmark_TrenchStartSetup()
end
