LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local collisionCheck = require("camera.collisioncheck")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, player, kratosPup, sonActor
local kra_Pos = LD.GetWorldJointPosition("POI_AlfSonLightBridgeObscured", "TEMP_KraJoint")
local kra_Dir = LD.GetWorldJointForward("POI_AlfSonLightBridgeObscured", "TEMP_KraJoint")
local son_Pos = LD.GetWorldJointPosition("POI_AlfSonLightBridgeObscured", "Son_BridgeObscured_StartJoint")
local son_Dir = LD.GetWorldJointForward("POI_AlfSonLightBridgeObscured", "Son_BridgeObscured_StartJoint")
local boolTrenchBowlFirst = false
local boolUseCrankAfterTBF = false
local boolUseCrankBeforeTBF = false
local boolGetDownThere = false
local boolFirstCrank = false
local boolSecondCrank = false
local boolReturnToBoat = false
local bGetDownThere = false
local bWhatsThierProblem = false
local boolTrenchOpeningBtr = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player:FindPlayer()
end
function OnStart(level, obj)
end
function OnUpdate(level, obj)
  if game.Player.FindPlayer():IsInsideEntityZone("BtrZone_SeeGlyph") == true and boolTrenchBowlFirst == false and boolGetDownThere == false then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("SandBowlIslandIntro")
    end, 0.8)
    boolTrenchBowlFirst = true
  end
  if (game.Level.GetVariable("RuneCrankEnd_Left") == true or game.Level.GetVariable("RuneCrankEnd_Right") == true) and boolFirstCrank == false then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("Alf_CrankYankers_Son1")
    end, 1.3)
    boolFirstCrank = true
  end
  if game.Level.GetVariable("RuneCrankEnd_Left") == true and game.Level.GetVariable("RuneCrankEnd_Right") == true and boolFirstCrank == true and boolSecondCrank == false then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("Alf_CrankYankers_Son2", KraReply)
    end, 1.3)
    game.Audio.StartCheckpointedMusic("SND_MX_ALF_sand_bowl_return")
    boolSecondCrank = true
  end
  if game.Level.GetVariable("ALF_TrenchOpen") == true and boolTrenchOpeningBtr == false then
    game.Audio.PlayBanter("TrenchOpening")
    game.Audio.StartMusic("SND_MX_ALF_reveal_the_trench")
    boolTrenchOpeningBtr = true
  end
  if game.Level.GetVariable("BridgeVanishFight") == true and bWhatsThierProblem == false then
    game.Audio.PlayBanter("WhatsTheirProblem")
    bWhatsThierProblem = true
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    boolTrenchBowlFirst = boolTrenchBowlFirst,
    boolUseCrankAfterTBF = boolUseCrankAfterTBF,
    boolUseCrankBeforeTBF = boolUseCrankBeforeTBF,
    boolTrenchOpeningBtr = boolTrenchOpeningBtr,
    boolFirstCrank = boolFirstCrank,
    boolSecondCrank = boolSecondCrank,
    boolGetDownThere = boolGetDownThere,
    bGetDownThere = bGetDownThere,
    bWhatsThierProblem = bWhatsThierProblem
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolTrenchBowlFirst = savedInfo.boolTrenchBowlFirst
  boolUseCrankAfterTBF = savedInfo.boolUseCrankAfterTBF
  boolUseCrankBeforeTBF = savedInfo.boolUseCrankBeforeTBF
  boolTrenchOpeningBtr = savedInfo.boolTrenchOpeningBtr
  boolFirstCrank = savedInfo.boolFirstCrank
  boolSecondCrank = savedInfo.boolSecondCrank
  boolGetDownThere = savedInfo.boolGetDownThere
  bGetDownThere = savedInfo.bGetDownThere
  bWhatsThierProblem = savedInfo.bWhatsThierProblem
end
function CheckPuzzleDone()
  return game.Level.GetVariable("RuneCrankEnd_Left") or game.Level.GetVariable("RuneCrankEnd_Right")
end
function SetupActors()
  sonActor = actor.Actor.New("Banter Bridge Vanish: Son Actor", game.AI.FindSon)
end
function LightBridgeSequence()
  if boolGetDownThere == false and LD.GetEntityVariable("ALF_LightAcquired") == false then
    SetupActors()
    game.Compass.SetDesignerForcedHide(true)
    local POISeq = LD.CreateCineSequence(thisLevel, thisObj, "Bridge Banter Sequence")
    POISeq:Do(function()
      player:CallScript("DisableNextDockingCheckpoint")
    end)
    POISeq:Do(MoveKratos)
    POISeq:Do(function()
      timer.StartLevelTimer(1.1, function()
        game.Audio.PlayBanter("LightBridgeObscured")
        game.Audio.StartCheckpointedMusic("SND_MX_ALF_rune_puzzle_arrive")
      end)
    end)
    POISeq:ActorForceApproachAndWait(sonActor, {
      pos = son_Pos,
      dir = son_Dir,
      speed = 4,
      stop = false
    })
    POISeq:ActorSync(sonActor, {
      Branch = "BRA_AlfSonLightBridgeObscured",
      ReferenceJoint = "BridgeObscured_SynchJoint"
    })
    POISeq:WaitForActorPuppeteerComplete(sonActor)
    POISeq:Do(function()
      GameObjects.POI_AlfSonLightBridgeObscured:Hide()
    end)
    POISeq:Do(function()
      local alf320 = game.FindLevel("Alf320_TrenchADark")
      if alf320 ~= nil then
        timer.StartLevelTimer(4.6, function()
          alf320:CallScript("BridgeVanish")
        end)
      end
      local alf370 = game.FindLevel("Alf370_MoatScripting")
      if alf370 ~= nil then
        alf370:CallScript("TentacleWrapAnim")
      end
    end)
    POISeq:StopPuppetingActor(sonActor)
    POISeq:WaitUntilActorAnimPastPercentage(sonActor, 0.99)
    POISeq:Do(function()
      local alf320 = game.FindLevel("Alf320_TrenchADark")
      if alf320 ~= nil then
        alf320:CallScript("HideTentaclePOIZones")
      end
      GameObjects.CA_BeforeCombat.LuaObjectScript.Enable()
    end)
    POISeq:Do(function()
      boolGetDownThere = true
    end)
    POISeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    POISeq:StartSequence()
  end
end
function MoveKratos(...)
  kratosPup = game.Puppeteer.NewForce(thisObj, "LDLib - AI GoToLocationAlignAndWait", game.Player.FindPlayer())
  kratosPup:Approach({
    pos = kra_Pos,
    speed = 1,
    complete_radius = 1,
    stop = true
  })
  kratosPup:OnArrival(function()
    if kratosPup ~= nil then
      kratosPup:Clear()
      kratosPup:DetachPuppet()
      kratosPup = nil
    end
  end, {pos = kra_Pos, radius = 1})
end
function KraReply()
  if boolTrenchBowlFirst == false and game.Level.GetVariable("ALF_LakeRunesFound") == true and boolReturnToBoat == false then
    game.Audio.PlayBanter("Alf_CrankYankers_Kra1", Quest_Alfheim_Objective210_Complete)
    boolReturnToBoat = true
  elseif boolTrenchBowlFirst == true and game.Level.GetVariable("ALF_LakeRunesFound") == true and boolReturnToBoat == false then
    game.Audio.PlayBanter("Alf_CrankYankers_Kra2", Quest_Alfheim_Objective210_Complete)
    boolReturnToBoat = true
    LD.CallFunctionAfterDelay(CrankYankersLinger, 45)
  end
end
function CrankYankersLinger()
  if player:InsideZone("BtrZone_CrankYankerLinger") then
    if boolTrenchBowlFirst == true and game.Level.GetVariable("ALF_LakeRunesFound") == true then
      game.Audio.PlayBanter("Alf_CrankYankers_Linger")
      GameObjects.BtrZone_CrankYankerLinger:HideEntityVolume()
    end
  else
    GameObjects.BtrZone_CrankYankerLinger:HideEntityVolume()
  end
end
function GetDownThereHintBanter()
  return game.Level.GetVariable("CompletedCineNumber") < 230 and game.Level.GetVariable("BridgeVanishFight")
end
function HideGetDownThereBtrZone()
  GameObjects.Btr_GetDownThere:HideEntityVolume()
  bGetDownThere = true
end
function Quest_Alfheim_Objective210_Complete()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 710,
    Body = 718,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_Alfheim_Objective300"
  })
end
