local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisLevel, thisObj, player, son, kraPuppeteer, sonPuppeteer
local momfrontation = false
local cine_lights_250
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  cine_lights_250 = GameObjects.Cine_Start_250
  HideCineLights()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 245 <= cineNum and cineNum < 250 then
    game.Audio.SetBanterFact("disableBoatLoreInWAD", true)
  elseif 250 <= cineNum then
    EnableDock()
    HideDisableBoatLoreZone()
  end
end
function OnSaveCheckpoint(level, obj)
  return {playedSetupBool = momfrontation}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  momfrontation = savedInfo.playedSetupBool
end
function MomfrontationCine()
  if game.Level.GetVariable("ALF_LightAcquired") == true and game.Level.GetVariable("CompletedCineNumber") < 250 then
    SetDockingEnabled(false)
    thisObj:HideEntityVolume()
    GameObjects.Monfrontation_DisableBoatLore:Hide()
    game.Audio.SetBanterFact("disableBoatLoreInWAD", false)
    kraPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_MomfrontationCineKra", player)
    sonPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_MomfrontationCineSon", son)
    sonPuppeteer:StartMove("MOV_narAlf00BoatMomTalk00Cine")
    sonPuppeteer:OnComplete(SecondPart)
    momfrontation = true
  end
end
function SecondPart()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "momfrontation")
  local kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  seq:SetPostSkipMusic("SND_MX_ALF_start_master")
  seq:MarkAbleToSkip()
  seq:RequestCineModeAndWait(kratosActor, thisObj)
  seq:Do(function()
    if sonPuppeteer ~= nil and kraPuppeteer ~= nil then
      sonPuppeteer:StartMove("MOV_narAlf00BoatMomTalk10Cine")
      kraPuppeteer:StartMove("MOV_narAlf00BoatMomTalk10Cine")
      local boat = game.Boat.GetPlayerBoat()
      boat:AddChild(cine_lights_250, boat:GetJointIndex("zeroJoint"), 1)
      PlayCineLights()
      sonPuppeteer:OnComplete(function()
        sonPuppeteer = nil
      end)
      kraPuppeteer:OnComplete(function()
        kraPuppeteer = nil
        game.Level.SetVariable("CompletedCineNumber", 250)
        HideCineLights()
      end)
    end
  end)
  seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  seq:Do(function()
    SetDockingEnabled(true)
  end)
  seq:Do(function()
    if seq.skipping then
      game.Audio.PlayBanter("OnlyMomentsPass")
    end
  end)
  seq:UnparentObject(cine_lights_250)
  seq:StartSequence()
end
function SetDockingEnabled(value)
  local dockLevel = game.FindLevel("Alf000_SkyDark")
  local dock = dockLevel:FindSingleGameObject("Boat_Dock_2").Child
  if value == true then
    dock:CallScript("EnableDocking")
  else
    dock:CallScript("DisableDocking")
  end
end
function EnableDock()
  SetDockingEnabled(true)
end
function PlayCineLights()
  cine_lights_250:Show()
  cine_lights_250:JumpAnimToFrame(0)
  cine_lights_250:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_250:Hide()
end
function BoatTowards_MomFrontation()
  game.Audio.SetBanterFact("disableBoatLoreInWAD", true)
  game.Audio.SetBanterFact("selected_lore", -1)
end
function BoatAway_MomFrontation()
end
function HideDisableBoatLoreZone()
  GameObjects.Monfrontation_DisableBoatLore:Hide()
end
